/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;

public class PurPriceEditPlugin
extends AbstractBillPlugIn {
    private static final String COSTTYPE = "COSTTYPE";
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit costTypeCtrl = (BasedataEdit)this.getControl(COSTTYPE);
        costTypeCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("type", "not in", (Object)"1"));
        });
        BasedataEdit materialCtrl = (BasedataEdit)this.getControl("material");
        materialCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Set materialBySalOrder;
            ListShowParameter fParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            fParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            ListFilterParameter filterParameter = fParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("enablepur", "=", (Object)true));
            DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode");
            DynamicObject tracknumber = (DynamicObject)this.getModel().getValue("tracknumber");
            if (!(configuredcode == null && tracknumber == null || CadEmptyUtils.isEmpty((Set)(materialBySalOrder = ConfigTrackHelper.getMaterialBySalOrder((Long)(configuredcode == null ? 0L : configuredcode.getLong("id")), (Long)(tracknumber == null ? 0L : tracknumber.getLong("id"))))))) {
                qList.add(new QFilter("id", "in", (Object)materialBySalOrder));
            }
        });
        BasedataEdit matVersion = (BasedataEdit)this.getControl("matversion");
        matVersion.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
            if (mat != null) {
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = parameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                qList.add(new QFilter("material", "=", mat.getPkValue()));
            }
        });
        BasedataEdit configuredCode = (BasedataEdit)this.getControl("configuredcode");
        configuredCode.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List configCodeIds;
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
            if (mat != null && !CadEmptyUtils.isEmpty((List)(configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(mat.getLong("id")))))) {
                qList.add(new QFilter("id", "in", (Object)configCodeIds));
            }
        });
        BasedataEdit elementCtrl = (BasedataEdit)this.getControl("element");
        elementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject subElement = (DynamicObject)this.getModel().getValue("subelement", beforeF7SelectEvent.getRow());
            if (subElement != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)this.getElement(subElement.getLong("id"))));
            }
        });
        BasedataEdit subElementCtrl = (BasedataEdit)this.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Set<Long> subElement;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", beforeF7SelectEvent.getRow());
            if (element != null) {
                qList.add(new QFilter("id", "in", this.getSubElement(element.getLong("id"))));
            }
            if ((subElement = this.getNotSubElement()).size() > 0) {
                qList.add(new QFilter("id", "not in", subElement));
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals("advconbaritemap1")) {
            this.ctrlPriceRate();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName().toUpperCase();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "COSTTYPE": {
                this.bindCurrency();
                break;
            }
            case "MATERIAL": {
                Util.ctrlVerAndAuxpty(this.getView());
                this.setEablePur();
                DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
                if (!CostTypeHelper.isUseMatVersion((Long)(CadEmptyUtils.isEmpty((DynamicObject)costtype) ? 0L : costtype.getLong("id")))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"matversion"});
                }
                this.effectDateEnable();
                if (newValue == null) {
                    this.getModel().beginInit();
                    this.getModel().setValue("configuredcode", null);
                    this.getView().updateView("configuredcode");
                    this.getModel().setValue("tracknumber", null);
                    this.getView().updateView("tracknumber");
                    this.getModel().endInit();
                }
                this.initEntryInfo();
                break;
            }
            case "ELEMENT": {
                this.setDefaultSubElement(e);
                this.enableRate();
                break;
            }
            case "SUBELEMENT": {
                this.setElement(e);
                this.ctrlPriceRate();
                this.enableRate();
                break;
            }
            case "PRICE": 
            case "RATE": {
                this.ctrlPriceRate();
                break;
            }
            case "CONFIGUREDCODE": {
                ConfigTrackHelper.setMaterialValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), null);
                ConfigTrackHelper.setTrackValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), null);
                this.effectDateEnable();
                break;
            }
            case "TRACKNUMBER": {
                ConfigTrackHelper.setConfigValueByTrack((IFormView)this.getView(), (IDataModel)this.getModel(), null);
                this.effectDateEnable();
                break;
            }
            case "LOT": 
            case "PROJECT": 
            case "AUXPTY": {
                this.effectDateEnable();
                break;
            }
            case "PRICEEFFECTDATE": {
                this.getModel().setValue("effectdate", (Object)this.getModel().getDataEntity().getDate("priceeffectdate"));
                break;
            }
            default: {
                return;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDataSrc();
        this.getModel().setValue("pricerule", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            long id = this.getModel().getDataEntity().getLong("pricerule.id");
            if (id == PriceRuleConstants.PUR_MANUALLY_ID || id == PriceRuleConstants.PUR_CALBAL_ID) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierinfo"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"supplierinfo"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"pricerule"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierinfo"});
        }
        this.effectDateEnable();
    }

    private void effectDateEnable() {
        PriceHelper.effectDateEnable((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"cad_purprices");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getOperationKey().toUpperCase()) {
            case "COPY": {
                DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
                if (priceRule == null) {
                    return;
                }
                PriceCommon.copyCheck(this.getView(), evt, priceRule.getLong("id"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.getView().updateView("keycol");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object costType = fsp.getCustomParam("CostType");
        if (costType != null) {
            this.getModel().setValue(COSTTYPE, costType);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{COSTTYPE});
            this.bindCurrency();
            this.setEablePur();
        }
        Util.ctrlVerAndAuxpty(this.getView());
        this.ctrlPriceRate();
        DynamicObject costTypeDy = (DynamicObject)this.getModel().getValue("costtype");
        if (!CadEmptyUtils.isEmpty((DynamicObject)costTypeDy) && !CostTypeHelper.isUseMatVersion((Long)costTypeDy.getLong("id"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"matversion"});
            BasedataEdit matversion = (BasedataEdit)this.getView().getControl("matversion");
            matversion.setMustInput(false);
        }
        this.enableRate();
        PriceHelper.setVisibleField((long)this.getModel().getDataEntity().getLong("costtype.id"), (IFormView)this.getView());
        this.getModel().setDataChanged(false);
        this.bindElementInfo();
    }

    private void bindElementInfo() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        for (int index = entrys.size() - 1; index >= 0; --index) {
            BigDecimal standardcost = ((DynamicObject)entrys.get(index)).getBigDecimal("price");
            if (BigDecimal.ZERO.compareTo(standardcost) != 0) continue;
            entrys.remove(index);
        }
        this.getView().updateView("entryentity");
    }

    private void enableRate() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
            return;
        }
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryentity.get(i);
            DynamicObject subelement = entry.getDynamicObject("subelement");
            if (subelement == null) continue;
            if (MATCOST.equals(subelement.getString("type"))) {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"rate"});
                continue;
            }
            this.getModel().setValue("rate", null, i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"rate"});
        }
    }

    private void initDataSrc() {
        this.getModel().setValue("datasrc", (Object)"manual");
    }

    private void setDefaultSubElement(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject ele = (DynamicObject)this.getView().getModel().getValue("element", rowIndex);
        if (ele == null) {
            return;
        }
        long elementId = ele.getLong("id");
        QFilter qfElement = new QFilter("id", "=", (Object)elementId);
        DynamicObject dyElement = QueryServiceHelper.queryOne((String)"cad_element", (String)"elementtype.id", (QFilter[])new QFilter[]{qfElement});
        long elementTypeId = dyElement.getLong("elementtype.id");
        qfElement = new QFilter("element", "=", (Object)elementId);
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        DynamicObjectCollection dyElementRelation = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{qfElement, qfElementType});
        if (dyElementRelation == null) {
            return;
        }
        HashSet<Long> eleIds = new HashSet<Long>();
        for (DynamicObject subElement : dyElementRelation) {
            eleIds.add(subElement.getLong("subelement"));
        }
        QFilter qfDefault = new QFilter("defaultvalue", "=", (Object)true);
        QFilter qfSubElement = new QFilter("id", "in", eleIds);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSubElement, qfDefault});
        if (dySubElement != null) {
            this.getView().getModel().setValue("subelement", (Object)dySubElement.getLong("id"), rowIndex);
        }
    }

    private void setElement(PropertyChangedArgs e) {
        this.getModel().beginInit();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("subelement", rowIndex);
        if (subEle == null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getView().getModel().setValue("element", (Object)dySubElement.getLong("element"), rowIndex);
            this.getView().updateView("element", rowIndex);
        }
        this.getModel().endInit();
    }

    private void updateAmount() {
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObjectCollection entry = this.getView().getModel().getEntryEntity("entryentity");
        if (entry.size() > 0) {
            for (DynamicObject en : entry) {
                amount = amount.add(en.getBigDecimal("price"));
            }
        }
        this.getModel().setValue("amount", (Object)amount);
    }

    private void bindCurrency() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue(COSTTYPE);
        if (costType == null) {
            return;
        }
        this.getModel().setValue("currency", (Object)costType.getLong("currency.id"));
    }

    private void setEablePur() {
        Boolean isDataChanged = this.getModel().getDataChanged();
        Boolean enablePur = false;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material != null) {
            enablePur = material.getBoolean("enablepur");
        }
        this.getModel().setValue("businessctrl", enablePur != false ? ResManager.loadKDString((String)"\u53ef\u91c7\u8d2d", (String)"PurPriceEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]) : null);
        this.getModel().setDataChanged(isDataChanged.booleanValue());
    }

    private long getElement(long subElementId) {
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        return dySubElement != null ? dySubElement.getLong("element") : 0L;
    }

    public Set<Long> getSubElement(long elementId) {
        HashSet<Long> subElementIds = new HashSet<Long>();
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return subElementIds;
        }
        long elementTypeId = costType.getLong("elementtype.id");
        QFilter qfElement = new QFilter("element", "=", (Object)elementId);
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{qfElement, qfElementType});
        if (elementDetail.size() == 0) {
            return subElementIds;
        }
        for (DynamicObject ele : elementDetail) {
            subElementIds.add(ele.getLong("subelement.id"));
        }
        return subElementIds;
    }

    private Set<Long> getNotSubElement() {
        HashSet<Long> subElement = new HashSet<Long>();
        DynamicObjectCollection entry = this.getView().getModel().getEntryEntity("entryentity");
        if (entry.size() == 0) {
            return subElement;
        }
        for (DynamicObject en : entry) {
            if (en.get("subelement") == null) continue;
            subElement.add(en.getLong("subelement.id"));
        }
        return subElement;
    }

    private void initEntryInfo() {
        this.getModel().deleteEntryData("entryentity");
        Long materialId = this.getModel().getDataEntity().getLong("material.id");
        Long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
        if (CadEmptyUtils.isEmpty((Long)materialId) || CadEmptyUtils.isEmpty((Long)costTypeId)) {
            return;
        }
        List orgIds = CostTypeHelper.getOrgByCostType((Long)costTypeId);
        if (CadEmptyUtils.isEmpty((List)orgIds)) {
            return;
        }
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)1);
        materialIds.add(materialId);
        Map materialToEleMap = ElementHelper.getDefSubEles((Long)((Long)orgIds.get(0)), (Set)materialIds, (boolean)true);
        Map<Long, Long> info = this.getDefaulSupCalInfo();
        Long[] eleArr = (Long[])materialToEleMap.get(materialId);
        if (eleArr != null) {
            info.put(eleArr[1], eleArr[0]);
        }
        this.getModel().beginInit();
        for (Map.Entry<Long, Long> entry : info.entrySet()) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("element", (Object)entry.getValue(), index);
            this.getModel().setValue("subelement", (Object)entry.getKey(), index);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private Map<Long, Long> getDefaulSupCalInfo() {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        QFilter qfEnable = new QFilter("enable", "=", (Object)true);
        QFilter qfSupCal = new QFilter("supmaterielcount", "=", (Object)true);
        DynamicObjectCollection dycSubElement = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSupCal, qfEnable});
        HashSet subElement = new HashSet();
        dycSubElement.forEach(p -> subElement.add(p.getLong("id")));
        QFilter qfSubElement = new QFilter("subelement", "in", (Object)subElement.toArray());
        DynamicObjectCollection detail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter[]{qfSubElement});
        for (DynamicObject de : detail) {
            result.put(de.getLong("subelement"), de.getLong("element"));
        }
        return result;
    }

    private void ctrlPriceRate() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        Map<Long, BigDecimal> stdRate = Util.getRateInfo(Long.valueOf(costType.getPkValue().toString()));
        int priceprecision = costType.getInt("currency.priceprecision");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> subElement = new HashSet<Long>();
        BigDecimal sum = BigDecimal.ZERO;
        for (DynamicObject en : entry) {
            if (MATTYPE.equals(en.getString("subelement.type"))) {
                sum = sum.add(en.getBigDecimal("price"));
            }
            subElement.add(en.getLong("subelement.id"));
        }
        Set<Long> supCal = Util.getSubElemnetSupCal(subElement.toArray(new Long[0]));
        for (int i = 0; i < entry.size(); ++i) {
            String subElementType = ((DynamicObject)entry.get(i)).getString("subelement.type");
            if (!MATCOST.equals(subElementType)) {
                if (!MATTYPE.equals(subElementType)) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"rate"});
                continue;
            }
            Long subEle = ((DynamicObject)entry.get(i)).getLong("subelement.id");
            if (supCal.contains(subEle)) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"price"});
                BigDecimal rate = stdRate.get(subEle) == null ? new BigDecimal(0) : stdRate.get(subEle);
                Object objRate = this.getModel().getValue("rate", i);
                if (objRate != null && BigDecimal.ZERO.compareTo(new BigDecimal(String.valueOf(objRate))) != 0) {
                    BigDecimal curRate = new BigDecimal(String.valueOf(objRate));
                    this.getModel().setValue("price", (Object)sum.multiply(curRate).divide(new BigDecimal(100), priceprecision, 4), i);
                    continue;
                }
                if (BigDecimal.ZERO.compareTo(new BigDecimal(String.valueOf(objRate))) == 0 && BigDecimal.ZERO.compareTo(rate) != 0) {
                    this.getModel().setValue("rate", (Object)rate, i);
                }
                if (BigDecimal.ZERO.compareTo(rate) == 0) continue;
                this.getModel().setValue("price", (Object)sum.multiply(rate).divide(new BigDecimal(100), priceprecision, 4), i);
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"price"});
        }
        this.getView().updateView("entryentity");
        this.updateAmount();
    }
}

