/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.common.dto.PurPriceParamDto;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.PurPricingRuleHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;
import kd.macc.cad.servicehelper.RecordCalcDataChangeServiceHelper;

public class PurPriceListPlugin
extends AbstractListPlugin
implements ICloseCallBack {
    public static final String ELEMENTTYPE_MATERIAL = "001";
    public static final String ELEMENTTYPE_MATERIALFEE = "002";
    public static final String SPLIT_1 = "#";
    private static final String closeBack_doPricing = "closeBack_doPricing";
    Log logger = LogFactory.getLog(PurPriceListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_new"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey().toUpperCase()) {
            case "TBLNEW": 
            case "TBLDEL": 
            case "TBLSUBMIT": 
            case "TBLUNSUBMIT": 
            case "TBLCHECK": 
            case "TBLUNAUDIT": 
            case "TBLCOPY": {
                String tip = ResManager.loadKDString((String)"\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868", (String)"PurPriceListPlugin_40", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                PriceCommon.checkType(this.getView(), evt, this.getCacheCostType(), tip);
                break;
            }
            case "SYNCOSTTYPE": {
                PriceCommon.isSynCostPermission(this.getView(), evt, RequestContext.getOrCreate().getCurrUserId(), RequestContext.get().getOrgId(), "cad_purprices");
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateRateBusinessCtrl();
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quickupdate"});
        }
        PriceHelper.updateDate((BillList)((BillList)this.getControl("billlistap")), (String)this.getPageCache().get("CostType"), (String)"cad_purprices");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costtype.name": {
                    column.setFixed(true);
                    break;
                }
                case "billno": {
                    column.setFixed(true);
                    break;
                }
                case "material.number": {
                    column.setFixed(true);
                    break;
                }
                case "material.name": {
                    column.setFixed(true);
                    break;
                }
                case "matversion.name": {
                    column.setVisible(0);
                    break;
                }
                case "auxpty": {
                    column.setVisible(0);
                    break;
                }
                case "businessctrl": {
                    column.setVisible(0);
                    break;
                }
                case "remark": {
                    column.setVisible(0);
                    break;
                }
            }
        }
        PriceHelper.hideDate((String)this.getPageCache().get("CostType"), (BeforeCreateListColumnsArgs)o);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "importfromcostinfo": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_purprices", "47156aff000000ac")) {
                    return;
                }
                this.showImportForm();
                break;
            }
            case "syncosttype": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_purprices", "47156aff000000ac")) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Util.openSyncCostTypeView(this.getView(), "cad_purprices", rows);
                break;
            }
            case "stdratesetting": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_purprices", "47156aff000000ac")) {
                    return;
                }
                this.showForm(this.getView(), "cad_stdratesetting", this.getPageCache().get("CostType"));
                break;
            }
            case "quickupdate": {
                this.showQuickUpdateApply();
                break;
            }
            case "purpricingrule": {
                this.showPurPricingRule();
                break;
            }
            case "purpricing": {
                this.doPurPricing();
                break;
            }
            case "autoprice": {
                this.doAutoPrice();
                break;
            }
        }
    }

    private String getCurrCostTypeId() {
        String costTypeId = this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)costTypeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"PurPriceListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return "";
        }
        return costTypeId;
    }

    private void showPurPricingRule() {
        String costTypeId = this.getCurrCostTypeId();
        if (StringUtils.isEmpty((String)costTypeId)) {
            return;
        }
        boolean isAnalog = BomRouterHelper.isAnalogCostType((Long)Long.valueOf(costTypeId));
        if (!isAnalog) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u8bbe\u7f6e\u53d6\u4ef7\u89c4\u5219\u3002", (String)"PurPriceListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId("cad_purpricingrule");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costtype", (Object)costTypeId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "purPricingRule"));
        this.getView().showForm((FormShowParameter)fsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPurPricing() {
        String costTypeId = this.getCurrCostTypeId();
        if (StringUtils.isEmpty((String)costTypeId)) {
            return;
        }
        PurPriceParamDto param = this.wrapCommonParam(Long.valueOf(costTypeId));
        boolean isPass = PurPricingRuleHelper.checkData((PurPriceParamDto)param);
        if (!isPass) {
            return;
        }
        String lockErr = CalcMutexHelper.checkAndRequireXMutex((String)"pricing", Collections.singleton(param.getCostTypeId()));
        if (StringUtils.isNotEmpty((String)lockErr)) {
            this.getView().showErrorNotification(lockErr);
            return;
        }
        try {
            Map matWithPriceMap = null;
            if (matWithPriceMap == null || matWithPriceMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u5408\u540c\u6216\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u3002", (String)"PurPriceListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Set matSet = matWithPriceMap.keySet();
            HashSet<Long> matIds = new HashSet<Long>(10);
            for (String matValue : matSet) {
                String[] matValueArr = matValue.split(SPLIT_1);
                matIds.add(Long.valueOf(matValueArr[0]));
            }
            this.wrapPurPriceParam(param, matIds);
            Map<String, DynamicObject> matAndPurPriceMap = this.getMatAndPurPriceMap(costTypeId, matIds);
            ArrayList<DynamicObject> purPriceList = new ArrayList<DynamicObject>(10);
            for (Map.Entry entry : matWithPriceMap.entrySet()) {
                DynamicObject purPrice = null;
                String matKey = (String)entry.getKey();
                PurPriceParamDto purPriceParam = (PurPriceParamDto)entry.getValue();
                String[] matArr = matKey.split(SPLIT_1);
                param.setCurrMatId(Long.valueOf(matArr[0]));
                param.setMatVersionId(Long.valueOf(matArr[1]));
                param.setAuxptyId(Long.valueOf(matArr[2]));
                param.setCurrMatPrice(purPriceParam.getCurrMatPrice());
                param.setCurrDataSrc(purPriceParam.getCurrDataSrc());
                boolean isExistPurPrice = matAndPurPriceMap.containsKey(matKey);
                if (!isExistPurPrice) {
                    purPrice = this.generateNewPurPrice(param);
                } else {
                    purPrice = matAndPurPriceMap.get(matKey);
                    this.updatePurPriceByMatPrice(purPrice, param);
                }
                this.fillBillInfo(purPrice, param);
                purPriceList.add(purPrice);
            }
            if (!purPriceList.isEmpty()) {
                DynamicObject result = SaveServiceHelper.save((DynamicObject[])purPriceList.toArray(new DynamicObject[0]));
                ArrayList<Object> arrayList = new ArrayList<Object>(16);
                for (Object obj : result) {
                    if (!(obj instanceof DynamicObject)) continue;
                    arrayList.add(((DynamicObject)obj).getPkValue());
                }
                String opKey = "doprice";
                this.logger.info("\u5f53\u524d\u5b9e\u4f53\uff1acad_purprices\u901a\u8fc7\u64cd\u4f5c" + opKey + "\u53d8\u66f4\u6570\u636e\u6761\u6570\uff1a" + arrayList.size());
                if (arrayList.size() > 0) {
                    int size = RecordCalcDataChangeServiceHelper.recordCalcChangedData((String)"cad_purprices", arrayList, (String)opKey);
                    this.logger.info("\u4fdd\u5b58\u5b9e\u4f53\uff1a{}\u53d8\u66f4\u8bb0\u5f55\u6210\u529f\u6761\u6570\uff1a{}", (Object)"cad_purprices", (Object)size);
                }
                this.getView().invokeOperation("refresh");
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d6\u4ef7\u5230\u6700\u65b0\u6570\u636e\u3002", (String)"PurPriceListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
        finally {
            CalcMutexHelper.releaseXMutex((String)"pricing", Collections.singleton(param.getCostTypeId()));
        }
    }

    private void fillBillInfo(DynamicObject purPrice, PurPriceParamDto param) {
        purPrice.set("datasrc", (Object)param.getCurrDataSrc());
        purPrice.set("auditor", (Object)param.getUserId());
        purPrice.set("auditdate", (Object)param.getCurrTime());
        purPrice.set("billstatus", (Object)"C");
    }

    private PurPriceParamDto wrapCommonParam(Long costTypeId) {
        PurPriceParamDto param = new PurPriceParamDto();
        param.setCostTypeId(costTypeId);
        param.setUserId(Long.valueOf(RequestContext.getOrCreate().getCurrUserId()));
        param.setCurrTime(new Date());
        param.setEntity("cad_purpricingrule");
        param.setView(this.getView());
        return param;
    }

    private void wrapPurPriceParam(PurPriceParamDto param, Set<Long> matIds) {
        Long currencyId = PurPricingRuleHelper.getCostTypeCurrency((Long)param.getCostTypeId());
        param.setCurrencyId(currencyId);
        Map<Long, BigDecimal> subEleAndStdRateMap = Util.getRateInfo(param.getCostTypeId());
        param.setSubEleAndStdRateMap(subEleAndStdRateMap);
        Map matDefSubEleMap = ElementRelationHelper.getMatDefSubEle((Long)param.getCostTypeId(), matIds);
        param.setMatDefSubEleMap(matDefSubEleMap);
        Map<Long, Long> purPriceSubEleAndEleMap = Util.getDefaulSupCalInfo();
        param.setPurPriceSubEleAndEleMap(purPriceSubEleAndEleMap);
    }

    private DynamicObject generateNewPurPrice(PurPriceParamDto param) {
        DynamicObject purPrice = BusinessDataServiceHelper.newDynamicObject((String)"cad_purprices");
        String billno = CodeRuleServiceHelper.getNumber((String)"cad_purprices", (DynamicObject)purPrice, (String)"");
        purPrice.set("billno", (Object)billno);
        purPrice.set("costtype", (Object)param.getCostTypeId());
        purPrice.set("currency", (Object)param.getCurrencyId());
        purPrice.set("material", (Object)param.getCurrMatId());
        purPrice.set("matversion", (Object)param.getMatVersionId());
        purPrice.set("auxpty", (Object)param.getAuxptyId());
        purPrice.set("creator", (Object)param.getUserId());
        purPrice.set("createtime", (Object)param.getCurrTime());
        purPrice.set("effectdate", (Object)TimeUtils.getDefaultEffectDate());
        purPrice.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
        int seq = 1;
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObjectCollection rows = purPrice.getDynamicObjectCollection("entryentity");
        Map subEleAndStdRateMap = param.getSubEleAndStdRateMap();
        Map purPriceSubEleAndEleMap = param.getPurPriceSubEleAndEleMap();
        for (Map.Entry subEleAndStdRate : subEleAndStdRateMap.entrySet()) {
            BigDecimal rate = (BigDecimal)subEleAndStdRate.getValue();
            if (rate.compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject row = rows.addNew();
            Long subEleId = (Long)subEleAndStdRate.getKey();
            row.set("seq", (Object)seq++);
            row.set("subelement", (Object)subEleId);
            row.set("element", purPriceSubEleAndEleMap.get(subEleId));
            row.set("rate", subEleAndStdRateMap.get(subEleId));
            row.set("price", (Object)param.getCurrMatPrice().multiply(row.getBigDecimal("rate").divide(new BigDecimal(100))));
            amount = amount.add(row.getBigDecimal("price"));
        }
        DynamicObject row = rows.addNew();
        Map matDefSubEleMap = param.getMatDefSubEleMap();
        row.set("seq", (Object)seq++);
        row.set("subelement", matDefSubEleMap.get(param.getCurrMatId()));
        row.set("element", purPriceSubEleAndEleMap.get(row.getLong("subelement")));
        row.set("price", (Object)param.getCurrMatPrice());
        amount = amount.add(row.getBigDecimal("price"));
        purPrice.set("amount", (Object)amount);
        return purPrice;
    }

    private void updatePurPriceByMatPrice(DynamicObject purPrice, PurPriceParamDto param) {
        DynamicObjectCollection rows = purPrice.getDynamicObjectCollection("entryentity");
        BigDecimal currMatPrice = param.getCurrMatPrice();
        BigDecimal amount = BigDecimal.ZERO;
        Long matId = purPrice.getLong("material.id");
        Map matDefSubEleMap = param.getMatDefSubEleMap();
        Long defSubEleId = (Long)matDefSubEleMap.get(matId);
        boolean isExistTargetMat = false;
        for (DynamicObject row : rows) {
            DynamicObject subelement = row.getDynamicObject("subelement");
            String type = subelement.getString("type");
            if (!ELEMENTTYPE_MATERIAL.equals(type)) {
                BigDecimal rate = row.getBigDecimal("rate").divide(new BigDecimal(100));
                row.set("price", (Object)rate.multiply(currMatPrice));
            } else if (subelement.getLong("id") == defSubEleId.longValue()) {
                row.set("price", (Object)currMatPrice);
                isExistTargetMat = true;
            }
            amount = amount.add(row.getBigDecimal("price"));
        }
        if (!isExistTargetMat) {
            DynamicObject newMatRow = rows.addNew();
            newMatRow.set("seq", (Object)(rows.size() + 1));
            newMatRow.set("subelement", (Object)defSubEleId);
            newMatRow.set("element", param.getPurPriceSubEleAndEleMap().get(defSubEleId));
            newMatRow.set("price", (Object)currMatPrice);
            amount = amount.add(currMatPrice);
        }
        purPrice.set("amount", (Object)amount);
    }

    private Map<String, DynamicObject> getMatAndPurPriceMap(String costTypeId, Set<Long> matIds) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("material", "in", matIds));
        qfList.add(new QFilter("costtype", "=", (Object)Long.valueOf(costTypeId)));
        List purPriceIds = QueryServiceHelper.queryPrimaryKeys((String)"cad_purprices", (QFilter[])qfList.toArray(new QFilter[0]), null, (int)-1);
        DynamicObject[] purPrices = BusinessDataServiceHelper.load((Object[])purPriceIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_purprices"));
        HashMap<String, DynamicObject> matAndPurPriceIdMap = new HashMap<String, DynamicObject>(16);
        if (purPrices != null && purPrices.length > 0) {
            for (int i = 0; i < purPrices.length; ++i) {
                DynamicObject purPrice = purPrices[i];
                StringBuilder matKey = new StringBuilder();
                matKey.append(purPrice.getLong("material.id")).append(SPLIT_1).append(purPrice.getLong("matversion.id")).append(SPLIT_1).append(purPrice.getLong("auxpty.id"));
                matAndPurPriceIdMap.put(matKey.toString(), purPrice);
            }
        }
        return matAndPurPriceIdMap;
    }

    private void showForm(IFormView view, String entityName, String costtypeId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(entityName);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("costtype", (Object)costtypeId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "stdRateSetting_Update"));
        view.showForm((FormShowParameter)formShowParameter);
    }

    private void showQuickUpdateApply() {
        String costtypeId = this.getPageCache().get("CostType");
        DynamicObject costType = CostTypeHelper.getCostType((Long)Long.parseLong(costtypeId), (String)"type");
        if ("0".equals(costType.getString("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"PurPriceListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurPriceListPlugin_36", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        ArrayList<QFilter> statusEnableQf = new ArrayList<QFilter>(16);
        statusEnableQf.add(new QFilter("id", "in", ids));
        statusEnableQf.add(new QFilter("billstatus", "=", (Object)"C"));
        HashSet newIds = new HashSet(ids);
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"costtype,material,tracknumber", (QFilter[])statusEnableQf.toArray(new QFilter[0]));
        if (purPrices.size() != newIds.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u3002", (String)"PurPriceListPlugin_37", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String matInfo = this.getMulPriceRule(ids);
        if (!CadEmptyUtils.isEmpty((String)matInfo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u201c%s\u201d\u6307\u5b9a\u4e86\u591a\u79cd\u53d6\u4ef7\u89c4\u5219\uff0c\u8bf7\u91cd\u9009\u3002", (String)"PurPriceListPlugin_27", (String)"macc-cad-formplugin", (Object[])new Object[0]), matInfo));
            return;
        }
        String mulMatKcInfo = this.getMulMatKcInfo(ids);
        if (!CadEmptyUtils.isEmpty((String)mulMatKcInfo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u201c%s\u201d\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7ec4\u5408\u201c\u7269\u6599+\u8f85\u52a9\u5c5e\u6027+\u914d\u7f6e\u53f7+\u8ddf\u8e2a\u53f7\u201d\u3002", (String)"PurPriceListPlugin_38", (String)"macc-cad-formplugin", (Object[])new Object[0]), mulMatKcInfo));
            return;
        }
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if ("1".equals(isAttTargetCostType)) {
            QFilter idFilter = new QFilter("id", "in", ids);
            QFilter trcakFilter = new QFilter("tracknumber", ">", (Object)0L);
            DynamicObjectCollection purPriceObjs = QueryServiceHelper.query((String)"cad_purprices", (String)"id", (QFilter[])new QFilter[]{idFilter, trcakFilter});
            List trackPriceIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)purPriceObjs, (String)"id");
            ids.removeAll(trackPriceIds);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cad_quickapplyupdate");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("costtype", (Object)((DynamicObject)purPrices.get(0)).getString("costtype"));
            formShowParameter.setCustomParam("sourcePage", (Object)"purPrice");
            formShowParameter.setCustomParam("ids", ids);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
            formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cad_quickapplyupdate");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("costtype", (Object)((DynamicObject)purPrices.get(0)).getString("costtype"));
            formShowParameter.setCustomParam("sourcePage", (Object)"purPrice");
            formShowParameter.setCustomParam("ids", (Object)trackPriceIds);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cad_quickapplyupdate");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("costtype", (Object)((DynamicObject)purPrices.get(0)).getString("costtype"));
            formShowParameter.setCustomParam("sourcePage", (Object)"purPrice");
            formShowParameter.setCustomParam("ids", ids);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
        }
    }

    private void showImportForm() {
        Long costtypeId = Long.valueOf(this.getPageCache().get("CostType"));
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costtypeId)});
        if (CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u5c5e\u6027\u7684\u6210\u672c\u7c7b\u578b\uff0c\u4e0d\u652f\u6301\u624b\u5de5\u7f16\u8f91\u3002\u8bf7\u901a\u8fc7\u6210\u672c\u66f4\u65b0\u64cd\u4f5c\u66f4\u65b0\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u3002", (String)"PurPriceListPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cad_importmatcostinfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("costType", (Object)this.getPageCache().get("CostType"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importFromCostInfo"));
        this.getView().showForm(formShowParameter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String costTypeId = PriceCommon.getCostTypeId(e.getParameter().getFormId(), e.getParameter().getPkId());
        if (StringUtils.isEmpty((String)costTypeId)) {
            costTypeId = this.getCacheCostType();
        }
        e.getParameter().setCustomParam("CostType", (Object)costTypeId);
        if (!PriceCommon.isSimulatedCostType(costTypeId)) {
            e.getParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String pageCacheCosttype = this.getPageCache().get("CostType");
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = PriceCommon.getCostTypeComboItemList(this.getView().getFormShowParameter().getAppId());
            if (costTypes == null || costTypes.isEmpty()) break;
            commonFilterColumn.setComboItems(costTypes);
            ComboItem item = costTypes.get(0);
            commonFilterColumn.setDefaultValue(item.getValue());
            commonFilterColumn.setMustInput(true);
            if (!CadEmptyUtils.isEmpty((String)pageCacheCosttype)) break;
            pageCacheCosttype = item.getValue();
            break;
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("CostType", pageCacheCosttype);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("costtype.id".equals(field) || "costtype.name".equals(field)) {
            e.addCustomQFilter(CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView()));
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                e.getQfilters().add(baseDataFilter);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter") || filterValues.containsKey("schemefilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            List list = customfilter = customfilter != null ? customfilter : (List)filterValues.get("schemefilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            String pageCacheCosttype = null;
            for (int i = 0; i < customfilter.size(); ++i) {
                Map map = (Map)customfilter.get(i);
                List listFieldName = (List)map.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (listFieldName.get(j).equals("costtype.id")) {
                        List listValue = (List)map.get("Value");
                        pageCacheCosttype = (String)listValue.get(j);
                        continue;
                    }
                    if (!listFieldName.get(j).equals("costtype.name")) continue;
                    List ids = (List)map.get("Id");
                    List list2 = ids = ids == null ? (List)map.get("id") : ids;
                    if (CadEmptyUtils.isEmpty((List)ids)) continue;
                    pageCacheCosttype = ids.get(0).toString();
                }
            }
            if (pageCacheCosttype != null) {
                this.getPageCache().put("CostType", pageCacheCosttype);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            e.getQFilters().add(new QFilter("costtype.type", "=", (Object)"1"));
        }
        List filters = e.getQFilters();
        PriceHelper.filterExpDate((List)filters);
        filters.add(new QFilter("entryentity.price", "!=", (Object)BigDecimal.ZERO));
        e.setOrderBy("billno asc,costtype.name asc");
    }

    private String getCacheCostType() {
        String id = this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)id) && StringUtils.isNotEmpty((String)(id = this.getDefualtSelectCostType()))) {
            this.getPageCache().put("CostType", id);
        }
        return id;
    }

    private String getDefualtSelectCostType() {
        DynamicObject[] costTypes;
        Boolean isAca = "aca".equals(this.getView().getFormShowParameter().getAppId());
        DynamicObject[] dynamicObjectArray = costTypes = isAca != false ? ElementRelationHelper.getModeCostTypes() : ElementRelationHelper.getCostTypes();
        if (costTypes == null || costTypes.length < 1) {
            return null;
        }
        return String.valueOf(costTypes[0].getLong("id"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importFromCostInfo": {
                DynamicObject costType = (DynamicObject)closedCallBackEvent.getReturnData();
                if (costType == null) break;
                this.importFromCostInfo(costType);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "stdRateSetting_Update": {
                if (closedCallBackEvent.getReturnData() == null || !"save".equals(closedCallBackEvent.getReturnData().toString())) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "purPricingRule": {
                String res = (String)closedCallBackEvent.getReturnData();
                if (res == null || !res.equals("success")) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u4fdd\u5b58\u6210\u529f\u3002", (String)"PurPriceListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                break;
            }
            case "updateStandCostBack": 
            case "updateEffDateBack": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "closeBack_doPricing": {
                this.getView().hideLoading();
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfo = this.getPageCache().get("responseInfo");
                this.logger.info("\u53d6\u4ef7\uff0c\u53d6\u4ef7\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)responseInfo);
                if (CadEmptyUtils.isEmpty((String)responseInfo)) {
                    return;
                }
                Map result = (Map)SerializationUtils.fromJsonString((String)responseInfo, Map.class);
                boolean status = (Boolean)result.get("status");
                boolean existFailedCalcRule = (Boolean)result.get("existFailedCalcRule");
                if (!status) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u4ef7\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002", (String)"PurPriceListPlugin_39", (String)"macc-cad-formplugin", (Object[])new Object[0]), result.get("errMsg")));
                } else {
                    int count;
                    int n = count = result.get("count") == null ? 0 : (Integer)result.get("count");
                    if (count == 0) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"PurPriceListPlugin_34", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    } else {
                        String tips = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5f15\u5165%1$s\u6761\u6570\u636e\u3002", (String)"PurPriceListPlugin_35", (String)"macc-cad-formplugin", (Object[])new Object[0]), count);
                        this.getView().showSuccessNotification(tips);
                    }
                    if (existFailedCalcRule) {
                        this.getView().showErrorNotification(result.get("failedCalcRuleTips").toString());
                    }
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void importFromCostInfo(DynamicObject costtype) {
        DynamicObject[] materialCosts;
        String currentCostTypePrimaryKey = this.getCacheCostType();
        DynamicObject currentCostType = BusinessDataServiceHelper.loadSingle((Object)currentCostTypePrimaryKey, (String)"cad_costtype");
        DynamicObjectCollection costInfos = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"material", (QFilter[])new QFilter[]{new QFilter("costtype", "=", costtype.get("id")), new QFilter("status", "=", (Object)"C")});
        Set materials = costInfos.stream().map(e -> e.getLong("material")).collect(Collectors.toSet());
        Iterator iterator = materials.iterator();
        while (iterator.hasNext()) {
            Long materialId = (Long)iterator.next();
            if (this.isVerifyPass(materialId, currentCostType)) continue;
            iterator.remove();
        }
        if (materials.size() == 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u201c%1$s/%2$s\u201d\u4e0b\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u672a\u83b7\u53d6\u5230\u5916\u8d2d\u4ef6\u4fe1\u606f\u3002", (String)"PurPriceListPlugin_23", (String)"macc-cad-formplugin", (Object[])new Object[0]), costtype.get("number"), costtype.get("name"));
            this.logger.info(msg);
            throw new KDBizException(msg);
        }
        ArrayList<DynamicObject> outPurchases = new ArrayList<DynamicObject>(10);
        String selectProp = "costtype,material,matversion,auxpty,entryentity.element,entryentity.subelement,entryentity.standardcost";
        for (DynamicObject materialCost : materialCosts = BusinessDataServiceHelper.load((String)"cad_matcostinfo", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("material", "in", materials), new QFilter("costtype", "=", costtype.get("id")), new QFilter("status", "=", (Object)"C")})) {
            DynamicObject outPurchaseBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_purprices");
            outPurchaseBill.set("costtype", (Object)currentCostType);
            outPurchaseBill.set("currency", materialCost.get("costtype.currency"));
            outPurchaseBill.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
            outPurchaseBill.set("expdate", (Object)DateUtils.getDeFaultExpDate());
            outPurchaseBill.set("material", materialCost.get("material"));
            outPurchaseBill.set("matversion", materialCost.get("matversion"));
            outPurchaseBill.set("auxpty", materialCost.get("auxpty"));
            outPurchaseBill.set("datasrc", (Object)"manual");
            this.setOutPurchaseEntry(outPurchaseBill, materialCost);
            this.fillBaseInfo(outPurchaseBill);
            outPurchases.add(outPurchaseBill);
        }
        try {
            List purPriceBillNo = CodeRuleServiceHelper.getNumbers((String)"cad_purprices", outPurchases);
            int count = 0;
            if (purPriceBillNo.size() == outPurchases.size()) {
                for (DynamicObject outPurchase : outPurchases) {
                    outPurchase.set("billno", purPriceBillNo.get(count++));
                }
            }
        }
        catch (Exception e2) {
            this.logger.error("\u6279\u91cf\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38,\u8bf7\u68c0\u67e5\u7f16\u53f7\u89c4\u5219", (Throwable)e2);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_purprices", (DynamicObject[])outPurchases.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f", (String)"PurPriceListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private void setOutPurchaseEntry(DynamicObject outPurchaseBill, DynamicObject materialCost) {
        BigDecimal amount = new BigDecimal("0");
        BigDecimal materialAmount = new BigDecimal("0");
        DynamicObjectCollection costinfo_entryentity = materialCost.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection outpurchase_entryentity = outPurchaseBill.getDynamicObjectCollection("entryentity");
        boolean isexists = this.isExistSubEleByMat(costinfo_entryentity);
        for (DynamicObject entry : costinfo_entryentity) {
            if (!this.isMaterialEntry(entry)) continue;
            DynamicObject dObj = outpurchase_entryentity.addNew();
            dObj.set("element", entry.get("element"));
            dObj.set("subelement", entry.get("subelement"));
            dObj.set("price", entry.get("standardcost"));
            if (ELEMENTTYPE_MATERIAL.equals(entry.getString("subelement.type"))) {
                materialAmount = materialAmount.add(entry.getBigDecimal("standardcost"));
            }
            amount = amount.add(entry.getBigDecimal("standardcost"));
        }
        if (isexists) {
            QFilter typeFilter = new QFilter("type", "=", (Object)ELEMENTTYPE_MATERIALFEE);
            QFilter caclFilter = new QFilter("supmaterielcount", "=", (Object)Character.valueOf('1'));
            DynamicObject[] subelements = BusinessDataServiceHelper.load((String)"cad_subelement", (String)"number,type,supmaterielcount", (QFilter[])new QFilter[]{typeFilter, caclFilter});
            DynamicObject element = BusinessDataServiceHelper.loadSingle((String)"cad_element", (String)"number,type", (QFilter[])new QFilter[]{typeFilter});
            for (int i = 0; i < subelements.length; ++i) {
                DynamicObject dObj = outpurchase_entryentity.addNew();
                dObj.set("element", (Object)element);
                dObj.set("subelement", (Object)subelements[i]);
                BigDecimal rate = this.getStdRate(subelements[i]);
                dObj.set("price", (Object)materialAmount.multiply(rate).divide(new BigDecimal("100")));
                dObj.set("rate", (Object)rate);
                amount = amount.add(dObj.getBigDecimal("price"));
            }
        }
        outPurchaseBill.set("amount", (Object)amount);
    }

    private BigDecimal getStdRate(DynamicObject subelement) {
        String currentType = this.getCacheCostType();
        QFilter typeFilter = new QFilter("costtype", "=", (Object)Long.parseLong(currentType));
        QFilter subEleFilter = new QFilter("entryentity.subelement", "=", subelement.getPkValue());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_stdratesetting", (String)"entryentity.stdrate", (QFilter[])new QFilter[]{typeFilter, subEleFilter});
        return dynamicObject != null ? dynamicObject.getBigDecimal("entryentity.stdrate") : new BigDecimal("0");
    }

    private boolean isExistSubEleByMat(DynamicObjectCollection costinfo_entryentity) {
        for (DynamicObject ele : costinfo_entryentity) {
            DynamicObject subelement = ele.getDynamicObject("subelement");
            if (!subelement.getBoolean("supmaterielcount")) continue;
            return true;
        }
        return false;
    }

    private void fillBaseInfo(DynamicObject outPurchaseBill) {
        outPurchaseBill.set("billstatus", (Object)"A");
        outPurchaseBill.set("creator", (Object)RequestContext.get().getUserId());
        outPurchaseBill.set("createtime", (Object)new Date());
    }

    private boolean isMaterialEntry(DynamicObject entry) {
        ArrayList types = Lists.newArrayList((Object[])new String[]{ELEMENTTYPE_MATERIAL, ELEMENTTYPE_MATERIALFEE});
        String elementType = entry.getString("element.type");
        String subelementType = entry.getString("subelement.type");
        boolean calcByMatCost = entry.getBoolean("subelement.supmaterielcount");
        return types.contains(elementType) && types.contains(subelementType) && !calcByMatCost;
    }

    private boolean isVerifyPass(Long materialId, DynamicObject costtype) {
        QFilter idFilter = new QFilter("id", "=", (Object)materialId);
        QFilter materialFilter = new QFilter("material", "=", (Object)materialId);
        QFilter typeFilter = new QFilter("costtype", "=", costtype.get("id"));
        DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"enableproduct,enablepur", (QFilter[])new QFilter[]{idFilter});
        boolean exists = QueryServiceHelper.exists((String)"cad_bomsetting", (QFilter[])new QFilter[]{materialFilter, typeFilter});
        return material.getBoolean("enableproduct") && material.getBoolean("enablepur") && !exists;
    }

    private void updateRateBusinessCtrl() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        Map<Long, BigDecimal> rate = this.getRate(rows);
        Map<Long, String> businessCtrl = this.getBusinessCtrl(rows);
        if (rate == null || businessCtrl == null) {
            return;
        }
        int i = 0;
        for (ListSelectedRow row : rows) {
            String enablepur = businessCtrl.get(row.getPrimaryKeyValue());
            if (StringUtils.isNotEmpty((String)enablepur)) {
                billList.setCellFieldValue("businessctrl", i, (Object)enablepur);
            }
            ++i;
        }
    }

    private Map<Long, BigDecimal> getRate(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return null;
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection purPrice = QueryServiceHelper.query((String)"cad_purprices", (String)"entryentity.id,entryentity.rate", (QFilter[])new QFilter[]{filter});
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        for (DynamicObject pur : purPrice) {
            map.put(pur.getLong("entryentity.id"), pur.getBigDecimal("entryentity.rate"));
        }
        return map;
    }

    private Map<Long, String> getBusinessCtrl(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return null;
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection purPrice = QueryServiceHelper.query((String)"cad_purprices", (String)"id,material.enablepur enablepur", (QFilter[])new QFilter[]{filter});
        HashMap<Long, String> map = new HashMap<Long, String>();
        String val = ResManager.loadKDString((String)"\u53ef\u91c7\u8d2d", (String)"PurPriceListPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        for (DynamicObject pur : purPrice) {
            if (pur == null || !pur.getBoolean("enablepur")) continue;
            map.put(pur.getLong("id"), val);
        }
        return map;
    }

    private boolean isDownCalc(DynamicObjectCollection purPrices) {
        if (purPrices == null) {
            return true;
        }
        Long costTypeId = ((DynamicObject)purPrices.get(0)).getLong("costtype");
        HashSet materialIds = new HashSet(10);
        purPrices.forEach(p -> materialIds.add(p.getLong("material")));
        this.logger.info(String.format("\u53c2\u6570\uff1a\u6210\u672c\u7c7b\u578b%1$s,\u7269\u6599%2$s", costTypeId, materialIds));
        String selectedFields = "material.number AS matNumber";
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("isdowncalc", "=", (Object)Boolean.TRUE), new QFilter("material", "in", materialIds), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection bomSetting = QueryServiceHelper.query((String)"cad_bomsetting", (String)selectedFields, (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)bomSetting)) {
            return false;
        }
        StringBuilder sg = new StringBuilder();
        for (DynamicObject bomSet : bomSetting) {
            sg.append("\u3001");
            sg.append(bomSet.getString("matNumber"));
        }
        if (sg.length() == 0) {
            return false;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u7269\u6599%s\u7684\u6210\u672cBOM\u8bbe\u7f6e\u7684\u5411\u4e0b\u5377\u7b97\u672a\u5173\u95ed\u3002", (String)"PurPriceListPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]), sg.substring(1)));
        return true;
    }

    private String getMulPriceRule(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"keycolid,material.number materialnumber,material.name materialname,pricerule", (QFilter[])filters);
        if (purPrices.isEmpty()) {
            return null;
        }
        HashMap<Long, List> groups = new HashMap<Long, List>(purPrices.size());
        for (DynamicObject purPrice : purPrices) {
            groups.computeIfAbsent(purPrice.getLong("keycolid"), p -> new ArrayList()).add(purPrice);
        }
        for (Map.Entry group : groups.entrySet()) {
            if (CadEmptyUtils.isEmpty((List)((List)group.getValue())) || ((List)group.getValue()).size() < 2) continue;
            HashSet<Long> ruleIds = new HashSet<Long>(((List)group.getValue()).size());
            for (DynamicObject value : (List)group.getValue()) {
                ruleIds.add(value.getLong("pricerule"));
                if (ruleIds.size() <= 1) continue;
                return value.getString("materialnumber") + "/" + value.getString("materialname");
            }
        }
        return null;
    }

    private String getMulMatKcInfo(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"keycol,material.number materialnumber,material.name materialname,pricerule", (QFilter[])filters);
        if (purPrices.isEmpty()) {
            return null;
        }
        HashSet<String> existKeycols = new HashSet<String>(10);
        String msg = "";
        for (DynamicObject purPrice : purPrices) {
            String keycol = purPrice.getString("keycol");
            if (existKeycols.add(keycol) || msg.contains(purPrice.getString("materialnumber"))) continue;
            if (CadEmptyUtils.isEmpty((String)msg)) {
                msg = purPrice.getString("materialnumber") + "/" + purPrice.getString("materialname");
                continue;
            }
            msg = msg + "\u3001" + purPrice.getString("materialnumber") + "/" + purPrice.getString("materialname");
        }
        return msg;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "updatestandcost": 
            case "updateeffdate": {
                if (!PriceHelper.checkOperation((BeforeDoOperationEventArgs)e, (IFormView)this.getView(), (String)"cad_purprices", (String)this.getPageCache().get("CostType"), (String)operateKey)) break;
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("updatestandcost".equals(operateKey) ? "cad_updatestandcost" : "cad_seteffectdate");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("costtype", this.getPageCache().get("CostType"));
                map.put("entityNum", "cad_purprices");
                map.put("ids", PriceHelper.getSelectIds((BeforeDoOperationEventArgs)e));
                parameter.setCustomParams(map);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updatestandcost".equals(operateKey) ? "updateStandCostBack" : "updateEffDateBack"));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    private void doAutoPrice() {
        String costtypeId = this.getPageCache().get("CostType");
        if (costtypeId != null) {
            long costType = Long.parseLong(costtypeId);
            DynamicObject object = CostTypeHelper.getCostType((Long)costType, (String)"type,name");
            if ("0".equals(object.getString("type"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u81ea\u52a8\u53d6\u4ef7\u3002", (String)"PurPriceListPlugin_32", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            DLock lock = DLock.create((String)("AutoPricing_cad_purprices_" + costType), (String)ResManager.loadKDString((String)"\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u53d6\u4ef7\u9501", (String)"PurPriceListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%s\u3011\u6b63\u5728\u8fdb\u884c\u91c7\u8d2d\u53d6\u4ef7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"PurPriceListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), object.getString("name")));
                return;
            }
            List orgList = CostTypeHelper.getOrgByCostType((Long)costType);
            ArrayList accountList = new ArrayList(5);
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u53d6\u4ef7", (String)"PurPriceListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map result = new HashMap(16);
                try {
                    result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"AutoPricingService", (String)"execute", (Object[])new Object[]{"cad_purprices", orgList, accountList, RequestContext.get().getCurrUserId(), costType, this.getView().getFormShowParameter().getAppId(), progressId});
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u5fae\u670d\u52a1-\u53d6\u4ef7\u62a5\u9519\uff1a", (Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.close();
                    }
                }
                this.logger.info("\u53d6\u4ef7\uff0ccount\uff1a{}", result.get("count"));
                this.getPageCache().put("responseInfo", SerializationUtils.toJsonString(result));
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doPricing));
        }
    }
}

