/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PurPricingRuleEdit
extends AbstractBillPlugIn {
    private static final String OP_SAVEORUPDATE = "saveorupdate";
    private static final String OP_CANCEL = "cancel";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object costType = fsp.getCustomParam("costtype");
        IDataModel model = this.getModel();
        if (costType != null) {
            model.setValue("costtype", costType);
            model.setValue("user", (Object)RequestContext.get().getUserId());
            this.initCombo();
            this.bindInfo();
        }
        model.setDataChanged(false);
    }

    protected void initCombo() {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "saveorupdate": {
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "saveorupdate": {
                if (!this.isDataCheckPass(args) || !this.isBizCheckPass()) break;
                this.saveCurrBillInfo("cad_purpricingrule");
            }
        }
    }

    protected boolean isBizCheckPass() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String level_con = dataEntity.getString("level_con");
        String level_order = dataEntity.getString("level_order");
        if (StringUtils.isEmpty((CharSequence)level_con) && StringUtils.isEmpty((CharSequence)level_order)) {
            return false;
        }
        if (level_con.equals(level_order)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u540c\u7ea7\u522b\u7684\u4f18\u5148\u7ea7\u3002", (String)"PurPricingRuleEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean isDataCheckPass(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        return operationResult.isSuccess();
    }

    protected void saveCurrBillInfo(String entityName) {
        DynamicObject pricingRule = this.getPricingRuleSingle(entityName);
        if (pricingRule == null) {
            pricingRule = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        }
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        IDataModel model = this.getModel();
        for (IDataEntityProperty prop : properties) {
            pricingRule.set(prop.getName(), model.getValue(prop.getName()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pricingRule});
        model.setDataChanged(false);
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    protected void bindInfo() {
        DynamicObject pricingRule = this.getPricingRuleSingle("cad_purpricingrule");
        if (pricingRule != null) {
            DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
            IDataModel model = this.getModel();
            if (model != null) {
                for (IDataEntityProperty prop : properties) {
                    if (prop == null) continue;
                    model.setValue(prop.getName(), pricingRule.get(prop.getName()));
                }
                model.setDataChanged(false);
            }
        }
    }

    protected DynamicObject getPricingRuleSingle(String entityName) {
        DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("costtype");
        DynamicObject user = this.getModel().getDataEntity().getDynamicObject("user");
        QFilter commonQf = new QFilter("costtype", "=", (Object)costType.getLong("id"));
        commonQf.and("user", "=", (Object)user.getLong("id"));
        DynamicObject pricingRule = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{commonQf});
        if (pricingRule == null) {
            return null;
        }
        DynamicObject pricingRuleBiz = BusinessDataServiceHelper.loadSingle((Object)pricingRule.get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        return pricingRuleBiz;
    }
}

