/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;

public class ResourceOutEditPlugin
extends AbstractBillPlugIn {
    public static final String ENTITY_ENTRY = "entryentity";
    private static final String CALCBASIS_RESOURCE = "001";
    private static final String CALCBASIS_MATERIAL = "002";
    private static final String CALCBASIS_BATCH = "003";
    private static final String E003 = "003";
    private static final String E004 = "004";
    private static final String E005 = "005";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit elementCtrl = (BasedataEdit)this.getControl("element");
        elementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter fParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = fParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            HashSet<String> type = new HashSet<String>();
            type.add(E004);
            type.add(E005);
            qList.add(new QFilter("type", "in", type));
        });
        BasedataEdit subElementCtrl = (BasedataEdit)this.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", beforeF7SelectEvent.getRow());
            if (element == null) {
                HashSet<String> type = new HashSet<String>();
                type.add(E004);
                type.add(E005);
                showParameter.getListFilterParameter().setFilter(new QFilter("type", "in", type));
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getSubElement(element.getLong("id"))));
            }
        });
        BasedataEdit attaSubElementCtrl = (BasedataEdit)this.getControl("attasubelement");
        attaSubElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            HashSet<String> type = new HashSet<String>();
            type.add("003");
            showParameter.getListFilterParameter().setFilter(new QFilter("type", "in", type));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_ENTRY);
            Set attaSubelemenIds = entryEntity.stream().map(s -> s.getLong("attasubelement.id")).collect(Collectors.toSet());
            if (!attaSubelemenIds.isEmpty()) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", attaSubelemenIds));
            }
        });
        BasedataEdit materialEdit = (BasedataEdit)this.getControl("material");
        materialEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(this.getMatFilter());
        });
        BasedataEdit resourceunitEdit = (BasedataEdit)this.getControl("resourceunit");
        resourceunitEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            String calcbasis = (String)this.getModel().getValue("calcbasis");
            if (CALCBASIS_RESOURCE.equals(calcbasis)) {
                qFilters.add(new QFilter("group.number", "=", (Object)"Time"));
            } else {
                qFilters.add(new QFilter("group.number", "=", (Object)"Quantity"));
            }
        });
        BasedataEdit manuorgEdit = (BasedataEdit)this.getControl("manuorg");
        manuorgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
            if (costType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u7c7b\u578b\u201d", (String)"ResourceOutEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            List ids = PriceHelper.getProdOrg((Long)costType.getLong("createorg.id"), (Long)costType.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(new QFilter("id", "in", (Object)ids));
        });
        BasedataEdit routeEdit = (BasedataEdit)this.getControl("route");
        routeEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
            if (costType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u7c7b\u578b\u201d", (String)"ResourceOutEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Object manuOrg = this.getModel().getValue("manuorg");
            String srcRoute = (String)this.getModel().getValue("srcroute");
            if (manuOrg == null) {
                if ("cad_router".equals(srcRoute)) {
                    long createOrg = costType.getLong("createorg.id");
                    QFilter orgCtrlQfilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(Collections.singletonList(createOrg), (String)srcRoute);
                    qFilters.add(orgCtrlQfilter);
                } else {
                    List ids = PriceHelper.getProdOrg((Long)costType.getLong("createorg.id"), (Long)costType.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
                    QFilter orgCtrlQfilter = MatBaseDataFilterHelper.getOrgCtrlQfilter((List)ids, (String)srcRoute);
                    qFilters.add(orgCtrlQfilter);
                }
            } else if ("cad_router".equals(srcRoute)) {
                QFilter orgFilter = new QFilter("manuorg", "=", (Object)((DynamicObject)manuOrg).getLong("id"));
                qFilters.add(orgFilter);
            } else {
                QFilter orgCtrlQfilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(Collections.singletonList(((DynamicObject)manuOrg).getLong("id")), (String)srcRoute);
                qFilters.add(orgCtrlQfilter);
            }
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
            qFilters.add(new QFilter("processtype", "in", (Object)new String[]{"A", "B"}));
            qFilters.add(new QFilter("processentry.machiningtype", "in", (Object)new String[]{"1002", "1003"}));
        });
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        String srcRoute = (String)this.getModel().getValue("srcroute");
        if (CadEmptyUtils.isEmpty((String)srcRoute)) {
            srcRoute = PriceHelper.getPriceRouteEntity((Long)costType.getLong("id"));
            this.getModel().setValue("srcroute", (Object)srcRoute);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getOperationKey().toUpperCase()) {
            case "COPY": {
                DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
                if (priceRule == null) {
                    return;
                }
                PriceCommon.copyCheck(this.getView(), evt, priceRule.getLong("id"));
                break;
            }
        }
    }

    private void setCalcBasis() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject subelement = dataEntity.getDynamicObject("subelement");
        String type = "";
        if (subelement != null) {
            type = subelement.getString("type");
        }
        this.setCalcBasis(type);
    }

    private void setResourceUnitValue() {
        IDataModel model = this.getModel();
        String calcbasis = this.getCalcbasis();
        if (CALCBASIS_RESOURCE.equals(calcbasis)) {
            model.setValue("resourceunit", (Object)10L);
        } else if (CALCBASIS_MATERIAL.equals(calcbasis) || "003".equals(calcbasis)) {
            model.setValue("resourceunit", (Object)11L);
        } else {
            model.setValue("resourceunit", null);
        }
    }

    private void setValueVisible() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String calcbasis = dataEntity.getString("calcbasis");
        DynamicObject subelement = dataEntity.getDynamicObject("subelement");
        String type = "";
        if (subelement != null) {
            type = subelement.getString("type");
        }
        boolean showQty = false;
        boolean showAmount = false;
        boolean showAttaAmount = false;
        if (CALCBASIS_RESOURCE.equals(calcbasis)) {
            showQty = true;
            model.setValue("amount", null);
            if (E004.equals(type) || E005.equals(type)) {
                showAttaAmount = true;
            }
        } else if (CALCBASIS_MATERIAL.equals(calcbasis) || "003".equals(calcbasis)) {
            showAmount = true;
            model.setValue("qty", null);
        }
        view.setVisible(Boolean.valueOf(showQty), new String[]{"qty"});
        view.setVisible(Boolean.valueOf(showAmount), new String[]{"amount"});
        view.setVisible(Boolean.valueOf(showAttaAmount), new String[]{"attaqty"});
        view.setVisible(Boolean.valueOf(!showAttaAmount), new String[]{"attaamt"});
    }

    private void setEntryEntityVisible() {
        String subEleType = this.getSubEleType();
        if (E004.equals(subEleType) || E005.equals(subEleType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"attaitem"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"attaitem"});
        }
    }

    private void setEntryEntityDefValue() {
        IDataModel model = this.getModel();
        if (model.getEntryRowCount(ENTITY_ENTRY) > 0) {
            model.deleteEntryData(ENTITY_ENTRY);
        }
    }

    private void setCalcBasis(String type) {
        if (!E004.equals(type) && !E005.equals(type)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"calcbasis"});
            this.getModel().setValue("calcbasis", null);
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"calcbasis"});
        ComboEdit control = (ComboEdit)this.getControl("calcbasis");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        if (E004.equals(type) || E005.equals(type)) {
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u5de5\u65f6", (String)"ResourceOutEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0])), CALCBASIS_RESOURCE));
        }
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599", (String)"ResourceOutEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0])), CALCBASIS_MATERIAL));
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6279\u6b21", (String)"ResourceOutEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0])), "003"));
        control.setComboItems(comboItemList);
        this.setCalcBasisDefValue(type);
    }

    private void setCalcBasisDefValue(String type) {
        if (E004.equals(type)) {
            this.getModel().setValue("calcbasis", (Object)CALCBASIS_RESOURCE);
        } else if (E005.equals(type)) {
            this.getModel().setValue("calcbasis", (Object)CALCBASIS_MATERIAL);
        } else {
            this.getModel().setValue("calcbasis", null);
        }
    }

    private void cleanSubele() {
        DynamicObject ele = (DynamicObject)this.getModel().getValue("element");
        if (ele == null) {
            this.getModel().setValue("subelement", null);
        }
    }

    private void setAttaElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject attasubelement = row.getDynamicObject("attasubelement");
            if (attasubelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter("subelement", "=", (Object)attasubelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue("attaelement", (Object)elementDetail.getLong("element.id"), rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        switch (name) {
            case "element": {
                this.setDefaultSubElement(e);
                this.cleanSubele();
                break;
            }
            case "subelement": {
                this.setElement(e);
                this.setCalcBasis();
                break;
            }
            case "calcbasis": {
                this.setResourceUnitValue();
                this.setResourceUnitEnable();
                this.setValueVisible();
                this.setEntryEntityDefValue();
                break;
            }
            case "attasubelement": {
                this.setAttaElement(e);
                break;
            }
            case "material": {
                Util.ctrlVerAndAuxpty(this.getView());
                this.effectDateEnable();
                break;
            }
            case "resource": 
            case "costtype": 
            case "auxpty": {
                this.effectDateEnable();
                break;
            }
            case "priceeffectdate": {
                this.getModel().setValue("effectdate", (Object)this.getModel().getDataEntity().getDate("priceeffectdate"));
                break;
            }
            case "manuorg": {
                Object route = this.getModel().getValue("route");
                if ((oldValue == null || route == null) && (oldValue != null || route == null)) break;
                this.getModel().setValue("route", null);
                this.cleaRouteInfo();
                break;
            }
            case "route": {
                if (oldValue == null) break;
                this.cleaRouteInfo();
            }
        }
    }

    private void cleaRouteInfo() {
        this.getModel().setValue("processseq", (Object)"");
        this.getModel().setValue("operationno", (Object)"");
        this.getModel().setValue("operation", null);
        this.getModel().setValue("operationdesc", (Object)"");
        this.getModel().setValue("workstation", null);
    }

    private void setRouteInfo() {
        Object route = this.getModel().getValue("route");
        String processSeq = (String)this.getModel().getValue("processseq");
        String operationNo = (String)this.getModel().getValue("operationno");
        if (route == null || CadEmptyUtils.isEmpty((String)processSeq) || CadEmptyUtils.isEmpty((String)operationNo)) {
            return;
        }
        String srcRoute = (String)this.getModel().getValue("srcroute");
        Long routeId = ((DynamicObject)route).getLong("id");
        QFilter filter = new QFilter("id", "=", (Object)routeId);
        filter.and(new QFilter("processentry.parent", "=", (Object)processSeq));
        DynamicObject routeObject = QueryServiceHelper.queryOne((String)srcRoute, (String)"processentry.operation operation,processentry.operationdesc operationdesc,processentry.workstation workstation", (QFilter[])new QFilter[]{filter});
        if (routeObject == null) {
            return;
        }
        this.getModel().setValue("operation", (Object)routeObject.getLong("operation"));
        this.getModel().setValue("operationdesc", (Object)routeObject.getString("operationdesc"));
        this.getModel().setValue("workstation", (Object)routeObject.getLong("workstation"));
        this.getView().updateView();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDataSrc();
        this.getModel().setValue("pricerule", (Object)PriceRuleConstants.OUTRES_MANUALLY_ID);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object costType = fsp.getCustomParam("CostType");
        if (costType != null) {
            String srcRoute = PriceHelper.getPriceRouteEntity((Long)Long.parseLong(costType.toString()));
            this.getModel().setValue("srcroute", (Object)srcRoute);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object costType = fsp.getCustomParam("CostType");
        if (costType != null) {
            this.getModel().setValue("costtype", costType);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costtype"});
            this.bindCurrency();
        }
        if (PriceCommon.isCalcCostType((String)costType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new", "bar_del", "bar_save", "bar_modify", "bar_submit", "bar_audit", "bar_submitandnew", "bar_more"});
        }
        this.setValueEnable();
        this.setValueVisible();
        this.getModel().setDataChanged(false);
        PriceHelper.setVisibleField((long)this.getModel().getDataEntity().getLong("costtype.id"), (IFormView)this.getView());
    }

    private void initDataSrc() {
        this.getModel().setValue("datasrc", (Object)"manual");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.cleanBlankRows();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.getView().updateView();
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            long id = this.getModel().getDataEntity().getLong("pricerule.id");
            if (id == PriceRuleConstants.OUTRES_MANUALLY_ID) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierinfo"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"supplierinfo"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"pricerule"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supplierinfo"});
        }
        this.effectDateEnable();
    }

    private void cleanBlankRows() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_ENTRY);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (DynamicObject entry : entryEntity) {
            BigDecimal attaQty = entry.getBigDecimal("attaqty");
            BigDecimal attaAmt = entry.getBigDecimal("attaamt");
            String calcbasis = (String)this.getModel().getValue("calcbasis");
            if (CALCBASIS_RESOURCE.equals(calcbasis) && BigDecimal.ZERO.compareTo(attaQty) == 0 || !CALCBASIS_MATERIAL.equals(calcbasis) && !"003".equals(calcbasis) || BigDecimal.ZERO.compareTo(attaAmt) != 0) continue;
            indexList.add(entry.getInt("seq") - 1);
        }
        if (indexList.isEmpty()) {
            return;
        }
        int[] indexs = new int[indexList.size()];
        for (int i = 0; i < indexs.length; ++i) {
            indexs[i] = (Integer)indexList.get(i);
        }
        this.getModel().deleteEntryRows(ENTITY_ENTRY, indexs);
    }

    private void setValueEnable() {
        this.setCalcbasisEnable();
        this.setResourceUnitEnable();
    }

    private void setCalcbasisEnable() {
        IFormView view = this.getView();
        String type = this.getSubEleType();
        if (E004.equals(type) || E005.equals(type)) {
            view.setEnable(Boolean.valueOf(true), new String[]{"calcbasis"});
        } else {
            view.setEnable(Boolean.valueOf(false), new String[]{"calcbasis"});
        }
    }

    private void setResourceUnitEnable() {
        IFormView view = this.getView();
        String calcbasis = this.getCalcbasis();
        if (CALCBASIS_RESOURCE.equals(calcbasis)) {
            view.setEnable(Boolean.valueOf(true), new String[]{"resourceunit"});
        } else {
            view.setEnable(Boolean.valueOf(false), new String[]{"resourceunit"});
        }
    }

    private String getSubEleType() {
        DynamicObject subelement = this.getModel().getDataEntity().getDynamicObject("subelement");
        String type = "";
        if (subelement != null) {
            type = subelement.getString("type");
        }
        return type;
    }

    private String getCalcbasis() {
        return this.getModel().getDataEntity().getString("calcbasis");
    }

    private void bindCurrency() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        this.getModel().setValue("currency", (Object)costType.getLong("currency.id"));
    }

    private void setDefaultSubElement(PropertyChangedArgs e) {
        QFilter qfElementType;
        String subtype;
        String type;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject ele = dataEntity.getDynamicObject("element");
        if (ele == null) {
            return;
        }
        DynamicObject subelement = dataEntity.getDynamicObject("subelement");
        if (subelement != null && (type = ele.getString("type")).equalsIgnoreCase(subtype = subelement.getString("type"))) {
            return;
        }
        long elementId = ele.getLong("id");
        QFilter qfElement = new QFilter("id", "=", (Object)elementId);
        DynamicObject dyElement = QueryServiceHelper.queryOne((String)"cad_element", (String)"elementtype.id", (QFilter[])new QFilter[]{qfElement});
        long elementTypeId = dyElement.getLong("elementtype.id");
        qfElement = new QFilter("element", "=", (Object)elementId);
        DynamicObjectCollection dyElementRelation = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{qfElement, qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId)});
        if (dyElementRelation == null) {
            return;
        }
        HashSet<Long> eleIds = new HashSet<Long>();
        for (DynamicObject subElement : dyElementRelation) {
            eleIds.add(subElement.getLong("subelement"));
        }
        QFilter qfSubElement = new QFilter("id", "in", eleIds);
        QFilter qfDefault = new QFilter("defaultvalue", "=", (Object)true);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSubElement, qfDefault});
        if (dySubElement != null) {
            this.getView().getModel().setValue("subelement", (Object)dySubElement.getLong("id"));
        }
    }

    private Set<Long> getSubElement(long elementId) {
        HashSet<Long> subElementIds = new HashSet<Long>();
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return subElementIds;
        }
        Long costTypeId = costType.getLong("id");
        QFilter qfCostTypeId = new QFilter("id", "=", (Object)costTypeId);
        DynamicObject dyCostType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"elementtype.id", (QFilter[])new QFilter[]{qfCostTypeId});
        if (dyCostType == null) {
            return subElementIds;
        }
        long elementTypeId = dyCostType.getLong("elementtype.id");
        QFilter qfElement = new QFilter("element", "=", (Object)elementId);
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{qfElement, qfElementType});
        if (elementDetail.size() == 0) {
            return subElementIds;
        }
        for (DynamicObject ele : elementDetail) {
            subElementIds.add(ele.getLong("subelement.id"));
        }
        return subElementIds;
    }

    private void setElement(PropertyChangedArgs e) {
        DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("subelement");
        if (subEle == null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getView().getModel().setValue("element", (Object)dySubElement.getLong("element"));
        }
    }

    private QFilter getMatFilter() {
        Long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costTypeId)});
        if (costType == null) {
            return new QFilter("id", "=", (Object)-1);
        }
        Long orgId = costType.getLong("createorg");
        OrgRelationParam param = new OrgRelationParam();
        param.setFromViewType("10");
        param.setToViewType("04");
        param.setOrgId(orgId.longValue());
        param.setDirectViewType("toorg");
        param.setIncludeSelf(true);
        List manuOrgs = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (CadEmptyUtils.isEmpty((List)manuOrgs)) {
            return new QFilter("id", "=", (Object)-1);
        }
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (List)manuOrgs, (boolean)false);
    }

    private void effectDateEnable() {
        PriceHelper.effectDateEnable((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"cad_resourceout");
    }
}

