/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.dto.PurPriceParamDto;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.PurPricingRuleHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;
import kd.macc.cad.servicehelper.RecordCalcDataChangeServiceHelper;

public class ResourceOutListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ResourceOutListPlugin.class);
    public static final String SPLIT_1 = "#";
    private static final String closeBack_doPricing = "closeBack_doPricing";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_new"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey().toUpperCase()) {
            case "TBLNEW": 
            case "TBLDEL": 
            case "TBLSUBMIT": 
            case "TBLUNSUBMIT": 
            case "TBLCHECK": 
            case "TBLUNAUDIT": 
            case "TBLCOPY": {
                String tip = ResManager.loadKDString((String)"\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868", (String)"ResourceOutListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                PriceCommon.checkType(this.getView(), evt, this.getCacheCostType(), tip);
                break;
            }
            case "SYNCOSTTYPE": {
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "syncosttype": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_resourceout", "47156aff000000ac")) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Util.openSyncCostTypeView(this.getView(), "cad_resourceout", rows);
                break;
            }
            case "purpricingrule": {
                this.showPurPricingRule();
                break;
            }
            case "purpricing": {
                this.doPurPricing();
                break;
            }
            case "quickupdate": {
                this.showQuickUpdateApply();
                break;
            }
            case "autoprice": {
                this.doAutoPrice();
                break;
            }
            case "updateexpdate": {
                this.updateExpdate();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "purPricingRule": {
                String res = (String)closedCallBackEvent.getReturnData();
                if (res == null || !res.equals("success")) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u4fdd\u5b58\u6210\u529f\u3002", (String)"ResourceOutListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                break;
            }
            case "updateStandCostBack": 
            case "updateEffDateBack": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "closedcallback_quickupdate": {
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                Object result = returnData.get("result");
                if (result == null) {
                    return;
                }
                String msg = (String)returnData.get("msg");
                if ("success".equals(String.valueOf(result))) {
                    this.getView().showSuccessNotification(msg);
                    break;
                }
                this.getView().showErrorNotification(msg);
                break;
            }
            case "closeBack_doPricing": {
                this.getView().hideLoading();
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfo = this.getPageCache().get("responseInfo");
                logger.info("\u53d6\u4ef7\uff0c\u53d6\u4ef7\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)responseInfo);
                if (CadEmptyUtils.isEmpty((String)responseInfo)) {
                    return;
                }
                Map resultMap = (Map)SerializationUtils.fromJsonString((String)responseInfo, Map.class);
                boolean status = (Boolean)resultMap.get("status");
                boolean existFailedCalcRule = (Boolean)resultMap.get("existFailedCalcRule");
                if (!status) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u4ef7\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002", (String)"ResourceOutListPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0]), resultMap.get("errMsg")));
                } else {
                    int count;
                    int n = count = resultMap.get("count") == null ? 0 : (Integer)resultMap.get("count");
                    if (count == 0) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"ResourceOutListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    } else {
                        String tips = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5f15\u5165%1$s\u6761\u6570\u636e\u3002", (String)"ResourceOutListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), count);
                        this.getView().showSuccessNotification(tips);
                    }
                    if (existFailedCalcRule) {
                        this.getView().showErrorNotification(resultMap.get("failedCalcRuleTips").toString());
                    }
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void showQuickUpdateApply() {
        String costtypeId = this.getCacheCostType();
        if (CadEmptyUtils.isEmpty((String)costtypeId)) {
            logger.info("\u65e0\u6cd5\u83b7\u53d6\u5230\u6210\u672c\u7c7b\u578b\u3002");
            return;
        }
        Long costTypeId = Long.parseLong(costtypeId);
        DynamicObject costType = CostTypeHelper.getCostType((Long)costTypeId, (String)"type");
        if (costType != null && "0".equals(costType.getString("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"ResourceOutListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> ids = this.getSelectedIds();
        if (CollectionUtils.isEmpty(ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u8bb0\u5f55\u6267\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"ResourceOutListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Set<Object>> resultMap = this.getResourcesByIds(ids);
        Set<Object> billNos = resultMap.get("billNos");
        if (!CadEmptyUtils.isEmpty(billNos)) {
            String content = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\u3002", (String)"ResourceOutListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), billNos);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"ResourceOutListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), content, MessageTypes.Default);
            return;
        }
        Set<Object> resIds = resultMap.get("resIds");
        Map<String, Set<Object>> resMap = this.getResourcesByNoRefAndMaterialsForResourcesByRef(costTypeId, resIds);
        if (resMap.get("matForResByRef").isEmpty() && resMap.get("resourcesByNoRef").isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u8d44\u6e90\uff0c\u65e0\u9700\u66f4\u65b0\u3002", (String)"ResourceOutListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String matInfo = this.getMulPriceRule(ids);
        if (!CadEmptyUtils.isEmpty((String)matInfo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u201c%s\u201d\u6307\u5b9a\u4e86\u591a\u79cd\u53d6\u4ef7\u89c4\u5219\uff0c\u8bf7\u91cd\u9009\u3002", (String)"ResourceOutListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]), matInfo));
            return;
        }
        String mulMatKcInfo = this.getMulMatKcInfo(ids);
        if (!CadEmptyUtils.isEmpty((String)mulMatKcInfo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u201c%s\u201d\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7ec4\u5408\u201c\u8d44\u6e90+\u7269\u6599+\u8f85\u52a9\u5c5e\u6027\u201d\u3002", (String)"ResourceOutListPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]), mulMatKcInfo));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cad_quickapplyupdate_md");
        formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "closedcallback_quickupdate"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("costtype", (Object)costtypeId);
        formShowParameter.setCustomParam("sourcePage", (Object)"resource");
        formShowParameter.setCustomParam("resourceformid", (Object)"cad_resourceout");
        formShowParameter.setCustomParam("ids", ids);
        formShowParameter.setCustomParam("resourceMatIds", resMap.get("matForResByRef"));
        formShowParameter.setCustomParam("resourcesByNoRef", resMap.get("resourcesByNoRef"));
        formShowParameter.setCustomParam("resourceMatByUseAuxp", new HashSet(1));
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(formShowParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<Object>> getResourcesByNoRefAndMaterialsForResourcesByRef(Long costType, Set<Object> resIds) {
        HashMap<String, Set<Object>> resMap = new HashMap<String, Set<Object>>(16);
        HashSet<Long> materialsForResourcesByRef = new HashSet<Long>(10);
        HashSet<String> resources = new HashSet<String>(10);
        HashSet<String> routerByRef = new HashSet<String>(10);
        HashSet<String> bomByRef = new HashSet<String>(10);
        DataSet routers = null;
        DataSet routerSettings = null;
        DataSet bomSettings = null;
        DataSet materialsByNotUseAuxpty = null;
        try {
            QFilter routerFilter = new QFilter("processentry.actentryentity.actresource", "in", resIds);
            QFilter processTypeFilter = new QFilter("processtype", "=", (Object)"A");
            routers = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_router", (String)"cad_router", (String)"id as routerid,processentry.actentryentity.actresource as resource,processentry.actentryentity.actresource.number as resourcenumber", (QFilter[])new QFilter[]{routerFilter, processTypeFilter}, null);
            QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costType);
            QFilter routerTypeFilter = new QFilter("routertype", "=", (Object)"A");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            routerSettings = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_routersetting", (String)"cad_routersetting", (String)"router,router.number as routernumber,materialentry.material as material,materialentry.material.number as matnumber", (QFilter[])new QFilter[]{costTypeFilter, routerTypeFilter, statusFilter}, null);
            QFilter isdowncalcFilter = new QFilter("isdowncalc", "=", (Object)"1");
            bomSettings = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_bomsetting", (String)"cad_bomsetting", (String)"bom,bom.number bomnumber,material,material.number as matnumber", (QFilter[])new QFilter[]{costTypeFilter, statusFilter, isdowncalcFilter}, null);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            materialsByNotUseAuxpty = QueryServiceHelper.queryDataSet((String)"BaseCalcDataChangedHelper#bd_material", (String)"bd_material", (String)"number as matnumber,masterid as materialid,isuseauxpty", (QFilter[])new QFilter[]{statusFilter, enableFilter}, null);
            routers = routers.join(routerSettings, JoinType.LEFT).on("routerid", "router").select(new String[]{"resource", "resourcenumber", "routernumber", "material", "matnumber"}).finish().join(bomSettings, JoinType.INNER).on("material", "material").select(new String[]{"resource", "resourcenumber", "routernumber", "bomnumber", "material", "matnumber"}).finish().join(materialsByNotUseAuxpty, JoinType.INNER).on("material", "materialid").select(new String[]{"resource", "resourcenumber", "routernumber", "bomnumber", "material", "matnumber", "isuseauxpty"}).finish();
            while (routers.hasNext()) {
                Row row = routers.next();
                if (null == row.getString("resourcenumber")) continue;
                if (resIds.contains(row.getLong("resource"))) {
                    resIds.remove(row.getLong("resource"));
                }
                materialsForResourcesByRef.add(row.getLong("material"));
                resources.add(row.getString("resourcenumber"));
                routerByRef.add(row.getString("routernumber"));
                bomByRef.add(row.getString("bomnumber"));
            }
            ArrayList<Long> routerIds = new ArrayList<Long>(10);
            DynamicObjectCollection routerEntrys = QueryServiceHelper.query((String)"cad_routersetting", (String)"router", (QFilter[])new QFilter[]{costTypeFilter, statusFilter});
            for (DynamicObject router : routerEntrys) {
                routerIds.add(router.getLong("router"));
            }
            Iterator<Object> resIdIterator = resIds.iterator();
            while (resIdIterator.hasNext()) {
                Object resId = resIdIterator.next();
                if (!this.isOnlyRefByNotAType(routerIds, resId)) continue;
                resIdIterator.remove();
            }
            resMap.put("resourcesByNoRef", resIds);
            resMap.put("matForResByRef", materialsForResourcesByRef);
            logger.info("\u8d44\u6e90\u5feb\u901f\u66f4\u65b0-\u672a\u88ab\u5f15\u7528\u7684\u8d44\u6e90\uff1a" + resIds);
            logger.info("\u8d44\u6e90\u5feb\u901f\u66f4\u65b0-\u5df2\u88ab\u5f15\u7528\u7684\u8d44\u6e90\uff1a" + resources + "\uff0c\u5f15\u7528\u7684\u5de5\u827a\u8def\u7ebf\uff1a" + routerByRef + "\uff0c\u5f15\u7528\u7684\u6210\u672cBOM\u53ca\u6210\u672cBOM\u8bbe\u7f6e\uff1a" + bomByRef);
        }
        catch (Exception e) {
            try {
                logger.error("\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u5feb\u901f\u66f4\u65b0-\u83b7\u53d6\u88ab\u5f15\u7528\u7684\u8d44\u6e90\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            }
            catch (Throwable throwable) {
                DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings, materialsByNotUseAuxpty});
                throw throwable;
            }
            DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings, materialsByNotUseAuxpty});
        }
        DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings, materialsByNotUseAuxpty});
        return resMap;
    }

    private boolean isOnlyRefByNotAType(List<Long> routerIds, Object resId) {
        QFilter idFilter = new QFilter("id", "in", routerIds);
        QFilter routerFilter = new QFilter("processentry.actentryentity.actresource", "=", (Object)Long.parseLong(resId.toString()));
        QFilter processAFilter = new QFilter("processtype", "=", (Object)"A");
        QFilter processBCFilter = new QFilter("processtype", "!=", (Object)"A");
        boolean existsA = QueryServiceHelper.exists((String)"cad_router", (QFilter[])new QFilter[]{idFilter, routerFilter, processAFilter});
        boolean existsBC = QueryServiceHelper.exists((String)"cad_router", (QFilter[])new QFilter[]{idFilter, routerFilter, processBCFilter});
        return !existsA && existsBC;
    }

    private Map<String, Set<Object>> getResourcesByIds(List<Long> ids) {
        HashMap<String, Set<Object>> resMap = new HashMap<String, Set<Object>>(4);
        DynamicObjectCollection resourceDyoCol = QueryServiceHelper.query((String)"cad_resourceout", (String)"resource.id,billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashSet resIds = new HashSet(ids.size());
        HashSet billNoIds = new HashSet(ids.size());
        resourceDyoCol.forEach(dyo -> {
            resIds.add(dyo.get("resource.id"));
            if (!"C".equals(dyo.getString("billstatus"))) {
                billNoIds.add(dyo.getString("billno"));
            }
        });
        resMap.put("resIds", resIds);
        resMap.put("billNos", billNoIds);
        return resMap;
    }

    private List<Long> getSelectedIds() {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            rows.forEach(row -> ids.add(Long.parseLong(row.getPrimaryKeyValue().toString())));
        }
        return ids;
    }

    private String getCurrCostTypeId() {
        String costTypeId = this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)costTypeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"ResourceOutListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return "";
        }
        return costTypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPurPricing() {
        String costTypeId = this.getCurrCostTypeId();
        if (StringUtils.isEmpty((String)costTypeId)) {
            return;
        }
        DynamicObject costType = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(costTypeId), (String)"cad_costtype");
        if (costType != null && !costType.getBoolean("isuseversion")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u672a\u542f\u7528\u201c\u5377\u7b97\u4e0d\u6309\u7269\u6599\u7248\u672c\u8ba1\u7b97\u201d\uff0c\u4e0d\u80fd\u8fdb\u884c\u91c7\u8d2d\u53d6\u4ef7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ResourceOutListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        PurPriceParamDto param = this.wrapCommonParam(Long.valueOf(costTypeId));
        boolean isPass = PurPricingRuleHelper.checkData((PurPriceParamDto)param);
        if (!isPass) {
            return;
        }
        String lockErr = CalcMutexHelper.checkAndRequireXMutex((String)"pricing_res", Collections.singleton(param.getCostTypeId()));
        if (StringUtils.isNotEmpty((String)lockErr)) {
            this.getView().showErrorNotification(lockErr);
            return;
        }
        try {
            Map matWithPriceMap = null;
            if (matWithPriceMap == null || matWithPriceMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u5408\u540c\u6216\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u3002", (String)"ResourceOutListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Set matIds = PurPricingRuleHelper.splitMatIds((Map)matWithPriceMap, (String)SPLIT_1);
            DynamicObject ruleRes = PurPricingRuleHelper.getSinglePurPricingRule((PurPriceParamDto)param);
            Map<String, Long> resMatMap = this.getResToMatMap(ruleRes, matIds);
            if (resMatMap == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u4e0b\uff0c\u5728\u201c\u8d44\u6e90\u5bf9\u5e94\u7269\u6599\u5b57\u6bb5\u201d\u4e2d\u8bf7\u9009\u62e9\u76f8\u5e94\u7684\u7269\u6599\u5b57\u6bb5\u3002", (String)"ResourceOutListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (resMatMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7269\u6599\u5bf9\u5e94\u7684\u8d44\u6e90\u3002", (String)"ResourceOutListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<Long, DynamicObject> resRateMap = this.getResRateMap(param, resMatMap);
            ArrayList<DynamicObject> resRateList = new ArrayList<DynamicObject>(10);
            for (Map.Entry matWithPrice : matWithPriceMap.entrySet()) {
                Object[] matKey = (Object[])matWithPrice.getKey();
                PurPriceParamDto purPriceParam = (PurPriceParamDto)matWithPrice.getValue();
                param.setCurrMatPrice(purPriceParam.getCurrMatPrice());
                param.setCurrDataSrc(purPriceParam.getCurrDataSrc());
                Long resId = resMatMap.get(matKey);
                if (resId == null || resId == 0L) continue;
                DynamicObject currResRate = resRateMap.get(resId);
                if (currResRate == null) {
                    currResRate = this.generateNewResRate(param, resId);
                } else {
                    this.updateCurrResRateByMatPrice(currResRate, param);
                }
                this.fillBillInfo(currResRate, param);
                resRateList.add(currResRate);
            }
            if (!resRateList.isEmpty()) {
                Object[] result = SaveServiceHelper.save((DynamicObject[])resRateList.toArray(new DynamicObject[0]));
                ArrayList<Object> successPks = new ArrayList<Object>(16);
                for (Object obj : result) {
                    if (!(obj instanceof DynamicObject)) continue;
                    successPks.add(((DynamicObject)obj).getPkValue());
                }
                String opKey = "doprice";
                logger.info("\u5f53\u524d\u5b9e\u4f53\uff1acad_resourceout\u901a\u8fc7\u64cd\u4f5c" + opKey + "\u53d8\u66f4\u6570\u636e\u6761\u6570\uff1a" + successPks.size());
                if (successPks.size() > 0) {
                    int size = RecordCalcDataChangeServiceHelper.recordCalcChangedData((String)"cad_resourceout", successPks, (String)opKey);
                    logger.info("\u4fdd\u5b58\u5b9e\u4f53\uff1acad_resourceout\u53d8\u66f4\u8bb0\u5f55\u6210\u529f\u6761\u6570\uff1a" + size);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d6\u4ef7\u5230\u6700\u65b0\u6570\u636e\u3002", (String)"ResourceOutListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7269\u6599\u5bf9\u5e94\u7684\u8d44\u6e90\u3002", (String)"ResourceOutListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            CalcMutexHelper.releaseXMutex((String)"pricing_res", Collections.singleton(param.getCostTypeId()));
        }
    }

    private void fillBillInfo(DynamicObject resRate, PurPriceParamDto param) {
        resRate.set("datasrc", (Object)param.getCurrDataSrc());
        resRate.set("auditor", (Object)param.getUserId());
        resRate.set("auditdate", (Object)param.getCurrTime());
        resRate.set("billstatus", (Object)"C");
    }

    private void setDetailInfo(DynamicObject resRate, PurPriceParamDto param) {
        resRate.set("subelement", (Object)param.getSubelementId());
        resRate.set("element", (Object)param.getElementId());
        resRate.set("calcbasis", (Object)param.getCalcbasis());
        resRate.set("resourceunit", (Object)param.getResourceUnit());
        String calcbasis = resRate.getString("calcbasis");
        if ("001".equals(calcbasis)) {
            resRate.set("qty", (Object)param.getCurrMatPrice());
            resRate.set("amount", (Object)BigDecimal.ZERO);
        } else if ("002".equals(calcbasis) || "003".equals(calcbasis)) {
            resRate.set("amount", (Object)param.getCurrMatPrice());
            resRate.set("qty", (Object)BigDecimal.ZERO);
        }
    }

    private void updateCurrResRateByMatPrice(DynamicObject resRate, PurPriceParamDto param) {
        this.setDetailInfo(resRate, param);
    }

    private DynamicObject generateNewResRate(PurPriceParamDto param, Long resId) {
        DynamicObject resRate = BusinessDataServiceHelper.newDynamicObject((String)param.getTargetEntity());
        String billno = CodeRuleServiceHelper.getNumber((String)param.getTargetEntity(), (DynamicObject)resRate, (String)"");
        resRate.set("billno", (Object)billno);
        resRate.set("costtype", (Object)param.getCostTypeId());
        resRate.set("currency", (Object)param.getCurrencyId());
        resRate.set("billstatus", (Object)"A");
        resRate.set("resource", (Object)resId);
        this.setDetailInfo(resRate, param);
        resRate.set("creator", (Object)param.getUserId());
        resRate.set("createtime", (Object)param.getCurrTime());
        return resRate;
    }

    private Map<String, Long> getResToMatMap(DynamicObject ruleRes, Set<Long> matIds) {
        String matField = ruleRes.getString("res_mat");
        String matVerField = ruleRes.getString("res_matversion");
        String matAuxptyField = ruleRes.getString("res_auxpty");
        if (StringUtils.isEmpty((String)matField)) {
            return new HashMap<String, Long>();
        }
        StringBuilder resFields = new StringBuilder("id");
        resFields.append(",").append(matField).append(".masterid AS ").append(matField);
        if (StringUtils.isNotEmpty((String)matVerField)) {
            resFields.append(",").append(matVerField);
        }
        if (StringUtils.isNotEmpty((String)matAuxptyField)) {
            resFields.append(",").append(matAuxptyField);
        }
        QFilter resQF = this.getMpdmQf(matField, matIds);
        DynamicObjectCollection resources = null;
        try {
            resources = QueryServiceHelper.query((String)"mpdm_resources", (String)resFields.toString(), (QFilter[])new QFilter[]{resQF});
        }
        catch (RuntimeException e) {
            logger.error("\u7ed3\u6784\u8f6c\u6362\u9519\u8bef\uff1a", (Throwable)e);
            return null;
        }
        HashMap<String, Long> resMatMap = new HashMap<String, Long>(16);
        if (resources != null) {
            resources.forEach(res -> {
                StringBuilder matKey = new StringBuilder();
                matKey.append(res.getLong(matField)).append(SPLIT_1).append(StringUtils.isNotEmpty((String)matVerField) ? res.getLong(matVerField) : 0L).append(SPLIT_1).append(StringUtils.isNotEmpty((String)matAuxptyField) ? res.getLong(matAuxptyField) : 0L);
                resMatMap.put(matKey.toString(), res.getLong("id"));
            });
        }
        return resMatMap;
    }

    protected QFilter getMpdmQf(String matField, Set<Long> matIds) {
        QFilter resQF = new QFilter("status", "=", (Object)"C");
        resQF.and(new QFilter("enable", "=", (Object)true));
        resQF.and(new QFilter(matField + ".masterid", "in", matIds));
        return resQF;
    }

    private Map<Long, DynamicObject> getResRateMap(PurPriceParamDto param, Map<String, Long> resMatMap) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("costtype", "=", (Object)param.getCostTypeId()));
        qfList.add(new QFilter("resource", "in", resMatMap.values()));
        List resRateIds = QueryServiceHelper.queryPrimaryKeys((String)param.getTargetEntity(), (QFilter[])qfList.toArray(new QFilter[0]), null, (int)-1);
        DynamicObject[] resRates = BusinessDataServiceHelper.load((Object[])resRateIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)param.getTargetEntity()));
        HashMap<Long, DynamicObject> resAndResRateMap = new HashMap<Long, DynamicObject>(16);
        if (resRates != null && resRates.length > 0) {
            for (int i = 0; i < resRates.length; ++i) {
                resAndResRateMap.put(resRates[i].getLong("resource.id"), resRates[i]);
            }
        }
        return resAndResRateMap;
    }

    private PurPriceParamDto wrapCommonParam(Long costTypeId) {
        PurPriceParamDto param = new PurPriceParamDto();
        param.setCostTypeId(costTypeId);
        param.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        param.setCurrTime(new Date());
        param.setEntity("cad_purpricingrule_res");
        param.setTargetEntity("cad_resourceout");
        param.setView(this.getView());
        Long currencyId = PurPricingRuleHelper.getCostTypeCurrency((Long)param.getCostTypeId());
        param.setCurrencyId(currencyId);
        return param;
    }

    private void showPurPricingRule() {
        String costTypeId = this.getCurrCostTypeId();
        if (StringUtils.isEmpty((String)costTypeId)) {
            return;
        }
        boolean isAnalog = BomRouterHelper.isAnalogCostType((Long)Long.valueOf(costTypeId));
        if (!isAnalog) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u8bbe\u7f6e\u53d6\u4ef7\u89c4\u5219\u3002", (String)"ResourceOutListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId("cad_purpricingrule_res");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costtype", (Object)costTypeId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "purPricingRule"));
        this.getView().showForm((FormShowParameter)fsp);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String costTypeId = PriceCommon.getCostTypeId(e.getParameter().getFormId(), e.getParameter().getPkId());
        if (StringUtils.isEmpty((String)costTypeId)) {
            costTypeId = this.getCacheCostType();
        }
        e.getParameter().setCustomParam("CostType", (Object)costTypeId);
        if (!PriceCommon.isSimulatedCostType(costTypeId)) {
            e.getParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String pageCacheCosttype = this.getPageCache().get("CostType");
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = PriceCommon.getCostTypeComboItemList(this.getView().getFormShowParameter().getAppId());
            if (costTypes == null || costTypes.isEmpty()) break;
            commonFilterColumn.setComboItems(costTypes);
            ComboItem item = costTypes.get(0);
            commonFilterColumn.setDefaultValue(item.getValue());
            commonFilterColumn.setMustInput(true);
            if (!CadEmptyUtils.isEmpty((String)pageCacheCosttype)) break;
            pageCacheCosttype = item.getValue();
            break;
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("CostType", pageCacheCosttype);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costtype.name": {
                    column.setFixed(true);
                    break;
                }
                case "billno": {
                    column.setFixed(true);
                    break;
                }
                case "resource.number": {
                    column.setFixed(true);
                    break;
                }
                case "resource.name": {
                    column.setFixed(true);
                    break;
                }
            }
        }
        PriceHelper.hideDate((String)this.getPageCache().get("CostType"), (BeforeCreateListColumnsArgs)o);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("costtype.id".equals(field) || "costtype.name".equals(field)) {
            DynamicObjectCollection costTypes = PriceCommon.getCostTypes(AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costTypes)) {
                HashSet costTypeIds = new HashSet(16);
                costTypes.forEach(s -> costTypeIds.add(s.getLong("id")));
                e.addCustomQFilter(new QFilter("id", "in", costTypeIds));
            } else {
                e.addCustomQFilter(CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView()));
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter") || filterValues.containsKey("schemefilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            List list = customfilter = customfilter != null ? customfilter : (List)filterValues.get("schemefilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            String pageCacheCosttype = null;
            for (int i = 0; i < customfilter.size(); ++i) {
                Map map = (Map)customfilter.get(i);
                List listValue = (List)map.get("Value");
                List listFieldName = (List)map.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (listFieldName.get(j).equals("costtype.id") && !CadEmptyUtils.isEmpty((List)listValue)) {
                        pageCacheCosttype = (String)listValue.get(j);
                        continue;
                    }
                    if (!listFieldName.get(j).equals("costtype.name")) continue;
                    List ids = (List)map.get("Id");
                    List list2 = ids = ids == null ? (List)map.get("id") : ids;
                    if (CadEmptyUtils.isEmpty((List)ids)) continue;
                    pageCacheCosttype = ids.get(0).toString();
                }
            }
            if (pageCacheCosttype != null) {
                this.getPageCache().put("CostType", pageCacheCosttype);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            e.getQFilters().add(new QFilter("costtype.type", "=", (Object)"1"));
        }
        List filters = e.getQFilters();
        PriceHelper.filterExpDate((List)filters);
        e.setOrderBy("resource.number asc,element.name asc,subelement.name asc");
    }

    private String getCacheCostType() {
        String id = this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)id) && StringUtils.isNotEmpty((String)(id = this.getDefualtSelectCostType()))) {
            this.getPageCache().put("CostType", id);
        }
        return id;
    }

    private String getDefualtSelectCostType() {
        DynamicObject[] costTypes = ElementRelationHelper.getCostTypes();
        if (costTypes == null || costTypes.length < 1) {
            return null;
        }
        return String.valueOf(costTypes[0].getLong("id"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quickupdate"});
        }
        PriceHelper.updateDate((BillList)((BillList)this.getControl("billlistap")), (String)this.getPageCache().get("CostType"), (String)"cad_resourceout");
    }

    private void doAutoPrice() {
        String costtypeId = this.getPageCache().get("CostType");
        if (costtypeId != null) {
            long costType = Long.parseLong(costtypeId);
            DynamicObject object = CostTypeHelper.getCostType((Long)costType, (String)"type");
            if ("0".equals(object.getString("type"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u81ea\u52a8\u53d6\u4ef7\u3002", (String)"ResourceOutListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            DLock lock = DLock.create((String)("AutoPricing_cad_resourceout_" + costType), (String)ResManager.loadKDString((String)"\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u53d6\u4ef7\u9501", (String)"ResourceOutListPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%s\u3011\u6b63\u5728\u8fdb\u884c\u91c7\u8d2d\u53d6\u4ef7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ResourceOutListPlugin_23", (String)"macc-cad-formplugin", (Object[])new Object[0]), object.getString("name")));
                return;
            }
            List orgList = CostTypeHelper.getOrgByCostType((Long)costType);
            ArrayList accountList = new ArrayList(5);
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u53d6\u4ef7", (String)"ResourceOutListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map result = new HashMap(16);
                try {
                    result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"AutoPricingService", (String)"execute", (Object[])new Object[]{"cad_resourceout", orgList, accountList, RequestContext.get().getCurrUserId(), costType, this.getView().getFormShowParameter().getAppId(), progressId});
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u5fae\u670d\u52a1-\u53d6\u4ef7\u62a5\u9519\uff1a", (Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.close();
                    }
                }
                logger.info("\u53d6\u4ef7\uff0ccount\uff1a{}", result.get("count"));
                this.getPageCache().put("responseInfo", SerializationUtils.toJsonString(result));
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doPricing));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "updatestandcost": 
            case "updateeffdate": {
                if (!PriceHelper.checkOperation((BeforeDoOperationEventArgs)e, (IFormView)this.getView(), (String)"cad_resourceout", (String)this.getPageCache().get("CostType"), (String)operateKey)) break;
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("updatestandcost".equals(operateKey) ? "cad_updatestandcost" : "cad_seteffectdate");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("costtype", this.getPageCache().get("CostType"));
                map.put("entityNum", "cad_resourceout");
                map.put("ids", PriceHelper.getSelectIds((BeforeDoOperationEventArgs)e));
                parameter.setCustomParams(map);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updatestandcost".equals(operateKey) ? "updateStandCostBack" : "updateEffDateBack"));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    private String getMulPriceRule(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection resOutPrices = QueryServiceHelper.query((String)"cad_resourceout", (String)"material,auxpty,resource,resource.number resourcenumber,resource.name resourcename,pricerule", (QFilter[])filters);
        if (resOutPrices.isEmpty()) {
            return null;
        }
        HashMap<String, List> groups = new HashMap<String, List>(resOutPrices.size());
        for (DynamicObject resOutPrice : resOutPrices) {
            String key = resOutPrice.getString("material") + "@" + resOutPrice.getString("auxpty") + "@" + resOutPrice.getString("resource");
            groups.computeIfAbsent(key, p -> new ArrayList()).add(resOutPrice);
        }
        for (Map.Entry group : groups.entrySet()) {
            if (CadEmptyUtils.isEmpty((List)((List)group.getValue())) || ((List)group.getValue()).size() < 2) continue;
            HashSet<Long> ruleIds = new HashSet<Long>(((List)group.getValue()).size());
            for (DynamicObject value : (List)group.getValue()) {
                ruleIds.add(value.getLong("pricerule"));
                if (ruleIds.size() <= 1) continue;
                return value.getString("resourcenumber") + "/" + value.getString("resourcename");
            }
        }
        return null;
    }

    private String getMulMatKcInfo(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection resOutPrices = QueryServiceHelper.query((String)"cad_resourceout", (String)"material,auxpty,route,processseq,operationno,resource,resource.number resourcenumber,resource.name resourcename,pricerule", (QFilter[])filters);
        if (resOutPrices.isEmpty()) {
            return null;
        }
        HashSet<String> existMats = new HashSet<String>(10);
        String msg = "";
        for (DynamicObject resOutPrice : resOutPrices) {
            String key = resOutPrice.getString("route") + "@" + resOutPrice.getString("processseq") + "@" + resOutPrice.getString("operationno") + "@" + resOutPrice.getString("resource");
            if (existMats.add(key) || msg.contains(resOutPrice.getString("resourcenumber"))) continue;
            if (CadEmptyUtils.isEmpty((String)msg)) {
                msg = resOutPrice.getString("resourcenumber") + "/" + resOutPrice.getString("resourcename");
                continue;
            }
            msg = msg + "\u3001" + resOutPrice.getString("resourcenumber") + "/" + resOutPrice.getString("resourcename");
        }
        return msg;
    }

    private void updateExpdate() {
        QFilter filter = new QFilter("pricerule", "!=", (Object)PriceRuleConstants.OUTRES_MANUALLY_ID);
        QFilter routeFilter = new QFilter("route", "is null", null);
        routeFilter.or(new QFilter("route", "=", (Object)0L));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)new Date());
        dateFilter.and(new QFilter("expdate", ">", (Object)new Date()));
        Object[] dynamicObjects = BusinessDataServiceHelper.load((String)"cad_resourceout", (String)"expdate", (QFilter[])new QFilter[]{filter, routeFilter, dateFilter});
        if (CadEmptyUtils.isEmpty((Object[])dynamicObjects)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"ResourceOutListPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Date dayStartTime = DateUtils.getDayStartTime((Date)new Date());
        for (Object dynamicObject : dynamicObjects) {
            dynamicObject.set("expdate", (Object)dayStartTime);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"ResourceOutListPlugin_24", (String)"macc-cad-formplugin", (Object[])new Object[0]));
    }
}

