/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.algox.price.ResourceRateAutoService;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.dto.PurPriceParamDto;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.PurPricingRuleHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;
import kd.macc.cad.servicehelper.RecordCalcDataChangeServiceHelper;

public class ResourceRateListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ResourceRateListPlugin.class);
    public static final String SPLIT_1 = "#";
    private static final String closeBack_doPricing = "closeBack_doPricing";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_new"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey().toUpperCase()) {
            case "TBLNEW": 
            case "TBLDEL": 
            case "TBLSUBMIT": 
            case "TBLUNSUBMIT": 
            case "TBLCHECK": 
            case "TBLUNAUDIT": 
            case "TBLCOPY": {
                String tip = ResManager.loadKDString((String)"\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868", (String)"ResourceRateListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                PriceCommon.checkType(this.getView(), evt, this.getCacheCostType(), tip);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "syncosttype": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_resourcerate", "47156aff000000ac")) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Util.openSyncCostTypeView(this.getView(), "cad_resourcerate", rows);
                break;
            }
            case "autopricing": {
                this.autoPricing();
                break;
            }
            case "purpricingrule": {
                this.showPurPricingRule();
                break;
            }
            case "purpricing": {
                this.doPurPricing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPurPricing() {
        String costTypeId = this.getCurrCostTypeId();
        if (StringUtils.isEmpty((String)costTypeId)) {
            return;
        }
        PurPriceParamDto param = this.wrapCommonParam(Long.valueOf(costTypeId));
        boolean isPass = PurPricingRuleHelper.checkData((PurPriceParamDto)param);
        if (!isPass) {
            return;
        }
        String lockErr = CalcMutexHelper.checkAndRequireXMutex((String)"pricing_res", Collections.singleton(param.getCostTypeId()));
        if (StringUtils.isNotEmpty((String)lockErr)) {
            this.getView().showErrorNotification(lockErr);
            return;
        }
        try {
            Map matWithPriceMap = null;
            if (matWithPriceMap == null || matWithPriceMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u5408\u540c\u6216\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u3002", (String)"ResourceRateListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Set matIds = PurPricingRuleHelper.splitMatIds((Map)matWithPriceMap, (String)SPLIT_1);
            DynamicObject ruleRes = PurPricingRuleHelper.getSinglePurPricingRule((PurPriceParamDto)param);
            Map<String, Long> resMatMap = this.getResToMatMap(ruleRes, matIds);
            if (resMatMap == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u4e2d\uff0c\u201c\u8d44\u6e90\u5bf9\u5e94\u7269\u6599\u5b57\u6bb5\u201d\u8bf7\u9009\u62e9\u76f8\u5e94\u7684\u7269\u6599\u5b57\u6bb5\u3002", (String)"ResourceRateListPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (resMatMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7269\u6599\u5bf9\u5e94\u7684\u8d44\u6e90\u3002", (String)"ResourceRateListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<Long, DynamicObject> resRateMap = this.getResRateMap(param, resMatMap);
            ArrayList<DynamicObject> resRateList = new ArrayList<DynamicObject>(10);
            for (Map.Entry matWithPrice : matWithPriceMap.entrySet()) {
                Object[] matKey = (Object[])matWithPrice.getKey();
                PurPriceParamDto purPriceParam = (PurPriceParamDto)matWithPrice.getValue();
                param.setCurrMatPrice(purPriceParam.getCurrMatPrice());
                param.setCurrDataSrc(purPriceParam.getCurrDataSrc());
                Long resId = resMatMap.get(matKey);
                if (resId == null || resId == 0L) continue;
                DynamicObject currResRate = resRateMap.get(resId);
                if (currResRate == null) {
                    currResRate = this.generateNewResRate(param, resId);
                } else {
                    this.updateCurrResRateByMatPrice(currResRate, param);
                }
                this.fillBillInfo(currResRate, param);
                resRateList.add(currResRate);
            }
            if (!resRateList.isEmpty()) {
                for (DynamicObject object : resRateList) {
                    object.set("pricerule", (Object)PriceRuleConstants.SELFRES_MANUALLY_ID);
                    object.set("pricerule_id", (Object)PriceRuleConstants.SELFRES_MANUALLY_ID);
                }
                Object[] result = SaveServiceHelper.save((DynamicObject[])resRateList.toArray(new DynamicObject[0]));
                ArrayList<Object> successPks = new ArrayList<Object>(16);
                for (Object obj : result) {
                    if (!(obj instanceof DynamicObject)) continue;
                    successPks.add(((DynamicObject)obj).getPkValue());
                }
                String opKey = "doprice";
                logger.info("\u5f53\u524d\u5b9e\u4f53\uff1acad_resourcerate\u901a\u8fc7\u64cd\u4f5c" + opKey + "\u53d8\u66f4\u6570\u636e\u6761\u6570\uff1a" + successPks.size());
                if (successPks.size() > 0) {
                    int size = RecordCalcDataChangeServiceHelper.recordCalcChangedData((String)"cad_resourcerate", successPks, (String)opKey);
                    logger.info("\u4fdd\u5b58\u5b9e\u4f53\uff1acad_resourcerate\u53d8\u66f4\u8bb0\u5f55\u6210\u529f\u6761\u6570\uff1a" + size);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d6\u4ef7\u5230\u6700\u65b0\u6570\u636e\u3002", (String)"ResourceRateListPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7269\u6599\u5bf9\u5e94\u7684\u8d44\u6e90\u3002", (String)"ResourceRateListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            CalcMutexHelper.releaseXMutex((String)"pricing_res", Collections.singleton(param.getCostTypeId()));
        }
    }

    private void fillBillInfo(DynamicObject resRate, PurPriceParamDto param) {
        resRate.set("datasrc", (Object)param.getCurrDataSrc());
        resRate.set("auditor", (Object)param.getUserId());
        resRate.set("auditdate", (Object)param.getCurrTime());
        resRate.set("billstatus", (Object)"C");
    }

    private void updateCurrResRateByMatPrice(DynamicObject resRate, PurPriceParamDto param) {
        this.setDetailInfo(resRate, param);
    }

    private DynamicObject generateNewResRate(PurPriceParamDto param, Long resId) {
        DynamicObject resRate = BusinessDataServiceHelper.newDynamicObject((String)param.getTargetEntity());
        String billno = CodeRuleServiceHelper.getNumber((String)param.getTargetEntity(), (DynamicObject)resRate, (String)"");
        resRate.set("billno", (Object)billno);
        resRate.set("costtype", (Object)param.getCostTypeId());
        resRate.set("currency", (Object)param.getCurrencyId());
        resRate.set("billstatus", (Object)"A");
        resRate.set("resource", (Object)resId);
        this.setDetailInfo(resRate, param);
        resRate.set("creator", (Object)param.getUserId());
        resRate.set("createtime", (Object)param.getCurrTime());
        return resRate;
    }

    private void setDetailInfo(DynamicObject resRate, PurPriceParamDto param) {
        resRate.set("subelement", (Object)param.getSubelementId());
        resRate.set("element", (Object)param.getElementId());
        resRate.set("calcbasis", (Object)param.getCalcbasis());
        resRate.set("resourceunit", (Object)param.getResourceUnit());
        String calcbasis = resRate.getString("calcbasis");
        if ("001".equals(calcbasis)) {
            resRate.set("qty", (Object)param.getCurrMatPrice());
            resRate.set("amount", (Object)BigDecimal.ZERO);
        } else if ("002".equals(calcbasis) || "003".equals(calcbasis)) {
            resRate.set("amount", (Object)param.getCurrMatPrice());
            resRate.set("qty", (Object)BigDecimal.ZERO);
        }
    }

    private Map<Long, DynamicObject> getResRateMap(PurPriceParamDto param, Map<String, Long> resMatMap) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("costtype", "=", (Object)param.getCostTypeId()));
        qfList.add(new QFilter("resource", "in", resMatMap.values()));
        List resRateIds = QueryServiceHelper.queryPrimaryKeys((String)param.getTargetEntity(), (QFilter[])qfList.toArray(new QFilter[0]), null, (int)-1);
        DynamicObject[] resRates = BusinessDataServiceHelper.load((Object[])resRateIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)param.getTargetEntity()));
        HashMap<Long, DynamicObject> resAndResRateMap = new HashMap<Long, DynamicObject>(16);
        if (resRates != null && resRates.length > 0) {
            for (int i = 0; i < resRates.length; ++i) {
                resAndResRateMap.put(resRates[i].getLong("resource.id"), resRates[i]);
            }
        }
        return resAndResRateMap;
    }

    private PurPriceParamDto wrapCommonParam(Long costTypeId) {
        PurPriceParamDto param = new PurPriceParamDto();
        param.setCostTypeId(costTypeId);
        param.setUserId(Long.valueOf(RequestContext.get().getUserId()));
        param.setCurrTime(new Date());
        param.setEntity("cad_purpricingrule_res");
        param.setTargetEntity("cad_resourcerate");
        param.setView(this.getView());
        Long currencyId = PurPricingRuleHelper.getCostTypeCurrency((Long)param.getCostTypeId());
        param.setCurrencyId(currencyId);
        return param;
    }

    private Map<String, Long> getResToMatMap(DynamicObject ruleRes, Set<Long> matIds) {
        String matField = ruleRes.getString("res_mat");
        String matVerField = ruleRes.getString("res_matversion");
        String matAuxptyField = ruleRes.getString("res_auxpty");
        if (StringUtils.isEmpty((String)matField)) {
            return new HashMap<String, Long>();
        }
        StringBuilder resFields = new StringBuilder("id");
        resFields.append(",").append(matField).append(".masterid AS ").append(matField);
        if (StringUtils.isNotEmpty((String)matVerField)) {
            resFields.append(",").append(matVerField);
        }
        if (StringUtils.isNotEmpty((String)matAuxptyField)) {
            resFields.append(",").append(matAuxptyField);
        }
        QFilter resQF = this.getMpdmQf(matField, matIds);
        DynamicObjectCollection resources = null;
        try {
            resources = QueryServiceHelper.query((String)"mpdm_resources", (String)resFields.toString(), (QFilter[])new QFilter[]{resQF});
        }
        catch (RuntimeException e) {
            logger.error("\u7ed3\u679c\u8f6c\u5316\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
        HashMap<String, Long> resMatMap = new HashMap<String, Long>(16);
        if (resources != null) {
            resources.forEach(res -> {
                StringBuilder matKey = new StringBuilder();
                matKey.append(res.getLong(matField)).append(SPLIT_1).append(StringUtils.isNotEmpty((String)matVerField) ? res.getLong(matVerField) : 0L).append(SPLIT_1).append(StringUtils.isNotEmpty((String)matAuxptyField) ? res.getLong(matAuxptyField) : 0L);
                resMatMap.put(matKey.toString(), res.getLong("id"));
            });
        }
        return resMatMap;
    }

    protected QFilter getMpdmQf(String matField, Set<Long> matIds) {
        QFilter resQF = new QFilter("status", "=", (Object)"C");
        resQF.and(new QFilter("enable", "=", (Object)true));
        resQF.and(new QFilter(matField + ".masterid", "in", matIds));
        return resQF;
    }

    private void showPurPricingRule() {
        String costTypeId = this.getCurrCostTypeId();
        if (StringUtils.isEmpty((String)costTypeId)) {
            return;
        }
        boolean isAnalog = BomRouterHelper.isAnalogCostType((Long)Long.valueOf(costTypeId));
        if (!isAnalog) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u8bbe\u7f6e\u53d6\u4ef7\u89c4\u5219\u3002", (String)"ResourceRateListPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId("cad_purpricingrule_res");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costtype", (Object)costTypeId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "purPricingRule"));
        this.getView().showForm((FormShowParameter)fsp);
    }

    private String getCurrCostTypeId() {
        String costTypeId = this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)costTypeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ResourceRateListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return "";
        }
        return costTypeId;
    }

    private void autoPricing() {
        Set costAccountIds;
        String costTypeId = this.getCurrCostTypeId();
        if (StringUtils.isEmpty((String)costTypeId)) {
            return;
        }
        long costType = Long.parseLong(costTypeId);
        DynamicObject object = CostTypeHelper.getCostType((Long)costType, (String)"type,name");
        if (!"1".equals(object.getString("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u81ea\u52a8\u53d6\u4ef7\u3002", (String)"ResourceRateListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId) && !CadEmptyUtils.isEmpty((Set)(costAccountIds = CostTypeHelper.getCostAccountIds((Long)costType, (String)appId))) && costAccountIds.size() > 1) {
            String fields = "id,name,number,costtype,selfresourceentry.seresrule as rule,selfresourceentry.seresrule.name as rulename";
            QFilter filter = new QFilter("costtype", "=", (Object)costType);
            filter.and("enable", "=", (Object)true);
            List<Long> ruleIds = Arrays.asList(PriceRuleConstants.SELFRES_RATE_ID, PriceRuleConstants.SELFRES_PLANRESOURCERATE_ID);
            filter.and("selfresourceentry.seresrule", "in", ruleIds);
            DynamicObjectCollection calPlanRules = QueryServiceHelper.query((String)"cad_calcruleplan", (String)fields, (QFilter[])filter.toArray(), null);
            for (DynamicObject calPlanRule : calPlanRules) {
                String tips = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\u3002\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u591a\u5957\u6210\u672c\u8d26\u7c3f\u65f6\uff0c\u4e0d\u652f\u6301\u4f7f\u7528\u53d6\u4ef7\u89c4\u5219\uff1a%s\u3002", (String)"ResourceRateListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), calPlanRule.getString("rulename"));
                this.getView().showTipNotification(tips);
            }
            return;
        }
        DLock lock = DLock.create((String)("AutoPricing_cad_resourcerate_" + costType), (String)ResManager.loadKDString((String)"\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u53d6\u4ef7\u9501", (String)"ResourceRateListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        boolean isLocked = lock.tryLock();
        if (!isLocked) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%s\u3011\u6b63\u5728\u8fdb\u884c\u91c7\u8d2d\u53d6\u4ef7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ResourceRateListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), object.getString("name")));
            return;
        }
        int resourceRateForIPrice = CadBgParamUtils.getCadParamForInt((String)"resourceRateForIPrice", (int)1);
        if (1 == resourceRateForIPrice) {
            List orgList = CostTypeHelper.getOrgByCostType((Long)costType);
            ArrayList accountList = new ArrayList(5);
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u53d6\u4ef7", (String)"ResourceRateListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map result = new HashMap(16);
                try {
                    result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"AutoPricingService", (String)"execute", (Object[])new Object[]{"cad_resourcerate", orgList, accountList, RequestContext.get().getCurrUserId(), costType, this.getView().getFormShowParameter().getAppId(), progressId});
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u5fae\u670d\u52a1-\u53d6\u4ef7\u62a5\u9519\uff1a", (Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.close();
                    }
                }
                logger.info("\u53d6\u4ef7\uff0ccount\uff1a{}", result.get("count"));
                this.getPageCache().put("responseInfo", SerializationUtils.toJsonString(result));
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doPricing));
        } else {
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u53d6\u4ef7", (String)"ResourceRateListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map result = new HashMap(16);
                try {
                    result = ResourceRateAutoService.autoImportRateResource((String)appId, (long)Long.parseLong(costTypeId), (String)progressId);
                }
                catch (Exception e) {
                    logger.error("\u53d6\u4ef7\u62a5\u9519\uff1a", (Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.close();
                    }
                }
                logger.info("\u53d6\u4ef7\uff0ccount\uff1a{}", result.get("count"));
                this.getPageCache().put("responseInfo", SerializationUtils.toJsonString(result));
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_doPricing));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String costTypeId = PriceCommon.getCostTypeId(e.getParameter().getFormId(), e.getParameter().getPkId());
        if (StringUtils.isEmpty((String)costTypeId)) {
            costTypeId = this.getCacheCostType();
        }
        e.getParameter().setCustomParam("CostType", (Object)costTypeId);
        if (!PriceCommon.isSimulatedCostType(costTypeId)) {
            e.getParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = PriceCommon.getCostTypeComboItemList(this.getView().getFormShowParameter().getAppId());
            if (costTypes == null || costTypes.isEmpty()) break;
            commonFilterColumn.setComboItems(costTypes);
            ComboItem item = costTypes.get(0);
            commonFilterColumn.setDefaultValue(item.getValue());
            commonFilterColumn.setMustInput(true);
            if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("CostType"))) break;
            this.getPageCache().put("CostType", item.getValue());
            break;
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costtype.name": {
                    column.setFixed(true);
                    break;
                }
                case "billno": {
                    column.setFixed(true);
                    break;
                }
                case "resource.number": {
                    column.setFixed(true);
                    break;
                }
                case "resource.name": {
                    column.setFixed(true);
                }
            }
        }
        PriceHelper.hideDate((String)this.getPageCache().get("CostType"), (BeforeCreateListColumnsArgs)o);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("costtype.id".equals(field) || "costtype.name".equals(field)) {
            e.addCustomQFilter(CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView()));
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                e.getQfilters().add(baseDataFilter);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter") || filterValues.containsKey("schemefilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            List list = customfilter = customfilter != null ? customfilter : (List)filterValues.get("schemefilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            String pageCacheCosttype = null;
            for (int i = 0; i < customfilter.size(); ++i) {
                Map map = (Map)customfilter.get(i);
                List listValue = (List)map.get("Value");
                List listFieldName = (List)map.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (listFieldName.get(j).equals("costtype.id") && !CadEmptyUtils.isEmpty((List)listValue)) {
                        pageCacheCosttype = (String)listValue.get(j);
                        continue;
                    }
                    if (!listFieldName.get(j).equals("costtype.name")) continue;
                    List ids = (List)map.get("Id");
                    List list2 = ids = ids == null ? (List)map.get("id") : ids;
                    if (CadEmptyUtils.isEmpty((List)ids)) continue;
                    pageCacheCosttype = ids.get(0).toString();
                }
            }
            if (pageCacheCosttype != null) {
                this.getPageCache().put("CostType", pageCacheCosttype);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            e.getQFilters().add(new QFilter("costtype.type", "=", (Object)"1"));
        }
        List filters = e.getQFilters();
        PriceHelper.filterExpDate((List)filters);
        e.setOrderBy("resource.number asc,element.name asc,subelement.name asc");
    }

    private String getCacheCostType() {
        String id = this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)id) && StringUtils.isNotEmpty((String)(id = this.getDefualtSelectCostType()))) {
            this.getPageCache().put("CostType", id);
        }
        return id;
    }

    private String getDefualtSelectCostType() {
        DynamicObject[] costTypes;
        Boolean isAca = "aca".equals(this.getView().getFormShowParameter().getAppId());
        DynamicObject[] dynamicObjectArray = costTypes = isAca != false ? ElementRelationHelper.getModeCostTypes() : ElementRelationHelper.getCostTypes();
        if (costTypes == null || costTypes.length < 1) {
            return null;
        }
        return String.valueOf(costTypes[0].getLong("id"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quickupdate"});
        }
        PriceHelper.updateDate((BillList)((BillList)this.getControl("billlistap")), (String)this.getPageCache().get("CostType"), (String)"cad_resourcerate");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "updatestandcost": 
            case "updateeffdate": {
                if (!PriceHelper.checkOperation((BeforeDoOperationEventArgs)e, (IFormView)this.getView(), (String)"cad_resourcerate", (String)this.getPageCache().get("CostType"), (String)operateKey)) break;
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("updatestandcost".equals(operateKey) ? "cad_updatestandcost" : "cad_seteffectdate");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("costtype", this.getPageCache().get("CostType"));
                map.put("entityNum", "cad_resourcerate");
                map.put("ids", PriceHelper.getSelectIds((BeforeDoOperationEventArgs)e));
                parameter.setCustomParams(map);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updatestandcost".equals(operateKey) ? "updateStandCostBack" : "updateEffDateBack"));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "updateStandCostBack": 
            case "updateEffDateBack": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "closeBack_doPricing": {
                boolean status;
                this.getView().hideLoading();
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfo = this.getPageCache().get("responseInfo");
                logger.info("\u53d6\u4ef7\uff0c\u53d6\u4ef7\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)responseInfo);
                if (CadEmptyUtils.isEmpty((String)responseInfo)) {
                    return;
                }
                Map result = (Map)SerializationUtils.fromJsonString((String)responseInfo, Map.class);
                boolean existFailedCalcRule = false;
                if (result.get("existFailedCalcRule") != null) {
                    existFailedCalcRule = (Boolean)result.get("existFailedCalcRule");
                }
                if (!(status = ((Boolean)result.get("status")).booleanValue())) {
                    Object errorMsg = result.get("errMsg");
                    this.getView().showTipNotification(String.valueOf(errorMsg));
                } else {
                    int count;
                    Object tipMsg = result.get("tip");
                    int n = count = result.get("count") == null ? 0 : (Integer)result.get("count");
                    if (count == 0) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u4ef7\u5b8c\u6210\uff0c\u4ef7\u683c\u672a\u53d1\u751f\u53d8\u52a8\uff0c\u65e0\u9700\u66f4\u65b0\u3002", (String)"ResourceRateListPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    } else {
                        String tips = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5f15\u5165%1$s\u6761\u6570\u636e\u3002", (String)"ResourceRateListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), count);
                        if (tipMsg == null || CadEmptyUtils.isEmpty((String)String.valueOf(tipMsg))) {
                            this.getView().showSuccessNotification(tips);
                        } else {
                            this.getView().showTipNotification(tips + tipMsg);
                        }
                    }
                    if (existFailedCalcRule) {
                        this.getView().showErrorNotification(result.get("failedCalcRuleTips").toString());
                    }
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

