/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class ResourceRateUpdateListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ResourceRateUpdateListPlugin.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "quickupdate": {
                this.showQuickUpdateApply();
                break;
            }
            case "norefsync": {
                this.showSyncPage();
                break;
            }
        }
    }

    private void showSyncPage() {
        List<Long> ids = this.getSelectedIds();
        if (CollectionUtils.isEmpty(ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u8d44\u6e90\u8d39\u7528\u8bb0\u5f55\u6267\u884c\u540c\u6b65\u3002", (String)"ResourceRateUpdateListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Set<Object>> resultMap = this.getResourcesByIds(ids);
        Set<Object> billNos = resultMap.get("billNos");
        if (!CadEmptyUtils.isEmpty(billNos)) {
            String content = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\u3002", (String)"ResourceRateUpdateListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), billNos);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"ResourceRateUpdateListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), content, MessageTypes.Default);
            return;
        }
        Set<Object> resIds = resultMap.get("resIds");
        Set<String> existResNos = this.getResourceByRef(Long.parseLong(this.getCurrCostTypeId()), resIds);
        if (!CadEmptyUtils.isEmpty(existResNos)) {
            String content = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u8d44\u6e90\u5df2\u88ab\u5de5\u827a\u8def\u7ebf\u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\u8d44\u6e90\u7f16\u7801\u4e3a\uff1a%s\u3002", (String)"ResourceRateUpdateListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]), existResNos);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8d44\u6e90\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"ResourceRateUpdateListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), content, MessageTypes.Default);
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cad_resourcesync");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "norefsync"));
        formShowParameter.setCustomParam("costtype", (Object)this.getCurrCostTypeId());
        this.getView().showForm(formShowParameter);
    }

    private void showQuickUpdateApply() {
        String costtypeId = this.getPageCache().get("CostType");
        DynamicObject costType = CostTypeHelper.getCostType((Long)Long.parseLong(costtypeId), (String)"type");
        if (costType != null && "0".equals(costType.getString("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"ResourceRateUpdateListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> ids = this.getSelectedIds();
        if (CollectionUtils.isEmpty(ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u8d44\u6e90\u8d39\u7528\u8bb0\u5f55\u6267\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"ResourceRateUpdateListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Set<Object>> resultMap = this.getResourcesByIds(ids);
        Set<Object> billNos = resultMap.get("billNos");
        if (!CadEmptyUtils.isEmpty(billNos)) {
            String content = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\u3002", (String)"ResourceRateUpdateListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), billNos);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"ResourceRateUpdateListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), content, MessageTypes.Default);
            return;
        }
        String matInfo = this.getMulPriceRule(ids);
        if (!CadEmptyUtils.isEmpty((String)matInfo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u201c%s\u201d\u6307\u5b9a\u4e86\u591a\u79cd\u53d6\u4ef7\u89c4\u5219\uff0c\u8bf7\u91cd\u9009\u3002", (String)"ResourceRateUpdateListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]), matInfo));
            return;
        }
        String mulMatKcInfo = this.getMulMatKcInfo(ids);
        if (!CadEmptyUtils.isEmpty((String)mulMatKcInfo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u201c%s\u201d\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7ec4\u5408\u201c\u8d44\u6e90+\u5de5\u4f5c\u4e2d\u5fc3\u201d\u3002", (String)"ResourceRateUpdateListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), mulMatKcInfo));
            return;
        }
        Set<Object> resIds = resultMap.get("resIds");
        Map<String, Set<Object>> resMap = this.getResourcesByNoRefAndMaterialsForResourcesByRef(Long.parseLong(costtypeId), resIds);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cad_quickapplyupdate_md");
        formShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "closedcallback_quickupdate"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("costtype", (Object)costtypeId);
        formShowParameter.setCustomParam("sourcePage", (Object)"resource");
        formShowParameter.setCustomParam("resourceformid", (Object)"cad_resourcerate");
        formShowParameter.setCustomParam("ids", ids);
        formShowParameter.setCustomParam("resourceMatIds", resMap.get("matForResByRef"));
        formShowParameter.setCustomParam("resourceMatByUseAuxp", resMap.get("matNoForResByRefUseAuxpty"));
        formShowParameter.setCustomParam("resourcesByNoRef", resMap.get("resourcesByNoRef"));
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(formShowParameter);
    }

    private String getCurrCostTypeId() {
        String costTypeId = this.getPageCache().get("CostType");
        if (StringUtils.isEmpty((String)costTypeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u7c7b\u578b\u3002", (String)"ResourceRateUpdateListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return "";
        }
        return costTypeId;
    }

    private List<Long> getSelectedIds() {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            rows.forEach(row -> ids.add(Long.parseLong(row.getPrimaryKeyValue().toString())));
        }
        return ids;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "norefsync": {
                if (null == closedCallBackEvent.getReturnData()) {
                    return;
                }
                List targetCostTypeIds = (List)closedCallBackEvent.getReturnData();
                this.copyResourcesToTarget(targetCostTypeIds);
                break;
            }
            case "closedcallback_quickupdate": {
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                Object result = returnData.get("result");
                if (result == null) {
                    return;
                }
                String msg = (String)returnData.get("msg");
                if ("success".equals(String.valueOf(result))) {
                    this.getView().showSuccessNotification(msg);
                    break;
                }
                this.getView().showErrorNotification(msg);
                break;
            }
        }
    }

    private void copyResourcesToTarget(List<Object> targetCostTypeIds) {
        List<Long> srcIds = this.getSelectedIds();
        Set<Object> resIds = this.getResourcesByIds(srcIds).get("resIds");
        QFilter stateQF = new QFilter("billstatus", "=", (Object)"C");
        Date effectTime = TimeServiceHelper.now();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_resourcerate");
        DynamicObject[] resources = BusinessDataServiceHelper.load((Object[])srcIds.toArray(), (DynamicObjectType)mainEntityType);
        QFilter tarCostTypeFilter = new QFilter("costtype", "in", targetCostTypeIds);
        tarCostTypeFilter.and(stateQF).and("resource", "in", resIds);
        tarCostTypeFilter.and(new QFilter("expdate", "=", (Object)TimeUtils.getDeFaultExpDate()));
        DynamicObject[] targetResources = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"id,expdate,resource,costtype", (QFilter[])new QFilter[]{tarCostTypeFilter});
        HashSet<String> existResource = new HashSet<String>(10);
        for (DynamicObject res : targetResources) {
            res.set("expdate", (Object)effectTime);
            existResource.add(res.getString("resource.id") + "_" + res.getString("costtype.id"));
        }
        if (targetResources.length > 0) {
            SaveServiceHelper.update((DynamicObject[])targetResources);
        }
        int size = resources.length * targetCostTypeIds.size();
        String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"cad_resourcerate", (DynamicObject)resources[0], null, (int)size);
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(size);
        int index = 0;
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        for (DynamicObject bill : resources) {
            String resStr = bill.getString("resource.id");
            for (Object costTypeId : targetCostTypeIds) {
                String key = resStr + "_" + costTypeId;
                DynamicObject copyBill = (DynamicObject)OrmUtils.clone((IDataEntityBase)bill, (boolean)false, (boolean)true);
                Long id = DBServiceHelper.genGlobalLongId();
                copyBill.set("id", (Object)id);
                copyBill.set("billno", (Object)numbers[index]);
                copyBill.set("createtime", (Object)effectTime);
                copyBill.set("modifytime", (Object)effectTime);
                copyBill.set("auditdate", (Object)effectTime);
                copyBill.set("creator_id", (Object)userId);
                copyBill.set("modifier_id", (Object)userId);
                copyBill.set("auditor_id", (Object)userId);
                copyBill.set("costtype_id", costTypeId);
                if (existResource.contains(key)) {
                    copyBill.set("effectdate", (Object)effectTime);
                } else {
                    copyBill.set("effectdate", (Object)TimeUtils.getDefaultEffectDate());
                }
                copyBill.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
                ++index;
                resultList.add(copyBill);
            }
        }
        SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[0]));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u4ef7\u76ee\u8868\u540c\u6b65\u6210\u529f\u3002", (String)"ResourceRateUpdateListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
    }

    private Map<String, Set<Object>> getResourcesByIds(List<Long> ids) {
        HashMap<String, Set<Object>> resMap = new HashMap<String, Set<Object>>(4);
        DynamicObjectCollection resourceDyoCol = QueryServiceHelper.query((String)"cad_resourcerate", (String)"resource.id,billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashSet resIds = new HashSet(ids.size());
        HashSet billNoIds = new HashSet(ids.size());
        resourceDyoCol.forEach(dyo -> {
            resIds.add(dyo.get("resource.id"));
            if (!"C".equals(dyo.getString("billstatus"))) {
                billNoIds.add(dyo.getString("billno"));
            }
        });
        resMap.put("resIds", resIds);
        resMap.put("billNos", billNoIds);
        return resMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getResourceByRef(Long costType, Set<Object> resIds) {
        HashSet<String> resources = new HashSet<String>(10);
        HashSet<String> routerByRef = new HashSet<String>(10);
        HashSet<String> bomByRef = new HashSet<String>(10);
        DataSet routers = null;
        DataSet routerSettings = null;
        DataSet bomSettings = null;
        try {
            QFilter routerFilter = new QFilter("processentry.actentryentity.actresource", "in", resIds);
            routers = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_router", (String)"cad_router", (String)"id as routerid,processentry.actentryentity.actresource as resource,processentry.actentryentity.actresource.number as actresnumber", (QFilter[])new QFilter[]{routerFilter}, null);
            QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costType);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            routerSettings = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_routersetting", (String)"cad_routersetting", (String)"router,router.number as routernumber,materialentry.material as material", (QFilter[])new QFilter[]{costTypeFilter, statusFilter}, null);
            QFilter isdowncalcFilter = new QFilter("isdowncalc", "=", (Object)"1");
            bomSettings = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_bomsetting", (String)"cad_bomsetting", (String)"bom,bom.number bomnumber,material", (QFilter[])new QFilter[]{costTypeFilter, statusFilter, isdowncalcFilter}, null);
            routers = routers.join(routerSettings, JoinType.LEFT).on("routerid", "router").select(new String[]{"actresnumber", "routernumber", "material"}).finish().join(bomSettings, JoinType.INNER).on("material", "material").select(new String[]{"actresnumber", "routernumber", "bomnumber", "material"}).finish();
            while (routers.hasNext()) {
                Row row = routers.next();
                if (null == row.getString("actresnumber")) continue;
                resources.add(row.getString("actresnumber"));
                routerByRef.add(row.getString("routernumber"));
                bomByRef.add(row.getString("bomnumber"));
            }
            logger.info("\u83b7\u53d6\u88ab\u5f15\u7528\u7684\u8d44\u6e90\uff1a" + resources + "\uff0c\u5f15\u7528\u7684\u5de5\u827a\u8def\u7ebf\uff1a" + routerByRef + "\uff0c\u5f15\u7528\u7684\u6210\u672cBOM\u53ca\u6210\u672cBOM\u8bbe\u7f6e\uff1a" + bomByRef);
        }
        catch (Exception e) {
            try {
                logger.error("\u83b7\u53d6\u88ab\u5f15\u7528\u7684\u8d44\u6e90\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            }
            catch (Throwable throwable) {
                DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings});
                throw throwable;
            }
            DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings});
        }
        DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings});
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<Object>> getResourcesByNoRefAndMaterialsForResourcesByRef(Long costType, Set<Object> resIds) {
        HashMap<String, Set<Object>> resMap = new HashMap<String, Set<Object>>(16);
        HashSet<Long> materialsForResourcesByRef = new HashSet<Long>(10);
        HashSet<String> materialsNoForResourcesByRefUseAuxpty = new HashSet<String>(10);
        HashSet<String> matNumbers = new HashSet<String>(10);
        HashSet<String> resources = new HashSet<String>(10);
        HashSet<String> routerByRef = new HashSet<String>(10);
        HashSet<String> bomByRef = new HashSet<String>(10);
        DataSet routers = null;
        DataSet routerSettings = null;
        DataSet bomSettings = null;
        DataSet materialsByNotUseAuxpty = null;
        try {
            QFilter routerFilter = new QFilter("processentry.actentryentity.actresource", "in", resIds);
            QFilter processTypeFilter = new QFilter("processtype", "=", (Object)"A");
            routers = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_router", (String)"cad_router", (String)"id as routerid,processentry.actentryentity.actresource as resource,processentry.actentryentity.actresource.number as resourcenumber", (QFilter[])new QFilter[]{routerFilter, processTypeFilter}, null);
            QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costType);
            QFilter routerTypeFilter = new QFilter("routertype", "=", (Object)"A");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            routerSettings = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_routersetting", (String)"cad_routersetting", (String)"router,router.number as routernumber,materialentry.material as material,materialentry.material.number as matnumber", (QFilter[])new QFilter[]{costTypeFilter, routerTypeFilter, statusFilter}, null);
            QFilter isdowncalcFilter = new QFilter("isdowncalc", "=", (Object)"1");
            bomSettings = QueryServiceHelper.queryDataSet((String)"ResourceRateUpdateListPlugin#cad_bomsetting", (String)"cad_bomsetting", (String)"bom,bom.number bomnumber,material,material.number as matnumber", (QFilter[])new QFilter[]{costTypeFilter, statusFilter, isdowncalcFilter}, null);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            materialsByNotUseAuxpty = QueryServiceHelper.queryDataSet((String)"BaseCalcDataChangedHelper#bd_material", (String)"bd_material", (String)"number as matnumber,masterid as materialid,isuseauxpty", (QFilter[])new QFilter[]{statusFilter, enableFilter}, null);
            routers = routers.join(routerSettings, JoinType.LEFT).on("routerid", "router").select(new String[]{"resource", "resourcenumber", "routernumber", "material", "matnumber"}).finish().join(bomSettings, JoinType.INNER).on("material", "material").select(new String[]{"resource", "resourcenumber", "routernumber", "bomnumber", "material", "matnumber"}).finish().join(materialsByNotUseAuxpty, JoinType.INNER).on("material", "materialid").select(new String[]{"resource", "resourcenumber", "routernumber", "bomnumber", "material", "matnumber", "isuseauxpty"}).finish();
            while (routers.hasNext()) {
                Row row = routers.next();
                if (null == row.getString("resourcenumber")) continue;
                if (resIds.contains(row.getLong("resource"))) {
                    resIds.remove(row.getLong("resource"));
                }
                if (row.getBoolean("isuseauxpty").booleanValue()) {
                    materialsNoForResourcesByRefUseAuxpty.add(row.getString("matnumber"));
                } else {
                    materialsForResourcesByRef.add(row.getLong("material"));
                    matNumbers.add(row.getString("matnumber"));
                }
                resources.add(row.getString("resourcenumber"));
                routerByRef.add(row.getString("routernumber"));
                bomByRef.add(row.getString("bomnumber"));
            }
            ArrayList<Long> routerIds = new ArrayList<Long>(10);
            DynamicObjectCollection routerEntrys = QueryServiceHelper.query((String)"cad_routersetting", (String)"router", (QFilter[])new QFilter[]{costTypeFilter, statusFilter});
            for (DynamicObject router : routerEntrys) {
                routerIds.add(router.getLong("router"));
            }
            Iterator<Object> resIdIterator = resIds.iterator();
            while (resIdIterator.hasNext()) {
                Object resId = resIdIterator.next();
                if (!this.isOnlyRefByNotAType(routerIds, resId)) continue;
                resIdIterator.remove();
            }
            resMap.put("resourcesByNoRef", resIds);
            resMap.put("matForResByRef", materialsForResourcesByRef);
            resMap.put("matNoForResByRefUseAuxpty", materialsNoForResourcesByRefUseAuxpty);
            logger.info("\u8d44\u6e90\u5feb\u901f\u66f4\u65b0-\u672a\u88ab\u5f15\u7528\u7684\u8d44\u6e90\uff1a" + resIds);
            logger.info("\u8d44\u6e90\u5feb\u901f\u66f4\u65b0-\u5df2\u88ab\u5f15\u7528\u7684\u8d44\u6e90\uff1a" + resources + "\uff0c\u5f15\u7528\u7684\u5de5\u827a\u8def\u7ebf\uff1a" + routerByRef + "\uff0c\u5f15\u7528\u7684\u6210\u672cBOM\u53ca\u6210\u672cBOM\u8bbe\u7f6e\uff1a" + bomByRef);
            logger.info("\u8d44\u6e90\u5feb\u901f\u66f4\u65b0-\u53ef\u5feb\u901f\u66f4\u65b0\u7684\u7269\u6599\uff1a" + matNumbers + ",\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\u7684\u7269\u6599\uff1a" + materialsNoForResourcesByRefUseAuxpty);
        }
        catch (Exception e) {
            try {
                logger.error("\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u5feb\u901f\u66f4\u65b0-\u83b7\u53d6\u88ab\u5f15\u7528\u7684\u8d44\u6e90\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            }
            catch (Throwable throwable) {
                DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings, materialsByNotUseAuxpty});
                throw throwable;
            }
            DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings, materialsByNotUseAuxpty});
        }
        DataSetUtils.colse((DataSet[])new DataSet[]{routers, routerSettings, bomSettings, materialsByNotUseAuxpty});
        return resMap;
    }

    private boolean isOnlyRefByNotAType(List<Long> routerIds, Object resId) {
        QFilter idFilter = new QFilter("id", "in", routerIds);
        QFilter routerFilter = new QFilter("processentry.actentryentity.actresource", "=", (Object)Long.parseLong(resId.toString()));
        QFilter processAFilter = new QFilter("processtype", "=", (Object)"A");
        QFilter processBCFilter = new QFilter("processtype", "!=", (Object)"A");
        boolean existsA = QueryServiceHelper.exists((String)"cad_router", (QFilter[])new QFilter[]{idFilter, routerFilter, processAFilter});
        boolean existsBC = QueryServiceHelper.exists((String)"cad_router", (QFilter[])new QFilter[]{idFilter, routerFilter, processBCFilter});
        return !existsA && existsBC;
    }

    private String getMulPriceRule(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection resOutPrices = QueryServiceHelper.query((String)"cad_resourcerate", (String)"workcenter,resource,resource.number resourcenumber,resource.name resourcename,pricerule", (QFilter[])filters);
        if (resOutPrices.isEmpty()) {
            return null;
        }
        HashMap<String, List> groups = new HashMap<String, List>(resOutPrices.size());
        for (DynamicObject resOutPrice : resOutPrices) {
            String key = resOutPrice.getString("workcenter") + "@" + resOutPrice.getString("resource");
            groups.computeIfAbsent(key, p -> new ArrayList()).add(resOutPrice);
        }
        for (Map.Entry group : groups.entrySet()) {
            if (CadEmptyUtils.isEmpty((List)((List)group.getValue())) || ((List)group.getValue()).size() < 2) continue;
            HashSet<Long> ruleIds = new HashSet<Long>(((List)group.getValue()).size());
            for (DynamicObject value : (List)group.getValue()) {
                ruleIds.add(value.getLong("pricerule"));
                if (ruleIds.size() <= 1) continue;
                return value.getString("resourcenumber") + "/" + value.getString("resourcename");
            }
        }
        return null;
    }

    private String getMulMatKcInfo(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection resOutPrices = QueryServiceHelper.query((String)"cad_resourcerate", (String)"workcenter,resource,resource.number resourcenumber,resource.name resourcename,pricerule", (QFilter[])filters);
        if (resOutPrices.isEmpty()) {
            return null;
        }
        HashSet<String> existMats = new HashSet<String>(10);
        String msg = "";
        for (DynamicObject resOutPrice : resOutPrices) {
            String key = resOutPrice.getString("workcenter") + "@" + resOutPrice.getString("resource");
            if (existMats.add(key) || msg.contains(resOutPrice.getString("resourcenumber"))) continue;
            if (CadEmptyUtils.isEmpty((String)msg)) {
                msg = resOutPrice.getString("resourcenumber") + "/" + resOutPrice.getString("resourcename");
                continue;
            }
            msg = msg + "\u3001" + resOutPrice.getString("resourcenumber") + "/" + resOutPrice.getString("resourcename");
        }
        return msg;
    }
}

