/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.servicehelper.RecordCalcDataChangeServiceHelper;

public class StandRateSetting
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener {
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";
    private static final String KEY_SAVE = "save";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final Log logger = LogFactory.getLog(StandRateSetting.class);

    public void initialize() {
        super.initialize();
        BillShowParameter fsp = (BillShowParameter)this.getView().getFormShowParameter();
        Object costType = fsp.getCustomParam("costtype");
        if (costType == null) {
            return;
        }
        QFilter qfCostType = new QFilter("costtype", "=", (Object)Long.valueOf(String.valueOf(costType)));
        List keys = QueryServiceHelper.queryPrimaryKeys((String)"cad_stdratesetting", (QFilter[])new QFilter[]{qfCostType}, null, (int)-1);
        if (keys.size() > 0) {
            fsp.setPkId(keys.get(0));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (KEY_SAVE.equals(operate.getOperateKey())) {
            Boolean isNeedUpdate;
            this.refreshData();
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm) && (isNeedUpdate = this.isUpdateStandRate()).booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u7269\u6599\u8d39\u7528\u9644\u52a0\u7387\u4f1a\u5237\u65b0\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b\u5bf9\u5e94\u7684\u5168\u90e8\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u7684\u6bd4\u7387\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"StandRateSetting_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("update_rate", (IFormPlugin)this));
                args.setCancel(true);
            }
            operate.getOption().setVariableValue(OPPARAM_AFTERCONFIRM, "true");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "costtype": {
                this.setCostTypeEable();
                this.bindEntryInfo();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object costType = fsp.getCustomParam("costtype");
        if (costType != null) {
            this.getModel().setValue("costtype", costType);
            this.getView().updateView("costtype");
            this.setCostTypeEable();
            this.bindEntryInfo();
        }
        this.getModel().setDataChanged(false);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "update_rate": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
                this.getView().invokeOperation(KEY_SAVE, operateOption);
                this.updateRate();
                this.getView().returnDataToParent((Object)KEY_SAVE);
                this.getView().close();
            }
        }
    }

    private void setCostTypeEable() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        if (CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type"))) {
            QFilter qfCostType = new QFilter("costtype", "=", costType.getPkValue());
            if (QueryServiceHelper.exists((String)"cad_purprices", (QFilter[])new QFilter[]{qfCostType})) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity", KEY_SAVE});
            }
        }
    }

    private void bindEntryInfo() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        HashSet<Long> existSubElement = new HashSet<Long>();
        QFilter qfCostType = new QFilter("costtype", "=", costType.getPkValue());
        DynamicObjectCollection stdRate = QueryServiceHelper.query((String)"cad_stdratesetting", (String)"costtype,entryentity.element,entryentity.subelement,entryentity.stdrate", (QFilter[])new QFilter[]{qfCostType});
        if (stdRate.size() > 0) {
            for (DynamicObject rate : stdRate) {
                long subElement = rate.getLong("entryentity.subelement");
                if (subElement == 0L) continue;
                existSubElement.add(subElement);
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("element", (Object)rate.getLong("entryentity.element"), index);
                this.getModel().setValue("subelement", (Object)subElement, index);
                this.getModel().setValue("stdrate", (Object)rate.getBigDecimal("entryentity.stdrate"), index);
            }
        }
        HashSet<QFilter> filters = new HashSet<QFilter>();
        filters.add(new QFilter("supmaterielcount", "=", (Object)true));
        filters.add(new QFilter("enable", "=", (Object)true));
        if (existSubElement.size() > 0) {
            filters.add(new QFilter("id", "not in", (Object)existSubElement.toArray()));
        }
        DynamicObjectCollection subElement = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        HashSet subElementId = new HashSet();
        subElement.forEach(a -> subElementId.add(a.getLong("id")));
        if (subElementId.size() > 0) {
            long elementTypeId = costType.getLong("elementtype.id");
            QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
            QFilter qfSubElementId = new QFilter("subelement", "in", (Object)subElementId.toArray());
            DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter[]{qfSubElementId, qfElementType});
            for (DynamicObject detail : elementDetail) {
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("element", (Object)detail.getLong("element"), index);
                this.getModel().setValue("subelement", (Object)detail.getLong("subelement"), index);
            }
        }
        this.getView().updateView("entryentity");
    }

    private Boolean isUpdateStandRate() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return false;
        }
        Long costTypeId = (Long)costType.getPkValue();
        QFilter qfCostType = new QFilter("costtype", "=", (Object)costTypeId);
        return QueryServiceHelper.exists((String)"cad_purprices", (QFilter[])new QFilter[]{qfCostType});
    }

    private void updateRate() {
        this.updatePurPrice();
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        Long costTypeId = (Long)costType.getPkValue();
        QFilter qfCostType = new QFilter("costtype", "=", (Object)costTypeId);
        DynamicObjectCollection purPrice = QueryServiceHelper.query((String)"cad_purprices", (String)"id", (QFilter[])new QFilter[]{qfCostType});
        HashSet idsAll = new HashSet();
        purPrice.forEach(p -> idsAll.add(p.getLong("id")));
        List splitLists = Lists.partition((List)Lists.newArrayList(idsAll), (int)5000);
        for (List ids : splitLists) {
            DynamicObject[] newPurPrice = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_purprices"));
            HashMap<Long, BigDecimal> idAndSum = new HashMap<Long, BigDecimal>(16);
            for (DynamicObject pur : newPurPrice) {
                DynamicObjectCollection entry = pur.getDynamicObjectCollection("entryentity");
                BigDecimal sum = BigDecimal.ZERO;
                for (DynamicObject en : entry) {
                    if (!MATTYPE.equals(en.getString("subelement.type"))) continue;
                    sum = sum.add(en.getBigDecimal("price"));
                }
                idAndSum.put(pur.getLong("id"), sum);
            }
            Map<Long, BigDecimal> rateSet = this.getCurRate();
            for (DynamicObject pur : newPurPrice) {
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal sum = (BigDecimal)idAndSum.get(pur.getLong("id"));
                DynamicObjectCollection entry = pur.getDynamicObjectCollection("entryentity");
                for (DynamicObject en : entry) {
                    if (MATCOST.equals(en.getString("subelement.type"))) {
                        Boolean supmaterialCount = en.getBoolean("subelement.supmaterielcount");
                        Long subElement = en.getLong("subelement.id");
                        BigDecimal rate = rateSet.get(subElement);
                        if (supmaterialCount.booleanValue() && !BigDecimal.ZERO.equals(rate)) {
                            rate = rate == null ? BigDecimal.ZERO : rate;
                            en.set("price", (Object)sum.multiply(rate).divide(new BigDecimal(100)));
                            en.set("rate", (Object)rate);
                        } else if (rate != null) {
                            en.set("price", (Object)0);
                            en.set("rate", (Object)0);
                        }
                    }
                    amount = amount.add(en.getBigDecimal("price"));
                }
                pur.set("amount", (Object)amount);
            }
            OperationResult op = OperationServiceHelper.executeOperate((String)KEY_SAVE, (String)"cad_purprices", (DynamicObject[])newPurPrice, (OperateOption)OperateOption.create());
            String opKey = "stdratesetting";
            List successPks = op.getSuccessPkIds();
            logger.info("\u5f53\u524d\u5b9e\u4f53\uff1acad_purprices\u901a\u8fc7\u64cd\u4f5c" + opKey + "\u53d8\u66f4\u6570\u636e\u6761\u6570\uff1a" + successPks.size());
            if (successPks.size() <= 0) continue;
            int size = RecordCalcDataChangeServiceHelper.recordCalcChangedData((String)"cad_purprices", (List)successPks, (String)opKey);
            logger.info("\u4fdd\u5b58\u5b9e\u4f53\uff1acad_purprices\u53d8\u66f4\u8bb0\u5f55\u6210\u529f\u6761\u6570\uff1a" + size);
        }
    }

    private void updatePurPrice() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (entry.size() == 0) {
            return;
        }
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        Long costTypeId = (Long)costType.getPkValue();
        QFilter qfCostType = new QFilter("costtype", "=", (Object)costTypeId);
        DynamicObjectCollection purPrice = QueryServiceHelper.query((String)"cad_purprices", (String)"id", (QFilter[])new QFilter[]{qfCostType});
        HashSet ids = new HashSet();
        purPrice.forEach(p -> ids.add(p.getLong("id")));
        DynamicObject[] newPurPrice = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_purprices"));
        for (DynamicObject en : entry) {
            for (DynamicObject newPur : newPurPrice) {
                DynamicObjectCollection newPurEntry = newPur.getDynamicObjectCollection("entryentity");
                HashSet subElementIds = new HashSet();
                newPurEntry.forEach(p -> subElementIds.add(p.getLong("subelement.id")));
                if (subElementIds.contains(en.getLong("subelement.id"))) {
                    if (en.getBigDecimal("stdrate") != null && BigDecimal.ZERO.compareTo(en.getBigDecimal("stdrate")) < 0) continue;
                    newPurEntry.removeIf(p -> p.getLong("subelement.id") == en.getLong("subelement.id"));
                    continue;
                }
                if (en.getBigDecimal("stdrate") == null || BigDecimal.ZERO.compareTo(en.getBigDecimal("stdrate")) == 0) continue;
                DynamicObject newEntry = newPurEntry.addNew();
                newEntry.set("element", (Object)en.getLong("element.id"));
                newEntry.set("subelement", (Object)en.getLong("subelement.id"));
                newEntry.set("price", (Object)0);
                newEntry.set("rate", (Object)en.getBigDecimal("stdrate"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])newPurPrice);
    }

    private Map<Long, BigDecimal> getCurRate() {
        HashMap<Long, BigDecimal> rate = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection entry = this.getView().getModel().getEntryEntity("entryentity");
        for (DynamicObject en : entry) {
            rate.put(en.getLong("subelement.id"), en.getBigDecimal("stdrate"));
        }
        return rate;
    }

    private void refreshData() {
        DynamicObjectCollection entrys = new DynamicObjectCollection();
        entrys.addAll((Collection)this.getModel().getEntryEntity("entryentity"));
        this.getModel().deleteEntryData("entryentity");
        logger.info("\u7269\u6599\u8d39\u7528\u9644\u52a0\u8d39\u7387\u8bbe\u7f6e-\u4fdd\u5b58\u524d\u63d0\u793a\u64cd\u4f5c\u3002\u5206\u5f55\u4e2a\u6570\uff1a{}", (Object)entrys.size());
        this.getModel().beginInit();
        for (DynamicObject entry : entrys) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("element", entry.get("element"), index);
            this.getModel().setValue("subelement", entry.get("subelement"), index);
            this.getModel().setValue("stdrate", (Object)entry.getBigDecimal("stdrate"), index);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }
}

