/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.price;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class UpdateStandCostEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    public static final long ELEMENT = 773126985240072192L;
    public static final long SUB_ELEMENT = 773175233367685120L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button confirm = (Button)this.getView().getControl("btnok");
        confirm.addClickListener((ClickListener)this);
        this.initFilter();
    }

    public void click(EventObject evt) {
        long costType;
        Map params;
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok") && (params = this.getView().getFormShowParameter().getCustomParams()) != null && params.size() > 2 && this.checkUpdateParam(costType = Long.parseLong(params.get("costtype").toString()))) {
            String entityNum = params.get("entityNum").toString();
            HashSet<Long> idsAll = new HashSet<Long>(16);
            JSONArray array = (JSONArray)params.get("ids");
            for (Object o : array) {
                idsAll.add(Long.parseLong(o.toString()));
            }
            List splitLists = Lists.partition((List)Lists.newArrayList(idsAll), (int)1000);
            for (List ids : splitLists) {
                DynamicObjectCollection entry;
                DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNum));
                ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
                DynamicObjectCollection entryDynamicObjects = this.getModel().getEntryEntity("entryentity");
                DynamicObjectCollection subDynamicObjects = this.getModel().getEntryEntity("subentryentity");
                if ("cad_purprices".equals(entityNum)) {
                    for (DynamicObject dyo : load) {
                        entry = dyo.getDynamicObjectCollection("entryentity");
                        entry.clear();
                        BigDecimal amount = BigDecimal.ZERO;
                        for (DynamicObject dynamicObject : subDynamicObjects) {
                            BigDecimal standPrice = dynamicObject.getBigDecimal("entrystandprice");
                            amount = standPrice.add(amount);
                            DynamicObject object = entry.addNew();
                            object.set("element", (Object)dynamicObject.getLong("entryelement.id"));
                            object.set("subelement", (Object)dynamicObject.getLong("entrysubelement.id"));
                            object.set("price", (Object)standPrice);
                            BigDecimal stdRate = dynamicObject.getBigDecimal("stdrate");
                            if (stdRate.compareTo(BigDecimal.ZERO) <= 0) continue;
                            object.set("rate", (Object)stdRate);
                        }
                        dyo.set("amount", (Object)amount);
                        saveList.add(dyo);
                    }
                }
                if ("cad_resourcerate".equals(entityNum) || "cad_resourceout".equals(entityNum)) {
                    for (DynamicObject dyo : load) {
                        entry = dyo.getDynamicObjectCollection("entryentity");
                        entry.clear();
                        for (DynamicObject entryDynamicObject : entryDynamicObjects) {
                            String calcBasis = entryDynamicObject.getString("calcbasis");
                            BigDecimal qty = entryDynamicObject.getBigDecimal("qty");
                            BigDecimal amount = entryDynamicObject.getBigDecimal("amount");
                            long resourceUnit = entryDynamicObject.getLong("resourceunit.id");
                            dyo.set("element", (Object)entryDynamicObject.getLong("element.id"));
                            dyo.set("subelement", (Object)entryDynamicObject.getLong("subelement.id"));
                            dyo.set("resourceunit", (Object)resourceUnit);
                            dyo.set("calcbasis", (Object)calcBasis);
                            if ("001".equals(calcBasis)) {
                                dyo.set("amount", (Object)BigDecimal.ZERO);
                                dyo.set("qty", (Object)qty);
                                continue;
                            }
                            dyo.set("qty", (Object)BigDecimal.ZERO);
                            dyo.set("amount", (Object)amount);
                        }
                        for (DynamicObject subDynamicObject : subDynamicObjects) {
                            DynamicObject dynamicObject;
                            dynamicObject = entry.addNew();
                            dynamicObject.set("attaelement", (Object)subDynamicObject.getLong("entryelement.id"));
                            dynamicObject.set("attasubelement", (Object)subDynamicObject.getLong("entrysubelement.id"));
                            dynamicObject.set("attaqty", (Object)subDynamicObject.getBigDecimal("entryqty"));
                        }
                        saveList.add(dyo);
                    }
                }
                if ("cad_outsourceprice".equals(entityNum)) {
                    for (DynamicObject dyo : load) {
                        entry = dyo.getDynamicObjectCollection("entryentity");
                        entry.clear();
                        for (DynamicObject entryDynamicObject : entryDynamicObjects) {
                            dyo.set("element", (Object)entryDynamicObject.getLong("element.id"));
                            dyo.set("subelement", (Object)entryDynamicObject.getLong("subelement.id"));
                            dyo.set("price", (Object)entryDynamicObject.getBigDecimal("standprice"));
                        }
                        for (DynamicObject subDynamicObject : subDynamicObjects) {
                            DynamicObject object = entry.addNew();
                            object.set("extelement", (Object)subDynamicObject.getLong("entryelement.id"));
                            object.set("extsubelement", (Object)subDynamicObject.getLong("entrysubelement.id"));
                            object.set("amount", (Object)subDynamicObject.getBigDecimal("entryamount"));
                        }
                        saveList.add(dyo);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"UpdateStandCostEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private boolean checkUpdateParam(Long costType) {
        long elementId;
        Iterator subEntryEntity;
        long subElementId;
        DynamicObjectCollection entryEntity;
        BigDecimal standPrice;
        String entityNum = this.getEntityNum();
        if ("cad_purprices".equals(entityNum)) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("subentryentity");
            Iterator query = QueryServiceHelper.query((String)"cad_stdratesetting", (String)"entryentity.stdrate", (QFilter[])new QFilter[]{new QFilter("costtype", "=", (Object)costType)});
            if (dynamicObjects.isEmpty() || query.size() == dynamicObjects.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateStandCostEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return false;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                long subElement = dynamicObject.getLong("entrysubelement.id");
                BigDecimal stdRate = dynamicObject.getBigDecimal("stdrate");
                standPrice = dynamicObject.getBigDecimal("entrystandprice");
                if (stdRate.compareTo(BigDecimal.ZERO) != 0 || !CadEmptyUtils.isEmpty((Long)subElement) && BigDecimal.ZERO.compareTo(standPrice) != 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u6216\u6807\u51c6\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateStandCostEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if ("cad_resourcerate".equals(entityNum) || "cad_resourceout".equals(entityNum)) {
            Object dynamicObject2;
            entryEntity = this.getModel().getEntryEntity("entryentity");
            for (Object dynamicObject2 : entryEntity) {
                long elementId2 = dynamicObject2.getLong("element.id");
                subElementId = dynamicObject2.getLong("subelement.id");
                String calcBasis = dynamicObject2.getString("calcbasis");
                long resourceUnit = dynamicObject2.getLong("resourceunit.id");
                if (CadEmptyUtils.isEmpty((Long)elementId2) || CadEmptyUtils.isEmpty((Long)subElementId) || CadEmptyUtils.isEmpty((String)calcBasis)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u5206\u5f55\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"UpdateStandCostEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (CadEmptyUtils.isEmpty((Long)resourceUnit)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"UpdateStandCostEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return false;
                }
                BigDecimal qty = dynamicObject2.getBigDecimal("qty");
                BigDecimal amount = dynamicObject2.getBigDecimal("amount");
                if ("001".equals(calcBasis)) {
                    if (BigDecimal.ZERO.compareTo(qty) != 0) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u4f9d\u636e\u4e3a\u8d44\u6e90\u5de5\u65f6\u65f6\uff0c\u8d39\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateStandCostEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (BigDecimal.ZERO.compareTo(amount) != 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u4f9d\u636e\u4e3a\u7269\u6599\u6216\u6279\u6b21\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateStandCostEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return false;
            }
            subEntryEntity = this.getModel().getEntryEntity("subentryentity");
            dynamicObject2 = subEntryEntity.iterator();
            while (dynamicObject2.hasNext()) {
                DynamicObject dynamicObject3 = (DynamicObject)dynamicObject2.next();
                elementId = dynamicObject3.getLong("entryelement.id");
                long subElementId2 = dynamicObject3.getLong("entrysubelement.id");
                BigDecimal entryQty = dynamicObject3.getBigDecimal("entryqty");
                if (!CadEmptyUtils.isEmpty((Long)elementId) && !CadEmptyUtils.isEmpty((Long)subElementId2) && BigDecimal.ZERO.compareTo(entryQty) != 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u52a0\u5236\u9020\u8d39\u7528\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"UpdateStandCostEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if ("cad_outsourceprice".equals(entityNum)) {
            entryEntity = this.getModel().getEntryEntity("entryentity");
            for (Object dynamicObject2 : entryEntity) {
                long elementId3 = dynamicObject2.getLong("element.id");
                subElementId = dynamicObject2.getLong("subelement.id");
                standPrice = dynamicObject2.getBigDecimal("standprice");
                if (!CadEmptyUtils.isEmpty((Long)elementId3) && !CadEmptyUtils.isEmpty((Long)subElementId) && BigDecimal.ZERO.compareTo(standPrice) != 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u5206\u5f55\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"UpdateStandCostEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return false;
            }
            subEntryEntity = this.getModel().getEntryEntity("subentryentity");
            Iterator iterator = subEntryEntity.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                elementId = dynamicObject.getLong("entryelement.id");
                long subElementId3 = dynamicObject.getLong("entrysubelement.id");
                BigDecimal entryAmount = dynamicObject.getBigDecimal("entryamount");
                if (!CadEmptyUtils.isEmpty((Long)elementId) && !CadEmptyUtils.isEmpty((Long)subElementId3) && BigDecimal.ZERO.compareTo(entryAmount) != 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u52a0\u8d39\u7528\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"UpdateStandCostEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "entrystandprice": {
                this.entryStandPriceChange();
                break;
            }
            case "entrysubelement": {
                this.entrySubElementChange(e);
                break;
            }
            case "calcbasis": {
                this.calcBasisChange();
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && params.size() > 2) {
            HashMap<String, HashMap<String, String>> map1;
            HashMap<String, String> paramMap1;
            HashMap<String, HashMap<String, String>> map;
            HashMap<String, String> paramMap;
            IDataModel model = this.getModel();
            Long costtype = Long.parseLong(params.get("costtype").toString());
            String entityNum = params.get("entityNum").toString();
            model.setValue("costtype", (Object)costtype);
            if ("cad_purprices".equals(entityNum)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryqty"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryamount"});
                paramMap = new HashMap<String, String>();
                paramMap.put("zh_CN", ResManager.loadKDString((String)"\u6210\u672c\u660e\u7ec6\u4fe1\u606f", (String)"UpdateStandCostEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                map = new HashMap<String, HashMap<String, String>>();
                map.put("text", paramMap);
                this.getView().updateControlMetadata("advconap1", map);
            }
            if ("cad_resourcerate".equals(entityNum) || "cad_resourceout".equals(entityNum)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"standprice"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entrystandprice"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"stdrate"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryamount"});
                paramMap = new HashMap();
                paramMap.put("zh_CN", ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20", (String)"UpdateStandCostEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                map = new HashMap();
                map.put("text", paramMap);
                this.getView().updateControlMetadata("advconap", map);
                paramMap1 = new HashMap<String, String>();
                paramMap1.put("zh_CN", ResManager.loadKDString((String)"\u9644\u52a0\u5236\u9020\u8d39\u7528", (String)"UpdateStandCostEditPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                map1 = new HashMap<String, HashMap<String, String>>();
                map1.put("text", paramMap1);
                this.getView().updateControlMetadata("advconap1", map1);
            }
            if ("cad_outsourceprice".equals(entityNum)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"calcbasis"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"qty"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"amount"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"resourceunit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entrystandprice"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"stdrate"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryqty"});
                paramMap = new HashMap();
                paramMap.put("zh_CN", ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20", (String)"UpdateStandCostEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                map = new HashMap();
                map.put("text", paramMap);
                this.getView().updateControlMetadata("advconap", map);
                paramMap1 = new HashMap();
                paramMap1.put("zh_CN", ResManager.loadKDString((String)"\u9644\u52a0\u8d39\u7528", (String)"UpdateStandCostEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                map1 = new HashMap();
                map1.put("text", paramMap1);
                this.getView().updateControlMetadata("advconap1", map1);
            }
            this.bindEntryInfo(costtype, entityNum);
        }
    }

    private void calcBasisChange() {
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        String calcBasis = (String)this.getModel().getValue("calcbasis", index);
        if ("001".equals(calcBasis)) {
            this.getModel().setValue("amount", null, index);
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"qty"});
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"amount"});
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"resourceunit"});
            this.getModel().setValue("resourceunit", (Object)10L, index);
        } else {
            this.getModel().setValue("qty", null, index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"qty"});
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"amount"});
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"resourceunit"});
            this.getModel().setValue("resourceunit", (Object)11L, index);
        }
    }

    private void entrySubElementChange(PropertyChangedArgs e) {
        this.getModel().beginInit();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("entrysubelement", rowIndex);
        if (subEle == null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getView().getModel().setValue("entryelement", (Object)dySubElement.getLong("element"), rowIndex);
            this.getView().updateView("entryelement", rowIndex);
        }
        this.getModel().endInit();
    }

    private void entryStandPriceChange() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String entityNum = params.get("entityNum").toString();
        if ("cad_purprices".equals(entityNum)) {
            BigDecimal standPrice = BigDecimal.ZERO;
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("subentryentity");
            for (DynamicObject dynamicObject : dynamicObjects) {
                long id = dynamicObject.getLong("entryelement.id");
                if (773126985240072192L != id) continue;
                standPrice = standPrice.add(dynamicObject.getBigDecimal("entrystandprice"));
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                int seq = dynamicObject.getInt("seq");
                BigDecimal stdRate = dynamicObject.getBigDecimal("stdrate");
                if (stdRate.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal price = stdRate.divide(new BigDecimal("100"), 10, 4).multiply(standPrice);
                this.getModel().setValue("entrystandprice", (Object)price, seq - 1);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        int index;
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("deleteentry".equals(key)) {
            index = this.getModel().getEntryCurrentRowIndex("entryentity");
            BigDecimal stdRate = (BigDecimal)this.getModel().getValue("stdrate", index);
            String entityNum = this.getEntityNum();
            if (entityNum != null && "cad_purprices".equals(entityNum) && stdRate.compareTo(BigDecimal.ZERO) > 0) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u6210\u672c\u8981\u7d20\u4e3a\u9644\u52a0\u8d39\u7387\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"UpdateStandCostEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
        if ("newentry".equals(key)) {
            e.setCancel(true);
            index = this.getModel().createNewEntryRow("subentryentity");
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"stdrate"});
        }
    }

    private void bindEntryInfo(Long costtype, String entityNum) {
        this.getModel().deleteEntryData("entryentity");
        if ("cad_purprices".equals(entityNum)) {
            QFilter qfCostType = new QFilter("costtype", "=", (Object)costtype);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_stdratesetting", (String)"costtype,entryentity.element,entryentity.subelement,entryentity.stdrate", (QFilter[])new QFilter[]{qfCostType});
            if (!dynamicObjects.isEmpty()) {
                for (DynamicObject rate : dynamicObjects) {
                    long subElement = rate.getLong("entryentity.subelement");
                    BigDecimal stdRate = rate.getBigDecimal("entryentity.stdrate");
                    if (subElement == 0L || BigDecimal.ZERO.compareTo(stdRate) == 0) continue;
                    int index = this.getModel().createNewEntryRow("subentryentity");
                    this.getModel().setValue("entryelement", (Object)rate.getLong("entryentity.element"), index);
                    this.getModel().setValue("entrysubelement", (Object)subElement, index);
                    this.getModel().setValue("stdrate", (Object)stdRate, index);
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"entryelement"});
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"entrysubelement"});
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"stdrate"});
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"entrystandprice"});
                }
            }
            int index = this.getModel().createNewEntryRow("subentryentity");
            this.getModel().setValue("entryelement", (Object)773126985240072192L, index);
            this.getModel().setValue("entrysubelement", (Object)773175233367685120L, index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"stdrate"});
        }
        if ("cad_resourcerate".equals(entityNum)) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("element", (Object)773173188837423104L, index);
            this.getModel().setValue("calcbasis", (Object)"001", index);
            this.getModel().setValue("resourceunit", (Object)10L, index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"amount"});
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"element"});
        }
        if ("cad_resourceout".equals(entityNum)) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("element", (Object)773173574319126528L, index);
            this.getModel().setValue("calcbasis", (Object)"001", index);
            this.getModel().setValue("resourceunit", (Object)10L, index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"amount"});
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"element"});
        }
        if ("cad_outsourceprice".equals(entityNum)) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("element", (Object)773173574319126528L, index);
            this.getModel().setValue("subelement", (Object)773176488857077760L, index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"element"});
        }
    }

    private void initFilter() {
        String entityNum = this.getEntityNum();
        BasedataEdit subElement = (BasedataEdit)this.getControl("subelement");
        subElement.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List filters = showParameter.getListFilterParameter().getQFilters();
            if ("cad_resourcerate".equals(entityNum)) {
                filters.add(new QFilter("id", "in", this.getSubElement(773173188837423104L)));
            }
            if ("cad_resourceout".equals(entityNum)) {
                filters.add(new QFilter("id", "in", this.getSubElement(773173574319126528L)));
            }
            if ("cad_outsourceprice".equals(entityNum)) {
                filters.add(new QFilter("id", "in", this.getSubElement(773173574319126528L)));
            }
        });
        BasedataEdit entryElement = (BasedataEdit)this.getControl("entryelement");
        entryElement.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List filters = showParameter.getListFilterParameter().getQFilters();
            if ("cad_resourcerate".equals(entityNum) || "cad_resourceout".equals(entityNum)) {
                filters.add(new QFilter("id", "=", (Object)773177371976173568L));
            }
            if ("cad_outsourceprice".equals(entityNum)) {
                filters.add(new QFilter("id", "!=", (Object)773173574319126528L));
            }
        });
        BasedataEdit entrySubElement = (BasedataEdit)this.getControl("entrysubelement");
        entrySubElement.addBeforeF7SelectListener(evt -> {
            Set<Long> subElements;
            DynamicObject elementDyo = (DynamicObject)this.getModel().getValue("entryelement");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List filters = showParameter.getListFilterParameter().getQFilters();
            if (elementDyo != null) {
                filters.add(new QFilter("id", "in", this.getSubElement(elementDyo.getLong("id"))));
            } else if ("cad_resourcerate".equals(entityNum) || "cad_resourceout".equals(entityNum)) {
                filters.add(new QFilter("id", "in", this.getSubElement(773177371976173568L)));
            }
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("subentryentity");
            HashSet<Long> ids = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject obj = dynamicObject.getDynamicObject("entrysubelement");
                if (obj == null) continue;
                ids.add(obj.getLong("id"));
            }
            if ("cad_outsourceprice".equals(entityNum) && !(subElements = this.getSubElement(773173574319126528L)).isEmpty()) {
                ids.addAll(subElements);
            }
            if (!ids.isEmpty()) {
                filters.add(new QFilter("id", "not in", ids));
            }
        });
    }

    private Set<Long> getSubElement(long elementId) {
        HashSet<Long> subElementIds = new HashSet<Long>();
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return subElementIds;
        }
        Long costTypeId = costType.getLong("id");
        QFilter qfCostTypeId = new QFilter("id", "=", (Object)costTypeId);
        DynamicObject dyCostType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"elementtype.id", (QFilter[])new QFilter[]{qfCostTypeId});
        if (dyCostType == null) {
            return subElementIds;
        }
        long elementTypeId = dyCostType.getLong("elementtype.id");
        QFilter qfElement = new QFilter("element", "=", (Object)elementId);
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{qfElement, qfElementType});
        if (elementDetail.size() == 0) {
            return subElementIds;
        }
        for (DynamicObject ele : elementDetail) {
            subElementIds.add(ele.getLong("subelement.id"));
        }
        return subElementIds;
    }

    private String getEntityNum() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && params.size() > 2) {
            return params.get("entityNum").toString();
        }
        return null;
    }
}

