/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class PlanCostDriverEditPlugin
extends AbstractBillPlugIn {
    private static final String BOS_COSTCENTER = "bos_costcenter";
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String MANU_ORG_CONFIRM = "manuOrgConfirm";
    private static final String COST_CENTER_CONFIRM = "costcenterconfirm";
    private static final String COST_DRIVER_CONFIRM = "costdriverconfirm";
    private static final String PERIOD = "period";
    private static final String KEY_BARITEM_NEW = "bar_new";
    private static final String KEY_BARITEM_SAVE = "bar_save";
    private static final String KEY_BARITEM_COPY = "bar_copy";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.getModel().getValue("org") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"PlanCostDriverEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            QFilter orgfilter = new QFilter("id", "=", (Object)0L);
            if (accountorg == null) {
                formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
                return;
            }
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            orgfilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
        });
        BasedataEdit costcent = (BasedataEdit)this.getControl("costcenter");
        costcent.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountorg)) {
                List<Long> ids = this.getCostCenterByUser();
                QFilter costcenterFilter = new QFilter("id", "in", ids);
                qList.add(costcenterFilter);
            } else {
                Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                manuOrgList.add(manuorgId);
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                qList.add(costCenterIdFilter);
            }
        });
        BasedataEdit costdriver = (BasedataEdit)this.getControl("costdriver");
        costdriver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            qList.add(new QFilter("issys", "=", (Object)Boolean.FALSE));
            qList.add(new QFilter("isrelatedwork", "=", (Object)Boolean.FALSE));
            qList.add(new QFilter("islinkresource", "=", (Object)Boolean.FALSE));
            qList.add(new QFilter("iscomplexcd", "=", (Object)Boolean.FALSE));
            qList.add(new QFilter("allocclass", "=", (Object)COSTCENTER));
            String appnum = this.getView().getFormShowParameter().getAppId();
            qList.add(new QFilter("appnum", "=", (Object)appnum));
        });
        BasedataEdit benefcostcenter = (BasedataEdit)this.getControl("benefcostcenter");
        benefcostcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            DynamicObject costdriverObject = (DynamicObject)this.getModel().getValue("costdriver");
            if (!CadEmptyUtils.isEmpty((DynamicObject)costdriverObject)) {
                String allocClass = costdriverObject.getString("allocclass");
                if (COSTCENTER.equals(allocClass)) {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    HashSet<Long> costcenterId = new HashSet<Long>();
                    if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                        for (DynamicObject dynamicObject : entryEntity) {
                            DynamicObject benefCostcenter = dynamicObject.getDynamicObject("benefcostcenter");
                            if (CadEmptyUtils.isEmpty((DynamicObject)benefCostcenter)) continue;
                            costcenterId.add(benefCostcenter.getLong("id"));
                        }
                    }
                    qList.add(new QFilter("id", "not in", costcenterId));
                } else if (COSTOBJECT.equals(allocClass)) {
                    if (this.getModel().getValue("costcenter") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u4e2d\u5fc3", (String)"PlanCostDriverEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(true);
                    } else {
                        DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
                        qList.add(new QFilter("id", "=", (Object)costCenter.getLong("id")));
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u52a8\u56e0", (String)"PlanCostDriverEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            List<Object> ids = new ArrayList();
            if (CadEmptyUtils.isEmpty((DynamicObject)accountorg)) {
                ids = this.getCostCenterByUser();
                QFilter costcenterFilter = new QFilter("id", "in", ids);
                qList.add(costcenterFilter);
            } else {
                qList.add(new QFilter("accountorg", "=", (Object)accountorg.getLong("id")));
            }
        });
        BasedataEdit period = (BasedataEdit)this.getControl(PERIOD);
        period.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            Long schemeId = this.getModel().getDataEntity().getLong("planscheme.id");
            if (CadEmptyUtils.isEmpty((Long)schemeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"PlanCostDriverEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)schemeId);
            qList.add(new QFilter("id", "in", (Object)periodIds));
        });
        BasedataEdit planScheme = (BasedataEdit)this.getControl("planscheme");
        planScheme.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            Long costaccount = this.getModel().getDataEntity().getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)costaccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanCostDriverEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            qList.add(new QFilter("costaccount", "=", (Object)costaccount));
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        this.getModel().setValue("sourcetype", (Object)"NEW");
        this.initOrgAndCostcenter(os);
        this.setVisibleByAllocClass();
        this.setColumn();
        this.setManuOrg();
        this.changManuorgStatus();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org", "costaccount", "qty"});
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.getModel().setDataChanged(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (KEY_BARITEM_COPY.equals(evt.getItemKey())) {
            long sourceId = (Long)this.getModel().getValue("sourceid");
            long recordSourceId = CadEmptyUtils.isEmpty((Long)sourceId) ? (Long)this.getModel().getValue("id") : sourceId;
            this.getView().getPageCache().put("sourceId", String.valueOf(recordSourceId));
            this.getView().getPageCache().put("copyFlag", "Y");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_new": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_SAVE});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"costcenter", "costdriver"});
                this.setEnable(true);
                break;
            }
            case "bar_copy": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_SAVE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"org", "costdriver", "costcenter"});
                String recordSourceId = this.getView().getPageCache().get("sourceId");
                this.getModel().setValue("sourceid", (Object)Long.parseLong(recordSourceId));
                this.setEnable(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            boolean dataChanged = this.getModel().getDataChanged();
            this.getPageCache().put("dataChanged", String.valueOf(dataChanged));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        if ("save".equals(args.getOperateKey())) {
            this.setVisibleByAllocClass();
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }
    }

    private void setColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.setColumnProperty("benefcostcenter", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("orgdutyname", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("entryqty", "isFixed", (Object)Boolean.TRUE);
    }

    private void setCostAccount(long orgId) {
        Long mainCostAccountId = CostAccountHelper.getMainCostAccount((Long)orgId, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        if (!CadEmptyUtils.isEmpty((Long)mainCostAccountId)) {
            this.getModel().setValue("costaccount", (Object)mainCostAccountId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (name) {
            case "org": {
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org != null) {
                    this.setCostAccount(org.getLong("id"));
                }
                this.getModel().setValue("manuorg", null);
                this.setManuOrg();
                this.changManuorgStatus();
                break;
            }
            case "costcenter": {
                this.changeCostCenter(e);
                break;
            }
            case "costdriver": {
                this.setVisibleByAllocClass();
                this.setBaseUnit();
                this.setManuOrg();
                this.changManuorgStatus();
                this.changeCostDriver(e);
                break;
            }
            case "entryqty": {
                this.setQty();
                break;
            }
            case "manuorg": {
                this.getModel().setValue("costcenter", null);
                break;
            }
            case "period": {
                Date[] periodEndDateArr;
                DynamicObject periodDyn = this.getModel().getDataEntity().getDynamicObject(PERIOD);
                if (periodDyn == null || (periodEndDateArr = PeriodHelper.getPeriodStartAndEndTime((Long)periodDyn.getLong("id"))) == null) break;
                this.getModel().setValue("bizdate", (Object)periodEndDateArr[1]);
                break;
            }
            case "planscheme": {
                this.getModel().setValue(PERIOD, null);
                break;
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("sourcetype", "NEW");
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    private void changeCostDriver(PropertyChangedArgs e) {
        DynamicObjectCollection dynamicObjects;
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        String oldId = "";
        if (oldValue != null) {
            oldId = String.valueOf(((DynamicObject)oldValue).getLong("id"));
        }
        if ((dynamicObjects = this.getModel().getEntryEntity("entryentity")).size() > 0 && !CadEmptyUtils.isEmpty((String)oldId)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6210\u672c\u52a8\u56e0\u5c06\u6e05\u7a7a\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u6e05\u7a7a", (String)"PlanCostDriverEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(COST_DRIVER_CONFIRM), null, oldId);
        }
    }

    private void changeCostCenter(PropertyChangedArgs e) {
        DynamicObjectCollection dynamicObjects;
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        String oldId = "";
        if (oldValue != null) {
            oldId = String.valueOf(((DynamicObject)oldValue).getLong("id"));
        }
        if ((dynamicObjects = this.getModel().getEntryEntity("entryentity")).size() > 0 && !CadEmptyUtils.isEmpty((String)oldId)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6210\u672c\u4e2d\u5fc3\u5c06\u6e05\u7a7a\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u6e05\u7a7a", (String)"PlanCostDriverEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(COST_CENTER_CONFIRM), null, oldId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MANU_ORG_CONFIRM.equals(callBackId)) {
            this.confirmOrNot(messageBoxClosedEvent, "manuorg");
        }
        if (COST_CENTER_CONFIRM.equals(callBackId)) {
            this.confirmOrNot(messageBoxClosedEvent, "costcenter");
        }
        if (COST_DRIVER_CONFIRM.equals(callBackId)) {
            this.confirmOrNot(messageBoxClosedEvent, "costdriver");
        }
    }

    private void confirmOrNot(MessageBoxClosedEvent messageBoxClosedEvent, String field) {
        String oldValue = messageBoxClosedEvent.getCustomVaule();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().deleteEntryData("entryentity");
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(field, (Object)(StringUtils.isEmpty((CharSequence)oldValue) ? null : Long.valueOf(oldValue)));
            this.getModel().endInit();
            this.getView().updateView(field);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    private void setBaseUnit() {
        DynamicObject costdriver = (DynamicObject)this.getModel().getValue("costdriver");
        if (CadEmptyUtils.isEmpty((DynamicObject)costdriver)) {
            this.getModel().setValue("costbaseunit", null);
            return;
        }
        this.getModel().setValue("costbaseunit", (Object)costdriver.getLong("unit.id"));
    }

    private void setQty() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        BigDecimal sum = new BigDecimal(0);
        for (DynamicObject dynamicObject : entryEntity) {
            BigDecimal entryQty = dynamicObject.getBigDecimal("entryqty");
            sum = sum.add(entryQty);
        }
        this.getModel().setValue("qty", (Object)sum);
    }

    public void setManuOrg() {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        boolean enableMulFactory = CostAccountHelper.isOrgEnableMulFactory((Long)orgId, (String)"sca");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("manuorg");
        basedataEdit.setMustInput(enableMulFactory);
        this.getView().setEnable(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private void setVisibleByAllocClass() {
        DynamicObject costdriver = (DynamicObject)this.getModel().getValue("costdriver");
        Boolean isCostObject = CadEmptyUtils.isEmpty((DynamicObject)costdriver) ? Boolean.FALSE : Boolean.TRUE;
        BasedataEdit costcenter = (BasedataEdit)this.getView().getControl("costcenter");
        costcenter.setMustInput(isCostObject.booleanValue());
        BasedataEdit benefCostCenter = (BasedataEdit)this.getView().getControl("benefcostcenter");
        benefCostCenter.setMustInput(isCostObject.booleanValue());
    }

    private void initOrgAndCostcenter(OperationStatus os) {
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            if (this.getPageCache().get("hasinit") == null) {
                String periodId;
                String period;
                String planSchemeId;
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String costAccountId = (String)fsp.getCustomParam("costaccount");
                if (StringUtils.isNotBlank((CharSequence)costAccountId)) {
                    this.getModel().setValue("costaccount", (Object)Long.parseLong(costAccountId));
                }
                Object costcenter = fsp.getCustomParam("costcenter");
                String manuorg = (String)fsp.getCustomParam("manuorg");
                if (StringUtils.isNotBlank((CharSequence)manuorg)) {
                    this.getModel().setValue("manuorg", (Object)Long.parseLong(manuorg));
                }
                if (costcenter != null && !"".equals(costcenter.toString())) {
                    this.getModel().setValue("costcenter", costcenter);
                }
                if (!CadEmptyUtils.isEmpty((String)(planSchemeId = (String)fsp.getCustomParam("planscheme")))) {
                    this.getModel().setValue("planscheme", (Object)planSchemeId);
                }
                if ((period = (String)fsp.getCustomParam(PERIOD)) != null && !"".equals(period)) {
                    this.getModel().setValue(PERIOD, (Object)period);
                }
                if (!CadEmptyUtils.isEmpty((String)(periodId = (String)fsp.getCustomParam("periodId")))) {
                    this.getModel().setValue(PERIOD, (Object)periodId);
                    Date[] periodEndDateArr = PeriodHelper.getPeriodStartAndEndTime((Long)Long.parseLong(periodId));
                    if (periodEndDateArr != null) {
                        this.getModel().setValue("bizdate", (Object)periodEndDateArr[1]);
                    }
                }
                this.getPageCache().put("hasinit", "1");
            } else {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) {
                    this.setCostAccount(org.getLong("id"));
                }
            }
        }
    }

    private void setEnable(Boolean enable) {
        this.getView().setEnable(enable, new String[]{"billno", "manuorg", "remark", "entryentity", "bar_newentry", "bar_deleteentry", "bar_configure"});
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private List<Long> getCostCenterByUser() {
        List accountOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        ArrayList<Long> ids = new ArrayList<Long>(accountOrgs.size());
        for (ComboItem ComboItem2 : accountOrgs) {
            ids.add(Long.valueOf(ComboItem2.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!accountOrgs.isEmpty()) {
            filters.add(new QFilter("accountorg", "in", ids));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        Object[] costCenter = BusinessDataServiceHelper.load((String)BOS_COSTCENTER, (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

