/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanOrgAndCostAccountListPlugin;
import kd.macc.cad.servicehelper.DiyCostDriverServiceHelper;

public class PlanCostDriverListPlugin
extends PlanOrgAndCostAccountListPlugin {
    private static final Log logger = LogFactory.getLog(PlanCostDriverListPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String closeBack_importResult = "importResult";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
        List filters = e.getQFilters();
        filters.add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
        e.setOrderBy("period desc,billno ASC,costcenter.number ASC");
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        Long manuorgId = null;
        if (!CadEmptyUtils.isEmpty((Long)orgId) && OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            manuorgId = this.getSelectOrgId("manuorg");
        }
        Long costcenter = this.getSelectOrgId("costcenter");
        String costAccount = this.getPageCache().get("costaccount");
        bsp.setCustomParam(this.ORG_FIELD, (Object)(orgId == null ? "" : String.valueOf(orgId)));
        bsp.setCustomParam("costaccount", (Object)costAccount);
        bsp.setCustomParam("costcenter", (Object)(costcenter == null ? "" : String.valueOf(costcenter)));
        bsp.setCustomParam("period", (Object)this.getPageCache().get("period"));
        bsp.setCustomParam("manuorg", (Object)(manuorgId == null ? "" : String.valueOf(manuorgId)));
        e.getParameter().setCustomParam("planscheme", (Object)this.getPageCache().get("planscheme"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateAccuracy();
    }

    private void updateAccuracy() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            return;
        }
        DynamicObject[] cols = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_plancostdriver"));
        HashMap<Object, String> costObjectMap = new HashMap<Object, String>();
        if (cols == null) {
            return;
        }
        for (DynamicObject item : cols) {
            DynamicObjectCollection entryentity;
            BigDecimal qty = item.getBigDecimal("qty");
            if (!CadEmptyUtils.isEmpty((BigDecimal)qty)) {
                String qtyStr = qty.stripTrailingZeros().toPlainString();
                costObjectMap.put(item.getPkValue(), qtyStr);
            }
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(entryentity = item.getDynamicObjectCollection("entryentity")))) continue;
            for (DynamicObject entry : entryentity) {
                BigDecimal entryQty = entry.getBigDecimal("entryqty");
                if (CadEmptyUtils.isEmpty((BigDecimal)entryQty)) continue;
                String entryQtyStr = entryQty.stripTrailingZeros().toPlainString();
                costObjectMap.put(entry.get("id"), entryQtyStr);
            }
        }
        int i = 0;
        for (ListSelectedRow row : rows) {
            Long id;
            Object primaryKeyValue = row.getPrimaryKeyValue();
            String qtyStr = (String)costObjectMap.get(primaryKeyValue);
            if (!CadEmptyUtils.isEmpty((String)qtyStr)) {
                billList.setCellFieldValue("qty", i, (Object)qtyStr);
            }
            if (CadEmptyUtils.isEmpty((Long)(id = (Long)row.getEntryPrimaryKeyValue()))) {
                ++i;
                continue;
            }
            String entryQtys = (String)costObjectMap.get(id);
            if (CadEmptyUtils.isEmpty((String)entryQtys)) {
                ++i;
                continue;
            }
            billList.setCellFieldValue("entryqty", i, (Object)entryQtys);
            ++i;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && opResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "tblnew": {
                List<ComboItem> orgComboItemList = this.getORGComboItemList();
                if (!CadEmptyUtils.isEmpty(orgComboItemList)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a", (String)"PlanCostDriverListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "delete": {
                break;
            }
            case "sysimport": {
                this.inSysImport();
                break;
            }
        }
    }

    private void inSysImport() {
        try {
            Map objRules;
            Long acctOrg = this.getSelectOrgId(this.ORG_FIELD);
            if (CadEmptyUtils.isEmpty((Long)acctOrg)) {
                return;
            }
            long accountOrgId = acctOrg;
            String costAccount = this.getPageCache().get("costaccount");
            long costAccountId = costAccount == null || CadEmptyUtils.isEmpty((String)costAccount) ? 0L : Long.parseLong(costAccount);
            String costCenter = this.getPageCache().get("costcenter");
            ArrayList<Long> costCenters = new ArrayList<Long>(10);
            if (!CadEmptyUtils.isEmpty((String)costCenter)) {
                List costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)costCenter, List.class);
                if (!CadEmptyUtils.isEmpty((List)costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
                    costCenterMultiSelect.forEach(s -> costCenters.add(Long.parseLong(String.valueOf(s))));
                } else if (costCenterMultiSelect.size() == 1 && !CadEmptyUtils.isEmpty((String)String.valueOf(costCenterMultiSelect.get(0)))) {
                    costCenters.add(Long.parseLong(String.valueOf(costCenterMultiSelect.get(0))));
                }
            }
            if (CadEmptyUtils.isEmpty(costCenters)) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("accountorg", "=", (Object)accountOrgId));
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("enable", "=", (Object)true));
                List costCentersByOrg = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
                costCentersByOrg.forEach(s -> costCenters.add(Long.parseLong(String.valueOf(s))));
            }
            if (CadEmptyUtils.isEmpty((Map)(objRules = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, costCenters)))) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"PlanCostDriverListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"CostObjectListPlugin_6"));
                return;
            }
            Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)accountOrgId, costCenters, (Map)objRules);
            List collConfigs = CommonCollConfigService.getCollConfigs((Long)acctOrg, (Long)costAccountId, (Set)calDimensionIds, (String)"cad_plancostdriver", (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5f52\u96c6\u65b9\u6848\u3002", (String)"PlanCostDriverListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"PlanCostDriverListPlugin_18"));
                return;
            }
            Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)accountOrgId);
            ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
            Long manuorgId = this.getSelectOrgId(this.ORG_FIELD);
            if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((Long)manuorgId)) {
                List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountOrgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(userHasPermManuOrgs);
            } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((Long)manuorgId)) {
                manuOrgs.add(manuorgId);
            }
            String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlanCostDriverListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = DiyCostDriverServiceHelper.importDiyCostDriver((Long)accountOrgId, (Long)costAccountId, (List)costCenters, (List)manuOrgs, (String)appNum, (String)progressId, (String)"cad_plancostdriver");
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"PlanCostDriverListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("searchconfig".equals(itemKey)) {
            this.searchConfig();
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"cad_plancostdriver", (IFormView)this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("forcedelete".equals(e.getCallBackId()) && MessageBoxResult.Yes == e.getResult()) {
            String forcedelete = this.getView().getPageCache().get("forcedelete");
            List deleteIds = (List)SerializationUtils.fromJsonString((String)forcedelete, List.class);
            if (CadEmptyUtils.isEmpty((List)deleteIds)) {
                logger.error("sca_matallocstd\u5f3a\u5236\u5220\u9664\u5f02\u5e38,\u672a\u83b7\u53d6\u5230\u9009\u4e2did");
                return;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)deleteIds)};
            DataSet rows = QueryServiceHelper.queryDataSet((String)"forcedeleteQuery", (String)"cad_plancostdriver", (String)"billno", (QFilter[])qFilters, null);
            String opType = ResManager.loadKDString((String)"\u5f3a\u5236\u5220\u9664\u64cd\u4f5c", (String)"PlanCostDriverListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            StringBuilder stringBuilder = new StringBuilder();
            while (rows.hasNext()) {
                stringBuilder.append(rows.next().getString("billno")).append("\uff0c");
            }
            String checkType = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5f3a\u5236\u5220\u9664\u7f16\u7801\u4e3a%s \u7684\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u636e", (String)"PlanCostDriverListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), stringBuilder.toString());
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_plancostdriver", (String)this.getView().getFormShowParameter().getAppId());
            DeleteServiceHelper.delete((String)"cad_plancostdriver", (QFilter[])qFilters);
            BillList list = (BillList)this.getView().getControl("billlistap");
            if (list != null) {
                list.refresh();
            }
        }
        if ("tbleffect".equals(e.getCallBackId()) && MessageBoxResult.Yes == e.getResult()) {
            this.getView().invokeOperation("effect");
        }
    }
}

