/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanFeeBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private Log logger = LogFactory.getLog(PlanFeeBillEditPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initFilter();
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operationKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operationKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_new", "searchup"});
                break;
            }
        }
    }

    private void initFilter() {
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("costcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            Long orgId = org.getLong("id");
            if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
                Long manuorg = this.getModel().getDataEntity().getLong("manuorg.id");
                if (CadEmptyUtils.isEmpty((Long)manuorg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5145\u751f\u4ea7\u7ec4\u7ec7", (String)"PlanFeeBillEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                ArrayList<Long> manuOrgs = new ArrayList<Long>();
                manuOrgs.add(manuorg);
                Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)orgId, manuOrgs, (String)this.getView().getFormShowParameter().getAppId());
                if (centerIds.isEmpty()) {
                    qFilters.add(new QFilter("id", "=", (Object)-1));
                } else {
                    qFilters.add(new QFilter("id", "in", (Object)centerIds));
                }
            } else {
                QFilter orgQf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                qFilters.add(orgQf);
            }
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
            qFilters.add(this.getAllocMoldQF());
        });
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(enabledCostAccountIdsFilter);
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            Long org = this.getModel().getDataEntity().getLong("org.id");
            if (CadEmptyUtils.isEmpty((Long)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanFeeBillEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
        BasedataEdit expenseItem = (BasedataEdit)this.getControl("expenseitem");
        expenseItem.addBeforeF7SelectListener(evt -> {
            List<QFilter> qFilters = this.getInputQFilters(evt);
            qFilters.add(new QFilter("isleaf", "=", (Object)true));
        });
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(evt -> {
            Long schemeId = this.getModel().getDataEntity().getLong("planscheme.id");
            if (CadEmptyUtils.isEmpty((Long)schemeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"PlanFeeBillEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)schemeId);
            List<QFilter> qFilters = this.getInputQFilters(evt);
            qFilters.add(new QFilter("id", "in", (Object)periodIds));
        });
        BasedataEdit planScheme = (BasedataEdit)this.getControl("planscheme");
        planScheme.addBeforeF7SelectListener(evt -> {
            Long costaccount = this.getModel().getDataEntity().getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)costaccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanFeeBillEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<QFilter> qFilters = this.getInputQFilters(evt);
            qFilters.add(new QFilter("costaccount", "=", (Object)costaccount));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    public void afterBindData(EventObject e) {
        this.setMustInputCostCenter();
        this.setManuOrg();
        Long id = (Long)this.getModel().getValue("id");
        if (id == 0L) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new"});
            this.initByListData();
        }
        this.setBillEnable();
        this.getModel().setDataChanged(false);
    }

    private void setBillEnable() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"billno"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno"});
        }
        Object operate = this.getView().getFormShowParameter().getCustomParam("operate");
        if (StringUtils.isNotBlank((Object)operate) && (StringUtils.equals((CharSequence)"new", (CharSequence)operate.toString()) || StringUtils.equals((CharSequence)"copy", (CharSequence)operate.toString()))) {
            this.setEnable(true);
            return;
        }
        String srcSys = this.getModel().getDataEntity().getString("srcbillid");
        if (StringUtils.isNotBlank((CharSequence)srcSys)) {
            this.setEnable(false);
        } else {
            QFilter filter = new QFilter("srcbillentry.srcbill", "=", (Object)this.getModel().getDataEntity().getLong("id"));
            filter.and("srcbillentry.type", "=", (Object)"A");
            boolean nonExists = QueryServiceHelper.exists((String)"cad_plannonprodalloc", (QFilter[])filter.toArray());
            boolean auxExists = QueryServiceHelper.exists((String)"cad_planauxprodalloc", (QFilter[])filter.toArray());
            boolean basicExists = QueryServiceHelper.exists((String)"cad_planbasicalloc", (QFilter[])filter.toArray());
            QFilter centerFilter = new QFilter("srcexpentry.expbillid", "=", (Object)this.getModel().getDataEntity().getLong("id"));
            centerFilter.and("srcexpentry.srctype", "=", (Object)"A");
            boolean flag = true;
            if (nonExists || auxExists || basicExists) {
                flag = false;
            }
            this.setEnable(flag);
        }
    }

    private void setEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costaccount"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"manuorg"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"period"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"allocmold"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costcenter"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costcentertype"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"expenseitem"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"totalamount"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bizdate"});
    }

    private void initByListData() {
        String periodId;
        IDataModel model = this.getModel();
        model.setValue("sourcetype", (Object)"NEW");
        model.setValue("totalamount", null);
        model.setValue("srcbillnum", (Object)" ");
        model.setValue("collconfig", null);
        model.setValue("srcbillid", (Object)" ");
        boolean isCopy = false;
        if (this.getView().getFormShowParameter().getCustomParam("iscopy") != null) {
            isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        }
        if (isCopy) {
            this.getModel().setDataChanged(true);
            return;
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String orgId = (String)fsp.getCustomParam("org");
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            model.setValue("org", (Object)orgId);
        } else {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            orgId = String.valueOf(org.getLong("id"));
        }
        String costCenterId = (String)fsp.getCustomParam("costcenter");
        if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
            model.setValue("costcenter", (Object)costCenterId);
            this.initAllocMold(costCenterId);
        }
        String costAccountId = (String)fsp.getCustomParam("costaccount");
        this.logger.info("initByListData costAccountId ==>{}", (Object)costAccountId);
        if (!CadEmptyUtils.isEmpty((String)costAccountId)) {
            model.setValue("costaccount", (Object)costAccountId);
        }
        model.setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        boolean enableMulFactory = CostAccountHelper.isOrgEnableMulFactory((Long)Long.parseLong(orgId), (String)"sca");
        String manuOrg = (String)fsp.getCustomParam("manuorg");
        if (!CadEmptyUtils.isEmpty((String)manuOrg) && enableMulFactory) {
            model.setValue("manuorg", (Object)manuOrg);
        } else {
            model.setValue("manuorg", null);
            this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        }
        String planSchemeId = (String)fsp.getCustomParam("planscheme");
        if (!CadEmptyUtils.isEmpty((String)planSchemeId)) {
            model.setValue("planscheme", (Object)planSchemeId);
        }
        if (!CadEmptyUtils.isEmpty((String)(periodId = (String)fsp.getCustomParam("period")))) {
            model.setValue("period", (Object)periodId);
            Date[] periodDate = PeriodHelper.getPeriodStartAndEndTime((Long)Long.valueOf(periodId));
            if (periodDate != null) {
                model.setValue("bizdate", (Object)periodDate[1]);
            }
        }
    }

    private void initAllocMold(String costCenterId) {
        DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
        if (CadEmptyUtils.isEmpty((String)costCenterId)) {
            return;
        }
        String orgduty = costCenter.getString("orgduty.number");
        String allocMold = "";
        allocMold = "4".equals(orgduty) ? "C" : ("5".equals(orgduty) ? "B" : "A");
        this.getModel().setValue("allocmold", (Object)allocMold);
        this.getModel().setValue("costcenter", (Object)costCenterId);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "org": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org != null) {
                    this.setCostAccount(org.getLong("id"));
                }
                this.setPeriod();
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.getModel().setValue("planscheme", null);
                this.setPeriod();
                this.setManuOrg();
                break;
            }
            case "allocmold": {
                this.getModel().setValue("costcenter", null);
                this.setMustInputCostCenter();
                break;
            }
            case "manuorg": {
                this.getModel().setValue("costcenter", null);
                break;
            }
            case "planscheme": {
                this.getModel().setValue("period", null);
            }
        }
    }

    public void setManuOrg() {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        boolean enableMulFactory = CostAccountHelper.isOrgEnableMulFactory((Long)orgId, (String)"sca");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("manuorg");
        basedataEdit.setMustInput(enableMulFactory);
        this.getView().setEnable(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long schemeId = this.getModel().getDataEntity().getLong("planscheme.id");
        if (CadEmptyUtils.isEmpty((Long)schemeId)) {
            return;
        }
        List periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)schemeId);
        if (periodIds != null && !periodIds.isEmpty()) {
            Long firstPeriodId = (Long)periodIds.get(0);
            this.getModel().setValue("period", (Object)firstPeriodId);
        }
    }

    private void setCostAccount(long orgId) {
        DynamicObjectCollection costaccounts = this.getCostaccount(orgId);
        if (costaccounts == null || costaccounts.size() == 0 || costaccounts.size() > 1) {
            return;
        }
        DynamicObject costaccount = (DynamicObject)costaccounts.get(0);
        this.getModel().setValue("costaccount", (Object)costaccount.getLong("id"));
    }

    private DynamicObjectCollection getCostaccount(Long orgId) {
        QFilter accountOrgQF = new QFilter("calorg", "=", (Object)orgId);
        QFilter enableStdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        String orderby = "enablestandardcost DESC, number ASC";
        return QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name", (QFilter[])new QFilter[]{accountOrgQF, enableStdtQF}, (String)orderby);
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        switch (operateKey) {
            case "searchup": {
                this.searchUpOriginalBill();
                break;
            }
            case "new": {
                fsp.setCustomParam("operate", (Object)"new");
                this.setBillEnable();
                break;
            }
            case "copy": {
                fsp.setCustomParam("operate", (Object)"copy");
                this.setBillEnable();
                break;
            }
            case "save": {
                long manuorgId;
                if (!CostAccountHelper.isOrgEnableMulFactory((Long)this.getModel().getDataEntity().getLong("org.id"), (String)"sca") || !StringUtils.isBlank((Object)(manuorgId = this.getModel().getDataEntity().getLong("manuorg.id"))) && manuorgId != 0L) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u5de5\u5382\u5df2\u542f\u7528\uff0c\u751f\u4ea7\u7ec4\u7ec7\u5fc5\u5f55\uff01", (String)"PlanFeeBillEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void searchUpOriginalBill() {
        String srcBill = this.getModel().getDataEntity().getString("srcbillid");
        if (CadEmptyUtils.isEmpty((String)srcBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8d39\u7528\u5f52\u96c6\u6ca1\u6709\u6765\u6e90\u5355\u636e\u3002", (String)"PlanFeeBillEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_planfeebill", (String)"srcbilltype,srcbillid", (QFilter[])new QFilter[]{idFilter});
        HashMap<String, Set> billTypeIdsMap = new HashMap<String, Set>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String billId = dynamicObject.getString("srcbillid");
            String billType = dynamicObject.getString("srcbilltype");
            if (billId == null || "".equals(billId)) continue;
            billTypeIdsMap.computeIfAbsent(billType, s -> new HashSet(16)).add(billId);
        }
        if (CadEmptyUtils.isEmpty(billTypeIdsMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8d39\u7528\u5f52\u96c6\u6ca1\u6709\u6765\u6e90\u5355\u636e\u3002", (String)"PlanFeeBillEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!CadEmptyUtils.isEmpty(billTypeIdsMap)) {
            for (Map.Entry billTypeEntry : billTypeIdsMap.entrySet()) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId((String)billTypeEntry.getKey());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                for (String srcBillId : (Set)billTypeEntry.getValue()) {
                    String[] pkIdArr;
                    for (String pkId : pkIdArr = srcBillId.split("@")) {
                        showParameter.addLinkQueryPkId((Object)Long.parseLong(pkId));
                    }
                }
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.unaudit();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("afterconfirm", "true");
            }
        }
    }

    private void unaudit() {
        Long billId = (Long)this.getModel().getValue("id");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cad_planfeebill", (Object[])new Object[]{billId}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getModel().setValue("billstatus", (Object)"A");
            this.getView().updateView();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"PlanFeeBillEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private QFilter getAllocMoldQF() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (StringUtils.isEmpty((CharSequence)allocMold)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u7c7b\u578b", (String)"PlanFeeBillEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return new QFilter("orgduty.number", "=", (Object)"-1");
        }
        switch (allocMold) {
            case "A": {
                return new QFilter("orgduty.number", "not in", (Object)new String[]{"4", "5"});
            }
            case "B": {
                return new QFilter("orgduty.number", "=", (Object)"5");
            }
            case "C": {
                return new QFilter("orgduty.number", "=", (Object)"4");
            }
        }
        return new QFilter("orgduty.number", "=", (Object)"-1");
    }

    private void setMustInputCostCenter() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (StringUtils.isEmpty((CharSequence)allocMold)) {
            return;
        }
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        switch (allocMold) {
            case "A": {
                costCenter.setMustInput(false);
                break;
            }
            case "B": 
            case "C": {
                costCenter.setMustInput(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("sourcetype", "NEW");
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    public void beforeBindData(EventObject e) {
    }
}

