/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.common.dto.PlanFeeImportReport;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.PlanfeeBillImportHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanOrgAndCostAccountListPlugin;

public class PlanFeeBillListPlugin
extends PlanOrgAndCostAccountListPlugin {
    private Log logger = LogFactory.getLog(PlanFeeBillListPlugin.class);
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_DELETE = "delete";
    private static final String closeBack_importResult = "importResult";

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        Long manuorgId = null;
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            manuorgId = this.getSelectOrgId("manuorg");
        }
        e.getParameter().setCustomParam("org", (Object)(orgId == null ? "" : String.valueOf(orgId)));
        Long costcenter = this.getSelectOrgId("costcenter");
        e.getParameter().setCustomParam("costaccount", (Object)this.getPageCache().get("costaccount"));
        e.getParameter().setCustomParam("costcenter", (Object)(costcenter == null ? "" : String.valueOf(costcenter)));
        e.getParameter().setCustomParam("manuorg", (Object)(manuorgId == null ? "" : String.valueOf(manuorgId)));
        e.getParameter().setCustomParam("period", (Object)this.getPageCache().get("period"));
        e.getParameter().setCustomParam("planscheme", (Object)this.getPageCache().get("planscheme"));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                this.checkAddWay(e, "new");
                break;
            }
            case "sysimport": {
                this.checkAddWay(e, "sysimport");
                break;
            }
            case "searchup": {
                ListSelectedRowCollection selectedRows = e.getListSelectedData();
                this.searchUpOriginalBillNew(selectedRows);
                break;
            }
            case "delete": {
                this.deleteTips(e);
            }
        }
    }

    private void deleteTips(BeforeDoOperationEventArgs e) {
        ArrayList<String> pkValues = new ArrayList<String>();
        ArrayList<String> billNumbers = new ArrayList<String>();
        ListSelectedRowCollection selectedRows = e.getListSelectedData();
        for (ListSelectedRow listSelectedRow : selectedRows.getBillListSelectedRowCollection()) {
            String pkValue = listSelectedRow.getPrimaryKeyValue().toString();
            pkValues.add(pkValue);
            if (!this.checkBillExist(pkValue)) continue;
            billNumbers.add(listSelectedRow.getBillNo());
        }
        String schemeId = this.getPageCache().get("schemeId");
        if (!CadEmptyUtils.isEmpty((String)schemeId)) {
            List startPeriodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)Long.valueOf(schemeId));
            QFilter idQFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DataSet queryMfg = QueryServiceHelper.queryDataSet((String)"queryMfg", (String)"cad_planfeebill", (String)"id,period", (QFilter[])idQFilter.toArray(), null);
            for (Row row : queryMfg) {
                if (startPeriodIds.contains(row.getLong("period"))) continue;
                e.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u975e\u542f\u7528\u671f\u95f4\u7684\u8ba1\u5212\u8d39\u7528\u5f52\u96c6\u5355", (String)"PlanFeeBillListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (billNumbers.size() > 0) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this);
            String confirmTip = String.format(ResManager.loadKDString((String)"\u5f52\u96c6\u5355%s\u5df2\u7ecf\u751f\u6210\u4e86\u5206\u914d\u5355\uff0c\u5220\u9664\u9700\u8981\u91cd\u65b0\u8fdb\u884c\u8d39\u7528\u5206\u914d\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"PlanFeeBillListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), org.apache.commons.lang.StringUtils.join(billNumbers, (String)","));
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            this.getPageCache().put("deleteId", SerializationUtils.toJsonString(pkValues));
        }
    }

    private boolean checkBillExist(String pkValue) {
        QFilter filter = new QFilter("srcbillentry.srcbill", "=", (Object)Long.parseLong(pkValue));
        boolean auxExists = QueryServiceHelper.exists((String)"cad_planauxprodalloc", (QFilter[])filter.toArray());
        boolean nonProExists = QueryServiceHelper.exists((String)"cad_plannonprodalloc", (QFilter[])filter.toArray());
        boolean basicExists = QueryServiceHelper.exists((String)"cad_planbasicalloc", (QFilter[])filter.toArray());
        return auxExists || nonProExists || basicExists;
    }

    private void searchUpOriginalBillNew(ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_planfeebill", (String)"srcbilltype,srcbillid", (QFilter[])new QFilter[]{idFilter});
        HashMap<String, Set> billTypeIdsMap = new HashMap<String, Set>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String billId = dynamicObject.getString("srcbillid");
            String billType = dynamicObject.getString("srcbilltype");
            if (billId == null || "".equals(billId)) continue;
            billTypeIdsMap.computeIfAbsent(billType, s -> new HashSet(16)).add(billId);
        }
        if (CadEmptyUtils.isEmpty(billTypeIdsMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8d39\u7528\u5f52\u96c6\u6ca1\u6709\u6765\u6e90\u5355\u636e\u3002", (String)"PlanFeeBillListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!CadEmptyUtils.isEmpty(billTypeIdsMap)) {
            for (Map.Entry billTypeEntry : billTypeIdsMap.entrySet()) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId((String)billTypeEntry.getKey());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                for (String srcBillId : (Set)billTypeEntry.getValue()) {
                    String[] pkIdArr;
                    for (String pkId : pkIdArr = srcBillId.split("@")) {
                        showParameter.addLinkQueryPkId((Object)Long.parseLong(pkId));
                    }
                }
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete": {
                List idList;
                String deleteId;
                if (!MessageBoxResult.Yes.equals((Object)e.getResult()) || !StringUtils.isNotBlank((CharSequence)(deleteId = this.getPageCache().get("deleteId"))) || CollectionUtils.isEmpty((Collection)(idList = (List)SerializationUtils.fromJsonString((String)deleteId, List.class)))) break;
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"cad_planfeebill");
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])idList.toArray());
                OperateOption operateOption = OperateOption.create();
                this.getView().invokeOperation(KEY_REFRESH, operateOption);
                this.getPageCache().remove("deleteId");
            }
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
            break;
        }
    }

    public void setFilter(SetFilterEvent e) {
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        if (orgId != null) {
            String costAccountId = this.getPageCache().get("costaccount");
            if (StringUtils.isNotBlank((CharSequence)costAccountId)) {
                DynamicObject currentPeriodType = PeriodHelper.getCurrentPeriodType((Long)Long.parseLong(costAccountId));
                if (currentPeriodType != null) {
                    PeriodHelper.getPeriodItems((Long)Long.parseLong(currentPeriodType.getPkValue().toString()));
                    QFilter periodFilter = new QFilter("period.periodtype", "=", currentPeriodType.getPkValue());
                    e.getQFilters().add(periodFilter);
                }
            } else {
                e.getQFilters().add(new QFilter("id", "in", (Object)-1));
            }
            QFilter manuOrgQFilter = this.getManuOrgQFilter();
            if (manuOrgQFilter != null) {
                e.getQFilters().add(manuOrgQFilter);
            }
            e.setOrderBy("billno desc");
        }
    }

    private void checkAddWay(BeforeDoOperationEventArgs e, String opr) {
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        Long costCenterId = this.getSelectOrgId("costcenter");
        String appNum = this.getView().getFormShowParameter().getAppId();
        if ("new".equals(opr)) {
            return;
        }
        if ("sysimport".equals(opr)) {
            List<Long> costCenterIdList = new ArrayList<Long>();
            List costCenters = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("multiselectcostcenters"), List.class);
            if (!CadEmptyUtils.isEmpty((List)costCenters) && costCenters.size() > 1) {
                String costCenterString = SerializationUtils.toJsonString((Object)costCenters);
                this.getPageCache().put("costCenterIdList", costCenterString);
                this.openImportWin();
                return;
            }
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
                if (enableMultiFactory) {
                    String manuOrgId = this.getPageCache().get("manuorg");
                    List<Long> manuList = new ArrayList<Long>();
                    if (CadEmptyUtils.isEmpty((String)manuOrgId)) {
                        manuList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                    } else {
                        manuList.add(Long.parseLong(manuOrgId));
                    }
                    HashSet<Long> centerIds = new HashSet<Long>(16);
                    DynamicObjectCollection dynamicObjects = OrgHelper.getCenterManyByManuOrgIds((Long)orgId, manuList, (String)appNum);
                    if (!dynamicObjects.isEmpty()) {
                        HashMap<Long, Long> centerManuMap = new HashMap<Long, Long>();
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            long centerId = dynamicObject.getLong("costcenter");
                            centerIds.add(centerId);
                            centerManuMap.put(centerId, dynamicObject.getLong("manuorg"));
                        }
                        this.getPageCache().put("centerManuMap", ((Object)centerManuMap).toString());
                    }
                    if (CadEmptyUtils.isEmpty(centerIds)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb!", (String)"PlanFeeBillListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    ArrayList costCenterIds = new ArrayList(centerIds);
                    this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIds));
                } else {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    filters.add(new QFilter("accountorg", "=", (Object)orgId));
                    filters.add(new QFilter("status", "=", (Object)"C"));
                    filters.add(new QFilter("enable", "=", (Object)true));
                    costCenterIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
                    costCenterIdList.add(0L);
                    this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIdList));
                }
                this.openImportWin();
                return;
            }
            costCenterIdList.add(costCenterId);
            this.getPageCache().put("costCenterIdList", SerializationUtils.toJsonString(costCenterIdList));
            this.openImportWin();
            return;
        }
    }

    private void openImportWin() {
        String appNum;
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts((Long)orgId, (Boolean)Boolean.TRUE, (String)(appNum = this.getView().getFormShowParameter().getAppId()));
        if (costAccounts != null && !costAccounts.isEmpty()) {
            if (costAccounts.size() == 1) {
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
                QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
                enable.and("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                enable.and("entryentity.isinit", "=", (Object)Boolean.TRUE);
                QFilter appNumQf = new QFilter("appnum", "=", (Object)appNum);
                QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQf};
                DynamicObject[] startStdCosts = BusinessDataServiceHelper.load((String)"sca_startstdcost", (String)"org,entryentity.costaccount,entryentity.isenabled,entryentity.isinit,entryentity.currentperiod", (QFilter[])filters);
                if (startStdCosts != null && startStdCosts.length == 1) {
                    ArrayList<DynamicObject> selectData = new ArrayList<DynamicObject>();
                    DynamicObject startStdCost = startStdCosts[0];
                    DynamicObject org = startStdCost.getDynamicObject("org");
                    DynamicObjectCollection entryEntity = startStdCost.getDynamicObjectCollection("entryentity");
                    if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                        for (DynamicObject entity : entryEntity) {
                            boolean isInit = entity.getBoolean("isinit");
                            boolean isEnabled = entity.getBoolean("isenabled");
                            if (!isEnabled || !isInit) continue;
                            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sca_matallocimport");
                            DynamicObjectCollection costaccountlist = dynamicObject.getDynamicObjectCollection("costaccountlist");
                            DynamicObject entry = costaccountlist.addNew();
                            DynamicObject costaccount = entity.getDynamicObject("costaccount");
                            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
                            if (CadEmptyUtils.isEmpty((DynamicObject)currentPeriod) || CadEmptyUtils.isEmpty((DynamicObject)costaccount)) continue;
                            entry.set("costaccount", (Object)costaccount);
                            entry.set("currentperiod", (Object)PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id")));
                            entry.set("org", (Object)org);
                            selectData.add(entry);
                        }
                        this.importPlanFeeBillBySys(selectData);
                    }
                }
            } else {
                String manuorgId = this.getPageCache().get("manuorg");
                ArrayList<Long> orgIdList = new ArrayList<Long>(10);
                orgIdList.add(orgId);
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("sca_matallocimport");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam("org", orgIdList);
                fsp.setCustomParam("manuorg", (Object)manuorgId);
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "form"));
                this.getView().showForm(fsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        this.getView().hideLoading();
        switch (actionId = e.getActionId()) {
            case "importResult": {
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                ExecuteResult executeResult = (ExecuteResult)SerializationUtils.fromJsonString((String)responseInfoStr, ExecuteResult.class);
                String submitTip = executeResult.getSubmitTip();
                String aduitTip = executeResult.getAduitTip();
                if (StringUtils.isEmpty((CharSequence)submitTip) && StringUtils.isEmpty((CharSequence)aduitTip)) {
                    executeResult.showNotificationSample(this.getView());
                    if (!executeResult.isSuccess()) break;
                    this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                    break;
                }
                StringBuilder tip = new StringBuilder();
                String successTip = (String)executeResult.getSuccessInfo().get("Success");
                tip.append(successTip).append("\r\n").append(submitTip).append(aduitTip);
                this.getView().showMessage(tip.toString());
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "form": {
                List selectData = (List)e.getReturnData();
                if (selectData == null || selectData.size() == 0) {
                    return;
                }
                this.importPlanFeeBillBySys(selectData);
                this.getView().invokeOperation(KEY_REFRESH);
                break;
            }
        }
    }

    private void importPlanFeeBillBySys(List<DynamicObject> selectData) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        HashSet<Long> costAccountSet = new HashSet<Long>(16);
        for (DynamicObject selectRow : selectData) {
            DynamicObject costaccount = selectRow.getDynamicObject("costaccount");
            costAccountSet.add(costaccount.getLong("id"));
            paramMap.put(String.valueOf(costaccount.getLong("id")), selectRow.getDynamicObject("currentperiod") == null ? 0L : selectRow.getDynamicObject("currentperiod").getLong("id"));
        }
        DynamicObject selectRow = selectData.get(0);
        Long orgId = selectRow.getDynamicObject("org").getLong("id");
        String manuorgId = this.getPageCache().get("manuorg");
        if (CadEmptyUtils.isEmpty((String)manuorgId)) {
            manuorgId = "0";
        }
        paramMap.put("manuorg", Long.parseLong(manuorgId));
        String costCenterIdListStr = this.getPageCache().get("costCenterIdList");
        List costCenterIdList = (List)SerializationUtils.fromJsonString((String)costCenterIdListStr, List.class);
        IFormView view = this.getView();
        Set dyDataRuleCostCenterIds = ImportServiceHelper.getDyDataRuleCostCenter((Long)RequestContext.get().getCurrUserId(), (String)view.getFormShowParameter().getAppId(), (String)"cad_planfeebill", (String)"4730fc9f000003ae", Collections.singletonList(orgId));
        if (!CadEmptyUtils.isEmpty((Set)dyDataRuleCostCenterIds)) {
            ArrayList notInDataRules = new ArrayList(10);
            costCenterIdList.forEach(p -> {
                if (!dyDataRuleCostCenterIds.contains(Long.parseLong(p.toString()))) {
                    notInDataRules.add(p);
                }
            });
            if (!CadEmptyUtils.isEmpty((List)costCenterIdList)) {
                costCenterIdList.removeAll(notInDataRules);
            }
        }
        paramMap.put("appnum", view.getFormShowParameter().getAppId());
        PlanFeeImportReport report = this.initializeReport(orgId, view.getFormShowParameter().getAppId());
        String centerManuMapString = this.getPageCache().get("centerManuMap");
        if (centerManuMapString != null) {
            Map<Long, Long> centerManuMap = this.mapStringToMap(centerManuMapString);
            paramMap.put("centerManuMap", centerManuMap);
        }
        paramMap.put("report", report);
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlanFeeBillListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            ExecuteResult executeResult = new ExecuteResult();
            try {
                executeResult = PlanfeeBillImportHelper.importPlanFeeBillBySys((Long)orgId, (Set)costAccountSet, (List)costCenterIdList, (Map)paramMap, (String)progressId);
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            finally {
                ProgressHelper.clearProgressParam((String)progressId);
            }
            String responseInfoStr = SerializationUtils.toJsonString((Object)executeResult);
            this.getPageCache().put("responseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        view.invokeOperation(KEY_REFRESH);
    }

    private void addItem(List<ComboItem> periodComboItems, String caption, DynamicObject period) {
        if (null == period || kd.bos.util.StringUtils.isEmpty((String)caption)) {
            return;
        }
        ComboItem item = new ComboItem();
        String periodId = period.getString("id");
        item.setCaption(new LocaleString(caption));
        item.setValue(periodId);
        periodComboItems.add(item);
    }

    public void initialize() {
        super.initialize();
    }

    public Map<Long, String> getPeriodLastDate() {
        HashMap<Long, String> date = new HashMap<Long, String>(100);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[0]);
        if (periods.size() == 0) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject period : periods) {
            Date endDate = period.getDate("enddate");
            String format = formatter.format(endDate);
            date.put(period.getLong("id"), format);
        }
        return date;
    }

    @Override
    protected QFilter getManuOrgQFilter() {
        Long orgId;
        boolean enableMultiFactory;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get("manuorg");
        if (StringUtils.isEmpty((CharSequence)manuOrgId) && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)(orgId = this.getSelectOrgId(this.ORG_FIELD)))) && !CadEmptyUtils.isEmpty((Long)orgId)) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private PlanFeeImportReport initializeReport(Long orgId, String appNum) {
        PlanFeeImportReport report = new PlanFeeImportReport();
        report.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        report.setCreateTime(TimeServiceHelper.now());
        report.setId(Long.valueOf(ID.genLongId()));
        report.setBillNo(ID.genStringId());
        report.setOrgId(orgId);
        report.setAppNum(appNum);
        return report;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "colreport": {
                this.viewColReport();
                break;
            }
        }
    }

    private void viewColReport() {
    }

    public Map<Long, Long> mapStringToMap(String str) {
        str = str.substring(1, str.length() - 1);
        String[] strs = str.split(",");
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        for (String string : strs) {
            String key = string.split("=")[0];
            String value = string.split("=")[1];
            String key1 = key.trim();
            String value1 = value.trim();
            map.put(Long.parseLong(key1), Long.parseLong(value1));
        }
        return map;
    }
}

