/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanPeriodControlEdit
extends AbstractBillPlugIn {
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(enabledCostAccountIdsFilter);
        });
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener(evt -> {
            Long costaccount = this.getModel().getDataEntity().getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)costaccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanPeriodControlEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<QFilter> qFilters = this.getInputQFilters(evt);
            DynamicObject periodType = PeriodHelper.getCurrentPeriodType((Long)costaccount);
            qFilters.add(new QFilter("periodtype.id", "=", (Object)periodType.getLong("id")));
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(evt -> {
            Long costaccount = this.getModel().getDataEntity().getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)costaccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanPeriodControlEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<QFilter> qFilters = this.getInputQFilters(evt);
            DynamicObject periodType = PeriodHelper.getCurrentPeriodType((Long)costaccount);
            qFilters.add(new QFilter("periodtype.id", "=", (Object)periodType.getLong("id")));
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setVisible();
    }

    private void setVisible() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblenable", "tbldisable", "tblclose_custom", "tblopen"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tblenable", "tbldisable", "tblclose_custom", "tblopen"});
        }
    }

    public void afterBindData(EventObject e) {
        this.setEnable();
        this.initByListData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        this.setVisible();
        this.setEnable();
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            default: 
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("tbldisable".equals(evt.getItemKey())) {
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryEntityGrid.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
                int currentRowIndex = selectRows[0];
                DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
                Long org = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
                Long costAccount = ((DynamicObject)this.getModel().getValue("costaccount")).getLong("id");
                QFilter qFilter = new QFilter("org", "=", (Object)org);
                qFilter.and(new QFilter("costaccount", "=", (Object)costAccount));
                DynamicObject startPeriod = current.getDynamicObject("startperiod");
                DynamicObject endPeriod = current.getDynamicObject("endperiod");
                List periodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
                qFilter.and(new QFilter("period", "in", (Object)periodIds));
                boolean existPlanFee = QueryServiceHelper.exists((String)"cad_planfeebill", (QFilter[])qFilter.toArray());
                boolean existPlanResource = QueryServiceHelper.exists((String)"cad_planresource", (QFilter[])qFilter.toArray());
                boolean existPlanWork = QueryServiceHelper.exists((String)"cad_planwork", (QFilter[])qFilter.toArray());
                boolean existPlanCostDriver = QueryServiceHelper.exists((String)"cad_plancostdriver", (QFilter[])qFilter.toArray());
                if (existPlanFee || existPlanResource || existPlanWork || existPlanCostDriver) {
                    String tipMsg = ResManager.loadKDString((String)"\u662f\u5426\u53cd\u542f\u7528\uff1f\u671f\u95f4\u5185\u5b58\u5728\u8ba1\u5212\u5355\u636e", (String)"PlanPeriodControlEdit_19", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(tipMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disable_confirm", (IFormPlugin)this));
                    evt.setCancel(true);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("disable_confirm".equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getView().invokeOperation("disable");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        switch (operateKey) {
            case "new": {
                fsp.setCustomParam("operate", (Object)"new");
                break;
            }
            case "save": {
                break;
            }
            case "enable": {
                this.enable(e);
                break;
            }
            case "disable": {
                this.disable(e);
                break;
            }
            case "close_custom": {
                this.close(e);
                break;
            }
            case "open": {
                this.open(e);
                break;
            }
            case "deleteentry": {
                this.deleteEntry(e);
            }
        }
    }

    private void deleteEntry(BeforeDoOperationEventArgs e) {
        EntryGrid entryEntityGrid;
        int[] selectRows;
        int rowIndex;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (this.checkEnable((List<DynamicObject>)entryEntity, rowIndex = (selectRows = (entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY)).getSelectRows())[0])) {
            e.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u671f\u95f4\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"PlanPeriodControlEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void enable(BeforeDoOperationEventArgs e) {
        if (this.checkSelectEntryEmpty(e)) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
            int currentRowIndex = selectRows[0];
            DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
            boolean currentEnable = current.getBoolean("enable");
            boolean currentClose = current.getBoolean("close");
            if (currentEnable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u5df2\u542f\u7528\u3002", (String)"PlanPeriodControlEdit_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            boolean existEnableOpen = false;
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i == currentRowIndex) continue;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                boolean enable = dynamicObject.getBoolean("enable");
                boolean close = dynamicObject.getBoolean("close");
                if (!enable || close || currentClose) continue;
                existEnableOpen = true;
                break;
            }
            if (existEnableOpen) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u5df2\u5b58\u5728\u5df2\u542f\u7528\u672a\u5173\u95ed\u7684\u671f\u95f4\u8303\u56f4\u3002", (String)"PlanPeriodControlEdit_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("enable", (Object)Boolean.TRUE, currentRowIndex);
            this.showNotificationAfterSave(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"PlanPeriodControlEdit_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    private void disable(BeforeDoOperationEventArgs e) {
        if (this.checkSelectEntryEmpty(e)) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
            int currentRowIndex = selectRows[0];
            DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
            boolean currentEnable = current.getBoolean("enable");
            if (!currentEnable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u672a\u542f\u7528\u3002", (String)"PlanPeriodControlEdit_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("enable", (Object)Boolean.FALSE, currentRowIndex);
            this.showNotificationAfterSave(ResManager.loadKDString((String)"\u53cd\u542f\u7528\u6210\u529f\u3002", (String)"PlanPeriodControlEdit_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    private void close(BeforeDoOperationEventArgs e) {
        if (this.checkSelectEntryEmpty(e)) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
            int currentRowIndex = selectRows[0];
            DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
            boolean currentEnable = current.getBoolean("enable");
            boolean currentClose = current.getBoolean("close");
            if (currentClose) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u5df2\u5173\u95ed\u3002", (String)"PlanPeriodControlEdit_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (!currentEnable) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u95ed\u5931\u8d25\u3002\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u542f\u7528\u624d\u80fd\u5173\u95ed\u3002", (String)"PlanPeriodControlEdit_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("close", (Object)Boolean.TRUE, currentRowIndex);
            this.showNotificationAfterSave(ResManager.loadKDString((String)"\u5173\u95ed\u6210\u529f\u3002", (String)"PlanPeriodControlEdit_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    private void open(BeforeDoOperationEventArgs e) {
        if (this.checkSelectEntryEmpty(e)) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
            int currentRowIndex = selectRows[0];
            DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
            boolean currentClose = current.getBoolean("close");
            if (!currentClose) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u672a\u5173\u95ed\u3002", (String)"PlanPeriodControlEdit_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            boolean existEnableOpen = false;
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i == currentRowIndex) continue;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                boolean enable = dynamicObject.getBoolean("enable");
                boolean close = dynamicObject.getBoolean("close");
                if (!enable || close) continue;
                existEnableOpen = true;
                break;
            }
            if (existEnableOpen) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53cd\u5173\u95ed\u5931\u8d25\u3002\u5df2\u5b58\u5728\u5df2\u542f\u7528\u672a\u5173\u95ed\u7684\u671f\u95f4\u8303\u56f4\u3002", (String)"PlanPeriodControlEdit_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("close", (Object)Boolean.FALSE, currentRowIndex);
            this.showNotificationAfterSave(ResManager.loadKDString((String)"\u53cd\u5173\u95ed\u6210\u529f\u3002", (String)"PlanPeriodControlEdit_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkSelectEntryEmpty(BeforeDoOperationEventArgs e) {
        int selectRow;
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanPeriodControlEdit_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow = selectRows[0]);
        if (dynamicObject.getDynamicObject("startperiod") == null) {
            String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u5f00\u59cb\u671f\u95f4\u201d\u3002", (String)"PlanPeriodControlEdit_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), selectRow + 1);
            this.getView().showTipNotification(tip);
            return true;
        }
        if (dynamicObject.getDynamicObject("endperiod") == null) {
            String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u7ed3\u675f\u671f\u95f4\u201d\u3002", (String)"PlanPeriodControlEdit_16", (String)"macc-cad-formplugin", (Object[])new Object[0]), selectRow + 1);
            this.getView().showTipNotification(tip);
            return true;
        }
        return false;
    }

    private void showNotificationAfterSave(String successNotification) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_planperiod", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(successNotification);
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private void setEnable() {
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org", "costaccount"});
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (this.checkEnable((List<DynamicObject>)entryEntity, i)) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"startperiod", "endperiod"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"startperiod", "endperiod"});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (proName) {
            case "org": {
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org == null) break;
                this.setCostAccount(org.getLong("id"));
                break;
            }
            case "startperiod": 
            case "endperiod": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
                int[] selectRows = entryEntityGrid.getSelectRows();
                int rowIndex = selectRows[0];
                if (!this.checkPeriodStartLessEnd((List<DynamicObject>)entryEntity, rowIndex)) {
                    this.getModel().setValue(proName, null, rowIndex);
                    this.getModel().setDataChanged(false);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"PlanPeriodControlEdit_17", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                if (!this.checkPeriodOverlap((List<DynamicObject>)entryEntity, rowIndex)) break;
                this.getModel().setValue(proName, null, rowIndex);
                this.getModel().setDataChanged(false);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u4e0d\u80fd\u5b58\u5728\u91cd\u53e0\u6216\u4ea4\u53c9\u3002", (String)"PlanPeriodControlEdit_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkEnable(List<DynamicObject> entryEntity, int rowIndex) {
        DynamicObject changeEntry;
        boolean enable;
        return !CadEmptyUtils.isEmpty(entryEntity) && (enable = (changeEntry = entryEntity.get(rowIndex)).getBoolean("enable"));
    }

    private boolean checkPeriodStartLessEnd(List<DynamicObject> entryEntity, int rowIndex) {
        if (!CadEmptyUtils.isEmpty(entryEntity)) {
            DynamicObject changeData = entryEntity.get(rowIndex);
            DynamicObject startPeriod = changeData.getDynamicObject("startperiod");
            DynamicObject endPeriod = changeData.getDynamicObject("endperiod");
            if (startPeriod != null && endPeriod != null && PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)endPeriod) > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPeriodInSameYear(List<DynamicObject> entryEntity, int rowIndex) {
        if (!CadEmptyUtils.isEmpty(entryEntity)) {
            DynamicObject changeData = entryEntity.get(rowIndex);
            DynamicObject startPeriod = changeData.getDynamicObject("startperiod");
            DynamicObject endPeriod = changeData.getDynamicObject("endperiod");
            if (startPeriod != null && endPeriod != null && startPeriod.getLong("periodyear") != endPeriod.getLong("periodyear")) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPeriodOverlap(List<DynamicObject> entryEntity, int rowIndex) {
        boolean flag = false;
        if (!CadEmptyUtils.isEmpty(entryEntity)) {
            DynamicObject changeData = entryEntity.get(rowIndex);
            DynamicObject startPeriod = changeData.getDynamicObject("startperiod");
            DynamicObject endPeriod = changeData.getDynamicObject("endperiod");
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i == rowIndex) continue;
                DynamicObject dynamicObject = entryEntity.get(i);
                DynamicObject start = dynamicObject.getDynamicObject("startperiod");
                DynamicObject end = dynamicObject.getDynamicObject("endperiod");
                if (start == null || end == null) continue;
                if (startPeriod != null && PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)start) >= 0 && PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)end) <= 0) {
                    flag = true;
                    break;
                }
                if (endPeriod != null && PeriodHelper.compare2period((DynamicObject)endPeriod, (DynamicObject)start) >= 0 && PeriodHelper.compare2period((DynamicObject)endPeriod, (DynamicObject)end) <= 0) {
                    flag = true;
                    break;
                }
                if (startPeriod == null || endPeriod == null || PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)start) >= 0 || PeriodHelper.compare2period((DynamicObject)endPeriod, (DynamicObject)end) <= 0) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private void setCostAccount(long orgId) {
        Long mainCostAccountId = CostAccountHelper.getMainCostAccount((Long)orgId, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        if (!CadEmptyUtils.isEmpty((Long)mainCostAccountId)) {
            this.getModel().setValue("costaccount", (Object)mainCostAccountId);
        }
    }

    private DynamicObjectCollection getCostaccount(Long orgId) {
        QFilter accountOrgQF = new QFilter("calorg", "=", (Object)orgId);
        QFilter enableStdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        String orderby = "enablestandardcost DESC, number ASC";
        return QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name", (QFilter[])new QFilter[]{accountOrgQF, enableStdtQF}, (String)orderby);
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    private void initByListData(EventObject e) {
        String operateKey = (String)this.getView().getFormShowParameter().getCustomParam("operate");
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            if (this.getPageCache().get("hasinitorg") == null) {
                String costAccountId;
                IDataModel model = this.getModel();
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String orgId = (String)fsp.getCustomParam("org");
                if (!CadEmptyUtils.isEmpty((String)orgId)) {
                    model.setValue("org", (Object)orgId);
                }
                if (!CadEmptyUtils.isEmpty((String)(costAccountId = (String)fsp.getCustomParam("costaccount")))) {
                    model.setValue("costaccount", (Object)costAccountId);
                }
                this.getPageCache().put("hasinitorg", "1");
            } else {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) {
                    this.setCostAccount(org.getLong("id"));
                }
            }
        }
    }
}

