/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.formplugin.base.PermissionListPlugin;

public class PlanPeriodControlList
extends PermissionListPlugin {
    private static final Log logger = LogFactory.getLog(PlanPeriodControlList.class);
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private volatile boolean orgClick = false;

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                this.checkNullField(e);
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String org = this.getPageCache().get("org");
        String costAccount = this.getPageCache().get("costaccount");
        bsp.setCustomParam("org", (Object)org);
        bsp.setCustomParam("costaccount", (Object)costAccount);
    }

    private void checkNullField(BeforeDoOperationEventArgs e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        fsp.setCustomParam("operate", (Object)"new");
        boolean hasNullValue = this.existNullField();
        if (hasNullValue) {
            e.setCancel(true);
            return;
        }
    }

    private boolean existNullField() {
        String org = this.getPageCache().get("org");
        if (CadEmptyUtils.isEmpty((String)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanPeriodControlList_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        String costaccount = this.getPageCache().get("costaccount");
        if (CadEmptyUtils.isEmpty((String)costaccount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanPeriodControlList_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        logger.info("checkOrgAndCostAccount accountorgId==>{},costaccountId ==>{}", (Object)org, (Object)costaccount);
        return false;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String accountOrgId = this.getPageCache().get("org");
        if (fieldName.startsWith("costaccount.") && !CadEmptyUtils.isEmpty((String)accountOrgId)) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)Long.parseLong(accountOrgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(enabledCostAccountIdsFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String defCostAccount;
        this.initClickEvent(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        String defOrg = this.getPageCache().get("org");
        if (StringUtils.isEmpty((CharSequence)defOrg)) {
            if (!acctOrgs.isEmpty()) {
                defOrg = this.getDefOrg(acctOrgs);
                this.moveTop(acctOrgs, defOrg);
            } else {
                defOrg = "0";
            }
        }
        List<ComboItem> costAccountItems = null;
        if (!CadEmptyUtils.isEmpty((String)defOrg)) {
            costAccountItems = this.getCostAccountComboItemListBy(Collections.singletonList(defOrg));
        }
        if (CadEmptyUtils.isEmpty((String)(defCostAccount = this.getPageCache().get("costaccount"))) && costAccountItems != null && costAccountItems.size() > 0) {
            defCostAccount = costAccountItems.get(0).getValue();
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "org.id": {
                    listcomitem.clear();
                    if (CadEmptyUtils.isEmpty((List)acctOrgs)) break;
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(defOrg);
                    this.getPageCache().put("org", defOrg);
                    break;
                }
                case "costaccount.name": {
                    listcomitem.clear();
                    if (costAccountItems != null && !costAccountItems.isEmpty()) {
                        commonFilterColumn.setComboItems(costAccountItems);
                        commonFilterColumn.setDefaultValue(defCostAccount);
                        this.getPageCache().put("costaccount", defCostAccount);
                        break;
                    }
                    this.getPageCache().put("costaccount", "");
                }
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues;
        List customfilter;
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)args, (String)"costaccount.id");
        }
        if ((customfilter = (List)(filterValues = args.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        String org = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            if (CadEmptyUtils.isEmpty((List)listValue)) continue;
            block9: for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "org.id": {
                        org = (String)listValue.get(j);
                        this.getPageCache().put("org", org);
                        this.getPageCache().put("costaccount", "");
                        this.filterContainerInit(this.filterContainerInitArgs);
                        continue block9;
                    }
                    case "costaccount.id": {
                        String costaccountId = (String)listValue.get(j);
                        this.getPageCache().put("costaccount", costaccountId);
                    }
                }
            }
        }
        if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("accountorgId"))) {
            List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)args, (String)"costcenter.id", (Long)Long.parseLong(this.getPageCache().get("accountorgId")));
            this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
        }
    }

    private String getCustomParam(String key) {
        try {
            Object pageOrg = this.getView().getFormShowParameter().getCustomParam(key);
            if (pageOrg != null && !CadEmptyUtils.isEmpty((String)pageOrg.toString())) {
                return String.valueOf(pageOrg);
            }
        }
        catch (Exception ex) {
            logger.error("\u8f6c\u6362\u62a5\u9519\uff1a", (Throwable)ex);
        }
        return null;
    }

    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(16);
        if (orgId == null) {
            return acctItems;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Object org : orgId) {
            orgIds.add(Long.valueOf(org.toString()));
        }
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount,entryentity.costaccount.number number";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (kd.bos.util.StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appId);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, enable, appNumQF};
        DataSet dataSet = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)"BaseListPlugin_getCostAccountComboItemListBy", (String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
            if (dataSet.isEmpty()) {
                return null;
            }
            ComboItem defaultItem = null;
            DataSet resultDataSet = dataSet.orderBy(new String[]{"number asc"});
            for (Row row : resultDataSet) {
                Boolean isMainAccount = row.getBoolean("ismainaccount");
                if (isMainAccount.booleanValue()) {
                    defaultItem = new ComboItem();
                    defaultItem.setCaption(new LocaleString(row.getString("name")));
                    defaultItem.setValue(row.getString("id"));
                    continue;
                }
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(row.getString("name")));
                item.setValue(row.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
            if (defaultItem != null) {
                acctItems.add(0, defaultItem);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6210\u672c\u8d26\u7c3f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return acctItems;
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String org;
            List list;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            Map commonFilters = ClickEventHelper.getCommonFilters(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = commonFilters != null && commonFilters.size() > 0;
            String defaultValue = "";
            if (selNotNull && (list = (List)commonFilters.get(fieldName)) != null && list.size() > 0) {
                defaultValue = list.get(0).toString();
            }
            if (!fieldName.startsWith("org.") || (org = this.getPageCache().get("org")) == null || "".equals(org)) continue;
            if (!CadEmptyUtils.isEmpty((String)defaultValue) && !defaultValue.equals(org)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    private void moveTop(List<ComboItem> acctOrgs, String orgId) {
        String currOrg;
        String string = currOrg = StringUtils.isEmpty((CharSequence)this.getPageCache().get("currOrg")) ? orgId : this.getPageCache().get("currOrg");
        if (CadEmptyUtils.isEmpty(acctOrgs) || CadEmptyUtils.isEmpty((String)currOrg)) {
            return;
        }
        for (int i = 0; i < acctOrgs.size(); ++i) {
            if (!currOrg.equals(acctOrgs.get(i).getValue())) continue;
            ComboItem temp = acctOrgs.get(0);
            acctOrgs.set(0, acctOrgs.get(i));
            acctOrgs.set(i, temp);
        }
        this.getPageCache().put("currOrg", currOrg);
    }

    private String getDefOrg(List<ComboItem> acctOrgs) {
        String orgId = this.getPageCache().get("org");
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            orgId = isAccounting ? currAcctOrg.toString() : (CadEmptyUtils.isEmpty(acctOrgs) ? "0" : acctOrgs.get(0).getValue());
            this.getPageCache().put("org", orgId);
        }
        return orgId;
    }
}

