/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;

public class PlanResourceBillEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("costcenter");
        costCenterInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            Long orgId = org.getLong("id");
            if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
                Long manuorg = this.getModel().getDataEntity().getLong("manuorg.id");
                if (CadEmptyUtils.isEmpty((Long)manuorg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5145\u751f\u4ea7\u7ec4\u7ec7", (String)"PlanResourceBillEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ArrayList<Long> manuOrgs = new ArrayList<Long>();
                manuOrgs.add(manuorg);
                Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)orgId, manuOrgs, (String)this.getView().getFormShowParameter().getAppId());
                if (centerIds.isEmpty()) {
                    qFilters.add(new QFilter("id", "=", (Object)-1));
                } else {
                    qFilters.add(new QFilter("id", "in", (Object)centerIds));
                }
            } else {
                QFilter orgQf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                qFilters.add(orgQf);
            }
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            QFilter orgfilter = new QFilter("id", "=", (Object)0L);
            if (accountorg == null) {
                formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
                return;
            }
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            orgfilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
        });
        BasedataEdit resourceunit = (BasedataEdit)this.getControl("resourceunit");
        resourceunit.addBeforeF7SelectListener(evt -> {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            Set<Long> transform2SecondUnitIds = this.getCanTransform2SecondsUnitIds();
            if (!CadEmptyUtils.isEmpty(transform2SecondUnitIds)) {
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", transform2SecondUnitIds));
            } else {
                formShowParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        });
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(evt -> {
            Long schemeId = this.getModel().getDataEntity().getLong("planscheme.id");
            if (CadEmptyUtils.isEmpty((Long)schemeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"PlanResourceBillEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List periodIds = PlanFeeAllocHelper.getPlanStartPeriods((Long)schemeId);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)periodIds));
        });
        BasedataEdit planScheme = (BasedataEdit)this.getControl("planscheme");
        planScheme.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            Long costaccount = this.getModel().getDataEntity().getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)costaccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanResourceBillEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            qList.add(new QFilter("costaccount", "=", (Object)costaccount));
        });
    }

    private Set<Long> getCanTransform2SecondsUnitIds() {
        QFilter desMuIdFilter = new QFilter("desmuid", "=", (Object)9L);
        QFilter srcMuIdFilter = new QFilter("srcmuid", "=", (Object)9L);
        desMuIdFilter.or(srcMuIdFilter);
        DynamicObjectCollection measureUnit = QueryServiceHelper.query((String)"bd_measureunitconv", (String)"denominator, numerator,srcmuid,desmuid", (QFilter[])new QFilter[]{desMuIdFilter});
        HashSet<Long> transform2SecondUnitIds = new HashSet<Long>(10);
        measureUnit.forEach(e -> {
            transform2SecondUnitIds.add(e.getLong("srcmuid"));
            transform2SecondUnitIds.add(e.getLong("desmuid"));
        });
        return transform2SecondUnitIds;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void initialize() {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setManuOrg();
        Long id = (Long)this.getModel().getValue("id");
        if (id == 0L) {
            this.initByListData();
        }
        this.setBillEnable();
        this.getModel().setDataChanged(false);
    }

    private void setBillEnable() {
        Long srcSys = this.getModel().getDataEntity().getLong("srcbillid");
        String sourceType = this.getModel().getDataEntity().getString("sourcetype");
        if (!CadEmptyUtils.isEmpty((Long)srcSys) && CadEmptyUtils.equals((String)sourceType, (String)"CONFIG")) {
            this.setEnable(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno"});
        } else {
            this.setEnable(true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"billno"});
        }
    }

    private void setEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costaccount"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"manuorg"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"period"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costcenter"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"resource"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"resourceunit"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"qty"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"planscheme"});
    }

    private void initByListData() {
        String periodId;
        String costAccountId;
        IDataModel model = this.getModel();
        model.setValue("sourcetype", (Object)"NEW");
        model.setValue("srcbillnum", (Object)" ");
        model.setValue("collconfig", null);
        model.setValue("srcbillid", (Object)0L);
        model.setValue("srcentryid", (Object)0L);
        boolean isCopy = false;
        if (this.getView().getFormShowParameter().getCustomParam("iscopy") != null) {
            isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        }
        if (isCopy) {
            this.getModel().setDataChanged(true);
            return;
        }
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.getModel().setValue("resourceunit", (Object)9L);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String orgId = (String)fsp.getCustomParam("org");
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            model.setValue("org", (Object)orgId);
        } else {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            orgId = String.valueOf(org.getLong("id"));
        }
        String costCenterId = (String)fsp.getCustomParam("costcenter");
        if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
            model.setValue("costcenter", (Object)costCenterId);
        }
        if (!CadEmptyUtils.isEmpty((String)(costAccountId = (String)fsp.getCustomParam("costaccount")))) {
            model.setValue("costaccount", (Object)costAccountId);
        }
        model.setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        boolean enableMulFactory = CostAccountHelper.isOrgEnableMulFactory((Long)Long.parseLong(orgId), (String)"sca");
        String manuOrg = (String)fsp.getCustomParam("manuorg");
        if (!CadEmptyUtils.isEmpty((String)manuOrg) && enableMulFactory) {
            model.setValue("manuorg", (Object)manuOrg);
        } else {
            model.setValue("manuorg", null);
        }
        String planSchemeId = (String)fsp.getCustomParam("planscheme");
        if (!CadEmptyUtils.isEmpty((String)planSchemeId)) {
            model.setValue("planscheme", (Object)planSchemeId);
        }
        if (!CadEmptyUtils.isEmpty((String)(periodId = (String)fsp.getCustomParam("period")))) {
            model.setValue("period", (Object)periodId);
            Date[] periodEndDateArr = PeriodHelper.getPeriodStartAndEndTime((Long)Long.parseLong(periodId));
            if (periodEndDateArr != null) {
                model.setValue("bizdate", (Object)periodEndDateArr[1]);
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "org": {
                break;
            }
            case "costaccount": {
                this.getModel().setValue("planscheme", null);
                break;
            }
            case "period": {
                Date[] periodEndDateArr;
                DynamicObject periodDyn = this.getModel().getDataEntity().getDynamicObject("period");
                if (periodDyn == null || (periodEndDateArr = PeriodHelper.getPeriodStartAndEndTime((Long)periodDyn.getLong("id"))) == null) break;
                this.getModel().setValue("bizdate", (Object)periodEndDateArr[1]);
                break;
            }
            case "manuorg": {
                this.getModel().setValue("costcenter", null);
                break;
            }
            case "planscheme": {
                this.getModel().setValue("period", null);
            }
        }
    }

    public void setManuOrg() {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        boolean enableMulFactory = CostAccountHelper.isOrgEnableMulFactory((Long)orgId, (String)"sca");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("manuorg");
        basedataEdit.setMustInput(enableMulFactory);
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private DynamicObjectCollection getCostaccount(Long orgId) {
        QFilter accountOrgQF = new QFilter("calorg", "=", (Object)orgId);
        QFilter enableStdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        String orderby = "enablestandardcost DESC, number ASC";
        return QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name", (QFilter[])new QFilter[]{accountOrgQF, enableStdtQF}, (String)orderby);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_new": {
                List orgComboItemList = OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                if (!CadEmptyUtils.isEmpty((List)orgComboItemList)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a", (String)"PlanResourceBillEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "bar_save": {
                Long manuorg;
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                Long orgId = org.getLong("id");
                if (!OrgHelper.isOrgEnableMultiFactory((Long)orgId) || !CadEmptyUtils.isEmpty((Long)(manuorg = Long.valueOf(this.getModel().getDataEntity().getLong("manuorg.id"))))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5145\u751f\u4ea7\u7ec4\u7ec7", (String)"PlanResourceBillEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        switch (e.getOperateKey()) {
            case "searchup": {
                this.searchUpBill();
                break;
            }
            case "new": {
                fsp.setCustomParam("operate", (Object)"new");
                this.setBillEnable();
                break;
            }
            case "copy": {
                fsp.setCustomParam("operate", (Object)"copy");
                this.setBillEnable();
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("sourcetype", "NEW");
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    private void searchUpBill() {
        Long srcBillId = (Long)this.getModel().getValue("srcbillid");
        if (CadEmptyUtils.isEmpty((Long)srcBillId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u4ece\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"PlanResourceBillEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String source = ((DynamicObject)this.getModel().getValue("srcbilltype")).getString("id");
        if (CadEmptyUtils.isEmpty((String)source)) {
            QFilter[] srcBillIdQf = new QFilter[]{new QFilter("id", "=", (Object)srcBillId)};
            this.showSearchBill("sfc_processreportbill", srcBillIdQf);
            this.showSearchBill("sfc_reportresource_adjust", srcBillIdQf);
            this.showSearchBill("pom_mftorderreport", srcBillIdQf);
            this.showSearchBill("om_processreport", srcBillIdQf);
        } else {
            SrcBillShowerUtils.showSearchUpBill((IFormView)this.getView(), (String)source, Collections.singletonList(srcBillId));
        }
    }

    private void showSearchBill(String entity, QFilter[] srcBillIdQf) {
        DynamicObjectCollection srcBillIds = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])srcBillIdQf);
        if (!srcBillIds.isEmpty()) {
            SrcBillShowerUtils.showSearchUpBill((IFormView)this.getView(), (String)entity, (List)DynamicObjectHelper.getFieldList((DynamicObjectCollection)srcBillIds, (String)"id"));
        }
    }

    private List<Long> getCostCenterByUser() {
        List accountOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        ArrayList<Long> ids = new ArrayList<Long>(accountOrgs.size());
        for (ComboItem ComboItem2 : accountOrgs) {
            ids.add(Long.valueOf(ComboItem2.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!accountOrgs.isEmpty()) {
            filters.add(new QFilter("accountorg", "in", ids));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }
}

