/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanOrgAndCostAccountListPlugin;

public class PlanResourceBillListPlugin
extends PlanOrgAndCostAccountListPlugin {
    private static final String IMPORT_RESULT = "importResult";
    protected static final String MANUORG = "manuorg";

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        Long manuorgId = null;
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            manuorgId = this.getSelectOrgId(MANUORG);
        }
        Long costcenter = this.getSelectOrgId("costcenter");
        e.getParameter().setCustomParam("org", (Object)(orgId == null ? "" : String.valueOf(orgId)));
        e.getParameter().setCustomParam("costaccount", (Object)this.getPageCache().get("costaccount"));
        e.getParameter().setCustomParam(MANUORG, (Object)(manuorgId == null ? "" : String.valueOf(manuorgId)));
        e.getParameter().setCustomParam("costcenter", (Object)(costcenter == null ? "" : String.valueOf(costcenter)));
        e.getParameter().setCustomParam("period", (Object)this.getPageCache().get("period"));
        e.getParameter().setCustomParam("planscheme", (Object)this.getPageCache().get("planscheme"));
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            QFilter manuOrgQFilter = this.getManuOrgQFilter();
            if (manuOrgQFilter != null) {
                e.getQFilters().add(manuOrgQFilter);
            }
            e.setOrderBy("bizdate desc,billno desc");
        }
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        List<Object> orgComboItemList = new ArrayList(16);
        if (("tblnew".equals(key) || "importdata".equals(key) || "sysimport".equals(key) || "sysimportcover".equals(key)) && CadEmptyUtils.isEmpty(orgComboItemList = this.getORGComboItemList())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a", (String)"PlanResourceBillListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "sysimport": {
                this.importSysDataToBill();
                break;
            }
            case "searchup": {
                this.searchUpBill();
                break;
            }
            case "colreport": {
                this.viewColReport();
                break;
            }
            case "searchconfig": {
                this.searchConfig();
                break;
            }
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"cad_planresource", (IFormView)this.getView());
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_colreport", (boolean)true, (int)1, (boolean)false);
        String acctOrgId = String.valueOf(this.getSelectOrgId(this.ORG_FIELD));
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)acctOrgId);
        listShowParameter.setCustomParam("colobj", (Object)CollectObjectEnum.PLAN_RESOURCE.getObj());
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u62a5\u544a", (String)"PlanResourceBillListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void searchUpBill() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() > 0) {
            Object[] primaryKeys = rows.getPrimaryKeyValues();
            Map<String, List<Object>> probillEntryIdMap = PlanResourceBillListPlugin.getProbillEntryIds(primaryKeys);
            if (CadEmptyUtils.isEmpty(probillEntryIdMap)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u6ca1\u6709\u6765\u6e90\u5355\u636e\u53f7\u3002", (String)"PlanResourceBillListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            block6: for (Map.Entry<String, List<Object>> probill : probillEntryIdMap.entrySet()) {
                String source;
                switch (source = probill.getKey()) {
                    case "0": {
                        continue block6;
                    }
                }
                SrcBillShowerUtils.showSearchUpBillOrList((IFormView)this.getView(), (String)source, probill.getValue(), null);
            }
        }
    }

    private static Map<String, List<Object>> getProbillEntryIds(Object[] objIds) {
        HashMap<String, List<Object>> probillEntryIdMap = new HashMap<String, List<Object>>(10);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"cad_planresource", (String)"id,srcbillid,srcbilltype", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return probillEntryIdMap;
        }
        for (DynamicObject row : rows) {
            Long srcBillId = row.getLong("srcbillid");
            String srcBillType = row.getString("srcbilltype");
            if (CadEmptyUtils.isEmpty((Long)srcBillId)) continue;
            probillEntryIdMap.computeIfAbsent(srcBillType, p -> new ArrayList(10)).add(row.getLong("srcbillid"));
        }
        return probillEntryIdMap;
    }

    private void importSysDataToBill() {
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        String costAccountId = this.getPageCache().get("costaccount");
        Long manuOrgId = this.getSelectOrgId(MANUORG);
        String costCenterId = this.getPageCache().get("costcenter");
        String planSchemeId = this.getPageCache().get("planscheme");
        ArrayList costCenters = new ArrayList(10);
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanResourceBillListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (CadEmptyUtils.isEmpty((String)costAccountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanResourceBillListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
        if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((Long)manuOrgId)) {
            List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            manuOrgs.addAll(userHasPermManuOrgs);
        } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((Long)manuOrgId)) {
            manuOrgs.add(manuOrgId);
        }
        String multiselectcostcenters = this.getPageCache().get("multiselectcostcenters");
        List costCenterMultiSelect = null;
        List costCenterSelect = null;
        if (!StringUtils.isEmpty((CharSequence)multiselectcostcenters)) {
            costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)multiselectcostcenters, List.class);
        }
        if (!StringUtils.isEmpty((CharSequence)costCenterId)) {
            costCenterSelect = (List)SerializationUtils.fromJsonString((String)costCenterId, List.class);
        }
        if (costCenterMultiSelect != null && costCenterMultiSelect.size() > 1) {
            costCenters.addAll(costCenterMultiSelect);
        } else if (!CadEmptyUtils.isEmpty(costCenterSelect)) {
            costCenters.addAll(costCenterSelect);
        } else {
            boolean isEnableMultiFactory;
            List<ComboItem> comboItems = this.getCostCenterComboItemListBy(orgId + "");
            if (!CadEmptyUtils.isEmpty(comboItems)) {
                comboItems.forEach(p -> costCenters.add(Long.parseLong(p.getValue())));
            }
            if ((isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId)) && CadEmptyUtils.isEmpty(comboItems)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb!", (String)"PlanResourceBillListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (CadEmptyUtils.isEmpty((String)planSchemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"PlanResourceBillListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String errorMsg = PlanFeeAllocHelper.checkPlanLastEnablePeriodClosed((Long)Long.parseLong(planSchemeId));
        if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return;
        }
        List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(orgId), (Set)Sets.newHashSet(costCenters), (String)"cad_planresource", (String)this.getView().getFormShowParameter().getAppId());
        Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)orgId, (List)enableCostCenters);
        if (CadEmptyUtils.isEmpty((Map)objRules)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"PlanResourceBillListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
            Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)orgId, (List)enableCostCenters, (Map)objRules);
            List collConfigs = ImportServiceHelper.getCollConfigs((Long)orgId, (Long)Long.parseLong(costAccountId), (Set)calDimensionIds, (String)"cad_planresource", (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u65b9\u6848\u3002", (String)"PlanResourceBillListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlanResourceBillListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            Map responseInfo = new HashMap(2);
            try {
                responseInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"PlanResourceService", (String)"importPlanResource", (Object[])new Object[]{orgId, Long.parseLong(costAccountId), Long.parseLong(planSchemeId), enableCostCenters, manuOrgs, this.getView().getFormShowParameter().getAppId(), progressId});
            }
            catch (NumberFormatException e) {
                MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"PlanResourceBillListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
            this.getPageCache().put("responseInfo", responseInfoStr);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), IMPORT_RESULT));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        this.getView().hideLoading();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                if ("confirm".equals(responseInfo.get("type"))) {
                    billList.refresh();
                    this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (callBackId) {
                case "showReport": {
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                    this.showColReport((String)responseInfo.get("colReportId"));
                    break;
                }
            }
        }
    }

    private void showColReport(String colReportId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_colreport");
        billShowParameter.setCustomParam("id", (Object)colReportId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u62a5\u544a", (String)"PlanResourceBillListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        HashSet hiddenKeys = new HashSet(3);
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costcenter.number": {
                    column.setFixed(true);
                    break;
                }
                case "costcenter.name": {
                    column.setFixed(true);
                    break;
                }
                case "manuorg.number": {
                    column.setFixed(true);
                    break;
                }
                case "manuorg.name": {
                    column.setFixed(true);
                    break;
                }
                case "billno": {
                    column.setFixed(true);
                    break;
                }
                case "resource.name": {
                    column.setFixed(true);
                }
            }
        }
        if (!CadEmptyUtils.isEmpty(hiddenKeys)) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, hiddenKeys);
        }
    }
}

