/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanResourceRateEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private Log logger = LogFactory.getLog(PlanResourceRateEdit.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initFilter();
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private void initFilter() {
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("costcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter orgQf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            qFilters.add(orgQf);
        });
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(enabledCostAccountIdsFilter);
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            Long org = this.getModel().getDataEntity().getLong("org.id");
            if (CadEmptyUtils.isEmpty((Long)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanResourceRateEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
        BasedataEdit expenseItem = (BasedataEdit)this.getControl("expenseitem");
        expenseItem.addBeforeF7SelectListener(evt -> {
            List<QFilter> qFilters = this.getInputQFilters(evt);
            qFilters.add(new QFilter("isleaf", "=", (Object)true));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    public void afterBindData(EventObject e) {
        Long id = (Long)this.getModel().getValue("id");
        this.setManuOrg();
        this.logger.info("MfgfeeBillEditPlugin afterBindData id=>{}", (Object)id);
        boolean flag = false;
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            this.initByListData();
        }
        this.getModel().setDataChanged(false);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"costaccount"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno"});
        }
    }

    private void setBillEnable() {
        Object operate = this.getView().getFormShowParameter().getCustomParam("operate");
        if (StringUtils.isNotBlank((Object)operate) && (StringUtils.equals((CharSequence)"new", (CharSequence)operate.toString()) || StringUtils.equals((CharSequence)"copy", (CharSequence)operate.toString()))) {
            this.setEnable(true);
            return;
        }
    }

    private void setEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costaccount"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"manuorg"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"period"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"costcenter"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"expenseitem"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"currency"});
    }

    private void initByListData() {
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String orgId = (String)fsp.getCustomParam("accountorgId");
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            model.setValue("org", (Object)orgId);
        } else {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            orgId = String.valueOf(org.getLong("id"));
        }
        String costCenterId = (String)fsp.getCustomParam("costCenterId");
        if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
            model.setValue("costcenter", (Object)costCenterId);
        }
        String costAccountId = (String)fsp.getCustomParam("costaccountId");
        this.logger.info("initByListData costAccountId ==>{}", (Object)costAccountId);
        if (!CadEmptyUtils.isEmpty((String)costAccountId)) {
            model.setValue("costaccount", (Object)costAccountId);
        }
        model.setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId));
        String manuOrg = (String)fsp.getCustomParam("manuorg");
        if (!CadEmptyUtils.isEmpty((String)manuOrg) && enableMultiFactory) {
            model.setValue("manuorg", (Object)manuOrg);
        } else {
            model.setValue("manuorg", null);
        }
        this.getView().setVisible(Boolean.valueOf(enableMultiFactory), new String[]{"manuorg"});
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "org": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org == null) break;
                this.setCostAccount(org.getLong("id"));
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.setManuOrg();
            }
        }
    }

    public void setManuOrg() {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        this.getView().setEnable(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private void setCostAccount(long orgId) {
        DynamicObjectCollection costaccounts = this.getCostaccount(orgId);
        if (costaccounts == null || costaccounts.size() == 0 || costaccounts.size() > 1) {
            return;
        }
        DynamicObject costaccount = (DynamicObject)costaccounts.get(0);
        this.getModel().setValue("costaccount", (Object)costaccount.getLong("id"));
    }

    private DynamicObjectCollection getCostaccount(Long orgId) {
        QFilter accountOrgQF = new QFilter("calorg", "=", (Object)orgId);
        QFilter enableStdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        String orderby = "enablestandardcost DESC, number ASC";
        return QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name", (QFilter[])new QFilter[]{accountOrgQF, enableStdtQF}, (String)orderby);
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        switch (operateKey) {
            case "searchup": {
                break;
            }
            case "new": {
                fsp.setCustomParam("operate", (Object)"new");
                this.setBillEnable();
                break;
            }
            case "copy": {
                fsp.setCustomParam("operate", (Object)"copy");
                this.setBillEnable();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("afterconfirm", "true");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("sourcetype", "IMP");
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    public void beforeBindData(EventObject e) {
    }
}

