/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.resourcerate.PlanResourceRatePublishService;
import kd.macc.cad.business.feealloc.MfgFeeNonProdAllocService;
import kd.macc.cad.business.feealloc.PlanResourceRateCalcService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanOrgAndCostAccountListPlugin;
import kd.macc.cad.formplugin.price.PriceCommon;

public class PlanResourceRateList
extends PlanOrgAndCostAccountListPlugin {
    private Log logger = LogFactory.getLog(PlanResourceRateList.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    protected static final String COSTACCOUNT = "costaccount";
    private static final String closeBack_importResult = "importResult";
    private static final String closeBack_doImport = "doImport";
    private static final String CONFIRMBACK_DOUNCONFIRM = "CONFIRMBACK_DOUNCONFIRM";
    private static final String SELECT_PUBLISH_COSTTYPE = "select_publish_costType";
    private static final String CLOSEBACK_DOPUBLISH = "closeBack_doPublish";
    private static final String KEY_REFRESH = "refresh";

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        Long manuorgId = null;
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            manuorgId = this.getSelectOrgId("manuorg");
        }
        e.getParameter().setCustomParam("accountorgId", (Object)(orgId == null ? "" : String.valueOf(orgId)));
        Long costcenter = this.getSelectOrgId("costcenter");
        e.getParameter().setCustomParam("costaccountId", (Object)this.getPageCache().get(COSTACCOUNT));
        e.getParameter().setCustomParam("costCenterId", (Object)(costcenter == null ? "" : String.valueOf(costcenter)));
        e.getParameter().setCustomParam("manuorg", (Object)(manuorgId == null ? "" : String.valueOf(manuorgId)));
        e.getParameter().setCustomParam("periodId", (Object)this.getPageCache().get("period"));
    }

    private List<Long> getPeriodSelIds() {
        Long periodSelId;
        ArrayList<Long> periodSelIds = new ArrayList<Long>(10);
        if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("periodmul"))) {
            List list = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("periodmul"), List.class);
            if (!CadEmptyUtils.isEmpty((List)list)) {
                for (String period : list) {
                    if (CadEmptyUtils.isEmpty((String)period)) continue;
                    periodSelIds.add(Long.valueOf(period));
                }
            }
        } else if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("period")) && !CadEmptyUtils.isEmpty((Long)(periodSelId = Long.valueOf(this.getPageCache().get("period"))))) {
            periodSelIds.add(periodSelId);
        }
        return periodSelIds;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        Long periodSelId = 0L;
        List periodIds = null;
        MfgFeeAllocImportParam importDto = null;
        switch (operateKey) {
            case "sysimport": {
                e.setCancel(true);
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                periodIds = PlanFeeAllocHelper.getPlanLastEnablePeriods((Long)importDto.getPlanscheme());
                String errorMsg = PlanFeeAllocHelper.checkPlanLastEnablePeriodClosed((Long)importDto.getPlanscheme());
                if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
                    this.getView().showTipNotification(errorMsg);
                    return;
                }
                if (periodIds.isEmpty()) break;
                List<Long> periodSelIds = this.getPeriodSelIds();
                if (CadEmptyUtils.isEmpty(periodSelIds)) {
                    for (Long periodId : periodIds) {
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                } else {
                    for (Long periodId : periodSelIds) {
                        if (!periodIds.contains(periodId)) continue;
                        importDto.getCalcPeriodMap().put(periodId, this.getPeriodName(periodId));
                    }
                    if (importDto.getCalcPeriodMap().isEmpty()) {
                        return;
                    }
                }
                this.doImport(importDto, false);
                break;
            }
            case "allocreport": {
                String org = this.getPageCache().get(this.ORG_FIELD);
                if (CadEmptyUtils.isEmpty((String)org)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanResourceRateList_16", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String orgId = (String)list.get(0);
                String accountId = this.getPageCache().get(COSTACCOUNT);
                if (CadEmptyUtils.isEmpty((String)accountId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanResourceRateList_21", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                String planscheme = this.getPageCache().get("planscheme");
                if (CadEmptyUtils.isEmpty((String)planscheme)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanResourceRateList_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openAllocReportPage("9", orgId, accountId, planscheme);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "publish": {
                Long manuOrgId;
                Long orgId = this.getSelectOrgId("org");
                if (CadEmptyUtils.isEmpty((Long)orgId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanResourceRateList_16", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (OrgHelper.isOrgEnableMultiFactory((Long)orgId) && CadEmptyUtils.isEmpty((Long)(manuOrgId = this.getSelectOrgId("manuorg")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u751f\u4ea7\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u591a\u751f\u4ea7\u7ec4\u7ec7\u6570\u636e\u540c\u65f6\u53d1\u5e03\u3002", (String)"PlanResourceRateList_31", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                String costAccountId = this.getPageCache().get(COSTACCOUNT);
                if (CadEmptyUtils.isEmpty((String)costAccountId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanResourceRateList_21", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long planSchemeId = Long.valueOf(this.getPageCache().get("planscheme"));
                if (CadEmptyUtils.isEmpty((Long)planSchemeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanResourceRateList_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                String errorMsg = PlanFeeAllocHelper.checkPlanLastEnablePeriodClosed((Long)planSchemeId);
                if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
                    this.getView().showTipNotification(errorMsg);
                    return;
                }
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_resourcerate", "47156aff000000ac")) {
                    return;
                }
                boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
                if (enableMultiFactory) {
                    orgId = this.getSelectOrgId("manuorg");
                }
                Long calCostTypeId = CostTypeHelper.getCostTypeByOrgAndCostAccount((Long)orgId, (Long)Long.parseLong(costAccountId), (boolean)enableMultiFactory);
                List simCostTypeIds = CostTypeHelper.getMnCostByHs((Long)calCostTypeId);
                this.showForm(simCostTypeIds);
                break;
            }
        }
    }

    public void showForm(List<Long> costtypeIds) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_synccosttype");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("plan_rate_publish", (Object)"1");
        fsp.setCustomParam("publish_costtype", costtypeIds);
        fsp.setCaption(ResManager.loadKDString((String)"\u53d1\u5e03\u5230\u76ee\u6807\u6210\u672c\u7c7b\u578b", (String)"PlanResourceRateList_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam("entityname", (Object)"cad_resourcerate");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_PUBLISH_COSTTYPE));
        this.getView().showForm(fsp);
    }

    protected void openAllocReportPage(String taskname, String orgId, String accountId, String planscheme) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cad_allocreport");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.getCustomParams().put("taskname", taskname);
        showParameter.getCustomParams().put("orgId", orgId);
        showParameter.getCustomParams().put("accountId", accountId);
        showParameter.getCustomParams().put("isplandata", true);
        showParameter.getCustomParams().put("planscheme", planscheme);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u5212\u8d39\u7387\u8ba1\u7b97\u62a5\u544a", (String)"PlanResourceRateList_17", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
            break;
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.getView().hideLoading();
        String actionId = e.getActionId();
        MfgFeeAllocImportParam importDto = null;
        List selectData = null;
        switch (actionId) {
            case "doImport": {
                selectData = (List)e.getReturnData();
                if (selectData == null || selectData.isEmpty()) {
                    return;
                }
                importDto = this.getPageImportDto();
                if (importDto == null) break;
                importDto.getCalcPeriodMap().putAll(this.getSelectCurrentPeriods(selectData));
                this.doImport(importDto, false);
                break;
            }
            case "importResult": {
                String importResponseInfoStr = this.getPageCache().get("importresponseInfo");
                if (CadEmptyUtils.isEmpty((String)importResponseInfoStr)) {
                    return;
                }
                String typeName = ResManager.loadKDString((String)"\u8ba1\u7b97", (String)"PlanResourceRateList_23", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)typeName, (String)importResponseInfoStr, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                this.getView().showMessage(importResponseInfoStr);
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "select_publish_costType": {
                this.doPublish(e);
                break;
            }
            case "closeBack_doPublish": {
                this.getView().hideLoading();
                String responseInfo = this.getPageCache().get("responseInfo");
                this.logger.info("\u8ba1\u5212\u8d39\u7387\u53d1\u5e03\uff0c\u53d1\u5e03\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)responseInfo);
                if (CadEmptyUtils.isEmpty((String)responseInfo)) {
                    return;
                }
                Map result = (Map)SerializationUtils.fromJsonString((String)responseInfo, Map.class);
                boolean status = (Boolean)result.get("status");
                if (!status) {
                    Object errorMsg = result.get("errMsg");
                    this.getView().showTipNotification(String.valueOf(errorMsg));
                } else {
                    Object tipMsg = result.get("tip");
                    int count = result.get("count") == null ? 0 : (Integer)result.get("count");
                    String tips = String.format(ResManager.loadKDString((String)"\u6210\u529f\u53d1\u5e03%s\u6761\u8ba1\u5212\u8d39\u7387\u3002", (String)"PlanResourceRateList_26", (String)"macc-cad-formplugin", (Object[])new Object[0]), count);
                    if (tipMsg == null || CadEmptyUtils.isEmpty((String)String.valueOf(tipMsg))) {
                        this.getView().showSuccessNotification(tips);
                    } else {
                        this.getView().showTipNotification(tips + tipMsg);
                    }
                }
                this.getView().invokeOperation(KEY_REFRESH);
                break;
            }
        }
    }

    private void doPublish(ClosedCallBackEvent event) {
        Object data = event.getReturnData();
        if (data == null) {
            return;
        }
        Map returnData = (Map)data;
        String publishCostType = (String)returnData.get("publishcosttype");
        List<Object> orgIds = this.getOrgCache();
        Long curOrgId = Long.valueOf(orgIds.get(0).toString());
        Long costAccountId = Long.valueOf(this.getPageCache().get(COSTACCOUNT));
        Long planSchemeId = Long.valueOf(this.getPageCache().get("planscheme"));
        String tip = this.validate(Long.parseLong(publishCostType), planSchemeId);
        if (!CadEmptyUtils.isEmpty((String)tip)) {
            this.getView().showTipNotification(tip);
            return;
        }
        DynamicObject publishCostTypeDyn = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(publishCostType))});
        DLock lock = DLock.create((String)("Publish_cad_planresource_" + publishCostType), (String)ResManager.loadKDString((String)"\u8ba1\u5212\u8d39\u7387\u53d1\u5e03\u9501", (String)"PlanResourceRateList_27", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        boolean isLocked = lock.tryLock();
        if (!isLocked) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8d39\u7387\u6b63\u5728\u5411\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u4ef7\u76ee\u8868\u7684\u6210\u672c\u7c7b\u578b\u3010%s\u3011\u53d1\u5e03\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"PlanResourceRateList_28", (String)"macc-cad-formplugin", (Object[])new Object[0]), publishCostTypeDyn.getString("name")));
            return;
        }
        String progressId = UUID.randomUUID().toString();
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u53d1\u5e03", (String)"PlanResourceRateList_29", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            Map result = new HashMap(16);
            try {
                result = PlanResourceRatePublishService.publish((Long)curOrgId, (Long)costAccountId, (Long)planSchemeId, (long)Long.parseLong(publishCostType), (String)progressId);
            }
            catch (Exception e) {
                this.logger.error("\u8ba1\u5212\u8d39\u7387\u53d1\u5e03\u62a5\u9519\uff1a", (Throwable)e);
            }
            finally {
                if (lock != null) {
                    lock.close();
                }
            }
            this.logger.info("\u53d1\u5e03\uff0ccount\uff1a{}", result.get("count"));
            this.getPageCache().put("responseInfo", SerializationUtils.toJsonString(result));
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), CLOSEBACK_DOPUBLISH));
    }

    private String validate(long costType, Long planSchemeId) {
        String tip = "";
        QFilter planSchemeFilter = new QFilter("id", "=", (Object)planSchemeId);
        planSchemeFilter.and(new QFilter("entryentity.enabled", "=", (Object)"1"));
        planSchemeFilter.and(new QFilter("entryentity.close", "=", (Object)"0"));
        DynamicObject planScheme = QueryServiceHelper.queryOne((String)"cad_planscheme", (String)"id,number,name,entryentity.startperiod.name startperiodname,entryentity.startperiod.begindate begindate,entryentity.endperiod.name endperiodname,entryentity.endperiod.enddate enddate ", (QFilter[])new QFilter[]{planSchemeFilter});
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("costtype", "=", (Object)costType);
        qFilter.and(new QFilter("pricerule", "=", (Object)1938502639356500992L));
        qFilters.add(qFilter);
        QFilter timeFilter = new QFilter("effectdate", "<", (Object)planScheme.getDate("begindate"));
        timeFilter.and(new QFilter("expdate", ">", (Object)planScheme.getDate("begindate")));
        timeFilter.and(new QFilter("expdate", "<", (Object)DateUtils.getDeFaultExpDate()));
        qFilters.add(timeFilter);
        boolean exist = QueryServiceHelper.exists((String)"cad_resourcerate", (QFilter[])qFilters.toArray(new QFilter[0]));
        QFilter timeFilter2 = new QFilter("effectdate", ">=", (Object)planScheme.getDate("begindate"));
        timeFilter2.and(new QFilter("effectdate", "<", (Object)planScheme.getDate("enddate")));
        qFilters.remove(timeFilter);
        qFilters.add(timeFilter2);
        boolean exist2 = QueryServiceHelper.exists((String)"cad_resourcerate", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (exist || exist2) {
            tip = String.format(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u4ef7\u76ee\u8868\u5b58\u5728\u8ba1\u5212\u65b9\u6848\u201c%1$s/%2$s\u201d\uff0c\u201c%3$s-%4$s\u201d\u5df2\u53d1\u5e03\u7684\u6570\u636e\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u53d1\u5e03\u3002", (String)"PlanResourceRateList_30", (String)"macc-cad-formplugin", (Object[])new Object[0]), planScheme.getString("number"), planScheme.getString("number"), planScheme.getString("startperiodname"), planScheme.getString("endperiodname"));
        }
        return tip;
    }

    protected MfgFeeAllocImportParam getPageImportDto() {
        MfgFeeAllocImportParam importDto = new MfgFeeAllocImportParam();
        importDto.setEntityType("cad_planbasicalloc");
        importDto.setAppnum(this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((String)this.getPageCache().get(COSTACCOUNT))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f", (String)"PlanResourceRateList_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        List<Object> orgIds = this.getOrgCache();
        Long curOrgid = Long.valueOf(orgIds.get(0).toString());
        Long costaccount = Long.valueOf(this.getPageCache().get(COSTACCOUNT));
        List<Long> manuorgs = this.getSelectManuOrg(curOrgid);
        List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIds);
        boolean isExistCostaccount = false;
        for (ComboItem item : comboItems) {
            if (!item.getValue().equals(this.getPageCache().get(COSTACCOUNT))) continue;
            isExistCostaccount = true;
            break;
        }
        if (!isExistCostaccount && CadEmptyUtils.isEmpty((String)this.getPageCache().get(COSTACCOUNT))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f", (String)"PlanResourceRateList_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        importDto.setOrg(curOrgid);
        importDto.setCostaccount(costaccount);
        importDto.setManuorg(manuorgs);
        if (CadEmptyUtils.isEmpty((String)this.getPageCache().get("planscheme"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u65b9\u6848", (String)"PlanResourceRateList_20", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return null;
        }
        importDto.setPlanscheme(Long.valueOf(this.getPageCache().get("planscheme")));
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)curOrgid);
        importDto.setEnableFactory(enableMulFactory);
        if (enableMulFactory) {
            List<Long> manuList = manuorgs.isEmpty() ? ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)curOrgid, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId()) : new ArrayList<Long>(manuorgs);
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)curOrgid, manuList, (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((Set)centerIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb!", (String)"PlanResourceRateList_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return null;
            }
            centerIds.add(0L);
            importDto.setCostCenterIds(centerIds);
        }
        return importDto;
    }

    protected Map<Long, String> getSelectCurrentPeriods(List<DynamicObject> returnDatas) {
        LinkedHashMap<Long, String> hashMap = new LinkedHashMap<Long, String>();
        List<DynamicObject> allocSelectData = returnDatas;
        for (DynamicObject data : allocSelectData) {
            DynamicObject currentperiod = data.getDynamicObject("currentperiod");
            if (currentperiod == null) continue;
            hashMap.put(currentperiod.getLong("id"), currentperiod.getString("name"));
        }
        return hashMap;
    }

    private List<Long> getSelectManuOrg(Long orgId) {
        ArrayList<Long> manuorg = null;
        String manuorgStr = this.getPageCache().get("manuorg");
        if (StringUtils.isNotEmpty((CharSequence)manuorgStr)) {
            manuorg = JSON.parseArray((String)manuorgStr, Long.class);
        }
        if (manuorg == null || manuorg.size() == 0 || manuorg.get(0) == null) {
            manuorg = new ArrayList<Long>(16);
            for (ComboItem item : ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())) {
                manuorg.add(Long.valueOf(item.getValue()));
            }
        }
        return manuorg;
    }

    protected String getPeriodName(Long periodId) {
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        if (periodDyn != null) {
            return periodDyn.getString("name");
        }
        return "";
    }

    private void doImport(MfgFeeAllocImportParam importDto, boolean isCheckData) {
        if (!isCheckData) {
            MfgFeeNonProdAllocService service = new MfgFeeNonProdAllocService();
            ArrayList<Long> errorNonPeriods = new ArrayList<Long>(10);
            ArrayList<Long> errorAuxPeriods = new ArrayList<Long>(10);
            ArrayList<Long> errorBacicPeriods = new ArrayList<Long>(10);
            for (Long periodId : importDto.getCalcPeriodMap().keySet()) {
                importDto.setPeriod(periodId);
                if (service.isBillHasData(importDto, "cad_plannonprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue(), ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()})) {
                    errorNonPeriods.add(periodId);
                }
                if (service.isBillHasData(importDto, "cad_auxprodalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue(), ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()})) {
                    errorAuxPeriods.add(periodId);
                }
                if (!service.isBillHasData(importDto, "cad_basicalloc", new String[]{ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue(), ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue()})) continue;
                errorBacicPeriods.add(periodId);
            }
            StringBuilder msgStr = new StringBuilder();
            if (!errorNonPeriods.isEmpty()) {
                msgStr.append(this.getConfirmTipStr(errorBacicPeriods, importDto, ResManager.loadKDString((String)"%s\u8ba1\u5212\u975e\u751f\u4ea7\u5206\u914d\u5b58\u5728\u672a\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanResourceRateList_12", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            }
            if (!errorAuxPeriods.isEmpty()) {
                msgStr.append(this.getConfirmTipStr(errorBacicPeriods, importDto, ResManager.loadKDString((String)"%s\u8ba1\u5212\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5b58\u5728\u672a\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanResourceRateList_13", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            }
            if (!errorBacicPeriods.isEmpty()) {
                msgStr.append(this.getConfirmTipStr(errorBacicPeriods, importDto, ResManager.loadKDString((String)"%s\u8ba1\u5212\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5b58\u5728\u672a\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"PlanResourceRateList_14", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            }
            if (msgStr.length() > 0) {
                this.getPageCache().put("importDto", JSON.toJSONString((Object)importDto));
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMBACK_DOUNCONFIRM, (IFormPlugin)this);
                String confirmTip = String.format(ResManager.loadKDString((String)"%s\u662f\u5426\u786e\u8ba4\u8fdb\u884c\u8ba1\u7b97\uff1f", (String)"PlanResourceRateList_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgStr.toString());
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
        }
        this.importPlanResourceRateData(importDto);
    }

    private String getConfirmTipStr(List<Long> periodIds, MfgFeeAllocImportParam importDto, String tipMsg) {
        StringBuilder msg = new StringBuilder();
        for (Long periodId : periodIds) {
            if (msg.length() > 0) {
                msg.append(",");
            }
            msg.append((String)importDto.getCalcPeriodMap().get(periodId));
        }
        return String.format(tipMsg, msg.toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && StringUtils.equals((CharSequence)CONFIRMBACK_DOUNCONFIRM, (CharSequence)e.getCallBackId())) {
            try {
                String json = this.getPageCache().get("importDto");
                MfgFeeAllocImportParam importDto = (MfgFeeAllocImportParam)JSON.parseObject((String)json, MfgFeeAllocImportParam.class);
                this.doImport(importDto, true);
            }
            catch (Exception ex) {
                this.logger.error("\u5bfc\u5165\u6570\u636e\u51fa\u73b0\u9519\u8bef", (Throwable)ex);
            }
        }
    }

    private void importPlanResourceRateData(MfgFeeAllocImportParam importDto) {
        String progressId = UUID.randomUUID().toString();
        Long planschemeId = Long.valueOf(this.getPageCache().get("planscheme"));
        String lockErrStr = SimpleMutexHelper.planmfgCheckAndRequireXMutex((String)"planrateimport", (Long)planschemeId);
        if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
            this.getView().showErrorNotification(lockErrStr);
            return;
        }
        ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlanResourceRateList_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
            String msg = null;
            try {
                msg = new PlanResourceRateCalcService().resourceRateCalc(importDto, progressId);
            }
            catch (Exception e) {
                ProgressHelper.showError((String)progressId, (String)e.getMessage());
            }
            finally {
                SimpleMutexHelper.releaseXMutex((String)"planrateimport", (Object)(planschemeId + "planrateimport"));
                ProgressHelper.clearProgressParam((String)progressId);
            }
            this.getPageCache().put("importresponseInfo", msg);
        }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
    }
}

