/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanSchemeEdit
extends AbstractBillPlugIn {
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(enabledCostAccountIdsFilter);
        });
        BasedataEdit mulCalcRule = (BasedataEdit)this.getControl("mulcalcrule");
        mulCalcRule.addBeforeF7SelectListener(evt -> {
            List<QFilter> qFilters = this.getInputQFilters(evt);
            qFilters.add(new QFilter("bindbill", "=", (Object)"B"));
            qFilters.add(new QFilter("sourcebilll", "=", (Object)"cad_resourcplanrate"));
        });
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener(evt -> {
            Long costaccount = this.getModel().getDataEntity().getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)costaccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanSchemeEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<QFilter> qFilters = this.getInputQFilters(evt);
            DynamicObject periodType = PeriodHelper.getCurrentPeriodType((Long)costaccount);
            qFilters.add(new QFilter("periodtype.id", "=", (Object)periodType.getLong("id")));
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
            QFilter startPeriodFilter = StartCostHelper.getPlanPeriodFilter((Long)costaccount);
            qFilters.add(startPeriodFilter);
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(evt -> {
            Long costaccount = this.getModel().getDataEntity().getLong("costaccount.id");
            if (CadEmptyUtils.isEmpty((Long)costaccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanSchemeEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<QFilter> qFilters = this.getInputQFilters(evt);
            DynamicObject periodType = PeriodHelper.getCurrentPeriodType((Long)costaccount);
            qFilters.add(new QFilter("periodtype.id", "=", (Object)periodType.getLong("id")));
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
            QFilter startPeriodFilter = StartCostHelper.getPlanPeriodFilter((Long)costaccount);
            qFilters.add(startPeriodFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setVisible();
    }

    private void setVisible() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"enable_custom", "disable_custom", "close_custom", "open_custom"});
    }

    public void afterBindData(EventObject e) {
        this.initByListData(e);
        this.setEnable();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "enable_custom": 
            case "disable_custom": {
                this.setEnable();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("disable_custom".equals(evt.getItemKey())) {
            if (this.checkSelectEntryEmpty()) {
                evt.setCancel(true);
                return;
            }
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryEntityGrid.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
                int currentRowIndex = selectRows[0];
                DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
                String currentEnable = current.getString("enabled");
                if (currentEnable.equals("0")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u672a\u542f\u7528\u3002", (String)"PlanSchemeEdit_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Long org = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
                Long costAccount = ((DynamicObject)this.getModel().getValue("costaccount")).getLong("id");
                Long planScheme = (Long)this.getModel().getValue("id");
                QFilter qFilter = new QFilter("org", "=", (Object)org);
                qFilter.and(new QFilter("costaccount", "=", (Object)costAccount));
                DynamicObject startPeriod = current.getDynamicObject("startperiod");
                DynamicObject endPeriod = current.getDynamicObject("endperiod");
                List periodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
                qFilter.and(new QFilter("period", "in", (Object)periodIds));
                qFilter.and(new QFilter("planscheme", "=", (Object)planScheme));
                boolean existPlanFee = QueryServiceHelper.exists((String)"cad_planfeebill", (QFilter[])qFilter.toArray());
                boolean existPlanResource = QueryServiceHelper.exists((String)"cad_planresource", (QFilter[])qFilter.toArray());
                boolean existPlanWork = QueryServiceHelper.exists((String)"cad_planwork", (QFilter[])qFilter.toArray());
                boolean existPlanCostDriver = QueryServiceHelper.exists((String)"cad_plancostdriver", (QFilter[])qFilter.toArray());
                if (existPlanFee || existPlanResource || existPlanWork || existPlanCostDriver) {
                    String tipMsg = ResManager.loadKDString((String)"\u662f\u5426\u53cd\u542f\u7528\uff1f\u671f\u95f4\u5185\u5b58\u5728\u8ba1\u5212\u5355\u636e", (String)"PlanSchemeEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(tipMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disable_confirm", (IFormPlugin)this));
                    evt.setCancel(true);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("disable_confirm".equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getView().invokeOperation("disable_custom");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        switch (operateKey) {
            case "new": {
                fsp.setCustomParam("operate", (Object)"new");
                break;
            }
            case "save": {
                break;
            }
            case "enable_custom": {
                this.enable(e);
                break;
            }
            case "disable_custom": {
                this.disable(e);
                break;
            }
            case "close_custom": {
                this.close(e);
                break;
            }
            case "open_custom": {
                this.open(e);
                break;
            }
            case "deleteentry": {
                this.deleteEntry(e);
            }
        }
    }

    private void deleteEntry(BeforeDoOperationEventArgs e) {
        EntryGrid entryEntityGrid;
        int[] selectRows;
        int rowIndex;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (this.checkEnable((List<DynamicObject>)entryEntity, rowIndex = (selectRows = (entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY)).getSelectRows())[0])) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u671f\u95f4\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"PlanSchemeEdit_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void enable(BeforeDoOperationEventArgs e) {
        if (this.checkSelectEntryEmpty()) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
            int currentRowIndex = selectRows[0];
            DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
            String currentEnable = current.getString("enabled");
            String currentClose = current.getString("close");
            if (currentEnable.equals("1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u5df2\u542f\u7528\u3002", (String)"PlanSchemeEdit_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (currentClose.equals("1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u5df2\u9501\u5b9a\u3002", (String)"PlanSchemeEdit_21", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String existEnableOpen = "0";
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i == currentRowIndex) continue;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String enable = dynamicObject.getString("enabled");
                String close = dynamicObject.getString("close");
                if (!enable.equals("1") || !close.equals("0") || !currentClose.equals("0")) continue;
                existEnableOpen = "1";
                break;
            }
            if (existEnableOpen.equals("1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u4ec5\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u5df2\u542f\u7528\u672a\u9501\u5b9a\u7684\u671f\u95f4\u8303\u56f4\u3002", (String)"PlanSchemeEdit_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("enabled", (Object)Character.valueOf('1'), currentRowIndex);
            Long id = (Long)this.getModel().getValue("id");
            if (id > 0L) {
                this.showNotificationAfterSave(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"PlanSchemeEdit_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"PlanSchemeEdit_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void disable(BeforeDoOperationEventArgs e) {
        if (this.checkSelectEntryEmpty()) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
            int currentRowIndex = selectRows[0];
            DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
            String currentEnable = current.getString("enabled");
            String currentClose = current.getString("close");
            if (currentEnable.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u672a\u542f\u7528\u3002", (String)"PlanSchemeEdit_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (currentClose.equals("1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u542f\u7528\u5931\u8d25\u3002\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u5df2\u9501\u5b9a\u3002", (String)"PlanSchemeEdit_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("enabled", (Object)"0", currentRowIndex);
            Long id = (Long)this.getModel().getValue("id");
            if (id > 0L) {
                this.showNotificationAfterSave(ResManager.loadKDString((String)"\u53cd\u542f\u7528\u6210\u529f\u3002", (String)"PlanSchemeEdit_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u542f\u7528\u6210\u529f\u3002", (String)"PlanSchemeEdit_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void close(BeforeDoOperationEventArgs e) {
        if (this.checkSelectEntryEmpty()) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
            int currentRowIndex = selectRows[0];
            DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
            String currentEnable = current.getString("enabled");
            String currentClose = current.getString("close");
            if (currentClose.equals("1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u5df2\u9501\u5b9a\u3002", (String)"PlanSchemeEdit_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (currentEnable.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9501\u5b9a\u5931\u8d25\u3002\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u542f\u7528\u624d\u80fd\u9501\u5b9a\u3002", (String)"PlanSchemeEdit_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("close", (Object)"1", currentRowIndex);
            Long id = (Long)this.getModel().getValue("id");
            if (id > 0L) {
                this.showNotificationAfterSave(ResManager.loadKDString((String)"\u9501\u5b9a\u6210\u529f\u3002", (String)"PlanSchemeEdit_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9501\u5b9a\u6210\u529f\u3002", (String)"PlanSchemeEdit_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private void open(BeforeDoOperationEventArgs e) {
        if (this.checkSelectEntryEmpty()) {
            e.setCancel(true);
            return;
        }
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity) && selectRows.length > 0) {
            int currentRowIndex = selectRows[0];
            DynamicObject current = (DynamicObject)entryEntity.get(currentRowIndex);
            String currentClose = current.getString("close");
            if (currentClose.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u671f\u95f4\u8303\u56f4\u672a\u9501\u5b9a\u3002", (String)"PlanSchemeEdit_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String existEnableOpen = "0";
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i == currentRowIndex) continue;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String enable = dynamicObject.getString("enabled");
                String close = dynamicObject.getString("close");
                if (!enable.equals("1") || !close.equals("0")) continue;
                existEnableOpen = "1";
                break;
            }
            if (existEnableOpen.equals("1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u9501\u5b9a\u5931\u8d25\u3002\u4ec5\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u5df2\u542f\u7528\u672a\u9501\u5b9a\u7684\u671f\u95f4\u8303\u56f4\u3002", (String)"PlanSchemeEdit_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            this.getModel().setValue("close", (Object)"0", currentRowIndex);
            Long id = (Long)this.getModel().getValue("id");
            if (id > 0L) {
                this.showNotificationAfterSave(ResManager.loadKDString((String)"\u53d6\u6d88\u9501\u5b9a\u6210\u529f\u3002", (String)"PlanSchemeEdit_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u9501\u5b9a\u6210\u529f\u3002", (String)"PlanSchemeEdit_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private boolean checkSelectEntryEmpty() {
        int selectRow;
        EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntityGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanSchemeEdit_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow = selectRows[0]);
        if (dynamicObject.getDynamicObject("startperiod") == null) {
            String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u5f00\u59cb\u671f\u95f4\u201d\u3002", (String)"PlanSchemeEdit_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), selectRow + 1);
            this.getView().showTipNotification(tip);
            return true;
        }
        if (dynamicObject.getDynamicObject("endperiod") == null) {
            String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u7ed3\u675f\u671f\u95f4\u201d\u3002", (String)"PlanSchemeEdit_16", (String)"macc-cad-formplugin", (Object[])new Object[0]), selectRow + 1);
            this.getView().showTipNotification(tip);
            return true;
        }
        if (CadEmptyUtils.isEmpty((String)dynamicObject.getString("excutemethod"))) {
            String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u6267\u884c\u65b9\u5f0f\u201d\u3002", (String)"PlanSchemeEdit_20", (String)"macc-cad-formplugin", (Object[])new Object[0]), selectRow + 1);
            this.getView().showTipNotification(tip);
            return true;
        }
        return false;
    }

    private void showNotificationAfterSave(String successNotification) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_planperiod", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(successNotification);
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private void setEnable() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org", "costaccount"});
        Long org = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        Long costAccount = ((DynamicObject)this.getModel().getValue("costaccount")).getLong("id");
        Long planScheme = (Long)this.getModel().getValue("id");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObject minStartPeriod = entryEntity.stream().filter(e -> e.getLong("id") > 0L).map(e -> e.getDynamicObject("startperiod")).min(Comparator.comparingLong(s -> s.getDate("begindate").getTime())).orElse(null);
        DynamicObject maxEndPeriod = entryEntity.stream().filter(e -> e.getDynamicObject("startperiod") != null).map(e -> e.getDynamicObject("endperiod")).max(Comparator.comparingLong(s -> s.getDate("enddate").getTime())).orElse(null);
        HashSet periodIdSet = new HashSet(10);
        if (minStartPeriod != null && maxEndPeriod != null) {
            QFilter qFilter = new QFilter("org", "=", (Object)org);
            qFilter.and(new QFilter("costaccount", "=", (Object)costAccount));
            List periodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)minStartPeriod, (DynamicObject)maxEndPeriod);
            qFilter.and(new QFilter("period", "in", (Object)periodIds));
            qFilter.and(new QFilter("planscheme", "=", (Object)planScheme));
            DynamicObjectCollection planFee = QueryServiceHelper.query((String)"cad_planfeebill", (String)"id,period", (QFilter[])qFilter.toArray());
            DynamicObjectCollection planResource = QueryServiceHelper.query((String)"cad_planresource", (String)"id,period", (QFilter[])qFilter.toArray());
            DynamicObjectCollection planWork = QueryServiceHelper.query((String)"cad_planwork", (String)"id,period", (QFilter[])qFilter.toArray());
            DynamicObjectCollection planCostDriver = QueryServiceHelper.query((String)"cad_plancostdriver", (String)"id,period", (QFilter[])qFilter.toArray());
            planFee.forEach(e -> periodIdSet.add(e.getLong("period")));
            planResource.forEach(e -> periodIdSet.add(e.getLong("period")));
            planWork.forEach(e -> periodIdSet.add(e.getLong("period")));
            planCostDriver.forEach(e -> periodIdSet.add(e.getLong("period")));
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject current = (DynamicObject)entryEntity.get(i);
            DynamicObject startPeriod = current.getDynamicObject("startperiod");
            DynamicObject endPeriod = current.getDynamicObject("endperiod");
            boolean existData = false;
            if (current.getLong("id") <= 0L) continue;
            List periodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
            for (Object periodId : periodIds) {
                if (!periodIdSet.contains(periodId)) continue;
                existData = true;
                break;
            }
            if (this.checkEnable((List<DynamicObject>)entryEntity, i) || existData) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"startperiod", "endperiod", "excutemethod"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"startperiod", "endperiod", "excutemethod"});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        Long id = dataEntity.getLong("id");
        switch (proName) {
            case "org": {
                if (org == null) break;
                this.setCostAccount(org.getLong("id"));
                break;
            }
            case "mulcalcrule": {
                DynamicObjectCollection newMulCalcRule = (DynamicObjectCollection)newValue;
                List ruleIds = newMulCalcRule.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                qFilter.and(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
                qFilter.and(new QFilter("enable", "=", (Object)true));
                qFilter.and(new QFilter("id", "!=", (Object)id));
                qFilter.and(new QFilter("mulcalcrule.fbasedataid", "in", ruleIds));
                DynamicObject existCalcRule = QueryServiceHelper.queryOne((String)"cad_planscheme", (String)"id,number,name,mulcalcrule.fbasedataid ruleid", (QFilter[])qFilter.toArray());
                if (existCalcRule == null) break;
                String schemeNumber = existCalcRule.getString("number");
                String schemeName = existCalcRule.getString("name");
                this.getModel().setValue("mulcalcrule", null);
                this.getModel().setDataChanged(false);
                String tip = String.format(ResManager.loadKDString((String)"\u7ef4\u62a4\u5931\u8d25\uff0c\u8be5\u5377\u7b97\u53d6\u4ef7\u89c4\u5219\u5df2\u5206\u914d\u7ed9\u6b64\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u8d26\u8584\u4e0b\u7684\u3010%1$s\u3011+\u3010%2$s\u3011\u4e86\u3002", (String)"PlanSchemeEdit_19", (String)"macc-cad-formplugin", (Object[])new Object[0]), schemeNumber, schemeName);
                this.getView().showErrorNotification(tip);
                break;
            }
            case "startperiod": 
            case "endperiod": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
                int[] selectRows = entryEntityGrid.getSelectRows();
                int rowIndex = selectRows[0];
                if (!this.checkPeriodStartLessEnd((List<DynamicObject>)entryEntity, rowIndex)) {
                    this.getModel().setValue(proName, null, rowIndex);
                    this.getModel().setDataChanged(false);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"PlanSchemeEdit_17", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                if (this.checkPeriodOverlap((List<DynamicObject>)entryEntity, rowIndex)) {
                    this.getModel().setValue(proName, null, rowIndex);
                    this.getModel().setDataChanged(false);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u671f\u95f4\u8303\u56f4\u4e0d\u80fd\u5b58\u5728\u91cd\u53e0\u6216\u4ea4\u53c9\u3002", (String)"PlanSchemeEdit_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                if (this.checkPeriodInSameYear((List<DynamicObject>)entryEntity, rowIndex)) break;
                this.getModel().setValue(proName, null, rowIndex);
                this.getModel().setDataChanged(false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u671f\u95f4\u8303\u56f4\u4e0d\u80fd\u8de8\u5e74\u3002", (String)"PlanSchemeEdit_23", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkEnable(List<DynamicObject> entryEntity, int rowIndex) {
        DynamicObject changeEntry;
        String enable;
        return !CadEmptyUtils.isEmpty(entryEntity) && (enable = (changeEntry = entryEntity.get(rowIndex)).getString("enabled")).equals("1");
    }

    private boolean checkPeriodStartLessEnd(List<DynamicObject> entryEntity, int rowIndex) {
        if (!CadEmptyUtils.isEmpty(entryEntity)) {
            DynamicObject changeData = entryEntity.get(rowIndex);
            DynamicObject startPeriod = changeData.getDynamicObject("startperiod");
            DynamicObject endPeriod = changeData.getDynamicObject("endperiod");
            if (startPeriod != null && endPeriod != null && PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)endPeriod) > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPeriodInSameYear(List<DynamicObject> entryEntity, int rowIndex) {
        if (!CadEmptyUtils.isEmpty(entryEntity)) {
            DynamicObject changeData = entryEntity.get(rowIndex);
            DynamicObject startPeriod = changeData.getDynamicObject("startperiod");
            DynamicObject endPeriod = changeData.getDynamicObject("endperiod");
            if (startPeriod != null && endPeriod != null && startPeriod.getLong("periodyear") != endPeriod.getLong("periodyear")) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPeriodOverlap(List<DynamicObject> entryEntity, int rowIndex) {
        boolean flag = false;
        if (!CadEmptyUtils.isEmpty(entryEntity)) {
            DynamicObject changeData = entryEntity.get(rowIndex);
            DynamicObject startPeriod = changeData.getDynamicObject("startperiod");
            DynamicObject endPeriod = changeData.getDynamicObject("endperiod");
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i == rowIndex) continue;
                DynamicObject dynamicObject = entryEntity.get(i);
                DynamicObject start = dynamicObject.getDynamicObject("startperiod");
                DynamicObject end = dynamicObject.getDynamicObject("endperiod");
                if (start == null || end == null) continue;
                if (startPeriod != null && PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)start) >= 0 && PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)end) <= 0) {
                    flag = true;
                    break;
                }
                if (endPeriod != null && PeriodHelper.compare2period((DynamicObject)endPeriod, (DynamicObject)start) >= 0 && PeriodHelper.compare2period((DynamicObject)endPeriod, (DynamicObject)end) <= 0) {
                    flag = true;
                    break;
                }
                if (startPeriod == null || endPeriod == null || PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)start) >= 0 || PeriodHelper.compare2period((DynamicObject)endPeriod, (DynamicObject)end) <= 0) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private void setCostAccount(long orgId) {
        Long mainCostAccountId = CostAccountHelper.getMainCostAccount((Long)orgId, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        if (!CadEmptyUtils.isEmpty((Long)mainCostAccountId)) {
            this.getModel().setValue("costaccount", (Object)mainCostAccountId);
        }
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    private void initByListData(EventObject e) {
        String operateKey = (String)this.getView().getFormShowParameter().getCustomParam("operate");
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            if (this.getPageCache().get("hasinitorg") == null) {
                String costAccountId;
                IDataModel model = this.getModel();
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String orgId = (String)fsp.getCustomParam("org");
                if (!CadEmptyUtils.isEmpty((String)orgId)) {
                    model.setValue("org", (Object)orgId);
                }
                if (!CadEmptyUtils.isEmpty((String)(costAccountId = (String)fsp.getCustomParam("costaccount")))) {
                    model.setValue("costaccount", (Object)costAccountId);
                }
                this.getPageCache().put("hasinitorg", "1");
            } else {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) {
                    this.setCostAccount(org.getLong("id"));
                }
            }
        }
    }
}

