/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.resourcerate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.formplugin.planfeealloc.PlanOrgAndCostAccountListPlugin;
import kd.macc.cad.servicehelper.WorkQtyCollectServiceHelper;

public class PlanWorkBillListPlugin
extends PlanOrgAndCostAccountListPlugin {
    private static final Log logger = LogFactory.getLog(PlanWorkBillListPlugin.class);
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private static final String closeBack_importResult = "importResult";

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("searchconfig".equals(itemKey)) {
            this.searchConfig();
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"cad_planwork", (IFormView)this.getView());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        if ("tblnew".equals(key) && CadEmptyUtils.isEmpty((Long)orgId)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a", (String)"PlanWorkBillListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
            evt.setCancel(true);
            return;
        }
        if ("sysimport".equals(key)) {
            this.inSysImport();
        }
    }

    private void inSysImport() {
        try {
            Map objRules;
            Long orgId = this.getSelectOrgId(this.ORG_FIELD);
            if (CadEmptyUtils.isEmpty((Long)orgId)) {
                return;
            }
            long accountOrgId = orgId;
            String costCenter = this.getPageCache().get("costcenter");
            ArrayList<Long> costCenters = new ArrayList<Long>(10);
            if (!CadEmptyUtils.isEmpty((String)costCenter)) {
                List costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)costCenter, List.class);
                if (!CadEmptyUtils.isEmpty((List)costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
                    costCenterMultiSelect.forEach(s -> costCenters.add(Long.parseLong(String.valueOf(s))));
                } else if (costCenterMultiSelect.size() == 1 && !CadEmptyUtils.isEmpty((String)String.valueOf(costCenterMultiSelect.get(0)))) {
                    costCenters.add(Long.parseLong(String.valueOf(costCenterMultiSelect.get(0))));
                }
            }
            if (CadEmptyUtils.isEmpty(costCenters)) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("accountorg", "=", (Object)accountOrgId));
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("enable", "=", (Object)true));
                filters.add(new QFilter("orgduty.number", "=", (Object)"5"));
                List costCentersByOrg = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
                costCentersByOrg.forEach(s -> costCenters.add(Long.parseLong(String.valueOf(s))));
            }
            if (CadEmptyUtils.isEmpty((Map)(objRules = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, costCenters)))) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"PlanWorkBillListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"CostObjectListPlugin_6"));
                return;
            }
            Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)accountOrgId, costCenters, (Map)objRules);
            List collConfigs = CommonCollConfigService.getCollConfigs((Long)orgId, null, (Set)calDimensionIds, (String)"cad_planwork", (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u4f5c\u4e1a\u6570\u91cf\u5f52\u96c6\u65b9\u6848\u3002", (String)"PlanWorkBillListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"WorkQtyCollecListPlugin_18"));
                return;
            }
            Long manuOrgId = this.getSelectOrgId("manuorg");
            Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)accountOrgId);
            ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
            if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((Long)manuOrgId)) {
                List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountOrgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(userHasPermManuOrgs);
            } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((Long)manuOrgId)) {
                manuOrgs.add(manuOrgId);
            }
            String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlanWorkBillListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = WorkQtyCollectServiceHelper.importWorkQtyCollect((Long)accountOrgId, (List)costCenters, (List)manuOrgs, (String)appNum, (String)progressId);
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"PlanWorkBillListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
            }
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long orgId = this.getSelectOrgId(this.ORG_FIELD);
        Long manuorgId = null;
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            manuorgId = this.getSelectOrgId("manuorg");
        }
        e.getParameter().setCustomParam("org", (Object)(orgId == null ? "" : String.valueOf(orgId)));
        Long costcenter = this.getSelectOrgId("costcenter");
        e.getParameter().setCustomParam("costaccount", (Object)this.getPageCache().get("costaccount"));
        e.getParameter().setCustomParam("costcenter", (Object)(costcenter == null ? "" : String.valueOf(costcenter)));
        e.getParameter().setCustomParam("manuorg", (Object)(manuorgId == null ? "" : String.valueOf(manuorgId)));
        e.getParameter().setCustomParam("period", (Object)this.getPageCache().get("period"));
        e.getParameter().setCustomParam("planscheme", (Object)this.getPageCache().get("planscheme"));
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.setOrderBy("bizdate desc,billno desc");
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateQtyScale();
    }

    private void updateQtyScale() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            return;
        }
        String fields = "id, baseunit, baseunit.precision AS precision, baseunit.precisionaccount AS precisionaccount, entryentity.id AS entryid, entryentity.entryqty AS entryqty";
        QFilter idQF = new QFilter("id", "in", (Object)rows.getPrimaryKeyValues());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"cad_planwork", (String)fields, (QFilter[])new QFilter[]{idQF});
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        for (DynamicObject col : cols) {
            Long entryid = col.getLong("entryid");
            if (null == entryid || 0L == entryid) continue;
            map.put(entryid, col);
        }
        for (int i = 0; i < rows.size(); ++i) {
            Long entryid = (Long)rows.get(i).getEntryPrimaryKeyValue();
            if (null == entryid || 0L == entryid) continue;
            DynamicObject col = (DynamicObject)map.get(entryid);
            int precision = col.getInt("precision");
            String precisionaccount = col.getString("precisionaccount");
            int roundType = 4;
            if ("2".equals(precisionaccount)) {
                roundType = 1;
            } else if ("3".equals(precisionaccount)) {
                roundType = 0;
            }
            BigDecimal value = col.getBigDecimal("entryqty").setScale(precision, roundType);
            if (value.longValue() == 0L) {
                return;
            }
            String allocvalueStr = value.toString();
            billList.setCellFieldValue("entryqty", i, (Object)allocvalueStr);
        }
    }

    public List<ComboItem> getCostCenterByAccoutOrg(String orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        long org = StringUtils.isEmpty((String)orgId) ? 0L : Long.parseLong(orgId);
        String manuOrgId = this.getPageCache().get("manuorgId");
        ArrayList<Long> manuOrgList = new ArrayList<Long>();
        if (!CadEmptyUtils.isEmpty((String)manuOrgId)) {
            manuOrgList.add(Long.parseLong(manuOrgId));
        }
        QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)org, manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
        filters.add(costCenterIdFilter);
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("orgduty.number", "=", (Object)"5"));
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        List centerItems = DynamicObjectHelper.toComboItem((DynamicObjectCollection)costCenters);
        return centerItems;
    }
}

