/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.settle;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.settle.CalcSettleEngine;
import kd.macc.cad.business.settle.model.SettleScheme;
import kd.macc.cad.business.settle.model.SettleTask;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.settle.QuerySchemeHolder;

public class CalculateSettlePlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(CalculateSettlePlugin.class);
    private static final String CONFIRMBACK_CAL = "distributcal";
    private static final String schemeEntryKey = "scheme_entry";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObjectCollection schemeEntry = this.getModel().getDataEntity().getDynamicObjectCollection(schemeEntryKey);
        if (schemeEntry != null && schemeEntry.size() > 0) {
            schemeEntry.forEach(obj -> this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u4fee\u6539\u65f6\u95f4\uff1a2023-11-10", (String)"CalculateSettlePlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        boolean success;
        String opKey = event.getOperateKey();
        OperationResult operationResult = event.getOperationResult();
        if (operationResult != null && !(success = operationResult.isSuccess())) {
            return;
        }
        if (CONFIRMBACK_CAL.equals(opKey)) {
            Boolean presetSet = (Boolean)this.getModel().getValue("preset_set");
            if (presetSet.booleanValue()) {
                String schemeStr = ResManager.loadKDString((String)"\u9884\u7f6e\u65b9\u6848\u672a\u8bbe\u7f6e\u6210\u672c\u8d26\u7c3f\uff0c\u5982\u9700\u4f7f\u7528\uff0c\u8bf7\u53e6\u5b58\u65b9\u6848\u540e\u8bbe\u7f6e\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalculateSettlePlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(schemeStr);
                return;
            }
            Long querySchemeId = new QuerySchemeHolder(this.getView()).getCurSchemeId();
            logger.info("\u6210\u672c\u6838\u7b97\u5de5\u4f5c\u53f0\u8ba1\u7b97\uff1a\u5f00\u59cb!\uff0c\u65b9\u6848id\u4e3a\u3010{}\u3011", (Object)querySchemeId);
            SettleScheme scheme = this.getSettleScheme();
            if (scheme == null) {
                return;
            }
            scheme.setSchemeId(querySchemeId);
            Map retMsg = CalcSettleEngine.startSettle((SettleScheme)scheme, (String)this.getView().getFormShowParameter().getAppId());
            if (retMsg != null && "0".equals(retMsg.get("code"))) {
                String msg = (String)retMsg.get("msg");
                if (CadEmptyUtils.isEmpty((String)msg)) {
                    msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"CalculateSettlePlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                }
                this.getView().showErrorNotification(msg);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u53d1\u8d77\u6210\u529f\u3002", (String)"CalculateSettlePlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.jumpPage(retMsg);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(schemeEntryKey);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(schemeEntryKey);
            entryGrid.selectRows(entryCurrentRowIndex);
            logger.info("\u6210\u672c\u6838\u7b97\u5de5\u4f5c\u53f0\u8ba1\u7b97\uff1a\u7ed3\u675f!");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean dataChanged;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (operateKey.equals(CONFIRMBACK_CAL) && (dataChanged = this.getModel().getDataChanged())) {
            RefObject afterConfirm = new RefObject();
            if (!source.getOption().tryGetVariableValue(CONFIRMBACK_CAL, afterConfirm)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMBACK_CAL, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u65b9\u6848\u6709\u53d8\u52a8\uff0c\u9700\u8981\u4fdd\u5b58\u540e\u6267\u884c\uff0c\u662f\u5426\u4fdd\u5b58\u5e76\u6267\u884c\uff1f\u662f\uff0c\u5219\u539f\u65b9\u6848\u4fdd\u5b58\u540e\u6267\u884c\uff0c\u5426\u5219\u56de\u5230\u65b9\u6848\u754c\u9762\u4e0d\u6267\u884c\u3002", (String)"CalculateSettlePlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && CONFIRMBACK_CAL.equals(e.getCallBackId())) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            StringBuilder failMessage = new StringBuilder();
            for (DynamicObject dynamicObject : entryentity) {
                DynamicObjectCollection subentryentity = (DynamicObjectCollection)dynamicObject.get("subentryentity");
                for (int i = 0; i < subentryentity.size(); ++i) {
                    String defaultparam;
                    DynamicObject subDyn = (DynamicObject)subentryentity.get(i);
                    String stepname = dynamicObject.getString("stepname").substring(0, 1);
                    boolean paramismust = subDyn.getBoolean("settleitem.paramismust");
                    boolean execute = subDyn.getBoolean("execute");
                    if (paramismust && execute && CadEmptyUtils.isEmpty((String)(defaultparam = subDyn.getString("defaultparam_tag")))) {
                        failMessage.append(String.format(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u6b65\u9aa4\u201d\u7b2c%1$s\u6b65\uff0c\u6838\u7b97\u4efb\u52a1\u9879\u7b2c%2$s\u884c\uff0c\u65b9\u6848\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002%n", (String)"CalculateSettlePlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]), stepname, i + 1));
                    }
                    if (subentryentity.size() <= i + 1) continue;
                    DynamicObject dynNext = (DynamicObject)subentryentity.get(i + 1);
                    boolean parallel = subDyn.getBoolean("settleitem.parallel");
                    boolean parallelNext = dynNext.getBoolean("parallel");
                    if (parallel || !parallelNext) continue;
                    failMessage.append(String.format(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u6b65\u9aa4\u201d\u7b2c%1$s\u6b65\uff0c\u6838\u7b97\u4efb\u52a1\u9879\u7b2c%2$s\u884c\uff0c\u4e0d\u5141\u8bb8\u548c\u4e0a\u4e00\u6b65\u540c\u65f6\u6267\u884c\u3002%n", (String)"CalculateSettlePlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]), stepname, i + 2));
                }
            }
            if (!CadEmptyUtils.isEmpty((String)failMessage.toString())) {
                this.getView().showMessage(failMessage.toString());
                return;
            }
            String schemename = this.getModel().getDataEntity().getString("schemename_set");
            if (CadEmptyUtils.isEmpty((String)schemename)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u65b9\u6848\u540d\u79f0\u201d\u3002", (String)"CalculateSettlePlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.saveScheme();
            OperateOption operationOption = OperateOption.create();
            operationOption.setVariableValue(CONFIRMBACK_CAL, "true");
            this.getView().invokeOperation(CONFIRMBACK_CAL, operationOption);
        }
    }

    private SettleScheme getSettleScheme() {
        SettleScheme scheme = new SettleScheme();
        ArrayList<SettleTask> tasks = new ArrayList<SettleTask>(10);
        DynamicObjectCollection entryentity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        StringBuilder failMessage = new StringBuilder();
        for (DynamicObject dynamicObject : entryentity) {
            DynamicObjectCollection subentryentity = (DynamicObjectCollection)dynamicObject.get("subentryentity");
            for (int i = 0; i < subentryentity.size(); ++i) {
                String defaultparam;
                DynamicObject subDyn = (DynamicObject)subentryentity.get(i);
                boolean paramismust = subDyn.getBoolean("settleitem.paramismust");
                boolean execute = subDyn.getBoolean("execute");
                if (paramismust && execute && CadEmptyUtils.isEmpty((String)(defaultparam = subDyn.getString("defaultparam_tag")))) {
                    String stepname = dynamicObject.getString("stepname").substring(0, 1);
                    failMessage.append(String.format(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u6b65\u9aa4\u201d\u7b2c%1$s\u6b65\uff0c\u6838\u7b97\u4efb\u52a1\u9879\u7b2c%2$s\u884c\uff0c\u65b9\u6848\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002%n", (String)"CalculateSettlePlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]), stepname, i + 1));
                }
                SettleTask settleTask = new SettleTask();
                settleTask.setSettleitem(Long.valueOf(subDyn.getLong("settleitem.id")));
                settleTask.setParampage(subDyn.getString("settleitem.parampage"));
                settleTask.setAppnum(subDyn.getString("settleitem.appnum"));
                settleTask.setDefaultparam(subDyn.getString("defaultparam_tag"));
                settleTask.setExecute(execute);
                settleTask.setExemethod(subDyn.getString("exemethod"));
                settleTask.setFunctype(dynamicObject.getString("stepname"));
                settleTask.setMannulconfirm(subDyn.getBoolean("mannulconfirm"));
                settleTask.setParallel(subDyn.getBoolean("parallel"));
                settleTask.setCalcparam(subDyn.getString("calcparam"));
                tasks.add(settleTask);
            }
        }
        if (!CadEmptyUtils.isEmpty((String)failMessage.toString())) {
            this.getView().showMessage(failMessage.toString());
            return null;
        }
        DynamicObjectCollection costaccounts = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        ArrayList<Long> costaccountIds = new ArrayList<Long>(10);
        for (DynamicObject costAccount : costaccounts) {
            DynamicObject costaccountDyn = (DynamicObject)costAccount.get(1);
            costaccountIds.add(Long.valueOf(String.valueOf(costaccountDyn.getPkValue())));
        }
        Map costaccountDynMap = BusinessDataServiceHelper.loadFromCache((Object[])costaccountIds.toArray(), (String)"cal_bd_costaccount");
        List acctOrgs = OrgHelper.getCurrAccountOrg((String)this.getView().getEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : costaccountDynMap.entrySet()) {
            DynamicObject calorgDyn = ((DynamicObject)entry.getValue()).getDynamicObject("calorg");
            if (calorgDyn == null || acctOrgs.contains(calorgDyn.getLong("id"))) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(((DynamicObject)entry.getValue()).getString("name"));
        }
        if (sb.length() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u6210\u672c\u8d26\u7c3f\u3010%s\u3011\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u53d1\u8d77\u8ba1\u7b97\u3002", (String)"CalculateSettlePlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), sb.toString()));
            return null;
        }
        scheme.setCostaccountIds(costaccountIds);
        scheme.setTasks(tasks);
        return scheme;
    }

    private void jumpPage(Map<String, Object> retMsg) {
        if (retMsg == null) {
            return;
        }
        List reportIds = (List)retMsg.get("reportIds");
        if (!CadEmptyUtils.isEmpty((List)reportIds) && reportIds.size() > 1) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("cad_settlereport");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("bos_list");
            parameter.getCustomParams().put("islinkin", "true");
            QFilter costAccountFilter = new QFilter("id", "in", (Object)reportIds);
            parameter.getListFilterParameter().setFilter(costAccountFilter);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            BillShowParameter lsp = new BillShowParameter();
            lsp.setFormId("cad_settlereport");
            lsp.setPkId(reportIds.get(0));
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }
}

