/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.settle;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.macc.cad.business.settle.model.Scafinwizard;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.ObjectUtils;

public class FinwizardPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnDataToParent();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object defaultparam = this.getView().getFormShowParameter().getCustomParam("defaultparam");
        if (ObjectUtils.isNotEmpty((Object)defaultparam)) {
            Scafinwizard scafinwizard = (Scafinwizard)SerializationUtils.fromJsonString((String)((String)defaultparam), Scafinwizard.class);
            Set costcenter = scafinwizard.getCostcenter();
            Object[] objects = costcenter.toArray();
            this.getModel().setValue("costcenter", (Object)objects);
            this.getModel().setValue("minrate", (Object)scafinwizard.getMinrate());
            this.getModel().setValue("maxrate", (Object)scafinwizard.getMaxrate());
            Boolean hideflag = (Boolean)this.getView().getFormShowParameter().getCustomParam("hideflag");
            if (hideflag != null && hideflag.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncancel"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
            }
        }
    }

    private void returnDataToParent() {
        Scafinwizard scafinwizard = new Scafinwizard();
        scafinwizard.setCostcenter(this.getCostCenterSet());
        scafinwizard.setMinrate((BigDecimal)this.getModel().getValue("minrate"));
        scafinwizard.setMinrate((BigDecimal)this.getModel().getValue("maxrate"));
        String filterString = SerializationUtils.toJsonString((Object)scafinwizard);
        this.getView().returnDataToParent((Object)filterString);
        this.getView().close();
    }

    private Set<Long> getCostCenterSet() {
        HashSet costCenterSet = Sets.newHashSet();
        DynamicObjectCollection costCenters = (DynamicObjectCollection)this.getModel().getValue("costcenter");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costCenters)) {
            for (DynamicObject row : costCenters) {
                DynamicObject costcenter = row.getDynamicObject("fbasedataid");
                costCenterSet.add(costcenter.getLong("masterid"));
            }
        }
        return costCenterSet;
    }
}

