/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.settle;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class QuerySchemeHolder {
    private static final String SCHEME_ENTITY = "cad_query_scheme";
    private final String formId;
    private IFormView view;
    private boolean isAddScheme = false;
    private static final String IS_ADD_SCHEME_CACHE_KEY = "isAddSchemeCacheKey";
    private String schemeEntryKey = "scheme_entry";
    private String schemeIdField_entry = "schemeid_entry";
    private String schemeNameField_entry = "schemename_entry";
    private String schemeIsdefaultField_entry = "isdefaultscheme_entry";
    private String isDefaultField_set = "isdefault_set";
    private String schemeNameField_set = "schemename_set";
    private String preset_set = "preset_set";
    private String filter_split = "filtersplit";
    private Set<String> removeEntities = new HashSet<String>(16);
    private static final String INIT_SCHEMESTR_CACHE = "initschemestr";
    private static final String CUST_FILTERS = "custfilters";
    private static final String CUST_SELECTROWS = "custselectrows";

    public QuerySchemeHolder(IFormView view) {
        this.view = view;
        DynamicObject dataEntityDyc = this.view.getModel().getDataEntity(true);
        this.formId = dataEntityDyc.getDataEntityType().getExtendName();
    }

    public void initSchemesList() {
        DynamicObjectCollection schemeDycs = this.getSchemeDycsByUser();
        if (schemeDycs.isEmpty()) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.formId);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (int i = 1; i <= 5; ++i) {
                DynamicObject dynamicObjectDefault = entryentity.addNew();
                dynamicObjectDefault.set("seq", (Object)i);
                dynamicObjectDefault.set("stepname", (Object)Integer.valueOf(i + "0"));
            }
            this.setDbValue2FomValue(dynamicObject);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(this.schemeIdField_entry, new Object[0]);
        vs.addField(this.schemeNameField_entry, new Object[0]);
        vs.addField(this.schemeIsdefaultField_entry, new Object[0]);
        for (DynamicObject item : schemeDycs) {
            Long schemeId = item.getLong("id");
            String schemeName = item.getString("name");
            String isdefaultScheme = item.getString("isdefault");
            vs.addRow(new Object[]{schemeId, schemeName, isdefaultScheme});
        }
        this.view.getModel().beginInit();
        this.view.getModel().deleteEntryData(this.schemeEntryKey);
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            ((AbstractFormDataModel)this.view.getModel()).batchCreateNewEntryRow(this.schemeEntryKey, vs);
        }
        this.view.getModel().endInit();
        this.view.updateView(this.schemeEntryKey);
    }

    public void setDefaultScheme() {
        String isInit = this.view.getPageCache().get("isinit");
        int entryRowCount = this.view.getModel().getEntryRowCount(this.schemeEntryKey);
        if (isInit != null || entryRowCount < 1) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.schemeEntryKey);
        entryGrid.selectRows(0);
        this.view.getPageCache().put("isinit", "");
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        String schemeStr = this.toJson(formDataEntityDyc);
        this.view.getPageCache().put(INIT_SCHEMESTR_CACHE, schemeStr);
    }

    public DynamicObject saveScheme() {
        int index;
        DynamicObjectCollection formSchemeDycs;
        Object entrySchemeName;
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        int currentRow = this.view.getModel().getEntryCurrentRowIndex(this.schemeEntryKey);
        Object selSchemeId = this.view.getModel().getValue(this.schemeIdField_entry, currentRow);
        boolean isNew = selSchemeId == null || selSchemeId.equals(0L) || this.view.getPageCache().get(IS_ADD_SCHEME_CACHE_KEY) != null;
        String setSchemeName = formDataEntityDyc.getString(this.schemeNameField_set);
        if (!setSchemeName.equals(entrySchemeName = this.view.getModel().getValue(this.schemeNameField_entry, currentRow))) {
            isNew = true;
        }
        DynamicObject schemeDyc = this.buildSchemeDyc(selSchemeId, isNew);
        String lockKey = this.formId + schemeDyc.getString("name");
        try (DLock lock = DLock.create((String)lockKey, (String)"cad-formplugin-QuerySchemeHolder");){
            lock.lock();
            this.checkHasSameNameScheme(schemeDyc);
            this.invokeSaveScheme(new DynamicObject[]{schemeDyc});
        }
        if (schemeDyc.getBoolean("isdefault")) {
            this.setOtherSchemeNotDefault(schemeDyc.getPkValue());
        }
        if (!isNew) {
            this.view.getModel().deleteEntryRow(this.schemeEntryKey, currentRow);
        }
        if ((formSchemeDycs = formDataEntityDyc.getDynamicObjectCollection(this.schemeEntryKey)).isEmpty()) {
            index = this.view.getModel().createNewEntryRow(this.schemeEntryKey);
        } else {
            index = !((DynamicObject)formSchemeDycs.get(0)).getBoolean(this.schemeIsdefaultField_entry) ? 0 : 1;
            this.view.getModel().insertEntryRow(this.schemeEntryKey, index);
        }
        this.view.getModel().setValue(this.schemeNameField_entry, schemeDyc.get("name"), index);
        this.view.getModel().setValue(this.schemeIsdefaultField_entry, schemeDyc.get("isdefault"), index);
        this.view.getModel().setValue(this.schemeIdField_entry, schemeDyc.getPkValue(), index);
        EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.schemeEntryKey);
        entryGrid.selectRows(index);
        this.view.getPageCache().remove(IS_ADD_SCHEME_CACHE_KEY);
        this.view.getModel().setDataChanged(false);
        return schemeDyc;
    }

    private void checkHasSameNameScheme(DynamicObject schemeDyc) {
        QFilter formIdFilter = new QFilter("formid", "=", (Object)this.formId);
        QFilter nameFilter = new QFilter("name", "=", (Object)schemeDyc.getString("name"));
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)schemeDyc.getString("appnum"));
        QFilter idFilter = new QFilter("id", "!=", schemeDyc.getPkValue());
        boolean isHasSameNameScheme = QueryServiceHelper.exists((String)SCHEME_ENTITY, (QFilter[])new QFilter[]{formIdFilter, nameFilter, appnumFilter, idFilter});
        if (isHasSameNameScheme) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c%s: \u201c\u540d\u79f0\u201d \u91cd\u590d\u6216\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4f7f\u7528\u3002", (String)"QuerySchemeHolder_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            msg = String.format(msg, schemeDyc.getString("name"));
            throw new KDBizException(msg);
        }
    }

    private void invokeSaveScheme(DynamicObject[] schemeDycs) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)SCHEME_ENTITY, (DynamicObject[])schemeDycs, (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\u3002", (String)"QuerySchemeHolder_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            if (errors.isEmpty()) {
                msg.append(result.getMessage()).append('\n');
            }
            throw new KDBizException(msg.toString());
        }
    }

    private DynamicObject buildSchemeDyc(Object selSchemeId, boolean isNew) {
        DynamicObject[] schemeDycs;
        DynamicObject formDataEntityDyc = this.view.getModel().getDataEntity(true);
        String name = formDataEntityDyc.getString(this.schemeNameField_set);
        DynamicObject schemeDyc = isNew ? this.createSchemeDyc(name) : ((schemeDycs = BusinessDataServiceHelper.load((Object[])new Object[]{selSchemeId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY))).length > 0 ? schemeDycs[0] : this.createSchemeDyc(name));
        String schemeStr = this.toJson(formDataEntityDyc);
        schemeDyc.set("name", (Object)name);
        schemeDyc.set("formid", (Object)this.formId);
        schemeDyc.set("modifier", (Object)RequestContext.get().getCurrUserId());
        if (schemeDyc.getDataEntityState().getFromDatabase()) {
            schemeDyc.set("modifytime", (Object)new Date());
        }
        schemeDyc.set("schemestr_tag", (Object)schemeStr);
        schemeDyc.set("appnum", (Object)this.view.getFormShowParameter().getAppId());
        if (!this.isDefaultField_set.isEmpty()) {
            schemeDyc.set("isdefault", (Object)formDataEntityDyc.getBoolean(this.isDefaultField_set));
        }
        return schemeDyc;
    }

    public void deleteScheme() {
        int[] selectRows = ((EntryGrid)this.view.getControl(this.schemeEntryKey)).getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        int currentRow = selectRows[0];
        Long schemeId = (Long)this.view.getModel().getValue(this.schemeIdField_entry, currentRow);
        this.view.getModel().deleteEntryRow(this.schemeEntryKey, currentRow);
        DeleteServiceHelper.delete((String)SCHEME_ENTITY, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
    }

    public void addScheme() {
        this.isAddScheme = true;
        EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.schemeEntryKey);
        entryGrid.selectRows(-1);
        this.resetScheme();
        this.view.getPageCache().put(IS_ADD_SCHEME_CACHE_KEY, "");
    }

    public void resetScheme() {
        this.isAddScheme = true;
        String filterSchemeStr = this.view.getPageCache().get(INIT_SCHEMESTR_CACHE);
        DynamicObject dbFormDataDyc = this.toDynamicObject(filterSchemeStr);
        this.setDbValue2FomValue(dbFormDataDyc);
        this.view.updateView(this.filter_split);
    }

    private DynamicObject createSchemeDyc(String name) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY);
        DynamicObject schemeDyc = new DynamicObject((DynamicObjectType)dataEntityType);
        Date now = new Date();
        schemeDyc.set("number", (Object)name);
        schemeDyc.set("creator", (Object)RequestContext.get().getCurrUserId());
        schemeDyc.set("createtime", (Object)now);
        schemeDyc.set("modifytime", (Object)now);
        schemeDyc.set("status", (Object)"C");
        schemeDyc.set("enable", (Object)"1");
        schemeDyc.set("id", (Object)DB.genLongId((String)dataEntityType.getAlias()));
        return schemeDyc;
    }

    private void setOtherSchemeNotDefault(Object selSchemeId) {
        DynamicObject[] otherSchemeDycs;
        int entryRowCount = this.view.getModel().getEntryRowCount(this.schemeEntryKey);
        HashSet<Object> schemeIds = new HashSet<Object>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            Object schemeId = this.view.getModel().getValue(this.schemeIdField_entry, i);
            if (!((Boolean)this.view.getModel().getValue(this.schemeIsdefaultField_entry, i)).booleanValue() || schemeId.equals(selSchemeId)) continue;
            schemeIds.add(schemeId);
            this.view.getModel().setValue(this.schemeIsdefaultField_entry, (Object)Boolean.FALSE, i);
            this.view.updateView(this.schemeIsdefaultField_entry, i);
        }
        for (DynamicObject ohterSchemeDyc : otherSchemeDycs = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY))) {
            ohterSchemeDyc.set("isdefault", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])otherSchemeDycs);
    }

    public DynamicObject getScheme(Long schemeId) {
        DynamicObject schemeDyc = null;
        QFilter idf = new QFilter("id", "=", (Object)schemeId);
        DynamicObjectCollection schemeDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)SCHEME_ENTITY, (String)"id,name,isdefault,schemestr_tag,preset", (QFilter[])idf.toArray(), null);
        if (schemeDycs.size() > 0) {
            schemeDyc = (DynamicObject)schemeDycs.get(0);
        }
        return schemeDyc;
    }

    private DynamicObjectCollection getSchemeDycsByUser() {
        QFilter filter = new QFilter("formid", "=", (Object)this.formId);
        filter.and(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()));
        filter.and(new QFilter("appnum", "=", (Object)this.view.getFormShowParameter().getAppId()));
        filter.and(new QFilter("preset", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("preset", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection schemeDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)SCHEME_ENTITY, (String)"id,name,isdefault,schemestr", (QFilter[])new QFilter[]{filter}, (String)"isdefault desc,modifytime desc");
        QFilter presetf = new QFilter("preset", "=", (Object)Boolean.TRUE);
        presetf.and(new QFilter("appnum", "=", (Object)this.view.getFormShowParameter().getAppId()));
        DynamicObjectCollection schemePresetDycs = QueryServiceHelper.query((String)this.getClass().getName(), (String)SCHEME_ENTITY, (String)"id,name,isdefault,schemestr", (QFilter[])new QFilter[]{presetf}, (String)"isdefault desc,preset desc,modifytime desc");
        schemeDycs.addAll((Collection)schemePresetDycs);
        return schemeDycs;
    }

    public void setScheme(int row) {
        Long schemeId = (Long)this.view.getModel().getValue(this.schemeIdField_entry, row);
        this.setScheme(schemeId);
        this.view.getModel().setDataChanged(false);
    }

    public void setScheme(Long schemeId) {
        if (schemeId == null || schemeId.equals(0L)) {
            return;
        }
        DynamicObject schemeDyc = this.getScheme(schemeId);
        if (schemeDyc == null) {
            return;
        }
        String filterSchemeStr = schemeDyc.getString("schemestr_tag");
        DynamicObject dbFormDataDyc = this.toDynamicObject(filterSchemeStr);
        this.setDbValue2FomValue(dbFormDataDyc);
        this.view.updateView(this.filter_split);
        this.view.getModel().setValue(this.schemeNameField_set, schemeDyc.get("name"));
        this.view.getModel().setValue(this.isDefaultField_set, schemeDyc.get("isdefault"));
        this.view.getModel().setValue(this.preset_set, schemeDyc.get("preset"));
        this.view.getPageCache().remove(IS_ADD_SCHEME_CACHE_KEY);
        this.selectEntryRows(filterSchemeStr);
    }

    public Long getCurSchemeId() {
        int currentRow = this.view.getModel().getEntryCurrentRowIndex(this.schemeEntryKey);
        Object curSchemeId = this.view.getModel().getValue(this.schemeIdField_entry, currentRow);
        if (curSchemeId == null) {
            curSchemeId = 0L;
        }
        return (Long)curSchemeId;
    }

    private void setDbValue2FomValue(DynamicObject dbFormDataDyc) {
        MainEntityType newFormDataEntityType = this.view.getModel().getDataEntityType();
        FormRoot rootControl = (FormRoot)this.view.getRootControl();
        this.setDbValue2FomValue((Container)rootControl, dbFormDataDyc, (DynamicObjectType)newFormDataEntityType, 0);
        this.view.getModel().beginInit();
        Map allEntities = newFormDataEntityType.getAllEntities();
        this.removeEntities.add(this.formId);
        this.removeEntities.add(this.schemeEntryKey);
        for (Map.Entry item : allEntities.entrySet()) {
            String key = (String)item.getKey();
            if (this.removeEntities.contains(key) || "subentryentity".equals(key)) continue;
            DynamicObjectCollection dbEntryDycs = dbFormDataDyc.getDynamicObjectCollection(key);
            this.view.getModel().deleteEntryData(key);
            if (dbEntryDycs.isEmpty()) continue;
            this.view.getModel().batchCreateNewEntryRow(key, dbEntryDycs.size());
            for (int i = 0; i < dbEntryDycs.size(); ++i) {
                this.setDbValue2FomValue((Container)this.view.getControl(key), (DynamicObject)dbEntryDycs.get(i), (DynamicObjectType)item.getValue(), i);
            }
        }
        this.view.getModel().endInit();
    }

    private void setDbValue2FomValue(Container container, DynamicObject dbFormDataDyc, DynamicObjectType newFormDataEntityType, int index) {
        HashSet<String> keySet = new HashSet<String>(16);
        this.initFilterFieldKeySet(keySet, container);
        DataEntityPropertyCollection dbProps = dbFormDataDyc.getDynamicObjectType().getProperties();
        for (IDataEntityProperty formProps : newFormDataEntityType.getProperties()) {
            Object val;
            if (keySet.contains(formProps.getName()) && dbProps.containsKey((Object)formProps.getName())) {
                val = dbFormDataDyc.get(formProps.getName());
                if (!"stepname".equals(formProps.getName()) && this.isAddScheme && formProps instanceof FieldProp) {
                    val = ((FieldProp)formProps).getDefValue();
                }
                this.view.getModel().setValue(formProps.getName(), val, index);
            }
            if (!"subentryentity".equals(formProps.getName())) continue;
            val = dbFormDataDyc.get(formProps.getName());
            if (this.isAddScheme && formProps instanceof FieldProp) {
                val = ((FieldProp)formProps).getDefValue();
            }
            this.view.getModel().setValue(formProps.getName(), val, index);
        }
    }

    private String toJson(DynamicObject filterObj) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(filterObj.getDynamicObjectType());
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        String filterStr = jser.serializeToString((Object)filterObj, null);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put(CUST_FILTERS, filterStr);
        Map entityEntitypeMap = EntityMetadataCache.getDataEntityType((String)filterObj.getDataEntityType().getName()).getAllEntities();
        HashMap entrySelRowsMap = new HashMap(16);
        for (Map.Entry entityTypeEntry : entityEntitypeMap.entrySet()) {
            if (!(entityTypeEntry.getValue() instanceof EntryType) || this.schemeEntryKey.equals(entityTypeEntry.getKey())) continue;
            int[] selectRows = ((EntryGrid)this.view.getControl((String)entityTypeEntry.getKey())).getSelectRows();
            entrySelRowsMap.put(entityTypeEntry.getKey(), selectRows);
        }
        param.put(CUST_SELECTROWS, entrySelRowsMap);
        return SerializationUtils.toJsonString(param);
    }

    private DynamicObject toDynamicObject(String schemeJson) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.formId);
        if (StringUtils.isEmpty((CharSequence)schemeJson)) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (int i = 1; i <= 5; ++i) {
                DynamicObject dynamicObjectDefault = entryentity.addNew();
                dynamicObjectDefault.set("seq", (Object)i);
                dynamicObjectDefault.set("stepname", (Object)Integer.valueOf(i + "0"));
            }
            return dynamicObject;
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String custfilters = (String)filterMap.get(CUST_FILTERS);
        DynamicObject fromDataDyc = (DynamicObject)jser.deserializeFromString(custfilters, null);
        DynamicObjectCollection entryentity = fromDataDyc.getDynamicObjectCollection("entryentity");
        if (entryentity.size() < 5) {
            for (int i = 1; i <= 5; ++i) {
                DynamicObject dynamicObjectDefault = entryentity.addNew();
                dynamicObjectDefault.set("seq", (Object)i);
                dynamicObjectDefault.set("stepname", (Object)Integer.valueOf(i + "0"));
            }
        }
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{fromDataDyc}, (IDataEntityType)type);
        return fromDataDyc;
    }

    private void initFilterFieldKeySet(Set<String> keySet, Container container) {
        for (Control control : container.getItems()) {
            if (control instanceof DateRangeEdit) {
                DateRangeEdit rangeEdit = (DateRangeEdit)control;
                keySet.add(rangeEdit.getStartDateFieldKey());
                keySet.add(rangeEdit.getEndDateFieldKey());
                continue;
            }
            if (control instanceof FieldEdit) {
                keySet.add(control.getKey());
                continue;
            }
            if (!(control instanceof Container)) continue;
            this.initFilterFieldKeySet(keySet, (Container)control);
        }
    }

    private void selectEntryRows(String filterSchemeStr) {
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)filterSchemeStr, HashMap.class);
        Map entrySelRowsMap = (Map)filterMap.get(CUST_SELECTROWS);
        if (entrySelRowsMap != null) {
            for (Map.Entry entrySelRowsEntry : entrySelRowsMap.entrySet()) {
                List selectRowIndexs;
                Control entryGrid = this.view.getControl((String)entrySelRowsEntry.getKey());
                if (!(entryGrid instanceof EntryGrid) || (selectRowIndexs = (List)entrySelRowsEntry.getValue()).isEmpty()) continue;
                int[] selectRowIndexArrays = new int[selectRowIndexs.size()];
                for (int i = 0; i < selectRowIndexs.size(); ++i) {
                    selectRowIndexArrays[i] = (Integer)selectRowIndexs.get(i);
                }
                ((EntryGrid)entryGrid).selectRows(selectRowIndexArrays, 0);
            }
        }
    }
}

