/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.settle;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.settle.QuerySchemeHolder;
import org.apache.commons.collections.CollectionUtils;

public class SchemeSettingPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final String SAVE_SCHEME_OP_KEY = "savescheme";
    private static final String DELETE_SCHEME_OP_KEY = "deletescheme";
    private static final String ADD_SCHEME_OP_KEY = "addscheme";
    private static final String RESET_SCHEME_OP_KEY = "resetcheme";
    private String schemeEntryKey = "scheme_entry";
    private static final String BUTTONAP_KEY = "buttonap";
    private static final String CALCPARAM = "calcparam";
    private static final String PARALLEL = "parallel";

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "settleitem": {
                this.updateCalcparam(e);
                break;
            }
            case "parallel": {
                this.parallel();
                break;
            }
            case "costaccount": {
                this.updatePeriodByCostAccount();
                break;
            }
        }
    }

    private void updatePeriodByCostAccount() {
        DynamicObjectCollection costaccount = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costaccount)) {
            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)Long.valueOf(String.valueOf(((DynamicObject)((DynamicObject)costaccount.get(0)).get(1)).getPkValue())));
            this.getModel().setValue("period", (Object)currentPeriod);
            if (costaccount.size() > 1) {
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                if (entryentity.isEmpty()) {
                    return;
                }
                DynamicObjectCollection subentryentity = (DynamicObjectCollection)((DynamicObject)entryentity.get(0)).get("subentryentity");
                if (!subentryentity.isEmpty()) {
                    for (int i = 0; i < subentryentity.size(); ++i) {
                        DynamicObject dynamicObject = (DynamicObject)subentryentity.get(i);
                        String number = (String)dynamicObject.get("settleitem.number");
                        if (!"CH_ITEM_007".equals(number)) continue;
                        dynamicObject.set(CALCPARAM, (Object)"");
                        dynamicObject.set("defaultparam_tag", (Object)"");
                    }
                }
            }
        }
    }

    private void updateCalcparam(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue != null) {
            Long id = (Long)((DynamicObject)newValue).getPkValue();
            QFilter idQFilter = new QFilter("id", "=", (Object)id);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_settleitem", (String)"mannulconfirm,defaultparam_tag", (QFilter[])new QFilter[]{idQFilter});
            String defaultparamTag = dynamicObject.getString("defaultparam_tag");
            this.getModel().setValue("defaultparam_tag", (Object)defaultparamTag);
            this.getModel().setValue("mannulconfirm", dynamicObject.get("mannulconfirm"));
            this.setCalcParam(defaultparamTag);
        }
    }

    private void parallel() {
        Boolean paraValue;
        EntryGrid entryGrid = (EntryGrid)this.getControl("subentryentity");
        int selectRows = entryGrid.getSelectRows()[0];
        DynamicObjectCollection subentryentity = this.getModel().getEntryEntity("subentryentity");
        DynamicObject settleItem = (DynamicObject)((DynamicObject)subentryentity.get(selectRows)).get("settleitem");
        if (CadEmptyUtils.isEmpty((DynamicObject)settleItem)) {
            this.getModel().setValue(PARALLEL, (Object)Boolean.FALSE);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u6267\u884c\u9879\u3002", (String)"SchemeSettingPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean parallel = settleItem.getBoolean(PARALLEL);
        boolean backParallel = true;
        if (selectRows > 0) {
            DynamicObject backSettleItem = (DynamicObject)((DynamicObject)subentryentity.get(selectRows - 1)).get("settleitem");
            backParallel = backSettleItem.getBoolean(PARALLEL);
        }
        if (!(!(paraValue = (Boolean)this.getModel().getValue(PARALLEL)).booleanValue() || parallel && backParallel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u6267\u884c\u9879\u548c\u4e0a\u4e00\u6b65\u4e0d\u80fd\u5e76\u884c\u3002", (String)"SchemeSettingPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(PARALLEL, (Object)Boolean.FALSE);
            this.getModel().setDataChanged(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
        holder.initSchemesList();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
        holder.setDefaultScheme();
        this.updatePeriodByCostAccount();
        this.getView().getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.schemeEntryKey);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Button defaultBtn = (Button)this.getView().getControl(BUTTONAP_KEY);
        defaultBtn.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{CALCPARAM});
        BasedataEdit settleitem = (BasedataEdit)this.getControl("settleitem");
        settleitem.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int rowNum = this.getModel().getEntryCurrentRowIndex("entryentity");
            String stepname = this.getModel().getEntryRowEntity("entryentity", rowNum).getString("stepname");
            QFilter qf = new QFilter("functype", "=", (Object)stepname);
            String appId = this.getView().getFormShowParameter().getAppId();
            if ("aca".equals(appId)) {
                qf.and(new QFilter("appnum", "!=", (Object)"sca"));
            } else if ("sca".equals(appId)) {
                qf.and(new QFilter("appnum", "!=", (Object)"aca"));
            }
            listShowParameter.getListFilterParameter().getQFilters().add(qf);
        });
        BasedataEdit costAccountEdit = (BasedataEdit)this.getControl("costaccount");
        costAccountEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            filters.add(SchemeSettingPlugin.getEnableQfilter(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
            List acctOrgs = OrgHelper.getCurrAccountOrg((String)this.getView().getModel().getDataEntityType().getName(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
                filters.add(QFilter.of((String)"1=0", (Object[])new Object[0]));
                return;
            }
            QFilter costAccountFilter = StartCostHelper.getEnabledCostAccountFilter((String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            costAccountFilter.and(new QFilter("calorg", "in", (Object)acctOrgs));
            filters.add(costAccountFilter);
        });
    }

    public static QFilter getEnableQfilter(String appNum) {
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{appNumQF, isEnabledFilter, enable};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        FormShowParameter showParameter = new FormShowParameter();
        switch (fieldKey) {
            case "buttonap": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.schemeEntryKey);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length < 1) {
                    return;
                }
                entryGrid.selectRows(selectRows[0]);
                break;
            }
            case "calcparam": {
                DynamicObject settleitem = (DynamicObject)this.getModel().getValue("settleitem");
                if (settleitem == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u6267\u884c\u9879\u3002", (String)"SchemeSettingPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                showParameter.setFormId(settleitem.getString("parampage"));
                showParameter.getCustomParams().put("defaultparam", this.getModel().getValue("defaultparam_tag"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.getCustomParams().put("settleitemnumber", settleitem.get("number"));
                if ("10".equals(this.getModel().getValue("stepname"))) {
                    DynamicObjectCollection costaccount = (DynamicObjectCollection)this.getModel().getValue("costaccount");
                    showParameter.getCustomParams().put("mulcostaccount", costaccount.size() > 1);
                }
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String defaultparam;
        super.closedCallBack(closedCallBackEvent);
        if (CALCPARAM.equals(closedCallBackEvent.getActionId()) && !CadEmptyUtils.isEmpty((String)(defaultparam = (String)closedCallBackEvent.getReturnData()))) {
            this.setCalcParam(defaultparam);
            this.getModel().setValue("defaultparam_tag", (Object)defaultparam);
        }
    }

    private void setCalcParam(String defaultparam) {
        if (CadEmptyUtils.isEmpty((String)defaultparam)) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)defaultparam, Map.class);
        String calcparainfo = (String)map.get("calcparainfo");
        if (CadEmptyUtils.isEmpty((String)calcparainfo)) {
            calcparainfo = ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"SchemeSettingPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        this.getModel().setValue(CALCPARAM, (Object)calcparainfo);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (event.getOperationResult() == null || !event.getOperationResult().isSuccess()) {
            return;
        }
        String opKey = event.getOperateKey();
        if (SAVE_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.saveScheme();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SchemeSettingPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        } else if (DELETE_SCHEME_OP_KEY.equals(opKey)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(this.schemeEntryKey)).getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"SchemeSettingPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                event.getOperationResult().setShowMessage(false);
                return;
            }
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.deleteScheme();
            this.getView().getPageCache().put("isDelete", "true");
        } else if (ADD_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.addScheme();
        } else if (RESET_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.resetScheme();
        }
    }

    public void entryRowClick(RowClickEvent e) {
        String key = ((EntryGrid)e.getSource()).getKey();
        if (this.schemeEntryKey.equals(key)) {
            boolean isClose;
            String lastRow = CadEmptyUtils.isEmpty((String)this.getPageCache().get("lastRow")) ? String.valueOf(0) : this.getPageCache().get("lastRow");
            this.getPageCache().put("lastRow", lastRow);
            int[] selectRows = ((EntryGrid)e.getSource()).getSelectRows();
            if (CadEmptyUtils.isEmpty((int[])selectRows)) {
                this.getPageCache().put("lastRow", "-1");
            }
            boolean isDataChange = this.getModel().getDataChanged();
            boolean isDelete = "true".equals(this.getView().getPageCache().get("isDelete"));
            if (isDelete) {
                this.getPageCache().remove("isDelete");
            }
            if (CadEmptyUtils.isEmpty((int[])selectRows) || !isDataChange || this.getPageCache().get("lastRow").equals(String.valueOf(selectRows[0])) || isDelete) {
                if ("switch".equals(this.getPageCache().get("dataSource"))) {
                    this.getPageCache().remove("dataSource");
                    return;
                }
                QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
                holder.setScheme(e.getRow());
                this.updatePeriodByCostAccount();
                if (!CadEmptyUtils.isEmpty((int[])selectRows)) {
                    this.getPageCache().put("lastRow", String.valueOf(selectRows[0]));
                }
                this.getView().getModel().setDataChanged(false);
                return;
            }
            if (!CadEmptyUtils.isEmpty((int[])selectRows) && isDataChange && !(isClose = "true".equals(this.getView().getPageCache().get("isclose")))) {
                this.getPageCache().put("nextRow", String.valueOf(selectRows[0]));
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SchemeSettingPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u5207\u6362", (String)"SchemeSettingPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("switch_" + e.getRow(), (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5207\u6362\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SchemeSettingPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, callBackListener, btnNameMaps);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        String callBackId = e.getCallBackId();
        if (callBackId.equals("close")) {
            boolean isClose = true;
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().getPageCache().put("isclose", String.valueOf(true));
                this.getView().close();
            } else if (MessageBoxResult.Cancel.equals((Object)result)) {
                isClose = false;
            }
            this.getView().getPageCache().put("isclose", String.valueOf(isClose));
        } else if (callBackId.startsWith("switch")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
                holder.setScheme(Integer.parseInt(this.getPageCache().get("nextRow")));
                this.getPageCache().put("lastRow", this.getPageCache().get("nextRow"));
                this.updatePeriodByCostAccount();
                this.getView().getModel().setDataChanged(false);
            } else {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.schemeEntryKey);
                entryGrid.selectRows(Integer.parseInt(this.getPageCache().get("lastRow")));
                this.getPageCache().put("dataSource", "switch");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean isDataChange = this.getModel().getDataChanged();
        boolean isClose = "true".equals(this.getView().getPageCache().get("isclose"));
        if (isDataChange && !isClose) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SchemeSettingPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SchemeSettingPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("close", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SchemeSettingPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, callBackListener, btnNameMaps);
            e.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("btn_addconfig".equals(operateKey)) {
            int rowNum = this.getModel().getEntryCurrentRowIndex("entryentity");
            String stepname = this.getModel().getEntryRowEntity("entryentity", rowNum).getString("stepname");
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex("entryentity", rowNum);
            int subRow = entryOperate.createNewEntryRow("subentryentity");
            this.getModel().setValue("functype", (Object)stepname, subRow, rowNum);
            this.getView().updateView("subentryentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = lsp.getListFilterParameter().getQFilters();
        if ("costaccount".equals(name)) {
            QFilter appnumFilter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
            DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])new QFilter[]{appnumFilter});
            if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
                Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
                qFilters.add(new QFilter("id", "in", costAccountIdList));
            } else {
                qFilters.add(new QFilter("id", "=", (Object)0));
            }
        }
    }
}

