/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.settle;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class SettleItemEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(SettleItemEditPlugin.class);
    private static final String CALCPARAM = "calcparam";
    private static final String PRE_CONDITION = "precondition";

    public void propertyChanged(PropertyChangedArgs e) {
        String method;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("method".equals(propertyName) && "oper".equals(method = (String)this.getModel().getValue("method"))) {
            this.getModel().setValue("parampage", (Object)"cad_settleoperation");
        }
    }

    public void afterBindData(EventObject e) {
        this.deleteTextClearButton(PRE_CONDITION);
        this.deleteTextClearButton(CALCPARAM);
        super.afterBindData(e);
        Boolean mannulconfirm = (Boolean)this.getModel().getValue("mannulconfirm");
        if (mannulconfirm.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mannulconfirm"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        this.getModel().setValue("appnum", (Object)appId);
        String defaultparam = (String)this.getModel().getValue("defaultparam_tag");
        if (!CadEmptyUtils.isEmpty((String)defaultparam)) {
            this.setCalcParam(defaultparam);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CALCPARAM});
        this.addClickListeners(new String[]{PRE_CONDITION});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if (CALCPARAM.equals(fieldKey) || PRE_CONDITION.equals(fieldKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(String.valueOf(this.getModel().getValue("parampage")));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put("defaultparam", this.getModel().getValue("defaultparam_tag"));
            showParameter.getCustomParams().put("settleitemnumber", this.getModel().getValue("number"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
            try {
                this.getView().showForm(showParameter);
            }
            catch (Exception e) {
                logger.info("SettleItemEditPlugin -> click -> ", (Object)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u53c2\u6570\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"SettleItemEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String defaultparam;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ((CALCPARAM.equals(actionId) || PRE_CONDITION.equals(actionId)) && !CadEmptyUtils.isEmpty((String)(defaultparam = (String)closedCallBackEvent.getReturnData()))) {
            this.setCalcParam(defaultparam);
            this.getModel().setValue("defaultparam_tag", (Object)defaultparam);
        }
    }

    private void setCalcParam(String defaultparam) {
        String method;
        if (CadEmptyUtils.isEmpty((String)defaultparam)) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)defaultparam, Map.class);
        String calcparainfo = (String)map.get("calcparainfo");
        if (CadEmptyUtils.isEmpty((String)calcparainfo)) {
            calcparainfo = ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"SettleItemEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        }
        if ("oper".equals(method = (String)this.getModel().getValue("method"))) {
            this.getModel().setValue(PRE_CONDITION, (Object)calcparainfo);
        } else {
            this.getModel().setValue(CALCPARAM, (Object)calcparainfo);
        }
        this.getView().getModel().setDataChanged(false);
    }

    private void deleteTextClearButton(String buttonKey) {
        HashMap<String, Boolean> editor = new HashMap<String, Boolean>();
        HashMap<String, HashMap<String, Boolean>> item = new HashMap<String, HashMap<String, Boolean>>();
        editor.put("showClearButton", false);
        item.put("item", editor);
        this.getView().updateControlMetadata(buttonKey, item);
    }
}

