/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.settle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.iep.info.DynamicParamModel;
import kd.fi.iep.info.ParamEntry;
import kd.macc.cad.business.strategy.IColsSelectStrategy;
import kd.macc.cad.business.strategy.MetaHelper;
import kd.macc.cad.business.strategy.SelectParams;
import kd.macc.cad.business.strategy.TypeSelectStrategy;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.utils.IntellExecSchemaUtil;

public class SettleOperationPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(SettleOperationPlugin.class);
    protected static final List<String> unLimitFields = new ArrayList<String>(5);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        this.addClickListeners(new String[]{"org", "costaccount", "bookdate"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName() == null) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "bussiness": {
                String bussiness = (String)this.getModel().getValue("bussiness_id");
                if (bussiness == null) {
                    return;
                }
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
                filterGrid.SetValue(new FilterCondition());
                this.getView().updateView("filtergridap");
                IntellExecSchemaUtil.setOperComboListOperByData(bussiness, this.getView());
                break;
            }
            case "oper": {
                String number1 = (String)this.getModel().getValue("bussiness_id");
                String oper = (String)e.getChangeSet()[0].getNewValue();
                if (!Objects.nonNull(oper)) break;
                this.initFilterCondition(number1, number1, "add", oper);
                this.showOperParam(true);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean hideflag = (Boolean)this.getView().getFormShowParameter().getCustomParam("hideflag");
        if (hideflag != null && hideflag.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", "btnok"});
        }
    }

    private void showOperParam(boolean isPropertyChanged) {
        Object paramObj;
        Object bussiness = this.getModel().getValue("bussiness_id");
        Object oper = this.getModel().getValue("oper");
        String defaultparam = (String)this.getView().getFormShowParameter().getCustomParam("defaultparam");
        if (CadEmptyUtils.isEmpty((String)defaultparam)) {
            return;
        }
        Map initData = (Map)SerializationUtils.fromJsonString((String)defaultparam, Map.class);
        Map paramVal = null;
        if (initData != null && (paramObj = initData.get("param")) != null) {
            paramVal = (Map)initData.get("param");
        }
        if (bussiness != null) {
            QFilter[] qf = new QFilter[]{new QFilter("bizapp", "=", (Object)AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId()), new QFilter("bussiness", "=", bussiness), new QFilter("oper", "=", oper)};
            List<DynamicParamModel> params = IntellExecSchemaUtil.getParamList(qf);
            FormShowParameter para = new FormShowParameter();
            if (params.size() > 0) {
                DynamicParamModel model = params.get(0);
                if (paramVal != null && paramVal.size() > 0) {
                    String key = model.getUniqueKey();
                    List allParams = model.getParams();
                    for (ParamEntry each : allParams) {
                        Object val = paramVal.get(key + each.getNumber());
                        if (val == null) continue;
                        each.setParamval(val.toString());
                    }
                }
                para.setFormId("gl_intellfoper_param");
                para.getOpenStyle().setTargetKey("flexpanelparam");
                para.getOpenStyle().setShowType(ShowType.InContainer);
                para.setCustomParam("operParam", (Object)SerializationUtils.toJsonString((Object)model));
                this.getView().showForm(para);
            } else {
                para.setFormId("gl_intellfoper_param");
                para.getOpenStyle().setTargetKey("flexpanelparam");
                para.getOpenStyle().setShowType(ShowType.InContainer);
                para.setCustomParam("operParam", (Object)SerializationUtils.toJsonString((Object)new DynamicParamModel()));
                this.getView().showForm(para);
            }
            this.getPageCache().put("paramPageId", para.getPageId());
        }
    }

    private void initFilterCondition(String formNumber, String entityNumber, String viewStatus, String oper) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        List<Object> filterColumns = new ArrayList();
        if (formNumber != null && !"".equals(formNumber.trim())) {
            filterColumns = this.getAvailFilterColumns(formNumber, entityNumber);
        }
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        this.setDefaultFilter(filterGrid, oper);
        if (this.isBillEntryTypeByFormID(formNumber) && "add".equals(viewStatus)) {
            FilterCondition filterCondition;
            boolean isExistStatusField;
            String billStatusField = this.getBillStatusField(formNumber);
            List fieldNames = filterColumns.stream().map(v -> (String)v.get("fieldName")).collect(Collectors.toList());
            if (Objects.nonNull(billStatusField) && fieldNames.contains(billStatusField) && !(isExistStatusField = (filterCondition = filterGrid.getFilterGridState().getFilterCondition()).getFilterRow().stream().anyMatch(v -> billStatusField.equals(v.getFieldName())))) {
                this.setBillStatusFilter(filterGrid, billStatusField);
            }
        }
        this.getView().updateView("filtergridap");
    }

    private void setBillStatusFilter(FilterGrid filterGrid, String billStatusField) {
        SimpleFilterRow billStatusFilter = new SimpleFilterRow();
        billStatusFilter.setFieldName(billStatusField);
        billStatusFilter.setCompareType("105");
        ArrayList<FilterValue> values = new ArrayList<FilterValue>(10);
        FilterValue filterValue = new FilterValue();
        String oper = (String)this.getModel().getValue("oper");
        filterValue.setValue((Object)"A");
        if ("audit".equals(oper)) {
            filterValue.setValue((Object)"B");
        }
        if ("generatevoucher".equals(oper)) {
            filterValue.setValue((Object)"C");
        }
        values.add(filterValue);
        billStatusFilter.setValue(values);
        billStatusFilter.setLeftBracket("");
        billStatusFilter.setRightBracket("");
        billStatusFilter.setLogic("0");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        filterCondition.getFilterRow().add(billStatusFilter);
        filterGrid.SetValue(filterCondition);
    }

    private String getBillStatusField(String formId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        if (type.getClass().getSimpleName().equals("BillEntityType")) {
            return ((BillEntityType)type).getBillStatus();
        }
        return "";
    }

    private boolean isBillEntryTypeByFormID(String formId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        return Objects.nonNull(type) && type.getClass().getSimpleName().equals("BillEntityType");
    }

    private void setDefaultFilter(FilterGrid filterGrid, String oper) {
        String appId = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getId();
        String formNumber = (String)this.getModel().getValue("bussiness_id");
        Integer hash = DynamicParamModel.getUniqueKey((String)appId, (String)formNumber, (String)oper).hashCode();
        try (DataSet filterDataSet = QueryServiceHelper.queryDataSet((String)"gl.intelaccounting.filter", (String)"gl_intelloper_filter", (String)"bussiness,hash,datafilter_tag", (QFilter[])new QFilter[]{new QFilter("hash", "in", (Object)hash)}, null);){
            for (Row r : filterDataSet) {
                FilterCondition filter = this.getFilter(r.getString("datafilter_tag"));
                filterGrid.SetValue(filter);
            }
        }
    }

    private FilterCondition getFilter(String filter) {
        if (kd.bos.util.StringUtils.isEmpty((String)filter)) {
            return null;
        }
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)filter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>(1);
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        return (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
    }

    private List<Map<String, Object>> getAvailFilterColumns(String formNumber, String entityNumber) {
        Map<String, Object> fields = this.getListFilter(formNumber);
        List<Map<String, Object>> filterColumns = this.getAllFilterColumns(entityNumber);
        this.filterColumnList(filterColumns, fields);
        return filterColumns;
    }

    private List<Map<String, Object>> getAllFilterColumns(String bussValue) {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)bussValue);
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        return filterColumns;
    }

    private void filterColumnList(List<Map<String, Object>> filterColumns, Map<String, Object> fields) {
        Iterator<Map<String, Object>> iter = filterColumns.iterator();
        Set<String> filterSet = fields.keySet();
        Object fieldName = null;
        while (iter.hasNext()) {
            Map<String, Object> column = iter.next();
            fieldName = column.get("fieldName");
            if (!filterSet.contains(fieldName)) {
                iter.remove();
                continue;
            }
            column.put("fieldCaption", fields.get(fieldName));
        }
    }

    private Map<String, Object> getListFilter(String formId) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        Map filterMeta = FormMetadataCache.getFilterMeta((String)formId);
        if (CadEmptyUtils.isEmpty((Map)filterMeta)) {
            return fields;
        }
        Map filterContainer = (Map)SerializationUtils.fromJsonString((String)((String)filterMeta.get("FilterContainer")), Map.class);
        ArrayList itemsParent = (ArrayList)filterContainer.get("Items");
        if (itemsParent == null) {
            return fields;
        }
        for (Map itemMap : itemsParent) {
            ArrayList items = (ArrayList)itemMap.get("Items");
            if (items == null) continue;
            for (Map item : items) {
                fields.put((String)item.get("FieldName"), ((Map)item.get("Caption")).get(Lang.get().toString()));
            }
        }
        return fields;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "org": {
                this.getPageCache().put("dataType", "org");
                this.clickSourceBillField();
                break;
            }
            case "costaccount": {
                this.getPageCache().put("dataType", "costaccount");
                this.clickSourceBillField();
                break;
            }
            case "bookdate": {
                this.getPageCache().put("dataType", "bizdate");
                this.clickSourceBillField();
                break;
            }
            case "btnok": {
                this.returnDataToParentAndClose();
                break;
            }
            case "btncancel": {
                this.getView().close();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String oper = (String)showParam.getCustomParam("oper");
        String defaultparam = (String)showParam.getCustomParam("defaultparam");
        if (CadEmptyUtils.isEmpty((String)defaultparam)) {
            return;
        }
        IDataModel model = this.getModel();
        Map oldData = (Map)SerializationUtils.fromJsonString((String)defaultparam, Map.class);
        Object bussiness = oldData.get("bussiness");
        if (StringUtils.isNotBlank(bussiness)) {
            model.setValue("bussiness", bussiness);
            model.setValue("org", oldData.get("org"));
            model.setValue("costaccount", oldData.get("costaccount"));
            model.setValue("bookdate", oldData.get("bookdate"));
            String os = bussiness.toString();
            String entityNumber = IntellExecSchemaUtil.setOperComboByData(os, this.getView());
            this.initFilterCondition(os, entityNumber, oper, null);
            Object opernumber = oldData.get("oper");
            if ("buildvoucher".equals(opernumber)) {
                List ops = EntityMetadataCache.getDataEntityOperate((String)bussiness.toString());
                for (Map operMpas : ops) {
                    String type = operMpas.get("type").toString();
                    if (!"generatevoucher".equals(type)) continue;
                    opernumber = "generatevoucher";
                }
            }
            model.setValue("oper", opernumber);
            model.setValue("remark", oldData.get("remark"));
            this.getView().updateView("org");
            Object datafilter = oldData.get("datafilter");
            if (StringUtils.isNotBlank(datafilter)) {
                this.setDataFilter(datafilter.toString());
            }
        }
        this.showOperParam(false);
    }

    private void setDataFilter(String dataFilter) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filterGridap");
        filterGrid.SetValue(filterCondition);
        filterGrid.getFilterGridState().setState(filterCondition);
    }

    private void returnDataToParentAndClose() {
        HashMap<String, Object> operaMap = new HashMap<String, Object>();
        operaMap.put("bussiness", this.getModel().getValue("bussiness_id"));
        operaMap.put("oper", this.getModel().getValue("oper"));
        operaMap.put("remark", this.getModel().getValue("remark"));
        operaMap.put("org", this.getModel().getValue("org"));
        operaMap.put("costaccount", this.getModel().getValue("costaccount"));
        operaMap.put("bookdate", this.getModel().getValue("bookdate"));
        if (!CadEmptyUtils.isEmpty(operaMap)) {
            if (StringUtils.isBlank(operaMap.get("bussiness"))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleOperationPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank(operaMap.get("oper"))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleOperationPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        DynamicObject bussiness = (DynamicObject)this.getModel().getValue("bussiness");
        Map operValueMap = this.getView().getPageCache().getAll();
        String operValue = "";
        if (!CadEmptyUtils.isEmpty((Map)operValueMap)) {
            operValue = (String)operValueMap.get(this.getModel().getValue("oper"));
        }
        operaMap.put("calcparainfo", String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\uff1a%1$s\uff0c\u6267\u884c\u64cd\u4f5c\uff1a%2$s", (String)"SettleOperationPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), bussiness.getString("name"), operValue));
        this.getDataFilter(operaMap);
        String filterString = SerializationUtils.toJsonString(operaMap);
        this.getView().returnDataToParent((Object)filterString);
        this.getView().close();
    }

    private void getDataFilter(Map<String, Object> operaMap) {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filterGridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        if (filteList == null || filteList.isEmpty()) {
            return;
        }
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        operaMap.put("datafilter", filterJson);
    }

    protected void clickSourceBillField() {
        IDataModel model = this.getModel();
        DynamicObject bussiness = (DynamicObject)model.getValue("bussiness");
        if (bussiness == null) {
            String tips = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"SettleOperationPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
        } else {
            String sourceBillNumber = bussiness.getString("number");
            String prop = this.getPageCache().get("dataType");
            String existFieldStr = "";
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"aca_matalloc");
            IDataEntityProperty property = dataEntityType.findProperty(prop);
            TypeSelectStrategy typeSelectStrategy = new TypeSelectStrategy(property);
            if (unLimitFields.contains(prop)) {
                typeSelectStrategy.setUnLimitBaseData(true);
            }
            if (prop != null && prop.equals("matnum")) {
                typeSelectStrategy.setUnLimitFieldName("material");
            }
            String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010%s\u3011\u7684\u6620\u5c04\u5b57\u6bb5", (String)"SettleOperationPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), "a");
            SelectParams params = new SelectParams();
            MetaHelper metaHelper = new MetaHelper((IColsSelectStrategy)typeSelectStrategy, sourceBillNumber);
            String jsonTree = metaHelper.buildTree2JSON();
            params.setJsonTree(jsonTree);
            FormShowParameter fp = this.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, "billFieldNameCol"));
            if (StringUtils.isNotEmpty((CharSequence)caption)) {
                fp.setCaption(caption);
            }
            this.getView().showForm(fp);
        }
    }

    protected FormShowParameter readyColsTreePage(SelectParams params, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String closeKey = e.getActionId();
        JSONArray data = this.parseReturnData(e);
        if (data != null && data.size() > 0) {
            JSONObject info = data.getJSONObject(0);
            if (!data.isEmpty() && "billFieldNameCol".equals(closeKey)) {
                String dataType = this.getPageCache().get("dataType");
                if ("bizdate".equals(dataType)) {
                    dataType = "bookdate";
                }
                this.getModel().setValue(dataType, (Object)info.getString("id"));
                this.getView().updateView(dataType);
            }
        }
    }

    protected JSONArray parseReturnData(ClosedCallBackEvent evt) {
        Object data = evt.getReturnData();
        try {
            return JSON.parseArray((String)((String)data));
        }
        catch (Exception var3) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a%1$s \u53c2\u6570\uff1a%2$s", (String)"SettleOperationPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), var3.getMessage(), data));
        }
    }
}

