/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.settle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.settle.CalcSettleEngine;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.InstanceAliveHelper;
import org.apache.commons.lang3.StringUtils;

public class SettleReportEditPlugin
extends AbstractFormPlugin
implements CountDownListener {
    protected static final Log logger = LogFactory.getLog(SettleReportEditPlugin.class);
    private static final String CALC_PROGRESSBAR = "progressbarap";
    private static final String CALC_COUNTDOWN = "countdownap";
    private static final String BTN_AUTOREFRESH = "bar_closeautorefresh";
    private static final String CACHE_CURRENTPERIOD = "cache_currentperiod";
    private static final Long RESTORE_CALC_TASKID = 1830522918912868352L;
    private static final String RESTORE_CLOSE_CONFIRM = "sca_restoretaskrunning-exitcalc";
    private static final String CALCPARAM = "calcparam";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("subentryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            String status = this.getModel().getDataEntity().getString("status");
            String substatus = pkEvent.getRowData().getString("substatus");
            boolean confirm = pkEvent.getRowData().getBoolean("confirm");
            String exemethod = pkEvent.getRowData().getString("exemethod");
            String jumpParam = pkEvent.getRowData().getString("jumpparam_tag");
            boolean curPeriod = this.isCurrentPeriod();
            DynamicObject settleitemDyn = pkEvent.getRowData().getDynamicObject("settleitem");
            Long settleId = 0L;
            if (settleitemDyn != null) {
                settleId = settleitemDyn.getLong("id");
            }
            if (pkEvent.getSource() instanceof OperationColumn && ("operatecolunm".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey()) || "executereport".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey()))) {
                List operationColItems = (List)pkEvent.getFormatValue();
                CalcSettleResult settleResult = null;
                if (!StringUtils.isEmpty((CharSequence)jumpParam)) {
                    try {
                        settleResult = (CalcSettleResult)JSON.parseObject((String)jumpParam, CalcSettleResult.class);
                    }
                    catch (Exception ex) {
                        logger.error("{}\u8f6c\u6362json\u62a5\u9519:", (Object)jumpParam, (Object)ex);
                    }
                }
                for (OperationColItem operationColItem : operationColItems) {
                    boolean confirmView;
                    if ("confirm".equalsIgnoreCase(operationColItem.getOperationKey())) {
                        confirmView = false;
                        if (!confirm && curPeriod && !CalcSettleEnum.SETTLESTATUS_ABORT.getValue().equals(status)) {
                            if (CalcSettleEnum.SETTLESUB_WARN.getValue().equals(substatus) && CalcSettleEnum.EXECUTE_SUCCNEXT.getValue().equals(exemethod)) {
                                confirmView = true;
                            }
                            if (CalcSettleEnum.SETTLESUB_CONFIRM.getValue().equals(substatus)) {
                                confirmView = true;
                            }
                            if (CalcSettleEnum.SETTLESUB_FAIL.getValue().equals(substatus)) {
                                confirmView = true;
                            }
                        }
                        operationColItem.setVisible(confirmView);
                    }
                    if ("recalc".equalsIgnoreCase(operationColItem.getOperationKey())) {
                        confirmView = false;
                        if (!confirm && curPeriod && !CalcSettleEnum.SETTLESTATUS_ABORT.getValue().equals(status) && CalcSettleEnum.SETTLESUB_FAIL.getValue().equals(substatus)) {
                            confirmView = true;
                        }
                        operationColItem.setVisible(confirmView);
                    }
                    if ("cancel".equalsIgnoreCase(operationColItem.getOperationKey())) {
                        confirmView = false;
                        if (curPeriod) {
                            Long taskRecordId;
                            if (CalcSettleEnum.SETTLESUB_WAIT.getValue().equals(substatus)) {
                                confirmView = true;
                            }
                            if (CalcSettleEnum.SETTLESUB_RUN.getValue().equals(substatus) && settleId.equals(RESTORE_CALC_TASKID) && !CadEmptyUtils.isEmpty((Long)(taskRecordId = this.getTaskRecordId(jumpParam)))) {
                                confirmView = true;
                                operationColItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u505c\u6b62\u8ba1\u7b97", (String)"SettleReportEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0])));
                            }
                        }
                        operationColItem.setVisible(confirmView);
                    }
                    if (settleResult == null || CadEmptyUtils.isEmpty((List)settleResult.getJumpPages()) || !operationColItem.getOperationKey().startsWith("link")) continue;
                    this.showLink(settleResult, operationColItem, this.getIndex(operationColItem.getOperationKey()));
                }
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTN_AUTOREFRESH.equals(evt.getItemKey())) {
            CountDown countdown = (CountDown)this.getView().getControl(CALC_COUNTDOWN);
            countdown.pause();
            if ("true".equals(this.getPageCache().get(BTN_AUTOREFRESH))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u81ea\u52a8\u5237\u65b0\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4", (String)"SettleReportEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            } else {
                this.getPageCache().put(BTN_AUTOREFRESH, "true");
            }
        }
    }

    public void afterBindData(EventObject e) {
        String autorefresh;
        super.afterBindData(e);
        DynamicObject modelDyn = this.getModel().getDataEntity();
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        String currstep = modelDyn.getString("currstep");
        int index = 0;
        DynamicObjectCollection funcTypeDyns = modelDyn.getDynamicObjectCollection("entryentity");
        this.setCalcParams(funcTypeDyns);
        if (!StringUtils.isEmpty((CharSequence)currstep)) {
            for (int i = 0; i < funcTypeDyns.size(); ++i) {
                if (!StringUtils.equals((CharSequence)((DynamicObject)funcTypeDyns.get(i)).getString("functype"), (CharSequence)currstep)) continue;
                index = i;
                break;
            }
        } else {
            int progress = modelDyn.getInt("progress");
            if (progress == 100) {
                index = funcTypeDyns.size() - 1;
            }
        }
        cardEntry.selectRows(new int[]{index}, index);
        ProgressBar bar = (ProgressBar)this.getView().getControl(CALC_PROGRESSBAR);
        bar.setPercent(modelDyn.getInt("progress"));
        boolean isAutoFreshView = false;
        if (this.isHasRunningTask(true) && StringUtils.isEmpty((CharSequence)(autorefresh = this.getPageCache().get(BTN_AUTOREFRESH)))) {
            isAutoFreshView = true;
            CountDown countdown = (CountDown)this.getView().getControl(CALC_COUNTDOWN);
            countdown.setDuration(5);
            countdown.start();
        }
        this.getView().setVisible(Boolean.valueOf(isAutoFreshView), new String[]{BTN_AUTOREFRESH, CALC_COUNTDOWN});
        if (this.isHasRunningTask(false)) {
            this.judgeInstanceAlive();
        }
    }

    private void setCalcParams(DynamicObjectCollection funcTypeDyns) {
        if (!funcTypeDyns.isEmpty()) {
            for (int i = 0; i < funcTypeDyns.size(); ++i) {
                DynamicObjectCollection subentryentity = ((DynamicObject)funcTypeDyns.get(i)).getDynamicObjectCollection("subentryentity");
                for (DynamicObject dynamicObject : subentryentity) {
                    String defaultparam = dynamicObject.getString("defaultparam_tag");
                    if (CadEmptyUtils.isEmpty((String)defaultparam)) continue;
                    if (CadEmptyUtils.isEmpty((String)defaultparam)) {
                        return;
                    }
                    Map map = (Map)SerializationUtils.fromJsonString((String)defaultparam, Map.class);
                    String calcparainfo = (String)map.get("calcparainfo");
                    if (CadEmptyUtils.isEmpty((String)calcparainfo)) {
                        calcparainfo = ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"SettleReportEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    }
                    dynamicObject.set(CALCPARAM, (Object)calcparainfo);
                    this.getView().getModel().setDataChanged(false);
                }
            }
        }
    }

    private boolean isCurrentPeriod() {
        DynamicObject modelDyn = this.getModel().getDataEntity();
        if (this.getPageCache().get(CACHE_CURRENTPERIOD) == null) {
            Long costaccountId = modelDyn.getLong("costaccount.id");
            DynamicObject periodDyn = PeriodHelper.getCurrentPeriod((Long)costaccountId);
            if (periodDyn != null && modelDyn.getLong("period.id") == periodDyn.getLong("id")) {
                this.getPageCache().put(CACHE_CURRENTPERIOD, "true");
                return true;
            }
            this.getPageCache().put(CACHE_CURRENTPERIOD, "false");
            return false;
        }
        return "true".equals(this.getPageCache().get(CACHE_CURRENTPERIOD));
    }

    private boolean isHasRunningTask(boolean containWait) {
        DynamicObjectCollection funcTypeDyns = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject funcDyn : funcTypeDyns) {
            DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taskDyn : taskDyns) {
                String substatus = taskDyn.getString("substatus");
                if (CalcSettleEnum.SETTLESUB_RUN.getValue().equals(substatus)) {
                    return true;
                }
                if (!containWait || !CalcSettleEnum.SETTLESUB_WAIT.getValue().equals(substatus)) continue;
                return true;
            }
        }
        return false;
    }

    private void judgeInstanceAlive() {
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObjectCollection funcTypeDyns = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject funcDyn : funcTypeDyns) {
            DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taskDyn : taskDyns) {
                DynamicObject item;
                boolean isAlive;
                String instanceId;
                String substatus = taskDyn.getString("substatus");
                if (!CalcSettleEnum.SETTLESTATUS_RUN.getValue().equals(substatus) || StringUtils.isEmpty((CharSequence)(instanceId = taskDyn.getString("instanceid"))) || (isAlive = InstanceAliveHelper.isAlive((String)instanceId))) continue;
                CalcSettleResult execResult = new CalcSettleResult();
                execResult.setConfirm(false);
                execResult.setStatus(CalcSettleEnum.SETTLESUB_FAIL.getValue());
                execResult.setRemark(ResManager.loadKDString((String)"\u670d\u52a1\u5f02\u5e38\u91cd\u542f\uff0c\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"SettleReportEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                Long taskId = taskDyn.getLong("id");
                CalcSettleEngine.dispatchTask((Long)this.getModel().getDataEntity().getLong("id"), (Long)taskId, (String)CalcSettleEnum.SETTLE_INTYPE_NEXT.getValue(), (CalcSettleResult)execResult);
                if (msgBuilder.length() > 0) {
                    msgBuilder.append(",");
                }
                if ((item = taskDyn.getDynamicObject("settleitem")) == null) continue;
                msgBuilder.append(item.getString("name"));
            }
        }
        if (msgBuilder.length() > 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u9879\uff1a%s\uff0c\u670d\u52a1\u5f02\u5e38\u91cd\u542f\uff0c\u8bbe\u7f6e\u6267\u884c\u9879\u6267\u884c\u72b6\u6001\u4e3a\u5931\u8d25\u3002", (String)"SettleReportEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), msgBuilder.toString()));
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        Long reportId = this.getModel().getDataEntity().getLong("id");
        String curPeriodMsg = ResManager.loadKDString((String)"\u975e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"SettleReportEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        switch (operateKey) {
            case "confirm": {
                if (!this.isCurrentPeriod()) {
                    this.getView().showErrorNotification(curPeriodMsg);
                    return;
                }
                this.confirmOperate(this.getCurTaskRow(), reportId);
                break;
            }
            case "recalc": {
                if (!this.isCurrentPeriod()) {
                    this.getView().showErrorNotification(curPeriodMsg);
                    return;
                }
                this.reCalcOperate(this.getCurTaskRow(), reportId);
                break;
            }
            case "cancel": {
                if (!this.isCurrentPeriod()) {
                    this.getView().showErrorNotification(curPeriodMsg);
                    return;
                }
                this.cancelCalcOperate(this.getCurTaskRow(), reportId);
                break;
            }
            case "abortcalc": 
            case "dofailclass": 
            case "dofailitem": {
                if (args.getOperationResult().isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"SettleReportEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
            }
        }
        if (operateKey.startsWith("link")) {
            this.openLink(this.getCurTaskRow(), this.getIndex(operateKey));
        }
    }

    private int getIndex(String key) {
        try {
            key = key.replace("link", "");
            int index = Integer.parseInt(key);
            if (index < 0) {
                return -1;
            }
            return index - 1;
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6index\u62a5\u9519", (Throwable)ex);
            return -1;
        }
    }

    private DynamicObject getCurTaskRow() {
        DynamicObject functypeDyn;
        DynamicObjectCollection taskDyns;
        int funcIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        int taskIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        DynamicObjectCollection dynCols = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        if (dynCols.size() > funcIndex && (taskDyns = (functypeDyn = (DynamicObject)dynCols.get(funcIndex)).getDynamicObjectCollection("subentryentity")).size() > taskIndex) {
            return (DynamicObject)taskDyns.get(taskIndex);
        }
        return null;
    }

    private void confirmOperate(DynamicObject taskDyn, Long reportId) {
        if (taskDyn == null) {
            return;
        }
        CalcSettleResult execResult = new CalcSettleResult();
        execResult.setConfirm(true);
        execResult.setStatus(CalcSettleEnum.SETTLESTATUS_SUCC.getValue());
        Long taskId = taskDyn.getLong("id");
        CalcSettleEngine.dispatchTask((Long)reportId, (Long)taskId, (String)CalcSettleEnum.SETTLE_INTYPE_NEXT.getValue(), (CalcSettleResult)execResult);
        this.getView().invokeOperation("refresh");
    }

    private void reCalcOperate(DynamicObject taskDyn, Long reportId) {
        if (taskDyn == null) {
            return;
        }
        Long taskId = taskDyn.getLong("id");
        try {
            CalcSettleEngine.dispatchTask((Long)reportId, (Long)taskId, (String)CalcSettleEnum.SETTLE_INTYPE_RUNERREXEC.getValue(), null);
        }
        catch (Exception ex) {
            logger.error("\u53d6\u6d88\u64cd\u4f5c\u5931\u8d25\uff1a", (Throwable)ex);
            String info = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"SettleReportEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(info + ex.getMessage());
        }
        this.getView().invokeOperation("refresh");
    }

    private void cancelCalcOperate(DynamicObject taskDyn, Long reportId) {
        if (taskDyn == null) {
            return;
        }
        Long taskId = taskDyn.getLong("id");
        DynamicObject settleitemDyn = taskDyn.getDynamicObject("settleitem");
        Long settleId = 0L;
        if (settleitemDyn != null) {
            settleId = settleitemDyn.getLong("id");
        }
        if (CalcSettleEnum.SETTLESUB_RUN.getValue().equals(taskDyn.getString("substatus")) && settleId.equals(RESTORE_CALC_TASKID)) {
            String jumpParam = taskDyn.getString("jumpparam_tag");
            Long taskRecordId = this.getTaskRecordId(jumpParam);
            if (!CadEmptyUtils.isEmpty((Long)taskRecordId)) {
                this.getPageCache().put("taskRecordId", String.valueOf(taskRecordId));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d1\u8d77\u505c\u6b62\u8ba1\u7b97\u540e\uff0c\u4f1a\u5728\u5f53\u524d\u5b50\u9879\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u540e\uff0c\u505c\u6b62\u540e\u7eed\u8fd0\u884c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SettleReportEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RESTORE_CLOSE_CONFIRM));
            }
        } else {
            CalcSettleEngine.dispatchTask((Long)reportId, (Long)taskId, (String)CalcSettleEnum.SETTLE_INTYPE_CANCELRUN.getValue(), null);
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (RESTORE_CLOSE_CONFIRM.equals(callBackId)) {
            DynamicObject taskRecord;
            String taskRecordId;
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes.getValue() == result.getValue() && !CadEmptyUtils.isEmpty((String)(taskRecordId = this.getPageCache().get("taskRecordId"))) && (taskRecord = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(taskRecordId), (String)"sca_taskrecord", (String)"id,taskname,progress,status")) != null) {
                String taskstatus = taskRecord.getString("status");
                if ("6".equals(taskstatus)) {
                    return;
                }
                if ("2".equals(taskstatus) || "1".equals(taskstatus)) {
                    taskRecord.set("status", (Object)"6");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskRecord});
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5728\u6267\u884c\u4e2d\u72b6\u6001\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"SettleReportEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private Long getTaskRecordId(String jumpParam) {
        CalcSettleResult settleResult = null;
        if (!StringUtils.isEmpty((CharSequence)jumpParam)) {
            try {
                settleResult = (CalcSettleResult)JSON.parseObject((String)jumpParam, CalcSettleResult.class);
            }
            catch (Exception ex) {
                logger.error("{}\u8f6c\u6362json\u62a5\u9519:", (Object)jumpParam, (Object)ex);
            }
        }
        if (settleResult == null || CadEmptyUtils.isEmpty((List)settleResult.getJumpPages())) {
            return 0L;
        }
        if (!StringUtils.isEmpty((CharSequence)settleResult.getRemarkTag())) {
            try {
                JSONObject jsonObj = JSON.parseObject((String)settleResult.getRemarkTag());
                if (jsonObj != null && jsonObj.containsKey((Object)"taskRecordId")) {
                    return jsonObj.getLong("taskRecordId");
                }
            }
            catch (Exception ex) {
                logger.error("{}\u8f6c\u6362json\u62a5\u9519:", (Object)jumpParam, (Object)ex);
            }
        }
        return 0L;
    }

    private void showLink(CalcSettleResult settleResult, OperationColItem operationColItem, int index) {
        if (index < 0) {
            return;
        }
        if (settleResult.getJumpPages().size() > index && settleResult.getJumpPages().get(index) != null) {
            SettleJumpPage jumpPage = (SettleJumpPage)settleResult.getJumpPages().get(index);
            operationColItem.setOperationName(new LocaleString(jumpPage.getName()));
            operationColItem.setVisible(true);
        }
    }

    private void openLink(DynamicObject taskDyn, int openIndex) {
        if (taskDyn == null) {
            return;
        }
        if (openIndex < 0) {
            return;
        }
        String jumpParam = taskDyn.getString("jumpparam_tag");
        CalcSettleResult settleResult = null;
        if (!StringUtils.isEmpty((CharSequence)jumpParam)) {
            try {
                settleResult = (CalcSettleResult)JSON.parseObject((String)jumpParam, CalcSettleResult.class);
            }
            catch (Exception ex) {
                logger.error("{}\u8f6c\u6362json\u62a5\u9519:", (Object)jumpParam, (Object)ex);
            }
        }
        if (settleResult == null || CadEmptyUtils.isEmpty((List)settleResult.getJumpPages())) {
            return;
        }
        if (settleResult.getJumpPages().size() <= openIndex || settleResult.getJumpPages().get(openIndex) == null) {
            return;
        }
        SettleJumpPage jumpPage = (SettleJumpPage)settleResult.getJumpPages().get(openIndex);
        if (CalcSettleEnum.OPTYPE_LIST.getValue().equals(jumpPage.getOpenType())) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(jumpPage.getSourcepage());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("bos_list");
            parameter.setCaption(jumpPage.getName());
            ListFilterParameter filterParam = new ListFilterParameter();
            if (!CadEmptyUtils.isEmpty((Map)jumpPage.getParam())) {
                for (Map.Entry param : jumpPage.getParam().entrySet()) {
                    parameter.getCustomParams().put(param.getKey(), param.getValue());
                }
            }
            parameter.setListFilterParameter(filterParam);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (CalcSettleEnum.OPTYPE_BILL.getValue().equals(jumpPage.getOpenType())) {
            BillShowParameter lsp = new BillShowParameter();
            lsp.setFormId(jumpPage.getSourcepage());
            if (!CadEmptyUtils.isEmpty((Map)jumpPage.getParam())) {
                Object pkId = jumpPage.getParam().get("pkId");
                if (pkId == null) {
                    pkId = jumpPage.getParam().get("id");
                }
                if (pkId != null) {
                    lsp.setPkId(pkId);
                }
                for (Map.Entry param : jumpPage.getParam().entrySet()) {
                    lsp.getCustomParams().put(param.getKey(), param.getValue());
                }
            }
            lsp.setCaption(jumpPage.getName());
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)lsp);
        } else if (CalcSettleEnum.OPTYPE_REPORT.getValue().equals(jumpPage.getOpenType())) {
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.setFormId(jumpPage.getSourcepage());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCaption(jumpPage.getName());
            if (!CadEmptyUtils.isEmpty((Map)jumpPage.getParam())) {
                for (Map.Entry param : jumpPage.getParam().entrySet()) {
                    showParameter.setCustomParam((String)param.getKey(), param.getValue());
                }
            }
            if (jumpPage.isQuery()) {
                showParameter.setQueryParam(new ReportQueryParam());
            }
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (CalcSettleEnum.OPTYPE_FORM.getValue().equals(jumpPage.getOpenType())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(jumpPage.getSourcepage());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (!CadEmptyUtils.isEmpty((Map)jumpPage.getParam())) {
                for (Map.Entry param : jumpPage.getParam().entrySet()) {
                    showParameter.setCustomParam((String)param.getKey(), param.getValue());
                }
            }
            this.getView().showForm(showParameter);
        }
    }

    public void onCountDownEnd(CountDownEvent evt) {
        super.onCountDownEnd(evt);
        CountDown countDown = (CountDown)evt.getSource();
        if (countDown.getKey().equals(CALC_COUNTDOWN)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CALCPARAM});
        CountDown countdown = (CountDown)this.getView().getControl(CALC_COUNTDOWN);
        countdown.addCountDownListener((CountDownListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if (CALCPARAM.equals(fieldKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            DynamicObject settleitem = (DynamicObject)this.getModel().getValue("settleitem");
            if (!CadEmptyUtils.isEmpty((DynamicObject)settleitem)) {
                showParameter.setFormId(settleitem.getString("parampage"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.getCustomParams().put("defaultparam", this.getModel().getValue("defaultparam_tag"));
                showParameter.getCustomParams().put("hideflag", true);
                showParameter.getCustomParams().put("settleitemnumber", settleitem.get("number"));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(showParameter);
            }
        }
    }
}

