/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.settle;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import org.apache.commons.lang3.StringUtils;

public class SettleReportListPlugin
extends AbstractListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private static final String CONFIRMBACK_ABORTCALC = "abortcalc";

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        List qFilters = e.getQFilters();
        if (!StringUtils.isEmpty((CharSequence)appId)) {
            qFilters.add(new QFilter("appnum", "=", (Object)appId));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        String orgId = this.getCurrOrgId(acctOrgs);
        String islinkin = (String)listShowParameter.getCustomParam("islinkin");
        if (!StringUtils.isEmpty((CharSequence)islinkin)) {
            orgId = null;
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "org.id": {
                    listcomitem.clear();
                    if (CadEmptyUtils.isEmpty((List)acctOrgs)) break;
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(orgId);
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("org")) {
            args.getQfilters().add(new QFilter("id", "in", (Object)ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10")));
        } else if (fieldName.startsWith("period")) {
            args.getQfilters().add(new QFilter("isadjustperiod", "=", (Object)false));
        }
    }

    private String getCurrOrgId(List<ComboItem> acctOrgs) {
        String orgId = this.getPageCache().get("orgId");
        if (orgId == null || "".equals(orgId)) {
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            if (isAccounting) {
                orgId = currAcctOrg + "";
            } else if (!CadEmptyUtils.isEmpty(acctOrgs)) {
                ComboItem comboItem = acctOrgs.get(0);
                orgId = comboItem.getValue();
            }
            if (orgId != null) {
                this.getPageCache().put("orgId", orgId);
            }
        }
        return orgId;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String pageCacheOrg = null;
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "org.id": {
                        String accountorgId;
                        if (listValue == null || listValue.isEmpty()) {
                            return;
                        }
                        pageCacheOrg = accountorgId = (String)listValue.get(j);
                        this.filterContainerInit(this.filterContainerInitArgs);
                    }
                }
            }
        }
        if (pageCacheOrg != null) {
            this.getPageCache().put("orgId", pageCacheOrg);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        HashSet<String> hiddenKeys = new HashSet<String>(1);
        hiddenKeys.add("billstatus");
        ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, hiddenKeys);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "abortcalc": 
            case "dofailclass": 
            case "dofailitem": {
                if (args.getOperationResult().isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"SettleReportListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tbl_abortcalc".equals(itemKey) || "bar_abortcalc".equals(itemKey)) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            if (selectedRows.size() == 0) {
                return;
            }
            String confirmTip = ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u7ec8\u6b62\u8ba1\u7b97\uff1f", (String)"SettleReportListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRMBACK_ABORTCALC, (IFormPlugin)this));
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && CONFIRMBACK_ABORTCALC.equals(e.getCallBackId())) {
            OperateOption operationOption = OperateOption.create();
            operationOption.setVariableValue(CONFIRMBACK_ABORTCALC, "true");
            this.getView().invokeOperation(CONFIRMBACK_ABORTCALC, operationOption);
        }
    }
}

