/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.syncrouter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class SyncRouterRuleEdit
extends AbstractBasePlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave(e);
                break;
            }
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        FilterGrid grid = (FilterGrid)this.getControl("filtertb");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        model.setValue("filter_tag", (Object)jsonStr);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setColsFilterGrid();
        this.bindFilterGrid();
    }

    private void setColsFilterGrid() {
        String controlName = "filtertb";
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"pdm_route");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(controlName);
        EntityTypeUtil helper = new EntityTypeUtil();
        List<Map<String, Object>> cols = helper.getFilterColumns((IDataEntityType)entityType);
        cols = this.filterCols(cols);
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(cols);
        this.getView().updateView(controlName);
    }

    private List<Map<String, Object>> filterCols(List<Map<String, Object>> cols) {
        ArrayList<Map<String, Object>> fsCols = new ArrayList<Map<String, Object>>(10);
        String entity = null;
        String colName = null;
        for (Map<String, Object> col : cols) {
            entity = col.get("entryEntity").toString();
            colName = col.get("fieldName").toString();
            if (!"pdm_route".equals(entity) || !colName.startsWith("material.") && !colName.startsWith("processtype") && !colName.startsWith("ismainprocess")) continue;
            fsCols.add(col);
        }
        return fsCols;
    }

    private void bindFilterGrid() {
        String filter = this.getModel().getDataEntity().getString("filter_tag");
        if (!StringUtils.isBlank((String)filter)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterGrid reserveFilter = (FilterGrid)this.getControl("filtertb");
            reserveFilter.SetValue(condition);
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW.equals((Object)status)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)"{\"filterRow\":[{\"id\":\"4DUMV=J604JP\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"material.configproperties\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4DUMV=J603WF\",\"value\":\"2\"}],\"baseDataIds\":[],\"lock\":false}],\"forList\":false}", FilterCondition.class);
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtertb");
                filterGrid.SetValue(filterCondition);
            }
        }
    }
}

