/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.sysparam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.PermissionBillPlugin;

public class CostCollectionSettingEdit
extends PermissionBillPlugin {
    private Map<String, List<String>> collectBillAndSrcBillMap = new HashMap<String, List<String>>(16);

    public void initialize() {
        super.initialize();
        this.setCollectBillAndSrcBillMap();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bizsettingentry"});
        this.addListener();
    }

    private void addListener() {
        String appId = this.getView().getFormShowParameter().getAppId();
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filters.add(new QFilter("id", "in", (Object)hasPermAccountOrgIds));
        });
        String matUseCollect = "sca".equals(appId) ? "sca_matusecollect" : "aca_matusecollect";
        BasedataEdit collectionBill = (BasedataEdit)this.getControl("collectionbill");
        collectionBill.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            List<String> collectionBills = Arrays.asList("cad_costobject", "cad_plannedoutputbill", "cad_factnedoutputbill", matUseCollect);
            filters.add(new QFilter("number", "in", collectionBills));
        });
        BasedataEdit sourceBill = (BasedataEdit)this.getControl("sourcebill");
        sourceBill.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            int index = this.getModel().getEntryCurrentRowIndex("bizsettingentry");
            DynamicObject row = this.getModel().getEntryRowEntity("bizsettingentry", index);
            if (row == null) {
                return;
            }
            if (row.getDynamicObject("collectionbill") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u5f52\u96c6\u5355\u636e\u3002", (String)"CostCollectionSettingEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String ccBill = row.getString("collectionbill.number");
            List<String> srcBills = this.collectBillAndSrcBillMap.get(ccBill);
            List<String> existSrcBillIds = this.getExistSrcBillIds(ccBill);
            srcBills = new ArrayList<String>(srcBills);
            srcBills.removeAll(existSrcBillIds);
            filters.add(new QFilter("number", "in", srcBills));
        });
        BasedataEdit transactionType = (BasedataEdit)this.getControl("transactiontype");
        transactionType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            int index = this.getModel().getEntryCurrentRowIndex("bizsettingentry");
            DynamicObject row = this.getModel().getEntryRowEntity("bizsettingentry", index);
            String srcBill = row.getString("sourcebill.number");
            if ("pom_mftorder".equals(srcBill)) {
                filters.add(new QFilter("transactiontype.domain", "=", (Object)"3"));
            }
            if ("om_mftorder".equals(srcBill)) {
                filters.add(new QFilter("transactiontype.domain", "=", (Object)"5"));
            }
        });
        BasedataEdit bizType = (BasedataEdit)this.getControl("biztype");
        bizType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            int index = this.getModel().getEntryCurrentRowIndex("bizsettingentry");
            DynamicObject row = this.getModel().getEntryRowEntity("bizsettingentry", index);
            String srcBill = row.getString("sourcebill.number");
            if (CadEmptyUtils.isEmpty((String)srcBill)) {
                return;
            }
            QFilter filter = new QFilter("billformid.number", "=", (Object)srcBill);
            DynamicObject billtype = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{filter});
            if (billtype == null) {
                return;
            }
            DynamicObject billTypeParam = SysParamHelper.getBillTypeParameter((String)srcBill, (long)billtype.getLong("id"));
            if (billTypeParam == null) {
                return;
            }
            DynamicObjectCollection entryEntities = billTypeParam.getDynamicObjectCollection("entryentity");
            HashSet<Long> bizTypeIds = new HashSet<Long>(10);
            for (DynamicObject entryEntity : entryEntities) {
                bizTypeIds.add(entryEntity.getLong("biztypenumber.id"));
            }
            if (!CadEmptyUtils.isEmpty(bizTypeIds)) {
                filters.add(new QFilter("id", "in", bizTypeIds));
            }
        });
        BasedataEdit invscheme = (BasedataEdit)this.getControl("invscheme");
        invscheme.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            int index = this.getModel().getEntryCurrentRowIndex("bizsettingentry");
            DynamicObject row = this.getModel().getEntryRowEntity("bizsettingentry", index);
            String srcBill = row.getString("sourcebill.number");
            DynamicObjectCollection biztypes = row.getDynamicObjectCollection("biztype");
            HashSet<Long> bizTypeIds = new HashSet<Long>(10);
            for (DynamicObject biztype : biztypes) {
                bizTypeIds.add(biztype.getLong("fbasedataid.id"));
            }
            if (CadEmptyUtils.isEmpty((String)srcBill) || CadEmptyUtils.isEmpty(bizTypeIds)) {
                return;
            }
            filters.add(new QFilter("billform.id", "=", (Object)srcBill));
            filters.add(new QFilter("bitypeentry.biztype", "in", bizTypeIds));
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getOperationKey()) {
            case "save": {
                this.getModel().setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
                this.getModel().setValue("modifier", (Object)RequestContext.get().getUserId());
                this.getModel().setValue("modifytime", (Object)new Date());
                DynamicObjectCollection bizSettingEntry = this.getModel().getEntryEntity("bizsettingentry");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)bizSettingEntry)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6210\u672c\u5f52\u96c6\u5355\u636e\u201d\u548c\u201c\u6765\u6e90\u5355\u636e\u201d\u3002", (String)"CostCollectionSettingEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (bizSettingEntry.size() > 1) {
                    return;
                }
                DynamicObject bizSetting = (DynamicObject)bizSettingEntry.get(0);
                DataEntityPropertyCollection properties = bizSetting.getDataEntityType().getProperties();
                boolean isSetValue = false;
                for (IDataEntityProperty property : properties) {
                    if (property.getName().equals("seq")) continue;
                    if (bizSetting.get(property) instanceof String && !CadEmptyUtils.isEmpty((String)bizSetting.getString(property))) {
                        isSetValue = true;
                        break;
                    }
                    if (!(bizSetting.get(property) instanceof DynamicObjectCollection) || StringUtils.isEmpty((Object)bizSetting.get(property)) || bizSetting.getDynamicObjectCollection(property).size() <= 0) continue;
                    isSetValue = true;
                    break;
                }
                if (isSetValue) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6210\u672c\u5f52\u96c6\u5355\u636e\u201d\u548c\u201c\u6765\u6e90\u5355\u636e\u201d\u3002", (String)"CostCollectionSettingEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void initData() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object org = fsp.getCustomParam("org");
        if (!StringUtils.isEmpty((Object)org) && !"0".equals(org)) {
            this.getModel().setValue("org", org);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        } else {
            long orgId;
            List permCalOrgIds = OrgHelper.getHasPermAccountOrgIds((String)"cad_costcollectionsetting", (String)this.getView().getFormShowParameter().getAppId());
            if (permCalOrgIds.contains(orgId = RequestContext.get().getOrgId())) {
                this.getModel().setValue("org", (Object)orgId);
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"org"});
        }
        DynamicObjectCollection bizsettingentry = this.getModel().getEntryEntity("bizsettingentry");
        for (int i = 0; i < bizsettingentry.size(); ++i) {
            String collectType;
            DynamicObject row = (DynamicObject)bizsettingentry.get(i);
            DynamicObject collectionbill = (DynamicObject)row.get("collectionbill");
            if (collectionbill == null || CadEmptyUtils.isEmpty((String)(collectType = collectionbill.getString("number")))) continue;
            if ("cad_costobject".equals(collectType) || "cad_plannedoutputbill".equals(collectType)) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"biztype", "invscheme"});
            }
            if (!"cad_factnedoutputbill".equals(collectType) && !"sca_matusecollect".equals(collectType) && !"aca_matusecollect".equals(collectType)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"transactiontype"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        String proName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (proName) {
            case "collectionbill": {
                String collectType = ((DynamicObject)newValue).getString("number");
                if (CadEmptyUtils.isEmpty((String)collectType)) {
                    return;
                }
                this.getModel().setValue("sourcebill", null, rowIndex);
                this.getModel().setValue("transactiontype", null, rowIndex);
                this.getModel().setValue("biztype", null, rowIndex);
                this.getModel().setValue("invscheme", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"transactiontype", "biztype", "invscheme"});
                if ("cad_costobject".equals(collectType) || "cad_plannedoutputbill".equals(collectType)) {
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"biztype", "invscheme"});
                }
                if (!"cad_factnedoutputbill".equals(collectType) && !"sca_matusecollect".equals(collectType) && !"aca_matusecollect".equals(collectType)) break;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"transactiontype"});
            }
        }
    }

    private List<String> getExistSrcBillIds(String ccBill) {
        ArrayList<String> existCollectionIds = new ArrayList<String>(10);
        DynamicObjectCollection bizSettingEntry = this.getModel().getEntryEntity("bizsettingentry");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)bizSettingEntry)) {
            return existCollectionIds;
        }
        bizSettingEntry.stream().filter(p -> ccBill.equals(p.getString("collectionbill.number"))).forEach(p -> existCollectionIds.add(p.getString("sourcebill.number")));
        return existCollectionIds;
    }

    private void setCollectBillAndSrcBillMap() {
        this.collectBillAndSrcBillMap.put("cad_costobject", Arrays.asList("pom_mftorder", "om_mftorder"));
        this.collectBillAndSrcBillMap.put("cad_plannedoutputbill", Arrays.asList("pom_mftorder", "om_mftorder"));
        this.collectBillAndSrcBillMap.put("cad_factnedoutputbill", Arrays.asList("im_mdc_mftmanuinbill", "im_mdc_mftreturnbill", "im_mdc_omcmplinbill", "im_productinbill"));
        this.collectBillAndSrcBillMap.put("sca_matusecollect", Arrays.asList("im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill", "im_materialreqoutbill"));
        this.collectBillAndSrcBillMap.put("aca_matusecollect", Arrays.asList("im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill", "im_materialreqoutbill"));
    }
}

