/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.sysparam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.enums.AssistantEnum;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.lang.StringUtils;

public class SysParamSettingEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(SysParamSettingEditPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String TAB_COSTACCOUNTPAGE = "costaccounttabpage";
    private static final String TAB_COSTACCUMULTABPAGE = "costaccumultabpage";
    private static final String TAB_SETTINGTABPAGE = "settingtabpage";
    private static final String PAGECACHE_PREACCOUNTPARAMS = "PreAccountParams";
    private static final String PAGECACHE_PREACCUMULPARAMS = "PreAccumulParams";
    private static final String PAGECACHE_PRETIMEACCUMULPARAMS = "PreTimeAccumulParams";
    private static final SysParamEnum[] JHSC_BILLANGE = new SysParamEnum[]{SysParamEnum.BILLRANGE_JHSC_SCGD, SysParamEnum.BILLRANGE_JHSC_WWGD, SysParamEnum.BILLRANGE_JHSC_WGRK};
    private static final SysParamEnum[] WGRK_BILLANGE = new SysParamEnum[]{SysParamEnum.BILLRANGE_WGRK_WIPCOMPELETE, SysParamEnum.BILLRANGE_WGRK_WWGRK, SysParamEnum.BILLRANGE_WGRK_PRODUCTCOMPELETE};
    private static final SysParamEnum[] ZYHY_BILLANGE = new SysParamEnum[]{SysParamEnum.BILLRANGE_ZYHY_PROCESSREPORT, SysParamEnum.BILLRANGE_ZYHY_PROCESSADJUST, SysParamEnum.BILLRANGE_ZYHY_MFTORDERREPORT, SysParamEnum.BILLRANGE_ZYHY_WGXHB};
    private static final SysParamEnum[] CLHY_BILLANGE = new SysParamEnum[]{SysParamEnum.BILLRANGE_CLHY_PROGET, SysParamEnum.BILLRANGE_CLHY_GETOUTSTORAGE, SysParamEnum.BILLRANGE_CLHY_WLL, SysParamEnum.BILLRANGE_CLHY_CBTZ};
    private static int count = 0;

    public void initialize() {
        super.initialize();
        if (count == 0) {
            this.updateDataForRule();
            this.updateDataForTimeScope();
            this.updateDataForBizScope();
            ++count;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid paramlist = (EntryGrid)this.getView().getControl("paramlist");
        paramlist.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"billrange"});
        this.addClickListeners(new String[]{"paramlist"});
        this.addClickListeners(new String[]{"settingparmlist"});
        this.addListener();
    }

    public void refresh(int currentRow) {
        if (this.getPageCache().get("focusTimes") == null || Integer.parseInt(this.getPageCache().get("focusTimes")) != currentRow) {
            int rowCount = this.getModel().getEntryRowCount("paramlist");
            for (int row = 0; row < rowCount; ++row) {
                String planCollectType = (String)this.getModel().getValue("plancollecttype", row);
                String completeType = (String)this.getModel().getValue("completetype", row);
                String resourceuseType = (String)this.getModel().getValue("resourceusetype", row);
                String matcollectWay = (String)this.getModel().getValue("matcollectway", row);
                if (!planCollectType.equals(SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue())) {
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"plancollectrange"});
                }
                if (!completeType.equals(SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue())) {
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"billrange"});
                }
                if (!resourceuseType.equals(SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue())) {
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"resourcerange"});
                }
                if (!matcollectWay.equals(SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT.getValue())) {
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"matcollectrange"});
                }
                this.setEnableForCollectWay(row);
            }
            this.getView().updateView("paramlist");
            this.getPageCache().put("focusTimes", String.valueOf(currentRow));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int currentRow = evt.getRow();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("paramlist");
        String fieldKey = entryGrid.getEntryState().getFocusField();
        String planCollectType = (String)this.getModel().getValue("plancollecttype", currentRow);
        String completeType = (String)this.getModel().getValue("completetype", currentRow);
        String resourceuseType = (String)this.getModel().getValue("resourceusetype", currentRow);
        String matcollectWay = (String)this.getModel().getValue("matcollectway", currentRow);
        if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(planCollectType) && "plancollectrange".contains(fieldKey) || SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completeType) && "billrange".contains(fieldKey) || SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT.getValue().equals(matcollectWay) && "matcollectrange".contains(fieldKey) || SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(resourceuseType) && "resourcerange".contains(fieldKey) || "resourceusetype".equals(fieldKey)) {
            this.resetComBoEditVal(currentRow, fieldKey);
        }
        if (!"restorecalcrange".equals(fieldKey)) {
            return;
        }
        String restoreCalcRange = (String)this.getModel().getValue("restoredimension", currentRow);
        if (SysParamEnum.RESTOREDIMENSION_ORG.getValue().equals(restoreCalcRange)) {
            this.resetComBoEditVal("restorecalcrange", new SysParamEnum[]{SysParamEnum.RESTORECALCRANGE_WIPCOM, SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL, SysParamEnum.RESTORECALCRANGE_PURINBILL}, new SysParamEnum[]{SysParamEnum.RESTORECALCRANGE_WIPCOM, SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL});
        } else {
            this.resetComBoEditVal("restorecalcrange", new SysParamEnum[]{SysParamEnum.RESTORECALCRANGE_WIPCOM, SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL, SysParamEnum.RESTORECALCRANGE_PURINBILL}, new SysParamEnum[]{SysParamEnum.RESTORECALCRANGE_WIPCOM});
        }
        this.setRestoreGetDataRangeEnable();
        this.refresh("accountparamlist", currentRow);
    }

    private void resetComBoEditVal(int currentRow, String field) {
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter", currentRow);
        DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("accountorg", currentRow);
        if (accountOrg == null) {
            return;
        }
        if (!CostObjectHelper.isExistCostObjectRule((Long)accountOrg.getLong("id"))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\uff0c\u7136\u540e\u8bbe\u7f6e\u5355\u636e\u8303\u56f4\u3002", (String)"SysParamSettingEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), accountOrg.getString("name")));
            this.resetComBoEditVal("plancollectrange", JHSC_BILLANGE, JHSC_BILLANGE);
            this.resetComBoEditVal("billrange", WGRK_BILLANGE, WGRK_BILLANGE);
            this.resetComBoEditVal("resourcerange", ZYHY_BILLANGE, ZYHY_BILLANGE);
            this.resetComBoEditVal("matcollectrange", CLHY_BILLANGE, CLHY_BILLANGE);
            this.getModel().setValue("plancollectrange", null, currentRow);
            this.getModel().setValue("billrange", null, currentRow);
            this.getModel().setValue("resourcerange", null, currentRow);
            this.getModel().setValue("matcollectrange", null, currentRow);
            this.refresh(currentRow);
            return;
        }
        String costCalMethod = CostObjectHelper.getCostCalMethod((Long)accountOrg.getLong("id"), (Long)(costcenter == null ? 0L : costcenter.getLong("id")));
        if (CadEmptyUtils.isEmpty((String)costCalMethod)) {
            if (costcenter == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u6309\u6210\u672c\u4e2d\u5fc3\u8bbe\u7f6e\uff0c\u8bf7\u5728\u4e1a\u52a1\u8303\u56f4\u4e0b\u586b\u5199\u6210\u672c\u4e2d\u5fc3\u3002", (String)"SysParamSettingEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), accountOrg == null ? "" : accountOrg.getString("name")));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u548c\u6210\u672c\u4e2d\u5fc3\u201c%2$s\u201d\u672a\u7ef4\u62a4\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u8bbe\u7f6e\u5355\u636e\u8303\u56f4\u3002", (String)"SysParamSettingEditPlugin_35", (String)"macc-cad-formplugin", (Object[])new Object[0]), accountOrg == null ? "" : accountOrg.getString("name"), costcenter.getString("name")));
            }
            this.resetComBoEditVal("plancollectrange", JHSC_BILLANGE, JHSC_BILLANGE);
            this.resetComBoEditVal("billrange", WGRK_BILLANGE, WGRK_BILLANGE);
            this.resetComBoEditVal("resourcerange", ZYHY_BILLANGE, ZYHY_BILLANGE);
            this.resetComBoEditVal("matcollectrange", CLHY_BILLANGE, CLHY_BILLANGE);
            this.getModel().setValue("plancollectrange", null, currentRow);
            this.getModel().setValue("billrange", null, currentRow);
            this.getModel().setValue("resourcerange", null, currentRow);
            this.getModel().setValue("matcollectrange", null, currentRow);
            this.refresh(currentRow);
        }
        this.resetComBoEditValByCostCalMethod(costCalMethod, currentRow, field, false);
        this.refresh(currentRow);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            this.resetComBoEditVal("completetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_API, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[]{SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_API, SysParamEnum.COMPTYPE_MANUAL});
            this.resetComBoEditVal("matcollectway", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT, SysParamEnum.COMPTYPE_TPLIMPORT, SysParamEnum.COMPTYPE_APIINTERFACE, SysParamEnum.COMPTYPE_MANUALENTER}, new SysParamEnum[]{SysParamEnum.COMPTYPE_TPLIMPORT, SysParamEnum.COMPTYPE_APIINTERFACE, SysParamEnum.COMPTYPE_MANUALENTER});
            this.resetComBoEditVal("resourceusetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_API, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[]{SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_API, SysParamEnum.COMPTYPE_MANUAL});
        }
    }

    public void afterBindData(EventObject e) {
        ComboEdit effectControlEdit;
        super.afterBindData(e);
        this.fillForm();
        EntryGrid entryGrid = (EntryGrid)this.getControl("paramlist");
        entryGrid.setColumnProperty("accountorg", "isFixed", (Object)true);
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("aca".equalsIgnoreCase(appNum)) {
            BasedataEdit settingorg;
            ComboEdit mfgFeeTypeEdit;
            ComboEdit completeTypeEdit = (ComboEdit)this.getView().getControl("completetype");
            if (completeTypeEdit != null) {
                completeTypeEdit.setComboItems(this.getCompleteComboItems());
            }
            if ((mfgFeeTypeEdit = (ComboEdit)this.getView().getControl("matcollectway")) != null) {
                mfgFeeTypeEdit.setComboItems(this.getMfgFeeComboItems());
            }
            if ((settingorg = (BasedataEdit)this.getView().getControl("settingorg")) != null) {
                settingorg.setMustInput(true);
            }
        } else if ("sca".equalsIgnoreCase(appNum)) {
            effectControlEdit = (ComboEdit)this.getView().getControl("effectcontrol");
            if (effectControlEdit != null) {
                effectControlEdit.setComboItems(this.getEffectControlComboItems());
            }
        } else if ("eca".equals(appNum)) {
            effectControlEdit = (ComboEdit)this.getView().getControl("effectcontrol");
            effectControlEdit.setComboItems(this.getEcaEffectControlItems());
        }
        if ("aca".equalsIgnoreCase(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isupdatebyperiod", "isallupdate", "reductstrategy", "outsourceprice", "restorecalcrange", "restoregetdatarange", "startbomrouterule", "reductrestorekeycol"});
        }
        if ("sca".equalsIgnoreCase(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"plancollecttype", "plancollectrange", "calckeyfield", "reductcalckeycol", "matlevelcalckey"});
        }
        if ("eca".equalsIgnoreCase(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_COSTACCOUNTPAGE, "advconap2", "calckeyfield", "reductcalckeycol", "matlevelcalckey", "reductrestorekeycol"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"startbomrouterule"});
            AdvContainer costCollectEntryGrid = (AdvContainer)this.getView().getControl("advconap1");
            costCollectEntryGrid.setCollapse(false);
            costCollectEntryGrid.setCollapseable(false);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"hourexpense"});
        if (!ImportServiceHelper.isOldUserForSysParamBizRange().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap2"});
        }
    }

    private void changeFileNameStatus() {
        DynamicObjectCollection timelist = this.getModel().getEntryEntity("timelist");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)timelist)) {
            return;
        }
    }

    private void setRestoreGetDataRangeEnable() {
        DynamicObjectCollection objList = this.getModel().getEntryEntity("accountparamlist");
        int index = 0;
        for (DynamicObject dynObj : objList) {
            String restoreCalcRange = dynObj.getString("restorecalcrange");
            boolean isContainsPurbill = restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue());
            BasedataEdit restoreGetDataRange = (BasedataEdit)this.getControl("restoregetdatarange");
            restoreGetDataRange.setEnable("", isContainsPurbill, index);
            ++index;
        }
    }

    private void refresh(String controlName, int curIndex) {
        String pageKey = controlName + "_lastIndex";
        String index = this.getPageCache().get(pageKey);
        if (!String.valueOf(curIndex).equals(index)) {
            this.getView().updateView(controlName);
        }
        this.getPageCache().put(pageKey, String.valueOf(curIndex));
    }

    private List<ComboItem> getMfgFeeComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItemObj = new ComboItem();
        comboItemObj.setCaption(new LocaleString(SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getName()));
        comboItemObj.setValue("INNERSYSIMPORT");
        ComboItem comboItemExcel = new ComboItem();
        comboItemExcel.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6a21\u7248\u5f15\u5165", (String)"SysParamSettingEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        comboItemExcel.setValue("TPLIMPORT");
        ComboItem comboItemApi = new ComboItem();
        comboItemApi.setCaption(new LocaleString(SysParamEnum.COMPTYPE_API.getName()));
        comboItemApi.setValue("APIINTERFACE");
        ComboItem comboItemManual = new ComboItem();
        comboItemManual.setCaption(new LocaleString(SysParamEnum.COMPTYPE_MANUAL.getName()));
        comboItemManual.setValue("MANUALENTER");
        comboItems.add(comboItemObj);
        comboItems.add(comboItemExcel);
        comboItems.add(comboItemApi);
        comboItems.add(comboItemManual);
        return comboItems;
    }

    private ArrayList<ComboItem> getEffectControlComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItemObj = new ComboItem();
        comboItemObj.setCaption(new LocaleString(SysParamEnum.SCA_PROALLOCSTD.getName()));
        comboItemObj.setValue(SysParamEnum.SCA_PROALLOCSTD.getValue());
        comboItems.add(comboItemObj);
        return comboItems;
    }

    private ArrayList<ComboItem> getEcaEffectControlItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItemObj = new ComboItem();
        comboItemObj.setCaption(new LocaleString(SysParamEnum.SCA_DIYCOSTDRIVER.getName()));
        comboItemObj.setValue(SysParamEnum.SCA_DIYCOSTDRIVER.getValue());
        comboItems.add(comboItemObj);
        return comboItems;
    }

    private ArrayList<ComboItem> getCompleteComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItemObj = new ComboItem();
        comboItemObj.setCaption(new LocaleString(SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getName()));
        comboItemObj.setValue(SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue());
        ComboItem comboItemExcel = new ComboItem();
        comboItemExcel.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6a21\u7248\u5f15\u5165", (String)"SysParamSettingEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        comboItemExcel.setValue(SysParamEnum.COMPTYPE_EXCEL.getValue());
        ComboItem comboItemApi = new ComboItem();
        comboItemApi.setCaption(new LocaleString(SysParamEnum.COMPTYPE_API.getName()));
        comboItemApi.setValue(SysParamEnum.COMPTYPE_API.getValue());
        ComboItem comboItemManual = new ComboItem();
        comboItemManual.setCaption(new LocaleString(SysParamEnum.COMPTYPE_MANUAL.getName()));
        comboItemManual.setValue(SysParamEnum.COMPTYPE_MANUAL.getValue());
        comboItems.add(comboItemObj);
        comboItems.add(comboItemExcel);
        comboItems.add(comboItemApi);
        comboItems.add(comboItemManual);
        return comboItems;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity rowDataEntity = e.getRowDataEntities()[0];
        String entityName = rowDataEntity.getDataEntity().getDataEntityType().getName();
        int rowIndex = rowDataEntity.getRowIndex();
        if ("settingparmlist".equals(e.getEntryProp().getName())) {
            return;
        }
        if ("timelist".equals(e.getEntryProp().getName())) {
            String periodStr = (String)this.getModel().getValue("importperiodscope", rowIndex);
            DynamicObject actOrg = (DynamicObject)this.getModel().getValue("actorg", rowIndex);
            this.getModel().setValue("timeshow", (Object)SysParamHelper.getTimeStrByImportPeriodScope((String)periodStr, (Long)(actOrg == null ? 0L : actOrg.getLong("id")), (String)AppIdHelper.getCurAppNum((IFormView)this.getView())), rowIndex);
            this.getView().updateView("timeshow", rowIndex);
            return;
        }
        if ("accountparamlist".equals(entityName)) {
            long acctOrg = RequestContext.getOrCreate().getOrgId();
            boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)acctOrg, (String)"10");
            if (isaccount) {
                this.getModel().setValue("org", (Object)acctOrg, rowIndex);
            }
            BasedataEdit restoreGetDataRange = (BasedataEdit)this.getControl("restoregetdatarange");
            restoreGetDataRange.setEnable("", false, rowIndex);
            return;
        }
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("aca".equalsIgnoreCase(appNum)) {
            this.getModel().setValue("matcollectway", (Object)"INNERSYSIMPORT", rowIndex);
            this.getModel().setValue("completetype", (Object)SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue(), rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"matcollectway"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"completetype"});
        }
        String matCollectWay = (String)this.getModel().getValue("matcollectway", rowIndex);
        String completeType = (String)this.getModel().getValue("completetype", rowIndex);
        String resourceUseType = (String)this.getModel().getValue("resourceusetype", rowIndex);
        String planCollectType = (String)this.getModel().getValue("plancollecttype", rowIndex);
        if (!"INNERSYSIMPORT".equals(matCollectWay)) {
            this.getModel().setValue("matcollectrange", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"matcollectrange"});
        }
        if (!"OBJECTRULE".equals(completeType)) {
            this.getModel().setValue("billrange", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"billrange"});
        }
        if (!"OBJECTRULE".equals(resourceUseType)) {
            this.getModel().setValue("resourcerange", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"resourcerange"});
        }
        if (!"OBJECTRULE".equals(planCollectType)) {
            this.getModel().setValue("plancollectrange", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"plancollectrange"});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String isDataChange;
        super.beforeItemClick(evt);
        if (evt.getItemKey().equals("bar_close") && StringUtils.equals((String)"true", (String)(isDataChange = this.getPageCache().get("isDataChange")))) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmClose", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"SysParamSettingEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().put("isDataChange", "true");
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        ComboEdit planCollectRange = (ComboEdit)this.getControl("plancollectrange");
        ComboEdit billRange = (ComboEdit)this.getControl("billrange");
        ComboEdit matcollectway = (ComboEdit)this.getControl("matcollectrange");
        ComboEdit resourcerange = (ComboEdit)this.getControl("resourcerange");
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter", rowIndex);
        DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("accountorg", rowIndex);
        DynamicObject actOrg = (DynamicObject)this.getModel().getValue("actorg", rowIndex);
        String periodStr = (String)this.getModel().getValue("importperiodscope", rowIndex);
        switch (e.getProperty().getName()) {
            case "accountorg": {
                if (newValue == null) {
                    return;
                }
                String costCalMethod = CostObjectHelper.getCostCalMethod((Long)Long.parseLong(((DynamicObject)newValue).getPkValue().toString()), (Long)(costcenter == null ? 0L : costcenter.getLong("id")));
                if (!CadEmptyUtils.isEmpty((String)costCalMethod)) {
                    this.resetComBoEditValByCostCalMethod(costCalMethod, rowIndex, "", true);
                    this.refresh(rowIndex);
                }
                this.reSetRangeValue(costCalMethod, rowIndex);
                break;
            }
            case "costcenter": {
                if (newValue == null) {
                    return;
                }
                DynamicObject centerOrg = ((DynamicObject)newValue).getDynamicObject("accountorg");
                if (centerOrg == null) {
                    return;
                }
                this.getModel().setValue("accountorg", centerOrg.getPkValue(), rowIndex);
                String costCalMethod = CostObjectHelper.getCostCalMethod((Long)Long.parseLong(centerOrg.getPkValue().toString()), (Long)Long.parseLong(((DynamicObject)newValue).getPkValue().toString()));
                if (!CadEmptyUtils.isEmpty((String)costCalMethod)) {
                    this.resetComBoEditValByCostCalMethod(costCalMethod, rowIndex, "", true);
                    this.refresh(rowIndex);
                }
                this.reSetRangeValue(costCalMethod, rowIndex);
                break;
            }
            case "plancollecttype": {
                if (!SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(newValue.toString())) {
                    this.getModel().setValue("plancollectrange", null, rowIndex);
                    planCollectRange.setEnable("", false, rowIndex);
                    break;
                }
                planCollectRange.setEnable("", true, rowIndex);
                String costCalMethod = CostObjectHelper.getCostCalMethod((Long)(accountOrg == null ? 0L : accountOrg.getLong("id")), (Long)(costcenter == null ? 0L : costcenter.getLong("id")));
                if ("SO".equals(costCalMethod) || "FL".equals(costCalMethod)) {
                    this.getModel().setValue("plancollectrange", (Object)",WGRK,", rowIndex);
                    return;
                }
                this.getModel().setValue("plancollectrange", (Object)",SCGD,", rowIndex);
                break;
            }
            case "completetype": {
                if (!SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(newValue.toString())) {
                    this.getModel().setValue("billrange", null, rowIndex);
                    billRange.setEnable("", false, rowIndex);
                    break;
                }
                billRange.setEnable("", true, rowIndex);
                String costCalMethod = CostObjectHelper.getCostCalMethod((Long)(accountOrg == null ? 0L : accountOrg.getLong("id")), (Long)(costcenter == null ? 0L : costcenter.getLong("id")));
                if ("SO".equals(costCalMethod) || "FL".equals(costCalMethod)) {
                    this.getModel().setValue("billrange", (Object)",PRODUCTCOMPELETE,", rowIndex);
                    return;
                }
                this.getModel().setValue("billrange", (Object)",WIPCOMPELETE,", rowIndex);
                break;
            }
            case "matcollectway": {
                if (!SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT.getValue().equals(newValue.toString())) {
                    this.getModel().setValue("matcollectrange", null, rowIndex);
                    matcollectway.setEnable("", false, rowIndex);
                    break;
                }
                matcollectway.setEnable("", true, rowIndex);
                String costCalMethod = CostObjectHelper.getCostCalMethod((Long)(accountOrg == null ? 0L : accountOrg.getLong("id")), (Long)(costcenter == null ? 0L : costcenter.getLong("id")));
                if ("SO".equals(costCalMethod) || "FL".equals(costCalMethod)) {
                    this.getModel().setValue("matcollectrange", (Object)",GET_OUTSTORAGE,", rowIndex);
                    return;
                }
                this.getModel().setValue("matcollectrange", (Object)",PRO_GET,", rowIndex);
                break;
            }
            case "resourceusetype": {
                if (!SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(newValue.toString())) {
                    this.getModel().setValue("resourcerange", null, rowIndex);
                    resourcerange.setEnable("", false, rowIndex);
                    this.getModel().setValue("warehousepoint", (Object)false, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"warehousepoint"});
                    break;
                }
                resourcerange.setEnable("", true, rowIndex);
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"warehousepoint"});
                String costCalMethod = CostObjectHelper.getCostCalMethod((Long)(accountOrg == null ? 0L : accountOrg.getLong("id")), (Long)(costcenter == null ? 0L : costcenter.getLong("id")));
                if ("SO".equals(costCalMethod) || "FL".equals(costCalMethod)) {
                    this.getModel().setValue("resourcerange", null, rowIndex);
                    return;
                }
                this.getModel().setValue("resourcerange", (Object)",PROCESSREPORT,PROCESSADJUST,MFTORDERREPORT,", rowIndex);
                break;
            }
            case "importperiodscope": {
                if (newValue == null) {
                    return;
                }
                if (actOrg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SysParamSettingEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("importperiodscope", null, rowIndex);
                    this.getView().updateView("importperiodscope", rowIndex);
                    return;
                }
                this.getModel().setValue("timeshow", (Object)SysParamHelper.getTimeStrByImportPeriodScope((String)periodStr, (Long)(actOrg == null ? 0L : actOrg.getLong("id")), (String)AppIdHelper.getCurAppNum((IFormView)this.getView())), rowIndex);
                this.getView().updateView("ispreviousoneton", rowIndex);
                this.getView().updateView("timeshow", rowIndex);
                break;
            }
            case "restoredimension": {
                String restoreCalcRange2 = (String)this.getModel().getValue("restorecalcrange", rowIndex);
                this.changeRestoreCalcRange(newValue.toString(), restoreCalcRange2, rowIndex);
                this.getModel().setValue("restoregetdatarange", null, rowIndex);
                break;
            }
            case "restorecalcrange": {
                String restoredimension = (String)this.getModel().getValue("restoredimension", rowIndex);
                this.changeRestoreCalcRange(restoredimension, newValue == null ? "" : newValue.toString(), rowIndex);
                break;
            }
            case "restoregetdatarange": {
                DynamicObjectCollection newRestoreRangeDyns = (DynamicObjectCollection)newValue;
                DynamicObjectCollection oldRestoreRangeDyns = (DynamicObjectCollection)oldValue;
                this.changeRestoreGetDataRange(oldRestoreRangeDyns, newRestoreRangeDyns, rowIndex);
                break;
            }
            case "reductstrategy": {
                Boolean isUpdateByPeriod = SysParamEnum.ITEMIZED_REDUCT.getValue().equalsIgnoreCase((String)this.getModel().getValue("reductstrategy"));
                this.getModel().setValue("isupdatebyperiod", (Object)isUpdateByPeriod);
                break;
            }
            case "actorg": {
                this.getModel().setValue("timeshow", (Object)SysParamHelper.getTimeStrByImportPeriodScope((String)periodStr, (Long)(actOrg == null ? 0L : actOrg.getLong("id")), (String)AppIdHelper.getCurAppNum((IFormView)this.getView())), rowIndex);
                this.getView().updateView("timeshow", rowIndex);
                break;
            }
        }
    }

    private void reSetRangeValue(String costCalMethod, Integer rowIndex) {
        String planCollectType = (String)this.getModel().getValue("plancollecttype", rowIndex.intValue());
        String completeType = (String)this.getModel().getValue("completetype", rowIndex.intValue());
        String resourceuseType = (String)this.getModel().getValue("resourceusetype", rowIndex.intValue());
        String matcollectWay = (String)this.getModel().getValue("matcollectway", rowIndex.intValue());
        if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(planCollectType)) {
            if (CostObjectEnum.BIZTYPE_SO.getValue().equals(costCalMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(costCalMethod)) {
                this.getModel().setValue("plancollectrange", (Object)",WGRK,", rowIndex.intValue());
            } else {
                this.getModel().setValue("plancollectrange", (Object)",SCGD,", rowIndex.intValue());
            }
        }
        if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completeType)) {
            if (CostObjectEnum.BIZTYPE_SO.getValue().equals(costCalMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(costCalMethod)) {
                this.getModel().setValue("billrange", (Object)",PRODUCTCOMPELETE,", rowIndex.intValue());
            } else {
                this.getModel().setValue("billrange", (Object)",WIPCOMPELETE,", rowIndex.intValue());
            }
        }
        if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(resourceuseType)) {
            if (CostObjectEnum.BIZTYPE_SO.getValue().equals(costCalMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(costCalMethod)) {
                this.getModel().setValue("resourceusetype", (Object)"MANUAL", rowIndex.intValue());
                this.getModel().setValue("resourcerange", null, rowIndex.intValue());
            } else {
                this.getModel().setValue("resourcerange", (Object)",PROCESSREPORT,PROCESSADJUST,MFTORDERREPORT,", rowIndex.intValue());
            }
        }
        if (SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT.getValue().equals(matcollectWay)) {
            if (CostObjectEnum.BIZTYPE_SO.getValue().equals(costCalMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(costCalMethod)) {
                this.getModel().setValue("matcollectrange", (Object)",GET_OUTSTORAGE,", rowIndex.intValue());
            } else {
                this.getModel().setValue("matcollectrange", (Object)",PRO_GET,", rowIndex.intValue());
            }
        }
    }

    private void changeRestoreGetDataRange(DynamicObjectCollection oldRestoreRangeDyns, DynamicObjectCollection restoreRangeDyns, int rowIndex) {
        List<Long> restoreRange;
        DynamicObject accountDyn = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
        if (restoreRangeDyns == null || accountDyn == null) {
            return;
        }
        Long accountId = accountDyn.getLong("id");
        HashMap<Long, Object> orgCostaccountMap = new HashMap<Long, Object>();
        boolean isHasSameOrg = false;
        for (DynamicObject dyn : restoreRangeDyns) {
            Long calorgId = dyn.getLong("fbasedataid.calorg.id");
            if (orgCostaccountMap.containsKey(calorgId)) {
                isHasSameOrg = true;
                continue;
            }
            orgCostaccountMap.put(calorgId, dyn);
        }
        if (isHasSameOrg) {
            while (restoreRangeDyns.size() > 0) {
                restoreRangeDyns.remove(0);
            }
            restoreRangeDyns.addAll((Collection)oldRestoreRangeDyns);
            this.getView().updateView("restoregetdatarange", rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93\u53d6\u6570\u8303\u56f4\u4e0d\u80fd\u9009\u62e9\u76f8\u540c\u6838\u7b97\u7ec4\u7ec7\u4e0b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"SysParamSettingEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> addDatas = this.getAddData(oldRestoreRangeDyns, restoreRangeDyns);
        Set<Long> addDataRanges = null;
        if (!CollectionUtils.isEmpty(addDatas) && (addDataRanges = this.getAddDataRange(addDatas)).size() > 0) {
            restoreRange = SysParamSettingEditPlugin.getBaseDataIdList(restoreRangeDyns);
            addDataRanges.addAll(restoreRange);
            addDataRanges.remove(accountId);
            orgCostaccountMap.clear();
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])addDataRanges.toArray(), (String)"cal_bd_costaccount");
            for (Object dyn : map.values()) {
                Long calorgId = dyn.getLong("calorg.id");
                if (orgCostaccountMap.containsKey(calorgId)) {
                    isHasSameOrg = true;
                    continue;
                }
                orgCostaccountMap.put(calorgId, dyn);
            }
            if (isHasSameOrg) {
                while (restoreRangeDyns.size() > 0) {
                    restoreRangeDyns.remove(0);
                }
                restoreRangeDyns.addAll((Collection)oldRestoreRangeDyns);
                this.getView().updateView("restoregetdatarange", rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93\u53d6\u6570\u8303\u56f4\u4e0d\u80fd\u9009\u62e9\u76f8\u540c\u6838\u7b97\u7ec4\u7ec7\u4e0b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"SysParamSettingEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection objList = this.getModel().getEntryEntity("accountparamlist");
            for (DynamicObject dynObj : objList) {
                Long curAccountId = dynObj.getLong("costaccount.id");
                if (!accountId.equals(curAccountId)) continue;
                dynObj.set("restoregetdatarange", null);
                restoreRangeDyns = dynObj.getDynamicObjectCollection("restoregetdatarange");
                for (DynamicObject accObj : map.values()) {
                    DynamicObject obj = restoreRangeDyns.addNew();
                    obj.set("fbasedataid", (Object)accObj);
                }
                this.getView().updateView("restoregetdatarange", rowIndex);
            }
        }
        restoreRangeDyns = (DynamicObjectCollection)this.getModel().getValue("restoregetdatarange", rowIndex);
        restoreRange = SysParamSettingEditPlugin.getBaseDataIdList(restoreRangeDyns);
        DynamicObjectCollection objList = this.getModel().getEntryEntity("accountparamlist");
        for (DynamicObject dynObj : objList) {
            Long curAccountId = dynObj.getLong("costaccount.id");
            DynamicObjectCollection curRestoreRangeDyns = dynObj.getDynamicObjectCollection("restoregetdatarange");
            List<Long> curRestoreRange = SysParamSettingEditPlugin.getBaseDataIdList(curRestoreRangeDyns);
            if (accountId.equals(curAccountId)) continue;
            if (restoreRange.contains(curAccountId)) {
                if (restoreRange.size() == curRestoreRange.size() && curRestoreRange.contains(accountId)) continue;
                ArrayList<Long> destList = new ArrayList<Long>();
                destList.addAll(restoreRange);
                destList.remove(curAccountId);
                destList.add(accountId);
                dynObj.set("restoregetdatarange", null);
                curRestoreRangeDyns = dynObj.getDynamicObjectCollection("restoregetdatarange");
                Map map = BusinessDataServiceHelper.loadFromCache((Object[])destList.toArray(), (String)"cal_bd_costaccount");
                for (DynamicObject accObj : map.values()) {
                    DynamicObject obj = curRestoreRangeDyns.addNew();
                    obj.set("fbasedataid", (Object)accObj);
                }
                continue;
            }
            if (!curRestoreRange.contains(accountId)) continue;
            curRestoreRange.remove(accountId);
            dynObj.set("restoregetdatarange", null);
            if (curRestoreRange.size() <= 0) continue;
            curRestoreRangeDyns = dynObj.getDynamicObjectCollection("restoregetdatarange");
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])curRestoreRange.toArray(), (String)"cal_bd_costaccount");
            for (DynamicObject accObj : map.values()) {
                DynamicObject obj = curRestoreRangeDyns.addNew();
                obj.set("fbasedataid", (Object)accObj);
            }
        }
        this.getView().updateView("accountparamlist");
    }

    private List<Long> getAddData(DynamicObjectCollection oldRestoreRangeDyns, DynamicObjectCollection restoreRangeDyns) {
        List<Long> oldRestoreRange = SysParamSettingEditPlugin.getBaseDataIdList(oldRestoreRangeDyns);
        List<Long> newRestoreRange = SysParamSettingEditPlugin.getBaseDataIdList(restoreRangeDyns);
        if (newRestoreRange.size() == 0) {
            return null;
        }
        newRestoreRange.removeAll(oldRestoreRange);
        return newRestoreRange;
    }

    private Set<Long> getAddDataRange(List<Long> addDatas) {
        HashSet<Long> sets = new HashSet<Long>();
        DynamicObjectCollection objList = this.getModel().getEntryEntity("accountparamlist");
        for (DynamicObject dynObj : objList) {
            Long curAccountId = dynObj.getLong("costaccount.id");
            if (!addDatas.contains(curAccountId)) continue;
            DynamicObjectCollection curRestoreRangeDyns = dynObj.getDynamicObjectCollection("restoregetdatarange");
            List<Long> curRestoreRange = SysParamSettingEditPlugin.getBaseDataIdList(curRestoreRangeDyns);
            sets.addAll(curRestoreRange);
        }
        return sets;
    }

    private void changeRestoreCalcRange(String restoredimension, String restoreCalcRange, int rowIndex) {
        String[] selItems = restoreCalcRange.split(",");
        boolean isContainsPurbill = restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue());
        BasedataEdit restoreGetDataRange = (BasedataEdit)this.getControl("restoregetdatarange");
        restoreGetDataRange.setEnable("", isContainsPurbill, rowIndex);
        if (!isContainsPurbill) {
            this.getModel().setValue("restoregetdatarange", null, rowIndex);
        }
        boolean isRemoveTransdirBill = false;
        boolean isAddWipCom = false;
        if (SysParamEnum.RESTOREDIMENSION_ORG.getValue().equals(restoredimension) && restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue())) {
            isRemoveTransdirBill = true;
        }
        if (!restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_WIPCOM.getValue())) {
            isAddWipCom = true;
        }
        if (isRemoveTransdirBill || isAddWipCom) {
            StringBuilder sb = new StringBuilder();
            if (isAddWipCom) {
                sb.append(SysParamEnum.RESTORECALCRANGE_WIPCOM.getValue());
                sb.append(",");
            }
            for (String item : selItems) {
                if (StringUtils.isEmpty((String)item) || SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue().equals(item) && isRemoveTransdirBill) continue;
                sb.append(item);
                sb.append(",");
            }
            this.getModel().setValue("restorecalcrange", (Object)sb.toString().substring(0, sb.length() - 1), rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("op_save".equals(operateKey)) {
            DynamicObject[] accountParams = this.queryCostAccountParams(this.getView().getFormShowParameter().getAppId());
            DynamicObjectCollection newData = this.getModel().getEntryEntity("accountparamlist");
            if (accountParams == null || newData == null || "yes".equals(this.getPageCache().get("AConfrim"))) {
                return;
            }
            HashMap<String, String> flagSameMap = new HashMap<String, String>(newData.size());
            for (DynamicObject newDatum : newData) {
                DynamicObject neworg = newDatum.getDynamicObject("org");
                DynamicObject newcostaccount = newDatum.getDynamicObject("costaccount");
                if (neworg == null || newcostaccount == null) {
                    return;
                }
                Long neworgPkValue = (Long)neworg.getPkValue();
                Long newcostaccountPkValue = (Long)newcostaccount.getPkValue();
                String concat = neworgPkValue.toString().concat(newcostaccountPkValue.toString());
                String flag = (String)flagSameMap.get(concat);
                if (flag == null) {
                    flagSameMap.put(concat, "Y");
                    continue;
                }
                return;
            }
            StringBuilder tipString = new StringBuilder();
            StringBuilder tipLogString = new StringBuilder();
            int tipHand = 0;
            for (int i = 0; i < accountParams.length; ++i) {
                DynamicObject oldDatum = accountParams[i];
                DynamicObject oldorg = oldDatum.getDynamicObject("org");
                DynamicObject oldcostaccount = oldDatum.getDynamicObject("costaccount");
                if (oldorg == null || oldcostaccount == null) continue;
                String oldValue = oldDatum.getString("assistant");
                String restoreCalcRange = oldDatum.getString("restorecalcrange");
                DynamicObjectCollection restoreGetDataRange = oldDatum.getDynamicObjectCollection("restoregetdatarange");
                tipHand = 0;
                for (DynamicObject newDatum : newData) {
                    String newRestoreCalcRange;
                    ++tipHand;
                    DynamicObject neworg = newDatum.getDynamicObject("org");
                    DynamicObject newcostaccount = newDatum.getDynamicObject("costaccount");
                    Long oldorgPkValue = (Long)oldorg.getPkValue();
                    Long oldcostaccountPkValue = (Long)oldcostaccount.getPkValue();
                    Long neworgPkValue = (Long)neworg.getPkValue();
                    Long newcostaccountPkValue = (Long)newcostaccount.getPkValue();
                    if (oldorgPkValue.compareTo(neworgPkValue) != 0 || oldcostaccountPkValue.compareTo(newcostaccountPkValue) != 0) continue;
                    String tipHeadStr = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c%2$s\u201d\u6210\u672c\u8d26\u7c3f%3$s", (String)"SysParamSettingEditPlugin_36", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    tipHeadStr = String.format(tipHeadStr, tipHand, newDatum.getString("costaccount.name"), "\uff0c");
                    StringBuilder tipStr = new StringBuilder();
                    StringBuilder tipLogStr = new StringBuilder();
                    String newValue = newDatum.getString("assistant");
                    if (StringUtils.isEmpty((String)oldValue)) {
                        oldValue = AssistantEnum.DIVIDE_DIRECT.getValue();
                    }
                    if (!oldValue.equals(newValue)) {
                        if (tipStr.length() == 0) {
                            tipStr.append(tipHeadStr);
                            tipLogStr.append(tipHeadStr);
                        }
                        tipStr.append(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5206\u914d\u65b9\u6cd5\u7531\u201c%1$s\u201d\u4fee\u6539\u4e3a\u201c%2$s %3$s\u201d\u3002", (String)"SysParamSettingEditPlugin_37", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getAssistantName(oldValue), this.getAssistantName(newValue), "\uff0c"));
                        tipLogStr.append(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7684\u3010%2$s\u3011\u7684\u8f85\u52a9\u5206\u914d\u65b9\u6cd5\uff0c\u7531%3$s \u4fee\u6539\u4e3a %4$s %5$s", (String)"SysParamSettingEditPlugin_38", (String)"macc-cad-formplugin", (Object[])new Object[0]), newDatum.getString("org.name"), newDatum.getString("costaccount.name"), this.getAssistantName(oldValue), this.getAssistantName(newValue), "\uff0c"));
                    }
                    if (this.isChangeRestoreCalcRange(restoreCalcRange, newRestoreCalcRange = newDatum.getString("restorecalcrange"))) {
                        if (tipStr.length() == 0) {
                            tipStr.append(tipHeadStr);
                            tipLogStr.append(tipHeadStr);
                        }
                        String tipResMsg = ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u8303\u56f4\u5df2\u4fee\u6539\u3002", (String)"SysParamSettingEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        tipStr.append(tipResMsg).append("\uff0c");
                        tipLogStr.append(tipResMsg).append("\uff0c");
                    }
                    DynamicObjectCollection newRestoreGetDataRange = newDatum.getDynamicObjectCollection("restoregetdatarange");
                    if (this.isChangeRestoreGetDataRange(SysParamSettingEditPlugin.getBaseDataIdList(restoreGetDataRange), SysParamSettingEditPlugin.getBaseDataIdList(newRestoreGetDataRange))) {
                        if (tipStr.length() == 0) {
                            tipStr.append(tipHeadStr);
                            tipLogStr.append(tipHeadStr);
                        }
                        String tipResMsg = ResManager.loadKDString((String)"\u4fee\u6539\u4e86\u91c7\u8d2d\u5165\u5e93\u5355\u53d6\u6570\u8303\u56f4", (String)"SysParamSettingEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        tipStr.append(tipResMsg).append("\uff0c");
                        tipLogStr.append(tipResMsg).append("\uff0c");
                    }
                    if (tipStr.length() <= 0) continue;
                    tipString.append(tipStr.toString().substring(0, tipStr.length() - 1)).append("\uff1b");
                    tipLogString.append(tipLogStr.toString().substring(0, tipStr.length() - 1)).append("\uff1b");
                }
            }
            if (tipString.toString().length() > 0) {
                String tip = tipString.substring(0, tipString.length() - 1) + "\u3002";
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s \u8bf7\u786e\u8ba4", (String)"SysParamSettingEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), tip), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmChange", (IFormPlugin)this));
                this.getPageCache().put("tipLogStr", tipLogString.toString());
                args.setCancel(true);
            }
        }
    }

    private boolean isChangeRestoreCalcRange(String oldVal, String newVal) {
        boolean ov1 = oldVal.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue());
        boolean nv1 = newVal.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue());
        boolean ov2 = oldVal.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue());
        boolean nv2 = newVal.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue());
        if (ov1 != nv1) {
            return true;
        }
        return ov2 != nv2;
    }

    private boolean isChangeRestoreGetDataRange(List<Long> oldRange, List<Long> newRange) {
        if (oldRange.size() != newRange.size()) {
            return true;
        }
        oldRange.retainAll(newRange);
        return oldRange.size() != newRange.size();
    }

    private String getAssistantName(String assistantValue) {
        if (assistantValue == null) {
            return "";
        }
        switch (assistantValue) {
            case "mutual": {
                return AssistantEnum.getName((String)AssistantEnum.DIVIDE_MUTUAL.getValue());
            }
            case "algebra": {
                return AssistantEnum.getName((String)AssistantEnum.DIVIDE_ALGEBRA.getValue());
            }
        }
        return AssistantEnum.getName((String)AssistantEnum.DIVIDE_DIRECT.getValue());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("confirmChange".equals(callBackId) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.getPageCache().put("AConfrim", "yes");
            this.getView().invokeOperation("op_save");
        }
        if ("confirmClose".equals(callBackId) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.getView().invokeOperation("close");
        }
        this.getPageCache().put("AConfrim", "no");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = Optional.ofNullable(e.getOperationResult()).map(s -> s.isSuccess()).orElse(true);
        if ("op_save".equals(e.getOperateKey()) && isSuccess) {
            this.getPageCache().put("isDataChange", "false");
            this.save();
        }
    }

    protected void addListener() {
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        costCenter.setF7MultipleSelect(false);
        costCenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            List<Object> costCenters = this.getAllSelectCostCenterId();
            if (!CadEmptyUtils.isEmpty(costCenters)) {
                filters.add(new QFilter("id", "not in", costCenters));
            }
            int index = this.getModel().getEntryCurrentRowIndex("paramlist");
            DynamicObject row = this.getModel().getEntryRowEntity("paramlist", index);
            if (row != null && row.getDynamicObject("accountorg") != null) {
                filters.add(new QFilter("accountorg", "=", row.getDynamicObject("accountorg").getPkValue()));
            } else {
                filters.add(new QFilter("accountorg", "=", (Object)0L));
            }
            filters.add(new QFilter("orgduty", "=", (Object)4L));
            filterParameter.setQFilters(filters);
        });
        BasedataEdit actOrg = (BasedataEdit)this.getControl("actorg");
        actOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            List<Long> hasPermAccountOrgs = this.getHasPermAccountOrgs();
            if (CollectionUtils.isEmpty(hasPermAccountOrgs)) {
                filters.add(new QFilter("id", "=", (Object)0L));
            } else {
                filters.add(new QFilter("id", "in", hasPermAccountOrgs));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit accountOrg = (BasedataEdit)this.getControl("accountorg");
        accountOrg.addBeforeF7SelectListener(evt -> {
            List<Long> hasPermAccountOrgs;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            int index = this.getModel().getEntryCurrentRowIndex("paramlist");
            DynamicObject row = this.getModel().getEntryRowEntity("paramlist", index);
            if (row != null && row.getDynamicObject("costcenter") != null) {
                DynamicObject centerOrg = row.getDynamicObject("costcenter").getDynamicObject("accountorg");
                if (centerOrg != null) {
                    filters.add(new QFilter("id", "=", centerOrg.getPkValue()));
                } else {
                    filters.add(new QFilter("id", "=", (Object)-1L));
                }
            }
            if (CollectionUtils.isEmpty(hasPermAccountOrgs = this.getHasPermAccountOrgs())) {
                filters.add(new QFilter("id", "=", (Object)0L));
            } else {
                filters.add(new QFilter("id", "in", hasPermAccountOrgs));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit transactionType = (BasedataEdit)this.getControl("transactiontype");
        transactionType.addBeforeF7SelectListener(evt -> {
            DynamicObject paramlist = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("paramlist").get(evt.getRow());
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("id", "in", this.getTransTypeFilter(paramlist)));
            filterParameter.setQFilters(filters);
        });
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            List<Long> hasPermAccountOrgs = this.getHasPermAccountOrgs();
            if (CollectionUtils.isEmpty(hasPermAccountOrgs)) {
                filters.add(new QFilter("id", "=", (Object)0L));
            } else {
                filters.add(new QFilter("id", "in", hasPermAccountOrgs));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            int index = this.getModel().getEntryCurrentRowIndex("accountparamlist");
            DynamicObject row = this.getModel().getEntryRowEntity("accountparamlist", index);
            if (row != null && row.getDynamicObject("org") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SysParamSettingEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                DynamicObject currOrg = row.getDynamicObject("org");
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnableQfilterByOrg((Long)currOrg.getLong("id"), null, (String)this.getView().getFormShowParameter().getAppId());
                List qFilters = filterParameter.getQFilters();
                qFilters.add(enabledCostAccountIdsFilter);
            }
        });
        BasedataEdit settingOrg = (BasedataEdit)this.getControl("settingorg");
        if (settingOrg != null) {
            settingOrg.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                List<Long> hasPermAccountOrgs = this.getHasPermAccountOrgs();
                if (CollectionUtils.isEmpty(hasPermAccountOrgs)) {
                    filters.add(new QFilter("id", "=", (Object)0L));
                } else {
                    filters.add(new QFilter("id", "in", hasPermAccountOrgs));
                }
                filterParameter.setQFilters(filters);
            });
        }
        BasedataEdit restoreGetDataRange = (BasedataEdit)this.getControl("restoregetdatarange");
        restoreGetDataRange.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            int index = this.getModel().getEntryCurrentRowIndex("accountparamlist");
            DynamicObject row = this.getModel().getEntryRowEntity("accountparamlist", index);
            String restoredimension = row.getString("restoredimension");
            String restorecalcrange = row.getString("restorecalcrange");
            Long accountId = row.getLong("costaccount.id");
            Long orgId = row.getLong("org.id");
            if (StringUtils.isNotEmpty((String)restorecalcrange) && restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) && !CadEmptyUtils.isEmpty((Long)accountId)) {
                HashSet<Long> accountIds = new HashSet<Long>();
                DynamicObjectCollection objList = this.getModel().getEntryEntity("accountparamlist");
                for (DynamicObject dynObj : objList) {
                    Long id;
                    String dynRestoredimension = dynObj.getString("restoredimension");
                    String dynRestorecalcrange = dynObj.getString("restorecalcrange");
                    if (!StringUtils.isNotEmpty((String)dynRestorecalcrange) || !dynRestorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) || !restoredimension.equals(dynRestoredimension) || CadEmptyUtils.isEmpty((Long)(id = Long.valueOf(dynObj.getLong("costaccount.id"))))) continue;
                    accountIds.add(id);
                }
                if (!accountIds.isEmpty()) {
                    accountIds.remove(accountId);
                    qFilters.add(new QFilter("id", "in", accountIds));
                    qFilters.add(new QFilter("calorg", "!=", (Object)orgId));
                    return;
                }
            }
            qFilters.add(new QFilter("id", "=", (Object)0L));
        });
    }

    private List<Object> getAllSelectCostCenterId() {
        DynamicObjectCollection cols = this.getModel().getEntryEntity("paramlist");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)cols)) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject row : cols) {
            DynamicObject costCenter = row.getDynamicObject("costcenter");
            if (costCenter == null) continue;
            list.add(costCenter.getPkValue());
        }
        return list;
    }

    private void fillForm() {
        this.fillAccountParamForm();
        this.fillAccumulParamForm();
        this.fillSettingParamForm();
    }

    private void fillSettingParamForm() {
        int[] indexs;
        String appId = this.getView().getFormShowParameter().getAppId();
        this.getModel().deleteEntryData("settingparmlist");
        Object[] params = this.querySettingParams(appId);
        if (CadEmptyUtils.isEmpty((Object[])params)) {
            return;
        }
        this.getModel().beginInit();
        for (int index : indexs = this.getModel().batchCreateNewEntryRow("settingparmlist", params.length)) {
            this.getModel().setValue("settingorg", params[index].get("actorg"), index);
            this.getModel().setValue("effectcontrol", params[index].get("effectcontrol"), index);
            this.getModel().setValue("hourexpense", params[index].get("hourexpense"), index);
            this.getModel().setValue("startbomrouterule", params[index].get("startbomrouterule"), index);
        }
        this.getModel().endInit();
        this.getView().updateView("settingparmlist");
    }

    private DynamicObject[] querySettingParams(String appId) {
        List<Long> hasPermAccountOrgs = this.getHasPermAccountOrgs();
        QFilter acctOrgFilter = null;
        acctOrgFilter = CollectionUtils.isEmpty(hasPermAccountOrgs) ? new QFilter("actorg", "=", (Object)-1L) : new QFilter("actorg", "in", hasPermAccountOrgs);
        acctOrgFilter.and("tab", "=", (Object)TAB_SETTINGTABPAGE);
        acctOrgFilter.and("appnum", "=", (Object)appId);
        DynamicObject[] costAccumulParams = BusinessDataServiceHelper.load((String)"cad_sysparam", (String)"id,actorg,effectcontrol,hourexpense,startbomrouterule", (QFilter[])new QFilter[]{acctOrgFilter});
        return costAccumulParams == null ? new DynamicObject[]{} : costAccumulParams;
    }

    private void fillAccountParamForm() {
        int[] indexs;
        HashSet<String> preAccountParams = new HashSet<String>(10);
        this.getModel().deleteEntryData("accountparamlist");
        String appNum = this.getView().getFormShowParameter().getAppId();
        this.getModel().setValue("appnum", (Object)appNum);
        Object[] params = this.queryCostAccountParams(appNum);
        if (CadEmptyUtils.isEmpty((Object[])params)) {
            return;
        }
        this.getModel().beginInit();
        for (int index : indexs = this.getModel().batchCreateNewEntryRow("accountparamlist", params.length)) {
            this.getModel().setValue("org", params[index].get("org"), index);
            this.getModel().setValue("costaccount", params[index].get("costaccount"), index);
            this.getModel().setValue("isupdatebyperiod", params[index].get("isupdatebyperiod"), index);
            this.getModel().setValue("isallupdate", params[index].get("isallupdate"), index);
            this.getModel().setValue("isMergeBill", params[index].get("isMergeBill"), index);
            this.getModel().setValue("reductstrategy", params[index].get("reductstrategy"), index);
            this.getModel().setValue("outsourceprice", params[index].get("outsourceprice"), index);
            this.getModel().setValue("calckeyfield", params[index].get("calckeyfield"), index);
            this.getModel().setValue("reductcalckeycol", params[index].get("reductcalckeycol"), index);
            this.getModel().setValue("matlevelcalckey", params[index].get("matlevelcalckey"), index);
            this.getModel().setValue("reductrestorekeycol", params[index].get("reductrestorekeycol"), index);
            Object assistant = params[index].get("assistant");
            this.getModel().setValue("assistant", ObjectUtils.isEmpty((Object)assistant) ? AssistantEnum.DIVIDE_DIRECT.getValue() : assistant, index);
            String restoredimension = params[index].getString("restoredimension");
            this.getModel().setValue("restoredimension", (Object)restoredimension, index);
            String restoreCalcRange = params[index].getString("restorecalcrange");
            if (StringUtils.isEmpty((String)restoreCalcRange)) {
                restoreCalcRange = SysParamEnum.RESTORECALCRANGE_WIPCOM.getValue();
            }
            this.getModel().setValue("restorecalcrange", (Object)restoreCalcRange, index);
            boolean isContainsPurbill = restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue());
            BasedataEdit restoreGetDataRange = (BasedataEdit)this.getControl("restoregetdatarange");
            restoreGetDataRange.setEnable("", isContainsPurbill, index);
            DynamicObjectCollection restoregegetdataranges = params[index].getDynamicObjectCollection("restoregetdatarange");
            List<Long> baseDataIdList = SysParamSettingEditPlugin.getBaseDataIdList(restoregegetdataranges);
            this.getModel().setValue("restoregetdatarange", (Object)baseDataIdList.toArray(), index);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", index);
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", index);
            String str = org.get("id") + "@" + costAccount.get("id");
            preAccountParams.add(str);
        }
        this.getModel().endInit();
        this.getView().updateView("accountparamlist");
        String preAccountParamsStr = StringUtils.join((Object[])preAccountParams.toArray(), (String)",");
        this.getPageCache().put(PAGECACHE_PREACCOUNTPARAMS, preAccountParamsStr);
    }

    private void fillAccumulParamForm() {
        this.fillTimeParams();
        this.fillBizParams();
        this.getView().updateView(TAB_COSTACCUMULTABPAGE);
    }

    private void fillTimeParams() {
        int[] indexs;
        HashSet<String> preTimeAccumulParams = new HashSet<String>(10);
        this.getModel().deleteEntryData("timelist");
        Object[] params = this.queryTimeAccumulParams(this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((Object[])params)) {
            return;
        }
        this.getModel().beginInit();
        for (int index : indexs = this.getModel().batchCreateNewEntryRow("timelist", params.length)) {
            this.getModel().setValue("actorg", params[index].get("actorg"), index);
            String importScopePeriodStr = params[index].getString("importperiodscope");
            if (CadEmptyUtils.isEmpty((String)importScopePeriodStr)) continue;
            String[] importScopes = importScopePeriodStr.split(",");
            Set importScopeSet = Arrays.stream(importScopes).filter(item -> !item.isEmpty()).collect(Collectors.toSet());
            String selectedImportPeriodScope = StringUtils.join(importScopeSet, (String)",");
            this.getModel().setValue("importperiodscope", (Object)selectedImportPeriodScope, index);
            this.getModel().setValue("ispreviousoneton", params[index].get("ispreviousoneton"), index);
            DynamicObject actOrg = (DynamicObject)this.getModel().getValue("actorg", index);
            String periodStr = (String)this.getModel().getValue("importperiodscope", index);
            this.getModel().setValue("timeshow", (Object)SysParamHelper.getTimeStrByImportPeriodScope((String)periodStr, (Long)(actOrg == null ? 0L : actOrg.getLong("id")), (String)AppIdHelper.getCurAppNum((IFormView)this.getView())), index);
            DynamicObject org = (DynamicObject)this.getModel().getValue("actorg", index);
            String str = org.getString("id");
            preTimeAccumulParams.add(str);
        }
        this.getModel().endInit();
        String preAccumulParamsStr = StringUtils.join((Object[])preTimeAccumulParams.toArray(), (String)",");
        this.getPageCache().put(PAGECACHE_PRETIMEACCUMULPARAMS, preAccumulParamsStr);
    }

    private void fillBizParams() {
        int[] indexs;
        String appId = this.getView().getFormShowParameter().getAppId();
        HashSet<String> preAccumulParams = new HashSet<String>(10);
        this.getModel().deleteEntryData("paramlist");
        Object[] params = this.queryCostAccumulParams(this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((Object[])params)) {
            return;
        }
        this.getModel().beginInit();
        for (int index : indexs = this.getModel().batchCreateNewEntryRow("paramlist", params.length)) {
            String resourcerange;
            String matcollectrange;
            String range;
            String planRange;
            this.getModel().setValue("accountorg", params[index].get("accountorg"), index);
            this.getModel().setValue("costcenter", params[index].get("costcenter"), index);
            DynamicObjectCollection transactiontypes = params[index].getDynamicObjectCollection("transactiontype");
            List<Long> baseDataIdList = SysParamSettingEditPlugin.getBaseDataIdList(transactiontypes);
            this.getModel().setValue("transactiontype", (Object)baseDataIdList.toArray(), index);
            this.getModel().setValue("plancollecttype", params[index].get("plancollecttype"), index);
            this.getModel().setValue("completetype", params[index].get("completetype"), index);
            this.getModel().setValue("resourceusetype", params[index].get("resourceusetype"), index);
            this.getModel().setValue("mfgfeebilltype", params[index].get("mfgfeebilltype"), index);
            this.getModel().setValue("matcollectway", params[index].get("matcollectway"), index);
            this.getModel().setValue("warehousepoint", params[index].get("warehousepoint"), index);
            if ("aca".equals(appId)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"completetype"});
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"matcollectway"});
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"matcollectway"});
            }
            String completetype = (String)params[index].get("completetype");
            if (!SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completetype)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"billrange"});
            }
            String plancollecttype = (String)params[index].get("plancollecttype");
            if (!SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(plancollecttype)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"plancollectrange"});
            }
            String resourceusetype = (String)params[index].get("resourceusetype");
            if (!SysParamEnum.COMPTYPE_OBJECTRULE.getValue().equals(resourceusetype)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"resourcerange"});
                this.getModel().setValue("warehousepoint", (Object)false, index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"warehousepoint"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"warehousepoint"});
            }
            String matCollectWay = (String)params[index].get("matcollectway");
            if (!"INNERSYSIMPORT".equals(matCollectWay)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"matcollectrange"});
            }
            if ((planRange = params[index].getString("plancollectrange")) != null) {
                this.getModel().setValue("plancollectrange", (Object)planRange, index);
            }
            if ((range = params[index].getString("billrange")) != null) {
                this.getModel().setValue("billrange", (Object)range, index);
            }
            if ((matcollectrange = params[index].getString("matcollectrange")) != null) {
                this.getModel().setValue("matcollectrange", (Object)matcollectrange, index);
            }
            if ((resourcerange = params[index].getString("resourcerange")) != null) {
                this.getModel().setValue("resourcerange", (Object)resourcerange, index);
            }
            this.getModel().setValue("isautoupdate", params[index].get("isautoupdate"), index);
            DynamicObject org = (DynamicObject)this.getModel().getValue("accountorg", index);
            String str = org.getString("id");
            preAccumulParams.add(str);
            DynamicObject accOrg = (DynamicObject)params[index].get("accountorg");
            DynamicObject costCenter = (DynamicObject)params[index].get("costcenter");
            String costCalMethod = CostObjectHelper.getCostCalMethod((Long)Long.parseLong(accOrg.getPkValue().toString()), (Long)(costCenter == null ? 0L : costCenter.getLong("id")));
            if (!CostObjectEnum.BIZTYPE_SO.getValue().equals(costCalMethod) && !CostObjectEnum.BIZTYPE_FL.getValue().equals(costCalMethod)) continue;
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"transactiontype"});
        }
        this.getModel().endInit();
        String preAccumulParamsStr = StringUtils.join((Object[])preAccumulParams.toArray(), (String)",");
        this.getPageCache().put(PAGECACHE_PREACCUMULPARAMS, preAccumulParamsStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save() {
        String sucOp;
        String opFail;
        String message;
        TXHandle txHandle;
        block27: {
            HashMap<Long, String> orgIdToControl;
            block25: {
                block26: {
                    block23: {
                        block24: {
                            String restoreCheckResStr;
                            block21: {
                                block22: {
                                    txHandle = TX.required();
                                    message = "flag";
                                    String result = this.doCheck();
                                    if (CadEmptyUtils.isEmpty((String)result)) break block21;
                                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", (String)"SysParamSettingEditPlugin_39", (String)"macc-cad-formplugin", (Object[])new Object[0]), result));
                                    if (txHandle == null) break block22;
                                    txHandle.close();
                                }
                                if (!"yes".equals(this.getPageCache().get("AConfrim"))) return;
                                this.getPageCache().put("AConfrim", "no");
                                try {
                                    String opType = ResManager.loadKDString((String)"\u4fdd\u5b58\u4fee\u6539", (String)"SysParamSettingEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                                    String opSuc = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"SysParamSettingEditPlugin_40", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                                    String opFail2 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"SysParamSettingEditPlugin_41", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                                    IPageCache pageCache = this.getView().getPageCache();
                                    String checkType = String.format("%1$s %2$s", pageCache.get("tipLogStr"), "flag".equals(message) ? opSuc : opFail2 + message);
                                    WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_sysparamsetting", (IDataModel)this.getModel());
                                    return;
                                }
                                catch (Exception e) {
                                    logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u5931\u8d25", (Throwable)e);
                                    String saveOp = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"SysParamSettingEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                                    String sucOp2 = ResManager.loadKDString((String)" \u6210\u529f", (String)"SysParamSettingEditPlugin_42", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                                    String failOp = ResManager.loadKDString((String)" \u5931\u8d25  ", (String)"SysParamSettingEditPlugin_43", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                                    String resultInfo = "flag".equals(message) ? sucOp2 : failOp + message;
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s %2$s,\u5e76\u4e14\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u662f\u5b58\u5728\u9519\u8bef\uff1a%3$s\u3002", (String)"SysParamSettingEditPlugin_44", (String)"macc-cad-formplugin", (Object[])new Object[0]), saveOp, resultInfo, e.getMessage()));
                                }
                                return;
                            }
                            boolean isQueryChange = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"checkkeycolchange", (String)"1"));
                            if (!isQueryChange || CadEmptyUtils.isEmpty((String)(restoreCheckResStr = this.changeRecoveryParam()))) break block23;
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", (String)"SysParamSettingEditPlugin_39", (String)"macc-cad-formplugin", (Object[])new Object[0]), restoreCheckResStr));
                            if (txHandle == null) break block24;
                            txHandle.close();
                        }
                        if (!"yes".equals(this.getPageCache().get("AConfrim"))) return;
                        this.getPageCache().put("AConfrim", "no");
                        try {
                            String opType = ResManager.loadKDString((String)"\u4fdd\u5b58\u4fee\u6539", (String)"SysParamSettingEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            String opSuc = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"SysParamSettingEditPlugin_40", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            String opFail3 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"SysParamSettingEditPlugin_41", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            IPageCache pageCache = this.getView().getPageCache();
                            String checkType = String.format("%1$s %2$s", pageCache.get("tipLogStr"), "flag".equals(message) ? opSuc : opFail3 + message);
                            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_sysparamsetting", (IDataModel)this.getModel());
                            return;
                        }
                        catch (Exception e) {
                            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u5931\u8d25", (Throwable)e);
                            String saveOp = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"SysParamSettingEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            String sucOp3 = ResManager.loadKDString((String)" \u6210\u529f", (String)"SysParamSettingEditPlugin_42", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            String failOp = ResManager.loadKDString((String)" \u5931\u8d25  ", (String)"SysParamSettingEditPlugin_43", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                            String resultInfo = "flag".equals(message) ? sucOp3 : failOp + message;
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s %2$s,\u5e76\u4e14\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u662f\u5b58\u5728\u9519\u8bef\uff1a%3$s\u3002", (String)"SysParamSettingEditPlugin_44", (String)"macc-cad-formplugin", (Object[])new Object[0]), saveOp, resultInfo, e.getMessage()));
                        }
                        return;
                    }
                    orgIdToControl = this.checkSettingParams();
                    if (orgIdToControl != null) break block25;
                    if (txHandle == null) break block26;
                    txHandle.close();
                }
                if (!"yes".equals(this.getPageCache().get("AConfrim"))) return;
                this.getPageCache().put("AConfrim", "no");
                try {
                    String opType = ResManager.loadKDString((String)"\u4fdd\u5b58\u4fee\u6539", (String)"SysParamSettingEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    String opSuc = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"SysParamSettingEditPlugin_40", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    String opFail4 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"SysParamSettingEditPlugin_41", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    IPageCache pageCache = this.getView().getPageCache();
                    String checkType = String.format("%1$s %2$s", pageCache.get("tipLogStr"), "flag".equals(message) ? opSuc : opFail4 + message);
                    WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_sysparamsetting", (IDataModel)this.getModel());
                    return;
                }
                catch (Exception e) {
                    logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u5931\u8d25", (Throwable)e);
                    String saveOp = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"SysParamSettingEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    String sucOp4 = ResManager.loadKDString((String)" \u6210\u529f", (String)"SysParamSettingEditPlugin_42", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    String failOp = ResManager.loadKDString((String)" \u5931\u8d25  ", (String)"SysParamSettingEditPlugin_43", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    String resultInfo = "flag".equals(message) ? sucOp4 : failOp + message;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s %2$s,\u5e76\u4e14\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u662f\u5b58\u5728\u9519\u8bef\uff1a%3$s\u3002", (String)"SysParamSettingEditPlugin_44", (String)"macc-cad-formplugin", (Object[])new Object[0]), saveOp, resultInfo, e.getMessage()));
                }
                return;
            }
            this.saveAccountParams();
            this.saveAccumulParams();
            this.saveSettingParams(orgIdToControl);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SysParamSettingEditPlugin_49", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            if (txHandle == null) break block27;
            txHandle.close();
        }
        if (!"yes".equals(this.getPageCache().get("AConfrim"))) return;
        this.getPageCache().put("AConfrim", "no");
        try {
            String opType = ResManager.loadKDString((String)"\u4fdd\u5b58\u4fee\u6539", (String)"SysParamSettingEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            String opSuc = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"SysParamSettingEditPlugin_40", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            opFail = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"SysParamSettingEditPlugin_41", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            IPageCache pageCache = this.getView().getPageCache();
            String checkType = String.format("%1$s %2$s", pageCache.get("tipLogStr"), "flag".equals(message) ? opSuc : opFail + message);
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_sysparamsetting", (IDataModel)this.getModel());
            return;
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u5931\u8d25", (Throwable)e);
            String saveOp = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"SysParamSettingEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            sucOp = ResManager.loadKDString((String)" \u6210\u529f", (String)"SysParamSettingEditPlugin_42", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            String failOp = ResManager.loadKDString((String)" \u5931\u8d25  ", (String)"SysParamSettingEditPlugin_43", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            String resultInfo = "flag".equals(message) ? sucOp : failOp + message;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s %2$s,\u5e76\u4e14\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u662f\u5b58\u5728\u9519\u8bef\uff1a%3$s\u3002", (String)"SysParamSettingEditPlugin_44", (String)"macc-cad-formplugin", (Object[])new Object[0]), saveOp, resultInfo, e.getMessage()));
        }
        return;
        catch (Exception e) {
            block28: {
                try {
                    message = e.getMessage();
                    txHandle.markRollback();
                    if (!"NotSetN".equals(e.getMessage())) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SysParamSettingEditPlugin_50", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        logger.error("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
                    }
                    if (txHandle == null) break block28;
                }
                catch (Throwable throwable) {
                    if (txHandle != null) {
                        txHandle.close();
                    }
                    if (!"yes".equals(this.getPageCache().get("AConfrim"))) throw throwable;
                    this.getPageCache().put("AConfrim", "no");
                    try {
                        String opType = ResManager.loadKDString((String)"\u4fdd\u5b58\u4fee\u6539", (String)"SysParamSettingEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        String opSuc = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"SysParamSettingEditPlugin_40", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        String opFail5 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"SysParamSettingEditPlugin_41", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        IPageCache pageCache = this.getView().getPageCache();
                        String checkType = String.format("%1$s %2$s", pageCache.get("tipLogStr"), "flag".equals(message) ? opSuc : opFail5 + message);
                        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_sysparamsetting", (IDataModel)this.getModel());
                        throw throwable;
                    }
                    catch (Exception e2) {
                        logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u5931\u8d25", (Throwable)e2);
                        String saveOp = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"SysParamSettingEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        String sucOp5 = ResManager.loadKDString((String)" \u6210\u529f", (String)"SysParamSettingEditPlugin_42", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        String failOp = ResManager.loadKDString((String)" \u5931\u8d25  ", (String)"SysParamSettingEditPlugin_43", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        String resultInfo = "flag".equals(message) ? sucOp5 : failOp + message;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s %2$s,\u5e76\u4e14\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u662f\u5b58\u5728\u9519\u8bef\uff1a%3$s\u3002", (String)"SysParamSettingEditPlugin_44", (String)"macc-cad-formplugin", (Object[])new Object[0]), saveOp, resultInfo, e2.getMessage()));
                    }
                    throw throwable;
                }
                txHandle.close();
            }
            if (!"yes".equals(this.getPageCache().get("AConfrim"))) return;
            this.getPageCache().put("AConfrim", "no");
            try {
                String opType = ResManager.loadKDString((String)"\u4fdd\u5b58\u4fee\u6539", (String)"SysParamSettingEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                String opSuc = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"SysParamSettingEditPlugin_40", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                opFail = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"SysParamSettingEditPlugin_41", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                IPageCache pageCache = this.getView().getPageCache();
                String checkType = String.format("%1$s %2$s", pageCache.get("tipLogStr"), "flag".equals(message) ? opSuc : opFail + message);
                WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_sysparamsetting", (IDataModel)this.getModel());
                return;
            }
            catch (Exception e3) {
                logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u5931\u8d25", (Throwable)e3);
                String saveOp = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"SysParamSettingEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                sucOp = ResManager.loadKDString((String)" \u6210\u529f", (String)"SysParamSettingEditPlugin_42", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                String failOp = ResManager.loadKDString((String)" \u5931\u8d25  ", (String)"SysParamSettingEditPlugin_43", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                String resultInfo = "flag".equals(message) ? sucOp : failOp + message;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s %2$s,\u5e76\u4e14\u64cd\u4f5c\u65e5\u5fd7\u5199\u5165\u662f\u5b58\u5728\u9519\u8bef\uff1a%3$s\u3002", (String)"SysParamSettingEditPlugin_44", (String)"macc-cad-formplugin", (Object[])new Object[0]), saveOp, resultInfo, e3.getMessage()));
            }
            return;
        }
    }

    private HashMap<Long, String> checkSettingParams() {
        DynamicObjectCollection collParamRows = this.getModel().getEntryEntity("settingparmlist");
        HashMap<Long, String> returnMap = new HashMap<Long, String>();
        int i = 0;
        for (DynamicObject collParamRow : collParamRows) {
            ++i;
            Long orgId = collParamRow.getLong("settingorg.id");
            if (CadEmptyUtils.isEmpty((Long)orgId)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u6210\u672c\u914d\u7f6e\u4e2d\u7b2c%s\u884c\u6838\u7b97\u7ec4\u7ec7\u672a\u586b\u5199\u3002", (String)"SysParamSettingEditPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), i));
                return null;
            }
            if (returnMap.get(orgId) == null) {
                String hourExpense;
                String effectcontrol = collParamRow.getString("effectcontrol");
                if (CadEmptyUtils.isEmpty((String)effectcontrol)) {
                    effectcontrol = " ";
                }
                if (CadEmptyUtils.isEmpty((String)(hourExpense = collParamRow.getString("hourexpense")))) {
                    hourExpense = " ";
                }
                boolean startBomRouteRule = collParamRow.getBoolean("startbomrouterule");
                returnMap.put(orgId, effectcontrol + '@' + hourExpense + "@" + startBomRouteRule);
                continue;
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6210\u672c\u914d\u7f6e\u7b2c%s\u884c\u4e2d\u6838\u7b97\u7ec4\u7ec7\u91cd\u590d,\u8bf7\u68c0\u67e5\u3002", (String)"SysParamSettingEditPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]), i));
            return null;
        }
        return returnMap;
    }

    private void saveSettingParams(Map<Long, String> orgIdToControl) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (orgIdToControl.size() == 0) {
            List<Long> hasPermAccountOrgs = this.getHasPermAccountOrgs();
            QFilter acctOrgFilter = null;
            acctOrgFilter = CollectionUtils.isEmpty(hasPermAccountOrgs) ? new QFilter("actorg", "=", (Object)-1L) : new QFilter("actorg", "in", hasPermAccountOrgs);
            acctOrgFilter.and("tab", "=", (Object)TAB_SETTINGTABPAGE);
            acctOrgFilter.and("appnum", "=", (Object)appId);
            DeleteServiceHelper.delete((String)"cad_sysparam", (QFilter[])new QFilter[]{acctOrgFilter});
        } else {
            DynamicObject[] actParams = this.querySettingParams(appId);
            HashSet<Long> deleteIdSet = new HashSet<Long>(actParams.length);
            ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> modifyDataList = new ArrayList<DynamicObject>();
            for (DynamicObject actParam : actParams) {
                Boolean startBomRouteRule;
                Long orgId = actParam.getLong("actorg.id");
                String str = orgIdToControl.get(orgId);
                if (str == null) {
                    deleteIdSet.add(actParam.getLong("id"));
                    continue;
                }
                String[] values = str.split("@");
                if (values.length == 0) continue;
                Boolean isModify = Boolean.FALSE;
                if (!values[0].equals(actParam.getString("effectcontrol"))) {
                    actParam.set("effectcontrol", (Object)values[0]);
                    isModify = Boolean.TRUE;
                }
                if (values.length >= 1 && !values[1].equals(actParam.getString("hourexpense"))) {
                    actParam.set("hourexpense", (Object)values[1]);
                    isModify = Boolean.TRUE;
                }
                Boolean bl = startBomRouteRule = "true".equals(values[2]) ? Boolean.TRUE : Boolean.FALSE;
                if (values.length == 3 && !startBomRouteRule.equals(actParam.getBoolean("startbomrouterule"))) {
                    actParam.set("startbomrouterule", (Object)startBomRouteRule);
                    isModify = Boolean.TRUE;
                }
                if (Boolean.TRUE.equals(isModify)) {
                    modifyDataList.add(actParam);
                }
                orgIdToControl.remove(orgId);
            }
            for (Map.Entry entry : orgIdToControl.entrySet()) {
                DynamicObject addData = BusinessDataServiceHelper.newDynamicObject((String)"cad_sysparam");
                addData.set("actorg", entry.getKey());
                String[] values = ((String)entry.getValue()).split("@");
                if (values.length == 1) {
                    addData.set("effectcontrol", (Object)values[0]);
                } else if (values.length == 2) {
                    addData.set("effectcontrol", (Object)values[0]);
                    addData.set("hourexpense", (Object)values[1]);
                } else if (values.length == 3) {
                    Boolean startBomRouteRule = "true".equals(values[2]) ? Boolean.TRUE : Boolean.FALSE;
                    addData.set("effectcontrol", (Object)values[0]);
                    addData.set("hourexpense", (Object)values[1]);
                    addData.set("startbomrouterule", (Object)startBomRouteRule);
                } else {
                    logger.info("\u6210\u672c\u914d\u7f6e\u53c2\u6570\u4e2d\uff0c\u6709\u6548\u671f\u63a7\u5236\u4e0e\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\uff1a" + (String)entry.getValue());
                    continue;
                }
                addData.set("tab", (Object)TAB_SETTINGTABPAGE);
                addData.set("appnum", (Object)appId);
                saveDataList.add(addData);
            }
            if (saveDataList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[0]));
            }
            if (modifyDataList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])modifyDataList.toArray(new DynamicObject[0]));
            }
            if (deleteIdSet.size() > 0) {
                DeleteServiceHelper.delete((String)"cad_sysparam", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIdSet)});
            }
        }
    }

    private String changeRecoveryParam() {
        String restoreCheckResStr = "";
        StringBuilder res = new StringBuilder();
        HashMap<DynamicObject, String> accountParam = new HashMap<DynamicObject, String>(16);
        HashMap<Long, String> accountParamF7 = new HashMap<Long, String>(16);
        HashSet<Long> accountDoCalc = new HashSet<Long>(16);
        DynamicObjectCollection accountSets = this.getModel().getEntryEntity("accountparamlist");
        for (DynamicObject p : accountSets) {
            accountParam.put(p.getDynamicObject("costaccount"), p.getString("restoredimension"));
        }
        DataSet recoverResult = QueryServiceHelper.queryDataSet((String)"param", (String)"sca_costrecovry", (String)"costaccount", null, null);
        recoverResult = recoverResult.groupBy(new String[]{"costaccount"}).finish();
        while (recoverResult.hasNext()) {
            Row row = recoverResult.next();
            accountDoCalc.add(row.getLong("costaccount"));
        }
        DataSet paramF7 = QueryServiceHelper.queryDataSet((String)"param", (String)"cad_sysparam", (String)"costaccount,restoredimension", null, null);
        while (paramF7.hasNext()) {
            Row row = paramF7.next();
            accountParamF7.put(row.getLong("costaccount"), row.getString("restoredimension"));
        }
        for (Map.Entry entry : accountParam.entrySet()) {
            DynamicObject accountDO = (DynamicObject)entry.getKey();
            if (!accountDoCalc.contains(accountDO.getLong("id")) || ((String)entry.getValue()).equals(accountParamF7.get(accountDO.getLong("id")))) continue;
            res.append("[");
            res.append(accountDO.getString("name"));
            res.append("]");
        }
        if (!CadEmptyUtils.isEmpty((String)res.toString())) {
            restoreCheckResStr = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f%s\u5df2\u8fdb\u884c\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\uff0c\u4e0d\u80fd\u53d8\u66f4\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\u3002", (String)"SysParamSettingEditPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]), res.toString());
        }
        return restoreCheckResStr;
    }

    /*
     * WARNING - void declaration
     */
    private String doCheck() {
        void var10_22;
        HashSet bizs = new HashSet(10);
        HashSet<DynamicObject> times = new HashSet<DynamicObject>(10);
        HashSet coms = new HashSet(10);
        HashSet<DynamicObject> reOrgs = new HashSet<DynamicObject>(10);
        DynamicObjectCollection bizParams = this.getModel().getEntryEntity("paramlist");
        bizParams.forEach(p -> bizs.add(p.getDynamicObject("accountorg")));
        DynamicObjectCollection timeParams = this.getModel().getEntryEntity("timelist");
        for (Object p2 : timeParams) {
            if (times.contains(p2.getDynamicObject("actorg"))) {
                reOrgs.add(p2.getDynamicObject("actorg"));
            }
            times.add(p2.getDynamicObject("actorg"));
        }
        StringBuilder reOrgstr = new StringBuilder();
        if (!CadEmptyUtils.isEmpty(reOrgs)) {
            for (DynamicObject dynamicObject : reOrgs) {
                reOrgstr.append("\u3010");
                reOrgstr.append(dynamicObject.getString("name"));
                reOrgstr.append("\u3011");
            }
        }
        if (!CadEmptyUtils.isEmpty((String)reOrgstr.toString())) {
            return String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%s\u5df2\u7ef4\u62a4\u4e86\u65f6\u95f4\u8303\u56f4\uff0c\u4e0d\u9700\u518d\u7ef4\u62a4\u3002", (String)"SysParamSettingEditPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0]), reOrgstr.toString());
        }
        coms.addAll(bizs);
        coms.retainAll(times);
        bizs.removeAll(coms);
        times.removeAll(coms);
        StringBuilder bizstr = new StringBuilder();
        if (!CadEmptyUtils.isEmpty(times)) {
            for (DynamicObject dynamicObject : times) {
                bizstr.append("\u3010");
                bizstr.append(dynamicObject.getString("name"));
                bizstr.append("\u3011");
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!CadEmptyUtils.isEmpty(bizs)) {
            for (DynamicObject biz : bizs) {
                stringBuilder.append("\u3010");
                stringBuilder.append(biz.getString("name"));
                stringBuilder.append("\u3011");
            }
        }
        String string = "";
        if (CadEmptyUtils.isEmpty((String)bizstr.toString()) && CadEmptyUtils.isEmpty((String)stringBuilder.toString())) {
            return string;
        }
        if (ImportServiceHelper.isOldUserForSysParamBizRange().booleanValue() && !"eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView())) && !CadEmptyUtils.isEmpty((String)bizstr.toString())) {
            String string2 = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%s\u9700\u8981\u7ef4\u62a4\u4e1a\u52a1\u8303\u56f4\u3002", (String)"SysParamSettingEditPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]), bizstr.toString());
        }
        if (!CadEmptyUtils.isEmpty((String)stringBuilder.toString())) {
            void var10_20;
            void var10_18;
            if (StringUtils.isNotBlank((String)var10_18)) {
                String string3 = (String)var10_18 + "\uff0c";
            }
            String string4 = (String)var10_20 + String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7%s\u7684\u65f6\u95f4\u8303\u56f4\u3002", (String)"SysParamSettingEditPlugin_23", (String)"macc-cad-formplugin", (Object[])new Object[0]), stringBuilder.toString());
        }
        return var10_22;
    }

    private void saveAccountParams() {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        DynamicObjectCollection accountParamRows = this.getModel().getEntryEntity("accountparamlist");
        DynamicObject[] accountParams = this.queryCostAccountParams(this.getView().getFormShowParameter().getAppId());
        HashSet<String> dbAccountParams = new HashSet<String>(10);
        HashSet<String> curAccountParams = new HashSet<String>(10);
        for (DynamicObject accountParam : accountParams) {
            String str = accountParam.get("org.id") + "@" + accountParam.get("costaccount.id");
            dbAccountParams.add(str);
        }
        for (DynamicObject accountParamRow : accountParamRows) {
            String str = accountParamRow.get("org.id") + "@" + accountParamRow.get("costaccount.id");
            curAccountParams.add(str);
        }
        HashSet<String> delAccountParams = new HashSet<String>(10);
        if (this.getPageCache().get(PAGECACHE_PREACCOUNTPARAMS) != null) {
            String[] preAccountParams;
            for (String preAccountParam : preAccountParams = this.getPageCache().get(PAGECACHE_PREACCOUNTPARAMS).split(",")) {
                if (CadEmptyUtils.isEmpty((String)preAccountParam) || curAccountParams.contains(preAccountParam)) continue;
                delAccountParams.add(preAccountParam);
            }
        }
        for (String curAccountParam : curAccountParams) {
            if (!dbAccountParams.contains(curAccountParam)) continue;
            delAccountParams.add(curAccountParam);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        ArrayList<Long> costAccountIds = new ArrayList<Long>(10);
        for (String delAccountParam : delAccountParams) {
            String[] param = delAccountParam.split("@");
            orgIds.add(Long.valueOf(param[0]));
            costAccountIds.add(Long.valueOf(param[1]));
        }
        if (!CadEmptyUtils.isEmpty(orgIds)) {
            QFilter filter = new QFilter("tab", "=", (Object)TAB_COSTACCOUNTPAGE);
            filter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
            filter.and("org", "in", orgIds);
            filter.and("costaccount", "in", costAccountIds);
            DeleteServiceHelper.delete((String)"cad_sysparam", (QFilter[])new QFilter[]{filter});
        }
        this.logIsUpdateByPeriod(accountParams, accountParamRows);
        this.logIsAllUpdate(accountParams, accountParamRows);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)accountParamRows)) {
            for (DynamicObject row : accountParamRows) {
                DynamicObject sysParam = BusinessDataServiceHelper.newDynamicObject((String)"cad_sysparam");
                sysParam.set("tab", (Object)TAB_COSTACCOUNTPAGE);
                sysParam.set("org", (Object)row.getLong("org.id"));
                sysParam.set("costaccount", (Object)row.getLong("costaccount.id"));
                sysParam.set("isupdatebyperiod", (Object)row.getBoolean("isupdatebyperiod"));
                sysParam.set("isallupdate", (Object)row.getBoolean("isallupdate"));
                sysParam.set("isMergeBill", (Object)row.getBoolean("isMergeBill"));
                sysParam.set("reductstrategy", (Object)row.getString("reductstrategy"));
                sysParam.set("outsourceprice", (Object)row.getString("outsourceprice"));
                sysParam.set("restoredimension", (Object)row.getString("restoredimension"));
                sysParam.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                sysParam.set("modifydate", (Object)new Date());
                sysParam.set("appnum", (Object)this.getView().getFormShowParameter().getAppId());
                sysParam.set("assistant", (Object)row.getString("assistant"));
                sysParam.set("restorecalcrange", (Object)row.getString("restorecalcrange"));
                sysParam.set("calckeyfield", (Object)row.getString("calckeyfield"));
                sysParam.set("reductcalckeycol", (Object)row.getString("reductcalckeycol"));
                sysParam.set("matlevelcalckey", (Object)row.getString("matlevelcalckey"));
                sysParam.set("reductrestorekeycol", (Object)row.getString("reductrestorekeycol"));
                DynamicObjectCollection restoreGetDataRangeDynCols = sysParam.getDynamicObjectCollection("restoregetdatarange");
                for (DynamicObject dyn : row.getDynamicObjectCollection("restoregetdatarange")) {
                    restoreGetDataRangeDynCols.addNew().set("fbasedataid_id", (Object)dyn.getLong("fbasedataid.id"));
                }
                list.add(sysParam);
            }
        }
        if (CadEmptyUtils.isEmpty(list)) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_sysparam");
        SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
    }

    private void logIsUpdateByPeriod(DynamicObject[] dbAccountParams, DynamicObjectCollection viewAccountParams) {
        HashMap<String, String> detailInfos = new HashMap<String, String>(16);
        HashMap<String, Boolean> dbParams = new HashMap<String, Boolean>(16);
        for (DynamicObject dbAccountParam : dbAccountParams) {
            String key = dbAccountParam.get("org.id") + "@" + dbAccountParam.get("costaccount.id");
            detailInfos.put(key, this.getDetailTip(dbAccountParam));
            dbParams.put(key, dbAccountParam.getBoolean("isupdatebyperiod"));
        }
        HashMap<String, Boolean> viewParams = new HashMap<String, Boolean>(16);
        for (DynamicObject viewAccountParam : viewAccountParams) {
            String key = viewAccountParam.get("org.id") + "@" + viewAccountParam.get("costaccount.id");
            detailInfos.put(key, this.getDetailTip(viewAccountParam));
            viewParams.put(key, viewAccountParam.getBoolean("isupdatebyperiod"));
        }
        HashSet<String> descriptions = new HashSet<String>(16);
        Set viewKeys = viewParams.keySet();
        String startOp = ResManager.loadKDString((String)"\u3010\u5f00\u542f\u3011", (String)"SysParamSettingEditPlugin_26", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        String closeOp = ResManager.loadKDString((String)"\u3010\u5173\u95ed\u3011", (String)"SysParamSettingEditPlugin_27", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        for (Map.Entry dbParam : dbParams.entrySet()) {
            if (viewKeys.contains(dbParam.getKey()) && !((Boolean)dbParam.getValue()).equals(viewParams.get(dbParam.getKey()))) {
                String string = String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c\u6309\u671f\u8fdb\u884c\u6210\u672c\u66f4\u65b0\u201d\u72b6\u6001\u7531%2$s\u4fee\u6539\u4e3a%3$s\u3002", (String)"SysParamSettingEditPlugin_45", (String)"macc-cad-formplugin", (Object[])new Object[0]), detailInfos.get(dbParam.getKey()), Boolean.TRUE.equals(dbParam.getValue()) ? startOp : closeOp, Boolean.TRUE.equals(viewParams.get(dbParam.getKey())) ? startOp : closeOp);
                descriptions.add(string);
            }
            if (viewKeys.contains(dbParam.getKey())) continue;
            String string = String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c\u6309\u671f\u8fdb\u884c\u6210\u672c\u66f4\u65b0\u201d\u7684\u72b6\u6001=%2$s\u88ab\u5220\u9664\u3002", (String)"SysParamSettingEditPlugin_46", (String)"macc-cad-formplugin", (Object[])new Object[0]), detailInfos.get(dbParam.getKey()), Boolean.TRUE.equals(dbParam.getValue()) ? startOp : closeOp);
            descriptions.add(string);
        }
        Set dbKeys = dbParams.keySet();
        for (Map.Entry entry : viewParams.entrySet()) {
            if (dbKeys.contains(entry.getKey())) continue;
            String description = String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c\u6309\u671f\u8fdb\u884c\u6210\u672c\u66f4\u65b0\u201d\u7684\u72b6\u6001=%2$s\u65b0\u589e\u3002", (String)"SysParamSettingEditPlugin_47", (String)"macc-cad-formplugin", (Object[])new Object[0]), detailInfos.get(entry.getKey()), Boolean.TRUE.equals(entry.getValue()) ? startOp : closeOp);
            descriptions.add(description);
        }
        if (descriptions.isEmpty()) {
            return;
        }
        String opType = ResManager.loadKDString((String)"\u4fdd\u5b58\u4fee\u6539", (String)"SysParamSettingEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        WriteLogUtils.addBatchLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)"0DDNKGUZRMR8", (String)opType, descriptions, (String)"cad_sysparamsetting");
    }

    private void logIsAllUpdate(DynamicObject[] dbAccountParams, DynamicObjectCollection viewAccountParams) {
        HashMap<String, String> detailInfos = new HashMap<String, String>(16);
        HashMap<String, Boolean> dbParams = new HashMap<String, Boolean>(16);
        for (DynamicObject dbAccountParam : dbAccountParams) {
            String key = dbAccountParam.get("org.id") + "@" + dbAccountParam.get("costaccount.id");
            detailInfos.put(key, this.getDetailTip(dbAccountParam));
            dbParams.put(key, dbAccountParam.getBoolean("isallupdate"));
        }
        HashMap<String, Boolean> viewParams = new HashMap<String, Boolean>(16);
        for (DynamicObject viewAccountParam : viewAccountParams) {
            String key = viewAccountParam.get("org.id") + "@" + viewAccountParam.get("costaccount.id");
            detailInfos.put(key, this.getDetailTip(viewAccountParam));
            viewParams.put(key, viewAccountParam.getBoolean("isallupdate"));
        }
        HashSet<String> descriptions = new HashSet<String>(16);
        Set viewKeys = viewParams.keySet();
        String startOp = ResManager.loadKDString((String)"\u3010\u5f00\u542f\u3011", (String)"SysParamSettingEditPlugin_26", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        String closeOp = ResManager.loadKDString((String)"\u3010\u5173\u95ed\u3011", (String)"SysParamSettingEditPlugin_27", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        for (Map.Entry dbParam : dbParams.entrySet()) {
            if (viewKeys.contains(dbParam.getKey()) && !((Boolean)dbParam.getValue()).equals(viewParams.get(dbParam.getKey()))) {
                String string = String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c\u652f\u6301\u5168\u91cf\u66f4\u65b0\u201d\u72b6\u6001 \u7531%2$s\u4fee\u6539\u4e3a%3$s\u3002", (String)"SysParamSettingEditPlugin_51", (String)"macc-cad-formplugin", (Object[])new Object[0]), detailInfos.get(dbParam.getKey()), Boolean.TRUE.equals(dbParam.getValue()) ? startOp : closeOp, Boolean.TRUE.equals(viewParams.get(dbParam.getKey())) ? startOp : closeOp);
                descriptions.add(string);
            }
            if (viewKeys.contains(dbParam.getKey())) continue;
            String string = String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c\u652f\u6301\u5168\u91cf\u66f4\u65b0\u201d\u7684\u72b6\u6001=%2$s\u88ab\u5220\u9664\u3002", (String)"SysParamSettingEditPlugin_52", (String)"macc-cad-formplugin", (Object[])new Object[0]), detailInfos.get(dbParam.getKey()), Boolean.TRUE.equals(dbParam.getValue()) ? startOp : closeOp);
            descriptions.add(string);
        }
        Set dbKeys = dbParams.keySet();
        for (Map.Entry entry : viewParams.entrySet()) {
            if (dbKeys.contains(entry.getKey())) continue;
            String description = String.format(ResManager.loadKDString((String)"%1$s\u7684\u201c\u652f\u6301\u5168\u91cf\u66f4\u65b0\u201d\u7684\u72b6\u6001=%2$s\u65b0\u589e\u3002", (String)"SysParamSettingEditPlugin_53", (String)"macc-cad-formplugin", (Object[])new Object[0]), detailInfos.get(entry.getKey()), Boolean.TRUE.equals(entry.getValue()) ? startOp : closeOp);
            descriptions.add(description);
        }
        if (descriptions.isEmpty()) {
            return;
        }
        String opType = ResManager.loadKDString((String)"\u4fdd\u5b58\u4fee\u6539", (String)"SysParamSettingEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        WriteLogUtils.addBatchLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)"0DDNKGUZRMR8", (String)opType, descriptions, (String)"cad_sysparamsetting");
    }

    private String getDetailTip(DynamicObject sysParams) {
        StringBuilder sg = new StringBuilder();
        String str = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s/%2$s\u3011", (String)"SysParamSettingEditPlugin_32", (String)"macc-cad-formplugin", (Object[])new Object[0]), sysParams.getString("org.number"), sysParams.getString("org.name"));
        sg.append(str);
        String str2 = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s/%2$s\u3011", (String)"SysParamSettingEditPlugin_33", (String)"macc-cad-formplugin", (Object[])new Object[0]), sysParams.getString("costaccount.number"), sysParams.getString("costaccount.name"));
        sg.append(str2);
        return sg.toString();
    }

    private void saveAccumulParams() {
        this.saveTimeParams();
        this.saveBizParams();
    }

    private void saveTimeParams() {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        DynamicObjectCollection collParamRows = this.getModel().getEntryEntity("timelist");
        DynamicObject[] actParams = this.queryTimeAccumulParams(this.getView().getFormShowParameter().getAppId());
        HashSet<String> dbTimeAccumulParams = new HashSet<String>(10);
        HashSet<String> curTimeAccumulParams = new HashSet<String>(10);
        for (DynamicObject actParam : actParams) {
            String str = actParam.getString("actorg.id");
            dbTimeAccumulParams.add(str);
        }
        for (DynamicObject collParamRow : collParamRows) {
            String str = collParamRow.getString("actorg.id");
            curTimeAccumulParams.add(str);
        }
        HashSet<String> delTimeAccumulParams = new HashSet<String>(10);
        if (this.getPageCache().get(PAGECACHE_PRETIMEACCUMULPARAMS) != null) {
            String[] preTimeAccumulParams;
            for (String preTimeAccumulParam : preTimeAccumulParams = this.getPageCache().get(PAGECACHE_PRETIMEACCUMULPARAMS).split(",")) {
                if (CadEmptyUtils.isEmpty((String)preTimeAccumulParam) || curTimeAccumulParams.contains(preTimeAccumulParam)) continue;
                delTimeAccumulParams.add(preTimeAccumulParam);
            }
        }
        for (String curAccumulParam : curTimeAccumulParams) {
            if (!dbTimeAccumulParams.contains(curAccumulParam)) continue;
            delTimeAccumulParams.add(curAccumulParam);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        for (String delTimeAccumulParam : delTimeAccumulParams) {
            orgIds.add(Long.valueOf(delTimeAccumulParam));
        }
        if (!CadEmptyUtils.isEmpty(orgIds)) {
            Iterator filter = new QFilter("tab", "=", (Object)TAB_COSTACCUMULTABPAGE);
            filter.and("appnum", "=", this.getView().getFormShowParameter().getAppId());
            filter.and("actorg", "in", orgIds);
            DeleteServiceHelper.delete((String)"cad_sysparam", (QFilter[])new QFilter[]{filter});
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)collParamRows)) {
            for (DynamicObject row : collParamRows) {
                DynamicObject sysParam = BusinessDataServiceHelper.newDynamicObject((String)"cad_sysparam");
                sysParam.set("tab", (Object)TAB_COSTACCUMULTABPAGE);
                sysParam.set("actorg", (Object)row.getLong("actorg.id"));
                String importScopePeriodStr = row.getString("importperiodscope");
                if (CadEmptyUtils.isEmpty((String)importScopePeriodStr)) continue;
                String[] importScopes = importScopePeriodStr.split(",");
                Set importScopeSet = Arrays.stream(importScopes).filter(item -> !item.isEmpty()).collect(Collectors.toSet());
                String selectedImportPeriodScope = StringUtils.join(importScopeSet, (String)",");
                sysParam.set("importperiodscope", (Object)selectedImportPeriodScope);
                sysParam.set("num", row.get("nnum"));
                sysParam.set("ispreviousoneton", (Object)row.getString("ispreviousoneton"));
                sysParam.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                sysParam.set("modifydate", (Object)new Date());
                sysParam.set("appnum", (Object)this.getView().getFormShowParameter().getAppId());
                list.add(sysParam);
            }
        }
        if (CadEmptyUtils.isEmpty(list) || list.size() <= 0) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_sysparam");
        SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
    }

    private void saveBizParams() {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        DynamicObjectCollection collParamRows = this.getModel().getEntryEntity("paramlist");
        DynamicObject[] accountParams = this.queryCostAccumulParams(this.getView().getFormShowParameter().getAppId());
        HashSet<String> dbAccumulParams = new HashSet<String>(10);
        HashSet<String> curAccumulParams = new HashSet<String>(10);
        for (DynamicObject accountParam : accountParams) {
            String str = accountParam.getString("accountorg.id");
            dbAccumulParams.add(str);
        }
        for (DynamicObject collParamRow : collParamRows) {
            String str = collParamRow.getString("accountorg.id");
            curAccumulParams.add(str);
        }
        HashSet<String> delAccumulParams = new HashSet<String>(10);
        if (this.getPageCache().get(PAGECACHE_PREACCUMULPARAMS) != null) {
            String[] preAccumulParams;
            for (String preAccumulParam : preAccumulParams = this.getPageCache().get(PAGECACHE_PREACCUMULPARAMS).split(",")) {
                if (CadEmptyUtils.isEmpty((String)preAccumulParam) || curAccumulParams.contains(preAccumulParam)) continue;
                delAccumulParams.add(preAccumulParam);
            }
        }
        for (String curAccumulParam : curAccumulParams) {
            if (!dbAccumulParams.contains(curAccumulParam)) continue;
            delAccumulParams.add(curAccumulParam);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        for (String delAccumulParam : delAccumulParams) {
            orgIds.add(Long.valueOf(delAccumulParam));
        }
        if (!CadEmptyUtils.isEmpty(orgIds)) {
            Iterator filter = new QFilter("tab", "=", (Object)TAB_COSTACCUMULTABPAGE);
            filter.and("appnum", "=", this.getView().getFormShowParameter().getAppId());
            filter.and("accountorg", "in", orgIds);
            DeleteServiceHelper.delete((String)"cad_sysparam", (QFilter[])new QFilter[]{filter});
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)collParamRows)) {
            for (DynamicObject row : collParamRows) {
                DynamicObject sysParam = BusinessDataServiceHelper.newDynamicObject((String)"cad_sysparam");
                sysParam.set("tab", (Object)TAB_COSTACCUMULTABPAGE);
                sysParam.set("accountorg", (Object)row.getLong("accountorg.id"));
                sysParam.set("costcenter", (Object)row.getLong("costcenter.id"));
                DynamicObjectCollection transactionTypes = row.getDynamicObjectCollection("transactiontype");
                sysParam.set("transactiontype", (Object)transactionTypes);
                sysParam.set("plancollecttype", (Object)row.getString("plancollecttype"));
                sysParam.set("plancollectrange", (Object)row.getString("plancollectrange"));
                sysParam.set("completetype", (Object)row.getString("completetype"));
                sysParam.set("billrange", (Object)row.getString("billrange"));
                sysParam.set("resourceusetype", (Object)row.getString("resourceusetype"));
                sysParam.set("mfgfeebilltype", (Object)row.getString("mfgfeebilltype"));
                sysParam.set("matcollectway", (Object)row.getString("matcollectway"));
                sysParam.set("matcollectrange", (Object)row.getString("matcollectrange"));
                sysParam.set("isautoupdate", (Object)row.getBoolean("isautoupdate"));
                sysParam.set("resourcerange", (Object)row.getString("resourcerange"));
                sysParam.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                sysParam.set("modifydate", (Object)new Date());
                sysParam.set("appnum", (Object)this.getView().getFormShowParameter().getAppId());
                sysParam.set("warehousepoint", (Object)row.getBoolean("warehousepoint"));
                list.add(sysParam);
            }
        }
        if (CadEmptyUtils.isEmpty(list) || list.size() <= 0) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_sysparam");
        SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
    }

    private List<Long> getHasPermAccountOrgs() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isSuperuser = PermissionServiceHelper.isSuperUser((long)userId);
        if (isSuperuser) {
            return OrgUnitServiceHelper.getAllOrg((String)"10");
        }
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)userId).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
        return orgIds;
    }

    private static List<Long> getBaseDataIdList(DynamicObjectCollection mulBaseData) {
        ArrayList<Long> bastdataidList = new ArrayList<Long>();
        if (mulBaseData != null && mulBaseData.size() > 0) {
            for (DynamicObject amountType : mulBaseData) {
                bastdataidList.add(amountType.getLong("fbasedataid.id"));
            }
        }
        return bastdataidList;
    }

    private Set<Long> getTransTypeFilter(DynamicObject paramlist) {
        HashSet<Long> transSet = new HashSet<Long>(16);
        if (CadEmptyUtils.isEmpty((DynamicObject)paramlist)) {
            return transSet;
        }
        Long orgId = paramlist.getLong("accountorg.id");
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            return transSet;
        }
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"04")) {
            this.toTransaIdSet(transSet, BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)orgId));
        }
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)false);
        for (Long productOrg : productOrgs) {
            this.toTransaIdSet(transSet, BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)productOrg));
        }
        return transSet;
    }

    private void toTransaIdSet(Set<Long> transaIds, QFilter filter) {
        DynamicObjectCollection transactions = QueryServiceHelper.query((String)"mpdm_transactproduct", (String)"id", (QFilter[])new QFilter[]{filter});
        for (DynamicObject transaction : transactions) {
            transaIds.add(transaction.getLong("id"));
        }
    }

    private DynamicObject[] queryCostAccountParams(String appNum) {
        List<Long> hasPermAccountOrgs = this.getHasPermAccountOrgs();
        QFilter acctOrgFilter = null;
        acctOrgFilter = CollectionUtils.isEmpty(hasPermAccountOrgs) ? new QFilter("org", "=", (Object)-1L) : new QFilter("org", "in", hasPermAccountOrgs);
        acctOrgFilter.and("tab", "=", (Object)TAB_COSTACCOUNTPAGE);
        acctOrgFilter.and("appnum", "=", (Object)appNum);
        DynamicObject[] costAccountParams = BusinessDataServiceHelper.load((String)"cad_sysparam", (String)"id,org,costaccount,isupdatebyperiod,isallupdate,ismergebill,reductstrategy,outsourceprice,restoredimension,assistant,restorecalcrange,restoregetdatarange,calckeyfield,reductcalckeycol,matlevelcalckey,reductrestorekeycol", (QFilter[])new QFilter[]{acctOrgFilter});
        return costAccountParams == null ? new DynamicObject[]{} : costAccountParams;
    }

    private DynamicObject[] queryTimeAccumulParams(String appNum) {
        List<Long> hasPermAccountOrgs = this.getHasPermAccountOrgs();
        QFilter acctOrgFilter = null;
        acctOrgFilter = CollectionUtils.isEmpty(hasPermAccountOrgs) ? new QFilter("actorg", "=", (Object)-1L) : new QFilter("actorg", "in", hasPermAccountOrgs);
        acctOrgFilter.and("tab", "=", (Object)TAB_COSTACCUMULTABPAGE);
        acctOrgFilter.and("appnum", "=", (Object)appNum);
        DynamicObject[] costAccumulParams = BusinessDataServiceHelper.load((String)"cad_sysparam", (String)"id,actorg,importperiodscope,num,ispreviousoneton", (QFilter[])new QFilter[]{acctOrgFilter});
        return costAccumulParams == null ? new DynamicObject[]{} : costAccumulParams;
    }

    private DynamicObject[] queryCostAccumulParams(String appNum) {
        List<Long> hasPermAccountOrgs = this.getHasPermAccountOrgs();
        QFilter acctOrgFilter = null;
        acctOrgFilter = CollectionUtils.isEmpty(hasPermAccountOrgs) ? new QFilter("accountorg", "=", (Object)-1L) : new QFilter("accountorg", "in", hasPermAccountOrgs);
        acctOrgFilter.and("tab", "=", (Object)TAB_COSTACCUMULTABPAGE);
        acctOrgFilter.and("appnum", "=", (Object)appNum);
        DynamicObject[] costAccumulParams = BusinessDataServiceHelper.load((String)"cad_sysparam", (String)"id,accountorg,costcenter,transactiontype,isautoupdate,completetype,resourceusetype,mfgfeebilltype,billrange,fbasedataid,matcollectway,matcollectrange,resourcerange,warehousepoint,plancollecttype,plancollectrange", (QFilter[])new QFilter[]{acctOrgFilter});
        return costAccumulParams == null ? new DynamicObject[]{} : costAccumulParams;
    }

    private void resetComBoEditValByCostCalMethod(String costCalMethod, int rowIndex, String field, Boolean isChange) {
        String matcollectWay;
        String resourceuseType;
        String completeType;
        if (CostObjectEnum.BIZTYPE_RO.getValue().equals(costCalMethod)) {
            if (AppIdHelper.isSCA((IFormView)this.getView())) {
                this.resetComBoEditVal("completetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_API, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[]{SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_API, SysParamEnum.COMPTYPE_MANUAL});
                this.resetComBoEditVal("matcollectway", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT, SysParamEnum.COMPTYPE_TPLIMPORT, SysParamEnum.COMPTYPE_APIINTERFACE, SysParamEnum.COMPTYPE_MANUALENTER}, new SysParamEnum[]{SysParamEnum.COMPTYPE_TPLIMPORT, SysParamEnum.COMPTYPE_APIINTERFACE, SysParamEnum.COMPTYPE_MANUALENTER});
                this.resetComBoEditVal("resourceusetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_API, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[]{SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_API, SysParamEnum.COMPTYPE_MANUAL});
            } else if (isChange.booleanValue()) {
                this.resetComBoEditVal("resourceusetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[0]);
            } else if ("resourceusetype".equals(field)) {
                this.resetComBoEditVal("resourceusetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[0]);
                this.setEnableForCollectWay(rowIndex);
                return;
            }
            this.resetComBoEditVal("plancollectrange", JHSC_BILLANGE, new SysParamEnum[]{SysParamEnum.BILLRANGE_JHSC_WGRK});
            this.resetComBoEditVal("billrange", WGRK_BILLANGE, new SysParamEnum[]{SysParamEnum.BILLRANGE_WGRK_PRODUCTCOMPELETE});
            this.resetComBoEditVal("resourcerange", ZYHY_BILLANGE, new SysParamEnum[0]);
            this.resetComBoEditVal("matcollectrange", CLHY_BILLANGE, new SysParamEnum[0]);
            if ("plancollectrange".equals(field)) {
                completeType = (String)this.getModel().getValue("plancollecttype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completeType)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("plancollectrange", (Object)",SCGD,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("plancollectrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"plancollectrange"});
                }
            } else if ("billrange".equals(field)) {
                completeType = (String)this.getModel().getValue("completetype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completeType)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("billrange", (Object)",WIPCOMPELETE,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("billrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"billrange"});
                }
            } else if ("resourcerange".equals(field)) {
                resourceuseType = (String)this.getModel().getValue("resourceusetype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(resourceuseType)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("resourcerange", (Object)",PROCESSREPORT,PROCESSADJUST,MFTORDERREPORT,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("resourcerange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"resourcerange"});
                }
            } else if ("matcollectrange".equals(field)) {
                matcollectWay = (String)this.getModel().getValue("matcollectway", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT.getValue().equals(matcollectWay)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("matcollectrange", (Object)",PRO_GET,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("matcollectrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"matcollectrange"});
                }
            }
        }
        if (CostObjectEnum.BIZTYPE_SO.getValue().equals(costCalMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(costCalMethod)) {
            if (isChange.booleanValue()) {
                this.resetComBoEditVal("resourceusetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE});
            } else if ("resourceusetype".equals(field)) {
                this.resetComBoEditVal("resourceusetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE});
                this.setEnableForCollectWay(rowIndex);
                return;
            }
            this.resetComBoEditVal("plancollectrange", JHSC_BILLANGE, new SysParamEnum[]{SysParamEnum.BILLRANGE_JHSC_SCGD, SysParamEnum.BILLRANGE_JHSC_WWGD});
            this.resetComBoEditVal("billrange", WGRK_BILLANGE, new SysParamEnum[]{SysParamEnum.BILLRANGE_WGRK_WIPCOMPELETE, SysParamEnum.BILLRANGE_WGRK_WWGRK});
            this.resetComBoEditVal("resourcerange", ZYHY_BILLANGE, ZYHY_BILLANGE);
            this.resetComBoEditVal("matcollectrange", CLHY_BILLANGE, new SysParamEnum[]{SysParamEnum.BILLRANGE_CLHY_PROGET, SysParamEnum.BILLRANGE_CLHY_WLL});
            if ("plancollectrange".equals(field)) {
                completeType = (String)this.getModel().getValue("plancollecttype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completeType)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("plancollectrange", (Object)",WGRK,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("plancollectrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"plancollectrange"});
                }
            } else if ("billrange".equals(field)) {
                completeType = (String)this.getModel().getValue("completetype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completeType)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("billrange", (Object)",PRODUCTCOMPELETE,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("billrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"billrange"});
                }
            } else if ("resourcerange".equals(field)) {
                resourceuseType = (String)this.getModel().getValue("resourceusetype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(resourceuseType)) {
                    this.getModel().setValue("resourcerange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"resourcerange"});
                }
            } else if ("matcollectrange".equals(field)) {
                matcollectWay = (String)this.getModel().getValue("matcollectway", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT.getValue().equals(matcollectWay)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("matcollectrange", (Object)",GET_OUTSTORAGE,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("matcollectrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"matcollectrange"});
                }
            }
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"transactiontype"});
        }
        if (CostObjectEnum.BIZTYPE_PZ.getValue().equals(costCalMethod)) {
            if (isChange.booleanValue()) {
                this.resetComBoEditVal("resourceusetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[0]);
            } else if ("resourceusetype".equals(field)) {
                this.resetComBoEditVal("resourceusetype", new SysParamEnum[]{SysParamEnum.COMPTYPE_SYS_OBJECTRULE, SysParamEnum.COMPTYPE_EXCEL, SysParamEnum.COMPTYPE_MANUAL}, new SysParamEnum[0]);
                this.setEnableForCollectWay(rowIndex);
                return;
            }
            this.resetComBoEditVal("plancollectrange", JHSC_BILLANGE, new SysParamEnum[0]);
            this.resetComBoEditVal("billrange", WGRK_BILLANGE, new SysParamEnum[0]);
            this.resetComBoEditVal("resourcerange", ZYHY_BILLANGE, new SysParamEnum[0]);
            this.resetComBoEditVal("matcollectrange", CLHY_BILLANGE, new SysParamEnum[0]);
            if ("plancollectrange".equals(field)) {
                completeType = (String)this.getModel().getValue("plancollecttype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completeType)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("plancollectrange", (Object)",SCGD,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("plancollectrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"plancollectrange"});
                }
            } else if ("billrange".equals(field)) {
                completeType = (String)this.getModel().getValue("completetype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(completeType)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("billrange", (Object)",WIPCOMPELETE,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("billrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"billrange"});
                }
            } else if ("resourcerange".equals(field)) {
                resourceuseType = (String)this.getModel().getValue("resourceusetype", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(resourceuseType)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("resourcerange", (Object)",PROCESSREPORT,PROCESSADJUST,MFTORDERREPORT,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("resourcerange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"resourcerange"});
                }
            } else if ("matcollectrange".equals(field)) {
                matcollectWay = (String)this.getModel().getValue("matcollectway", rowIndex);
                if (SysParamEnum.COMPTYPE_SYS_INNERSYSIMPORT.getValue().equals(matcollectWay)) {
                    if (this.getPageCache().get("focusTimes") == null || !this.getPageCache().get("focusTimes").equals(String.valueOf(rowIndex))) {
                        this.getModel().setValue("matcollectrange", (Object)",PRO_GET,", rowIndex);
                    }
                } else {
                    this.getModel().setValue("matcollectrange", null, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"matcollectrange"});
                }
            }
        }
        this.setEnableForCollectWay(rowIndex);
    }

    private void setEnableForCollectWay(int rowIndex) {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"completetype"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"matcollectway"});
        }
    }

    private void resetComBoEditVal(String field, SysParamEnum[] sysParamEnums, SysParamEnum[] needHides) {
        ComboEdit ruleEdit = (ComboEdit)this.getControl(field);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(10);
        this.getModel().beginInit();
        for (SysParamEnum sysParamEnum : sysParamEnums) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(sysParamEnum.getValue());
            comboItem.setCaption(new LocaleString(sysParamEnum.getName()));
            if (Arrays.asList(needHides).contains(sysParamEnum)) {
                comboItem.setItemVisible(false);
            }
            propertyItems.add(comboItem);
        }
        ruleEdit.setComboItems(propertyItems);
        this.getModel().endInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataForRule() {
        Object[] params = this.queryCostAccumulParams(this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((Object[])params)) {
            return;
        }
        HashMap<Long, String> needCreateRuleOrgs = new HashMap<Long, String>(16);
        for (Object param : params) {
            String costCalMethod;
            Long costcenter = param.getLong("costcenter.id");
            Long org = param.getLong("accountorg.id");
            if (CadEmptyUtils.isEmpty((Long)org) || !CadEmptyUtils.isEmpty((Long)costcenter) || !CadEmptyUtils.isEmpty((String)(costCalMethod = CostObjectHelper.getCostCalMethod((Long)org, (Long)costcenter)))) continue;
            needCreateRuleOrgs.put(org, param.getString("accountorg.name"));
        }
        if (CadEmptyUtils.isEmpty(needCreateRuleOrgs)) {
            return;
        }
        try (TXHandle txHandle = TX.required();){
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            int pn = 0;
            for (Map.Entry needCreateRuleOrg : needCreateRuleOrgs.entrySet()) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_costobjectrule");
                dynamicObject.set("number", (Object)("CR-00010" + pn));
                dynamicObject.set("name", needCreateRuleOrg.getValue());
                dynamicObject.set("accountorg", needCreateRuleOrg.getKey());
                dynamicObject.set("biztype", (Object)"RO");
                dynamicObject.set("rule", (Object)"SN");
                dynamicObject.set("sotype", (Object)"PB");
                dynamicObject.set("objrule", (Object)"CR_SRC");
                dynamicObject.set("objrulename", (Object)"CRN_SRC");
                dynamicObject.set("status", (Object)"C");
                dynamicObject.set("enable", (Object)"1");
                dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
                dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
                dynamicObject.set("auditor", (Object)RequestContext.get().getUserId());
                dynamicObject.set("createtime", (Object)new Date());
                dynamicObject.set("modifytime", (Object)new Date());
                dynamicObject.set("auditdate", (Object)new Date());
                ++pn;
                list.add(dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    private void updateDataForTimeScope() {
        QFilter orgFilter = new QFilter("actorg", ">", (Object)0L);
        Object[] timeDys = BusinessDataServiceHelper.load((String)"cad_sysparam", (String)"importtimescope,ispreviousoneton,effectcontrol", (QFilter[])new QFilter[]{orgFilter});
        if (CadEmptyUtils.isEmpty((Object[])timeDys)) {
            return;
        }
        for (Object time : timeDys) {
            String importTimeScope;
            String effectControl = time.getString("effectcontrol");
            if (!CadEmptyUtils.isEmpty((String)effectControl) && effectControl.contains(",aca_subelementandmat")) {
                time.set("effectcontrol", (Object)effectControl.replace(",aca_subelementandmat", ""));
            }
            if (CadEmptyUtils.isEmpty((String)(importTimeScope = time.getString("importtimescope")))) continue;
            boolean isPreviousOneToN = time.getBoolean("ispreviousoneton");
            List<String> timeScopes = Arrays.asList(importTimeScope.split(","));
            ArrayList<String> timeScopesList = new ArrayList<String>(timeScopes);
            if (timeScopesList.contains("previousmonth") && !isPreviousOneToN) {
                timeScopesList.remove("previousmonth");
                timeScopesList.add("previousonlymonth");
            }
            time.set("ispreviousoneton", (Object)true);
            timeScopesList.remove("nextmonth");
            String timeScopeStr = StringUtils.join(timeScopesList, (String)",");
            time.set("importtimescope", (Object)timeScopeStr);
        }
        SaveServiceHelper.update((DynamicObject[])timeDys);
    }

    private void updateDataForBizScope() {
        QFilter orgFilter = new QFilter("accountorg", ">", (Object)0L);
        Object[] rangeDys = BusinessDataServiceHelper.load((String)"cad_sysparam", (String)"billrange,matcollectrange", (QFilter[])new QFilter[]{orgFilter});
        if (CadEmptyUtils.isEmpty((Object[])rangeDys)) {
            return;
        }
        for (Object range : rangeDys) {
            String billrange = range.getString("billrange");
            String matcollectrange = range.getString("matcollectrange");
            if (CadEmptyUtils.isEmpty((String)billrange) && CadEmptyUtils.isEmpty((String)matcollectrange)) continue;
            List<String> billranges = Arrays.asList(billrange.split(","));
            List<String> matcollectranges = Arrays.asList(matcollectrange.split(","));
            ArrayList<String> billrangesList = new ArrayList<String>(billranges);
            ArrayList<String> matcollectrangesList = new ArrayList<String>(matcollectranges);
            Iterator billRanges = billrangesList.iterator();
            while (billRanges.hasNext()) {
                String s = (String)billRanges.next();
                if (!CadEmptyUtils.isEmpty((String)s)) continue;
                billRanges.remove();
            }
            Iterator matCollectRanges = matcollectrangesList.iterator();
            while (matCollectRanges.hasNext()) {
                String s = (String)matCollectRanges.next();
                if (!CadEmptyUtils.isEmpty((String)s)) continue;
                matCollectRanges.remove();
            }
            if (!billrangesList.contains("WIPCOMPELETE") && billrangesList.remove("WIPCOMPELETEBACK")) {
                billrangesList.add("WIPCOMPELETE");
            }
            if (!billrangesList.contains("PRODUCTCOMPELETE") && billrangesList.remove("PRODUCTCOMPELETEBACK")) {
                billrangesList.add("PRODUCTCOMPELETE");
            }
            if (!matcollectrangesList.contains("PRO_GET") && (matcollectrangesList.remove("PRO_FALLBACK") || matcollectrangesList.remove("PRO_ADD"))) {
                matcollectrangesList.add("PRO_GET");
            }
            if (!matcollectrangesList.contains("WLL") && (matcollectrangesList.remove("WTL") || matcollectrangesList.remove("WBL"))) {
                matcollectrangesList.add("WLL");
            }
            billrangesList.remove("WIPCOMPELETEBACK");
            billrangesList.remove("PRODUCTCOMPELETEBACK");
            matcollectrangesList.remove("PRO_FALLBACK");
            matcollectrangesList.remove("PRO_ADD");
            matcollectrangesList.remove("WTL");
            matcollectrangesList.remove("WBL");
            billrange = StringUtils.join(billrangesList, (String)",");
            matcollectrange = StringUtils.join(matcollectrangesList, (String)",");
            range.set("billrange", (Object)",".concat(billrange).concat(","));
            range.set("matcollectrange", (Object)",".concat(matcollectrange).concat(","));
        }
        SaveServiceHelper.update((DynamicObject[])rangeDys);
    }
}

