/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.syssetting;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanCostSettingHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.PermissionBillPlugin;

public class PlanCostSettingEdit
extends PermissionBillPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filters.add(new QFilter("id", "in", (Object)hasPermAccountOrgIds));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        this.initPresetFilter();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
                Long id = (Long)this.getModel().getValue("id");
                boolean isHasPlnCostSetting = PlanCostSettingHelper.isHasPlnCostSetting((Long)orgObj.getLong("id"), (Long)id);
                if (isHasPlnCostSetting) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u5df2\u7ecf\u7ef4\u62a4\u4e86\u8ba1\u5212\u6210\u672c\u914d\u7f6e\u89c4\u5219\u3002", (String)"PlanCostSettingEdit_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.dataRangeSave();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)"pom_mftorder");
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)srcMainType);
        List newCols = cols.stream().filter(m -> !m.get("fieldName").equals("planstatus")).collect(Collectors.toList());
        FilterGrid filtergrid = (FilterGrid)this.getView().getControl("filtergrid");
        filtergrid.setEntityNumber(srcMainType.getName());
        filtergrid.setFilterColumns(newCols);
    }

    private void dataRangeSave() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        this.getModel().getDataEntity().set("filter_tag", (Object)filterString);
    }

    private void initData() {
        this.getModel().beginInit();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object org = fsp.getCustomParam("org");
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)org) && !"0".equals(org)) {
            this.getModel().setValue("org", org);
        } else {
            DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
            if (orgObj == null) {
                long orgId;
                List permCalOrgIds = OrgHelper.getHasPermAccountOrgIds((String)"cad_plancost_setting", (String)this.getView().getFormShowParameter().getAppId());
                if (permCalOrgIds.contains(orgId = RequestContext.get().getOrgId())) {
                    this.getModel().setValue("org", (Object)orgId);
                } else if (!CadEmptyUtils.isEmpty((List)permCalOrgIds)) {
                    List orgIds = OrgHelper.getOrgOrderByNumber((List)permCalOrgIds);
                    this.getModel().setValue("org", orgIds.get(0));
                }
            }
        }
        this.getModel().endInit();
    }

    public void initPresetFilter() {
        String filter = (String)this.getModel().getDataEntity().get("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(filterCondition);
        }
    }
}

