/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.utils;

import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.ConvertPath;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.info.DynamicParamModel;
import kd.fi.iep.info.ParamEntry;
import kd.fi.iep.util.IntelAccountingConstant;

public class IntellExecSchemaUtil {
    public static final String BILL_NAME = "IntellCanExecute";
    public static final String FORM_FA_INITCARD_INIT = "fa_initcard_fin";
    private static final Set<String> FILTER_OPERS = new HashSet<String>(){
        private static final long serialVersionUID = -253044767116699695L;
        {
            this.add("new");
            this.add("modify");
            this.add("save");
            this.add("close");
            this.add("option");
            this.add("print");
            this.add("submitandnew");
            this.add("view");
            this.add("printsetting");
            this.add("refresh");
            this.add("copy");
            this.add("assign");
        }
    };

    public static String setOperComboListOperByData(String number, IFormView view) {
        view.getModel().setValue("oper", (Object)number);
        if (number == null) {
            return number;
        }
        return IntellExecSchemaUtil.setOperComboByData(number, view);
    }

    public static String setOperComboByData(String formId, IFormView view) {
        String os;
        String sql = "SELECT DISTINCT e.fnumber number, e.fkey oper FROM t_meta_entity e LEFT JOIN t_meta_bizunitrelform b ON e.fid = b.FFORMID left join t_meta_formdesign c on c.fentityid = e.fid WHERE c.fnumber = ?";
        Object[] dataResult = (Object[])DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new String[]{formId}, rh -> {
            Object[] result = new Object[2];
            String realFormId = null;
            HashSet<String> dataList = new HashSet<String>();
            while (rh.next()) {
                if (realFormId == null) {
                    realFormId = rh.getString("number");
                }
                Object opts = null;
                List ops = EntityMetadataCache.getDataEntityOperate((String)realFormId);
                block1: for (Map each : ops) {
                    opts = each.get("opbiz");
                    if (opts == null) continue;
                    List oos = opts;
                    for (String eac : oos) {
                        if (eac.indexOf(BILL_NAME) <= -1) continue;
                        dataList.add(each.get("key").toString());
                        continue block1;
                    }
                }
            }
            result[0] = realFormId;
            result[1] = dataList;
            return result;
        });
        Object tempEntity = dataResult[0];
        if (tempEntity != null && StringUtils.isNotEmpty((String)(os = tempEntity.toString()))) {
            formId = os;
        }
        Set dataSet = (Set)dataResult[1];
        Map operMap = FormDesignDao.getFormOperMap((String)formId);
        boolean hasBuildVoucher = false;
        List ops = EntityMetadataCache.getDataEntityOperate((String)formId);
        for (Map operMpas : ops) {
            String operKey = operMpas.get("key").toString();
            String type = operMpas.get("type").toString();
            if (FORM_FA_INITCARD_INIT.equals(formId)) continue;
            hasBuildVoucher = true;
            dataSet.add(operKey);
            operMap.put("generatevoucher", IntelAccountingConstant.getGENVOUCHER());
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(dataSet.size() + ops.size() + 1);
        HashMap operValueMap = Maps.newHashMapWithExpectedSize((int)10);
        for (String operKey : dataSet) {
            if (operKey.isEmpty() || FILTER_OPERS.contains(operKey)) continue;
            String nameStr = (String)operMap.get(operKey);
            if (StringUtils.isEmpty((String)nameStr)) {
                nameStr = operKey;
            }
            LocaleString name = new LocaleString(nameStr);
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(operKey);
            comboItem.setCaption(name);
            operValueMap.put(operKey, String.valueOf(name));
            list.add(comboItem);
        }
        view.getPageCache().put((Map)operValueMap);
        if (!hasBuildVoucher && IntellExecSchemaUtil.isDapBillEntitys(formId)) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue("buildvoucher");
            comboItem.setCaption(new LocaleString(IntelAccountingConstant.getGENVOUCHER()));
            list.add(comboItem);
        }
        ComboEdit combo = (ComboEdit)view.getControl("oper");
        combo.setComboItems(list);
        if (list.size() > 0) {
            combo.selectedStore((ComboItem)list.get(0));
        }
        return formId;
    }

    private static List<ConvertPath> loadAllConvertPaths(List<String> appIds) {
        String localeId = Lang.get().toString();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.FSourceEntityNumber, t1_l.FName AS FSourceEntityName ");
        sBuilder.append("      ,t0.FTargetEntityNumber, t2_l.FName AS FTargetEntityName ");
        sBuilder.append("      ,t0.FBizAppId ");
        sBuilder.append("      ,t1.FBizAppId AS FSourceBizAppId, t2.FBizAppId AS FTargetBizAppId ");
        sBuilder.append("FROM T_BOTP_ConvertRule t0 ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign t1 ON (t0.FSourceEntityNumber = t1.FNumber) ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign t2 ON (t0.FTargetEntityNumber = t2.FNumber) ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign_L t1_l ON (t0.FSourceEntityNumber = t1_l.FNumber and t1_l.FLocaleId = '").append(localeId).append("') ");
        sBuilder.append("LEFT JOIN T_META_EntityDesign_L t2_l ON (t0.FTargetEntityNumber = t2_l.FNumber and t2_l.FLocaleId = '").append(localeId).append("') ");
        sBuilder.append("WHERE t0.FType <> '2' AND t1.FBizAppId in (").append(IntellExecSchemaUtil.toSQLString(appIds)).append(")");
        ResultSetHandler<Set<ConvertPath>> action = new ResultSetHandler<Set<ConvertPath>>(){

            public Set<ConvertPath> handle(ResultSet rs) throws Exception {
                HashSet<ConvertPath> paths = new HashSet<ConvertPath>(rs.getRow());
                while (rs.next()) {
                    ConvertPath path = new ConvertPath();
                    path.setSourceEntityNumber(rs.getString("FSourceEntityNumber"));
                    path.setSourceEntityName(rs.getString("FSourceEntityName"));
                    path.setTargetEntityNumber(rs.getString("FTargetEntityNumber"));
                    path.setTargetEntityName(rs.getString("FTargetEntityName"));
                    path.setBizAppId(rs.getString("FBizAppId"));
                    path.setSourceBizAppId(rs.getString("FSourceBizAppId"));
                    path.setTargetBizAppId(rs.getString("FTargetBizAppId"));
                    paths.add(path);
                }
                return paths;
            }
        };
        Set convertPaths = (Set)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), null, (ResultSetHandler)action);
        return new ArrayList<ConvertPath>(convertPaths);
    }

    private static boolean isDapBillEntitys(String formId) {
        QFilter qf = new QFilter("isdap", "=", (Object)Boolean.TRUE);
        QFilter qf2 = new QFilter("billentity.id", "=", (Object)formId);
        boolean isDap = QueryServiceHelper.exists((String)"ai_dapconfig", (QFilter[])new QFilter[]{qf, qf2});
        return isDap;
    }

    public static String toSQLString(List<String> param) {
        StringBuilder sb = new StringBuilder();
        if (param == null || param.size() == 0) {
            return "";
        }
        for (String val : param) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(val).append("'");
        }
        return sb.toString();
    }

    public static List<DynamicParamModel> getParamList(QFilter[] qf) {
        String selectors = "bizapp,bussiness,oper,entryentity.id,entryentity.param,entryentity.paramname,entryentity.comboval,entryentity.require,entryentity.paramval,entryentity.paramdesc,entryentity.paramtype";
        DynamicObject[] paramCol = BusinessDataServiceHelper.load((String)"gl_intellexecparam", (String)selectors, (QFilter[])qf);
        ArrayList<DynamicParamModel> list = new ArrayList<DynamicParamModel>(paramCol.length);
        for (DynamicObject paramObj : paramCol) {
            DynamicParamModel model = new DynamicParamModel();
            DynamicObject app = paramObj.getDynamicObject("bizapp");
            model.setAppId(app == null ? "" : app.getPkValue().toString());
            model.setBusiness(paramObj.getString("bussiness"));
            model.setOper(paramObj.getString("oper"));
            DynamicObjectCollection entrys = paramObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                ParamEntry paramEntry = new ParamEntry();
                paramEntry.setId(entry.getString("id"));
                paramEntry.setNumber(entry.getString("param"));
                paramEntry.setName(entry.getString("paramname"));
                paramEntry.setRequire(entry.getBoolean("require"));
                paramEntry.setParamval(entry.getString("paramval"));
                paramEntry.setParamdesc(entry.getString("paramdesc"));
                paramEntry.setParamtype(entry.getString("paramtype"));
                paramEntry.setComboVal((Object)entry.getString("comboval"));
                model.addParams(paramEntry);
            }
            list.add(model);
        }
        return list;
    }
}

