/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.yieldcollection;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.cad.formplugin.common.Util;

public class FactnedOutputBillEditPlugin
extends AbstractBillPlugIn {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTITY_COST = "entrycost";
    private static final String STD_PRICE = "stdprice";
    private static final String AMOUNT = "amount";
    private static final String COMPLETE_QTY = "completeqty";
    private static final String BIZ_DATE = "bizdate";
    private static final String SCA_START_STD_COST = "sca_startstdcost";
    private static final String BOOK_DATE = "bookdate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit location = (BasedataEdit)this.getControl("location");
        location.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
            if (warehouse == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u4ed3\u5e93\u540e\u518d\u9009\u62e9\u4ed3\u4f4d\u3002", (String)"FactnedOutputBillEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                long warehouseid = warehouse.getLong("id");
                QFilter costcenterFilter = new QFilter("id", "=", (Object)warehouseid);
                DynamicObjectCollection isopenloca = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.location.id", (QFilter[])new QFilter[]{costcenterFilter});
                ArrayList<Long> locaids = new ArrayList<Long>(16);
                for (DynamicObject a : isopenloca) {
                    locaids.add(a.getLong(0));
                }
                if (!CadEmptyUtils.isEmpty(locaids)) {
                    qList.add(new QFilter("id", "in", locaids));
                }
            }
        });
        BasedataEdit version = (BasedataEdit)this.getControl("version");
        version.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("status", "=", (Object)"C"));
            DynamicObject materialver = (DynamicObject)this.getModel().getValue("material");
            if (!CadEmptyUtils.isEmpty((DynamicObject)materialver)) {
                qList.add(new QFilter("material", "=", (Object)materialver.getLong("id")));
            }
        });
        BasedataEdit costcent = (BasedataEdit)this.getControl("costcenter");
        costcent.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            List<Object> ids = new ArrayList();
            String newType = "completetype";
            qList.add(new QFilter("orgduty", "=", (Object)4));
            if (accountorg == null) {
                ids = this.getCostCenterByUser();
                QFilter costcenterFilter = new QFilter("id", "in", ids);
                qList.add(costcenterFilter);
            } else {
                Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                manuOrgList.add(manuorgId);
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                qList.add(costCenterIdFilter);
            }
        });
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
            if (costcenter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u6210\u672c\u4e2d\u5fc3\u540e\u518d\u9009\u62e9\u4ea7\u54c1\u3002", (String)"FactnedOutputBillEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                long costcenterid = costcenter.getLong("id");
                QFilter costcenterFilter = new QFilter("costcenter.id", "=", (Object)costcenterid);
                DynamicObjectCollection materialIds = QueryServiceHelper.query((String)"cad_costobject", (String)"material.id", (QFilter[])new QFilter[]{costcenterFilter});
                ArrayList<Long> locaids = new ArrayList<Long>(16);
                for (DynamicObject materialId : materialIds) {
                    locaids.add(materialId.getLong(0));
                }
                if (!CadEmptyUtils.isEmpty(locaids)) {
                    qList.add(new QFilter("id", "in", locaids));
                }
                qList.add(new QFilter("enable", "=", (Object)true));
                qList.add(new QFilter("status", "=", (Object)"C"));
                qList.add(QFilter.of((String)"enableproduct =? or enableoutsource =?", (Object[])new Object[]{true, true}));
            }
        });
        BasedataEdit plannedoutput = (BasedataEdit)this.getControl("plannedoutput");
        plannedoutput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
            DynamicObject material1 = (DynamicObject)this.getModel().getValue("material");
            DynamicObject auxpty = (DynamicObject)this.getModel().getValue("auxpty");
            DynamicObject matversion = (DynamicObject)this.getModel().getValue("version");
            if (CadEmptyUtils.isEmpty((DynamicObject)costcenter)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u6210\u672c\u4e2d\u5fc3\u540e\u518d\u9009\u62e9\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u5f52\u96c6\u3002", (String)"FactnedOutputBillEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)material1)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u4ea7\u54c1\u540e\u518d\u9009\u62e9\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u5f52\u96c6\u3002", (String)"FactnedOutputBillEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                HashSet<Long> plannedId = new HashSet<Long>();
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                    for (DynamicObject dynamicObject : entryEntity) {
                        DynamicObject costObject = dynamicObject.getDynamicObject("plannedoutput");
                        if (CadEmptyUtils.isEmpty((DynamicObject)costObject)) continue;
                        plannedId.add(costObject.getLong("id"));
                    }
                }
                qList.add(new QFilter("id", "not in", plannedId));
                qList.add(new QFilter("costcenter.id", "=", (Object)costcenter.getLong("id")));
                qList.add(new QFilter("billstatus", "=", (Object)"C"));
                qList.add(new QFilter("material.id", "=", (Object)material1.getLong("id")));
                qList.add(new QFilter("wipqty", ">", (Object)0));
                qList.add(new QFilter("closestatu", "=", (Object)"0"));
                if (auxpty != null) {
                    qList.add(new QFilter("auxpty", "=", (Object)auxpty.getLong("id")));
                } else {
                    qList.add(new QFilter("auxpty", "=", (Object)0L));
                }
                HashSet<Long> coIds = new HashSet<Long>(16);
                QFilter qversion = null;
                qversion = matversion != null ? new QFilter("bomversion", "=", (Object)matversion.getLong("id")) : new QFilter("bomversion", "=", (Object)0L);
                DynamicObjectCollection querycost = QueryServiceHelper.query((String)"cad_costobject", (String)"id", (QFilter[])new QFilter[]{qversion});
                for (DynamicObject co : querycost) {
                    coIds.add(co.getLong("id"));
                }
                qList.add(new QFilter("costobject", "in", coIds));
                filterParameter.setOrderBy("planneddate asc");
            }
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FactnedOutputBillEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void setCostcenterByCostdriver(List<QFilter> qList, DynamicObject accountorg, String newType) {
        DynamicObjectCollection costquery;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        HashSet<Long> costcentIds = new HashSet<Long>();
        if (accountorg != null) {
            filters.add(new QFilter("accountorg", "=", (Object)accountorg.getLong("id")));
        }
        if (CadEmptyUtils.isEmpty((List)(costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)("accountorg,costcenter," + newType), (QFilter[])filters.toArray(new QFilter[0]))))) {
            return;
        }
        Boolean hasNullCostcenter = Boolean.FALSE;
        int isManual = 0;
        long sysOrgId = 0L;
        ArrayList<String> manualList = new ArrayList<String>();
        manualList.add("");
        manualList.add("MANUAL");
        for (Object dynamicObject : costquery) {
            long long1 = dynamicObject.getLong("costcenter");
            if (long1 != 0L) continue;
            sysOrgId = dynamicObject.getLong("accountorg");
            hasNullCostcenter = Boolean.TRUE;
            String stNewType = dynamicObject.getString(newType);
            if (manualList.contains(stNewType)) {
                isManual = 1;
                continue;
            }
            isManual = 2;
        }
        if (hasNullCostcenter.booleanValue() && isManual == 2) {
            filters.add(new QFilter("costcenter", "!=", (Object)0L));
            filters.add(new QFilter(newType, "in", manualList));
            costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])filters.toArray(new QFilter[0]));
            costcentIds.clear();
            List<Long> costCenterByOrg = this.getCostCenterByOrg(sysOrgId);
            if (!CadEmptyUtils.isEmpty((List)costquery)) {
                for (DynamicObject dynamicObject : costquery) {
                    long costcenterId = dynamicObject.getLong("costcenter");
                    if (costCenterByOrg == null) continue;
                    costCenterByOrg.remove(costcenterId);
                }
                QFilter costcenterIdFilter = new QFilter("id", "not in", (Object)costCenterByOrg);
                qList.add(costcenterIdFilter);
            } else {
                List<Long> costCenterByOrg1 = this.getCostCenterByOrg(sysOrgId);
                QFilter costcenterIdFilter = new QFilter("id", "not in", costCenterByOrg1);
                qList.add(costcenterIdFilter);
            }
        } else if (Boolean.FALSE.equals(hasNullCostcenter) || Boolean.TRUE.equals(hasNullCostcenter) && isManual == 1) {
            filters.add(new QFilter("costcenter", "!=", (Object)0L));
            filters.add(new QFilter(newType, "not in", manualList));
            costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])filters.toArray(new QFilter[0]));
            costcentIds.clear();
            if (CadEmptyUtils.isEmpty((List)costquery)) {
                return;
            }
            for (Object dynamicObject : costquery) {
                long costcenterId = dynamicObject.getLong("costcenter");
                costcentIds.add(costcenterId);
            }
            QFilter costcenterIdFilter = new QFilter("id", "not in", costcentIds);
            qList.add(costcenterIdFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        this.initOrgAndCostCenterValue(os);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long sourceBill = (Long)this.getModel().getValue("sourcebill");
        if (!CadEmptyUtils.isEmpty((Long)sourceBill)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo", "fieldsetpanelap"});
        } else {
            BasedataEdit wareHouse = (BasedataEdit)this.getControl("warehouse");
            wareHouse.setMustInput(true);
        }
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        this.initOrgAndCostCenterStatus(os);
        this.updateWareinorg();
        this.initdata();
        this.initEnable();
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if ("aca".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"srcauditdate"});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"plannedoutput"});
        this.changManuorgStatus();
        this.getModel().setDataChanged(false);
    }

    private void initOrgAndCostCenterStatus(OperationStatus os) {
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            Object manuorg;
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Object accountorg = fsp.getCustomParam("org");
            if (accountorg != null && !"".equals(accountorg.toString())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"org"});
            }
            Object costcenter = fsp.getCustomParam("costcenter");
            if (costcenter != null && !"".equals(costcenter.toString())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"costcenter"});
                this.updateAccountOrgStatus();
            }
            if ((manuorg = fsp.getCustomParam("manuorg")) != null && !"".equals(manuorg.toString())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxpty"});
        }
    }

    private void initOrgAndCostCenterValue(OperationStatus os) {
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            Object manuorg;
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Object accountorg = fsp.getCustomParam("org");
            if (accountorg != null && !"".equals(accountorg.toString())) {
                this.getModel().setValue("org", accountorg);
            } else {
                this.getModel().setValue("org", null);
            }
            Object costcenter = fsp.getCustomParam("costcenter");
            if (costcenter != null && !"".equals(costcenter.toString())) {
                this.getModel().setValue("costcenter", costcenter);
                this.updateAccountOrgValue();
            }
            if ((manuorg = fsp.getCustomParam("manuorg")) != null && !"".equals(manuorg.toString())) {
                this.getModel().setValue("manuorg", manuorg);
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxpty"});
        }
    }

    private void initdata() {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (material == null) {
            this.getModel().setValue("version", null);
            this.getModel().setValue("auxpty", null);
            this.getModel().setValue("batch", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"batch"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxpty"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"version"});
            this.getModel().setValue("baseunit", null);
            this.getModel().setValue(COMPLETE_QTY, null);
        } else if (OperationStatus.ADDNEW.equals((Object)os)) {
            long materialid = material.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)materialid);
            DynamicObject isenablematerialversion = QueryServiceHelper.queryOne((String)"bd_material", (String)"isenablematerialversion", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean isenableversion = (Boolean)isenablematerialversion.get(0);
            DynamicObject isuseauxpty = QueryServiceHelper.queryOne((String)"bd_material", (String)"isuseauxpty", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean isuseauxpt = (Boolean)isuseauxpty.get(0);
            DynamicObject enablelo = QueryServiceHelper.queryOne((String)"bd_material", (String)"enablelot", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean enablelot = (Boolean)enablelo.get(0);
            if (isenableversion.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"version"});
            }
            if (isuseauxpt.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"auxpty"});
            }
            if (enablelot.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"batch"});
            }
        }
        if (warehouse != null) {
            long warehouseid = warehouse.getLong("id");
            QFilter warehouseFilter = new QFilter("id", "=", (Object)warehouseid);
            DynamicObject isopenlocationo = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"isopenlocation", (QFilter[])new QFilter[]{warehouseFilter});
            Boolean isopenlocation = (Boolean)isopenlocationo.get(0);
            if (isopenlocation.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"location"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"location"});
        }
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"addbtn"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"removebtn"});
        }
    }

    private void updateWareinorg() {
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
        if (costcenter != null) {
            long accountorgid = costcenter.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)accountorgid);
            DynamicObject query = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"accountorg", (QFilter[])new QFilter[]{costcenterFilter});
            this.getModel().setValue("wareinorg", query.get(0));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "costcenter": {
                this.updateAccountOrgValue();
                this.updateAccountOrgStatus();
                this.updateWareinorg();
                this.getModel().setValue("material", null);
                this.clearEntity();
                break;
            }
            case "material": {
                this.getModel().getDataEntity(true);
                this.updateBaseunit();
                this.initEntryCost();
                this.clearEntity();
                break;
            }
            case "warehouse": {
                this.changeEnablelocation();
                break;
            }
            case "plannedoutput": {
                this.updateEntryentity();
                break;
            }
            case "version": {
                this.updateEntryentity();
                break;
            }
            case "auxpty": {
                this.updateEntryentity();
                break;
            }
            case "completeqty": {
                this.updateEntryCost();
                break;
            }
            case "org": {
                this.changManuorgStatus();
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        List manuorgList;
        String manuOrgNumber;
        DynamicObject manuOrgObj;
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("completetype", "EXCEL");
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
        Object bizdate = sourceData.get(BIZ_DATE);
        Object bookdate = sourceData.get(BOOK_DATE);
        if (bizdate != null && bookdate == null) {
            sourceData.put(BOOK_DATE, bizdate);
        }
        String msg = "";
        Object orgObj = sourceData.get("org");
        if (orgObj == null) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FactnedOutputBillEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
            return;
        }
        Object costcenterObj = sourceData.get("costcenter");
        if (costcenterObj == null) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FactnedOutputBillEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
            return;
        }
        String acctOrgNumber = ((JSONObject)sourceData.get("org")).getString("number");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{acctOrgNumber})});
        Long accountorg = org == null ? 0L : org.getLong("id");
        Long manuorg = 0L;
        if (sourceData.get("manuorg") != null && (manuOrgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{manuOrgNumber = ((JSONObject)sourceData.get("manuorg")).getString("number")})})) != null) {
            manuorg = manuOrgObj.getLong("id");
        }
        if (OrgHelper.isOrgEnableMultiFactory((Long)accountorg) && CadEmptyUtils.isEmpty((Long)manuorg)) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u5f00\u542f\u4e86\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FactnedOutputBillEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
            return;
        }
        if (!(CadEmptyUtils.isEmpty((Long)manuorg) || (manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())) != null && manuorgList.contains(manuorg))) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"FactnedOutputBillEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.initEntryCost();
    }

    private void initEntryCost() {
        this.getModel().beginInit();
        int entryRowCount = this.getModel().getEntryRowCount(ENTITY_COST);
        int[] entryRows = new int[entryRowCount];
        for (int i = 0; i < entryRowCount; ++i) {
            entryRows[i] = i;
        }
        this.getModel().deleteEntryRows(ENTITY_COST, entryRows);
        Date bookDate = (Date)this.getModel().getValue(BOOK_DATE);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            return;
        }
        QFilter qFilter = new QFilter("org", "=", (Object)((Long)org.getPkValue()));
        qFilter.and(new QFilter("appnum", "=", (Object)"sca"));
        Map startStdCostMap = BusinessDataServiceHelper.loadFromCache((String)SCA_START_STD_COST, (QFilter[])qFilter.toArray());
        for (DynamicObject startStdCost : startStdCostMap.values()) {
            DynamicObjectCollection costAccountEntries = startStdCost.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject costAccountEntry : costAccountEntries) {
                Boolean isEnabled = costAccountEntry.getBoolean("isenabled");
                if (!isEnabled.booleanValue()) continue;
                Object costAccountId = costAccountEntry.getDynamicObject("costaccount").getPkValue();
                QFilter costAccountFilter = new QFilter("id", "=", (Object)((Long)costAccountId));
                DynamicObject costAccountObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (QFilter[])costAccountFilter.toArray());
                this.initEntryCost(costAccountObject, bookDate, material);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTITY_COST);
    }

    private void initEntryCost(DynamicObject costAccountObject, Date bookDate, DynamicObject material) {
        Long costTypeId;
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg");
        Long manuorgId = 0L;
        if (manuorg != null) {
            manuorgId = manuorg.getLong("id");
        }
        if ((costTypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costAccountObject.getLong("id"), (Long)accountorg.getLong("id"), (Long)manuorgId)) == null) {
            return;
        }
        QFilter qFilter = new QFilter("costtype", "=", (Object)costTypeId);
        qFilter.and(new QFilter("effectdate", "<=", (Object)bookDate));
        qFilter.and(new QFilter("expdate", ">=", (Object)bookDate));
        qFilter.and(new QFilter("material", ">=", (Object)((Long)material.getPkValue())));
        qFilter.and(new QFilter("ismaindata", "=", (Object)1));
        DynamicObject effectiveResult = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_calceffectiveresult", (QFilter[])qFilter.toArray());
        if (effectiveResult != null) {
            DynamicObjectCollection dynamicObjectCollection = effectiveResult.getDynamicObjectCollection(ENTRYENTITY);
            LinkedHashMap<Object, Object[]> entryEntityGroup = new LinkedHashMap<Object, Object[]>();
            for (DynamicObject entryEntity : dynamicObjectCollection) {
                String datatype = (String)entryEntity.get("datatype");
                DynamicObject subElement = entryEntity.getDynamicObject("subelement");
                if (!"2".equals(datatype) && !"3".equals(datatype)) continue;
                BigDecimal stdPrice = entryEntity.getBigDecimal(STD_PRICE);
                if (subElement == null) continue;
                Object[] costInfoArray = (Object[])entryEntityGroup.get(subElement.getPkValue());
                if (costInfoArray == null) {
                    costInfoArray = new Object[]{entryEntity, stdPrice};
                } else {
                    stdPrice = stdPrice.add((BigDecimal)costInfoArray[1]);
                    costInfoArray[1] = stdPrice;
                }
                entryEntityGroup.put(subElement.getPkValue(), costInfoArray);
            }
            if (entryEntityGroup.size() > 0) {
                this.initEntryCost(costAccountObject, bookDate, costTypeId, entryEntityGroup);
            }
        }
    }

    private void initEntryCost(DynamicObject costAccountObject, Date bookDate, Long costTypeId, Map<Object, Object[]> entryEntityGroup) {
        BigDecimal completeQty = (BigDecimal)this.getModel().getValue(COMPLETE_QTY);
        DynamicObject calPolicyObject = costAccountObject.getDynamicObject("calpolicy");
        calPolicyObject = BusinessDataServiceHelper.loadSingleFromCache((Object)calPolicyObject.getPkValue(), (String)"cal_bd_calpolicy");
        DynamicObject costTypeIdObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costTypeId, (String)"cad_costtype");
        DynamicObject periodTypeObject = calPolicyObject.getDynamicObject("periodtype");
        QFilter periodFilter = new QFilter("periodtype", "=", periodTypeObject.getPkValue());
        periodFilter.and(new QFilter("begindate", "<=", (Object)bookDate));
        periodFilter.and(new QFilter("enddate", ">=", (Object)bookDate));
        periodTypeObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])periodFilter.toArray());
        for (Object[] costInfoArray : entryEntityGroup.values()) {
            DynamicObject entryEntity = (DynamicObject)costInfoArray[0];
            BigDecimal stdPrice = (BigDecimal)costInfoArray[1];
            int newEntryRow = this.getModel().createNewEntryRow(ENTITY_COST);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTITY_COST, newEntryRow);
            entryRowEntity.set("costaccount", (Object)costAccountObject);
            entryRowEntity.set("period", (Object)periodTypeObject);
            entryRowEntity.set("costtype", (Object)costTypeIdObject);
            entryRowEntity.set("element", entryEntity.get("element"));
            entryRowEntity.set("subelement", entryEntity.get("subelement"));
            entryRowEntity.set(STD_PRICE, (Object)stdPrice);
            if (completeQty != null) {
                entryRowEntity.set(AMOUNT, (Object)stdPrice.multiply(completeQty).setScale(stdPrice.scale()));
            }
            entryRowEntity.set("srcsyncdate", (Object)bookDate);
        }
    }

    private void updateEntryCost() {
        BigDecimal completeQty = (BigDecimal)this.getModel().getValue(COMPLETE_QTY);
        int entryRowCount = this.getModel().getEntryRowCount(ENTITY_COST);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTITY_COST, i);
            BigDecimal stdPrice = (BigDecimal)entryRowEntity.get(STD_PRICE);
            BigDecimal amount = stdPrice.multiply(completeQty).setScale(stdPrice.scale());
            entryRowEntity.set(AMOUNT, (Object)amount);
        }
        this.getView().updateView(ENTITY_COST);
    }

    private void clearEntity() {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        int[] entryRows = new int[entryRowCount];
        for (int i = 0; i < entryRowCount; ++i) {
            entryRows[i] = i;
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, entryRows);
        this.getModel().createNewEntryRow(ENTRYENTITY);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_save": 
            case "bar_submit": {
                BigDecimal completeqty;
                DynamicObjectCollection lastQtys = this.getModel().getEntryEntity(ENTRYENTITY);
                BigDecimal qts = new BigDecimal(0);
                if (lastQtys != null && lastQtys.size() != 0) {
                    for (DynamicObject dynamicObject : lastQtys) {
                        BigDecimal qt = dynamicObject.getBigDecimal("qty");
                        qts = qts.add(qt);
                    }
                }
                if (qts.compareTo(completeqty = (BigDecimal)this.getModel().getValue(COMPLETE_QTY)) != 0) break;
                this.updateAccountOrgValue();
                this.updateAccountOrgStatus();
                break;
            }
            case "searchup": {
                this.showManuBill();
            }
        }
    }

    private void showManuBill() {
        Long sourcebill = Long.parseLong(String.valueOf(this.getModel().getValue("sourcebill")));
        String source = ((DynamicObject)this.getModel().getValue("srcbilltype")).getString("id");
        if (CadEmptyUtils.isEmpty((Long)sourcebill) || CadEmptyUtils.isEmpty((String)source)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u6765\u6e90\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"FactnedOutputBillEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        SrcBillShowerUtils.showSearchUpBill((IFormView)this.getView(), (String)source, Collections.singletonList(sourcebill));
    }

    private void updateEntryentity() {
        int max = this.getModel().getEntryEntity(ENTRYENTITY).size();
        int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        this.getModel().setValue("lastqty", (Object)BigDecimal.ZERO, index);
        Long costObjectId = 0L;
        for (int i = 0; i < max; ++i) {
            BigDecimal qtyb = (BigDecimal)this.getModel().getValue("qty", i);
            DynamicObject plannedoutput = (DynamicObject)this.getModel().getValue("plannedoutput", i);
            if (plannedoutput == null) continue;
            long id = plannedoutput.getLong("id");
            QFilter filter = new QFilter("id", "=", (Object)id);
            if (QueryServiceHelper.exists((String)"cad_plannedoutputbillf7", (QFilter[])new QFilter[]{filter})) {
                DynamicObject query = QueryServiceHelper.queryOne((String)"cad_plannedoutputbill", (String)"costobject", (QFilter[])new QFilter[]{filter});
                costObjectId = query.getLong("costobject");
                this.getModel().setValue("costobject", (Object)query.getLong("costobject"), i);
            }
            if (qtyb != null && qtyb.compareTo(BigDecimal.ZERO) > 0 || plannedoutput == null) continue;
            DynamicObject costobjectty = QueryServiceHelper.queryOne((String)"cad_plannedoutputbill", (String)"costobject,wipqty", (QFilter[])new QFilter[]{filter});
            this.getModel().setValue("lastqty", (Object)0, i);
            BigDecimal completeqty = (BigDecimal)this.getModel().getValue(COMPLETE_QTY);
            BigDecimal wipqty = costobjectty.getBigDecimal("wipqty");
            this.updateQty(max, i, completeqty, wipqty);
        }
        QFilter costObjectFilter = new QFilter("id", "=", (Object)costObjectId);
        DynamicObject costObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costobject", (String)"material,auxpty,configuredcode,tracknumber,projectnumber,lot", (QFilter[])costObjectFilter.toArray());
        if (costObject == null) {
            return;
        }
        this.getModel().setValue("configuredcode", (Object)costObject.getLong("configuredcode.id"));
        this.getModel().setValue("tracknumber", (Object)costObject.getLong("tracknumber.id"));
        this.getModel().setValue("project", (Object)costObject.getLong("projectnumber.id"));
        this.getModel().setValue("lot", (Object)costObject.getString("lot"));
    }

    private void updateQty(int max, int index, BigDecimal completeqty, BigDecimal result) {
        if (index + 1 == max && completeqty.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            BigDecimal sum = new BigDecimal(0);
            for (DynamicObject entry : entryEntity) {
                sum = sum.add(entry.getBigDecimal("qty"));
            }
            if ((sum = completeqty.subtract(sum)).compareTo(BigDecimal.ZERO) <= 0 && completeqty.compareTo(BigDecimal.ZERO) != 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5408\u8ba1\u5df2\u7ecf\u7b49\u4e8e\u5b8c\u5de5\u6570\u91cf\u4e86\u3002", (String)"FactnedOutputBillEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.getModel().deleteEntryRow(ENTRYENTITY, index);
                if (max == 1) {
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                }
                return;
            }
            if (sum.compareTo(BigDecimal.ZERO) <= 0) {
                this.getModel().setValue("qty", (Object)result, index);
            } else {
                this.getModel().setValue("qty", (Object)(result.compareTo(sum) == 0 || result.compareTo(sum) < 0 ? result : sum), index);
            }
        } else {
            this.getModel().setValue("qty", (Object)result, index);
        }
    }

    private void changeEnablelocation() {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        if (warehouse != null) {
            long warehouseid = warehouse.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)warehouseid);
            DynamicObject isopenloca = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"isopenlocation", (QFilter[])new QFilter[]{costcenterFilter});
            boolean isopenlocation = isopenloca.getBoolean(0);
            if (!isopenlocation) {
                this.getModel().setValue("location", null);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"location"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"location"});
            }
        }
    }

    private void updateBaseunit() {
        this.getModel().setValue("baseunit", null);
        this.getModel().setValue(COMPLETE_QTY, (Object)0);
        DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
        if (mat != null) {
            long accountorgid = mat.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)accountorgid);
            DynamicObject query = QueryServiceHelper.queryOne((String)"bd_material", (String)"baseunit", (QFilter[])new QFilter[]{costcenterFilter});
            DynamicObject isenablematerialversion = QueryServiceHelper.queryOne((String)"bd_material", (String)"isenablematerialversion", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean isenableversion = (Boolean)isenablematerialversion.get(0);
            DynamicObject isuseauxpty = QueryServiceHelper.queryOne((String)"bd_material", (String)"isuseauxpty", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean isuseauxpt = (Boolean)isuseauxpty.get(0);
            DynamicObject enablelo = QueryServiceHelper.queryOne((String)"bd_material", (String)"enablelot", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean enablelot = (Boolean)enablelo.get(0);
            this.getModel().setValue("version", null);
            this.getModel().setValue("auxpty", null);
            this.getModel().setValue("batch", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"batch"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxpty"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"version"});
            if (isenableversion.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"version"});
            }
            if (isuseauxpt.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"auxpty"});
            }
            if (enablelot.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"batch"});
            }
            this.getModel().setValue("baseunit", query.get(0));
        }
    }

    private void initEnable() {
        DynamicObject warehouse;
        DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
        if (mat != null) {
            long accountorgid = mat.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)accountorgid);
            DynamicObject isenablematerialversion = QueryServiceHelper.queryOne((String)"bd_material", (String)"isenablematerialversion", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean isenableversion = (Boolean)isenablematerialversion.get(0);
            DynamicObject isuseauxpty = QueryServiceHelper.queryOne((String)"bd_material", (String)"isuseauxpty", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean isuseauxpt = (Boolean)isuseauxpty.get(0);
            DynamicObject enablelo = QueryServiceHelper.queryOne((String)"bd_material", (String)"enablelot", (QFilter[])new QFilter[]{costcenterFilter});
            Boolean enablelot = (Boolean)enablelo.get(0);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"batch"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxpty"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"version"});
            if (isenableversion.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"version"});
            }
            if (isuseauxpt.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"auxpty"});
            }
            if (enablelot.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"batch"});
            }
        }
        if ((warehouse = (DynamicObject)this.getModel().getValue("warehouse")) != null) {
            long warehouseid = warehouse.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)warehouseid);
            DynamicObject isopenloca = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"isopenlocation", (QFilter[])new QFilter[]{costcenterFilter});
            boolean isopenlocation = isopenloca.getBoolean(0);
            if (!isopenlocation) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"location"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"location"});
            }
        }
    }

    private void updateAccountOrgStatus() {
        FormShowParameter fsp;
        Object accountorg;
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
        if (costcenter != null && ((accountorg = (fsp = this.getView().getFormShowParameter()).getCustomParam("org")) == null || "".equals(accountorg.toString()))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
    }

    private void updateAccountOrgValue() {
        FormShowParameter fsp;
        Object accountorg;
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
        if (costcenter != null && ((accountorg = (fsp = this.getView().getFormShowParameter()).getCustomParam("org")) == null || "".equals(accountorg.toString()))) {
            long accountorgid = costcenter.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)accountorgid);
            DynamicObject query = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"accountorg", (QFilter[])new QFilter[]{costcenterFilter});
            this.getModel().setValue("org", query.get(0));
        }
    }

    private List<Long> getCostCenterByUser() {
        List<ComboItem> accountOrgs = Util.getAccountOrg();
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (ComboItem ComboItem2 : accountOrgs) {
            ids.add(Long.valueOf(ComboItem2.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!accountOrgs.isEmpty()) {
            filters.add(new QFilter("accountorg", "in", ids));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    private List<Long> getCostCenterByOrg(long org) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)org));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    private String checkCostParam(Map<String, Object> data) {
        DynamicObjectCollection result;
        DynamicObjectCollection result2;
        String showCompletetype;
        QFilter appNumQF;
        String msg = null;
        String accountOrgNumber = ((JSONObject)data.get("org")).getString("number");
        String costCenterNumber = ((JSONObject)data.get("costcenter")).getString("number");
        String appNum = (String)data.get("appnum");
        QFilter accountorgQF = new QFilter("accountorg.number", "=", (Object)accountOrgNumber);
        QFilter costcenterQF = new QFilter("costcenter.number", "=", (Object)costCenterNumber);
        QFilter costcenterQFNull = new QFilter("costcenter", "=", (Object)0L);
        QFilter completetype = new QFilter("completetype", "=", (Object)SysParamEnum.COMPTYPE_EXCEL.getValue());
        boolean hasAccountAndCost = QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{accountorgQF, costcenterQF, completetype, appNumQF = new QFilter("appnum", "=", (Object)appNum)});
        if (hasAccountAndCost) {
            return msg;
        }
        boolean hasAccount = QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{accountorgQF, costcenterQFNull, completetype, appNumQF});
        if (hasAccount) {
            return msg;
        }
        msg = CadEmptyUtils.isEmpty((String)costCenterNumber) ? ("".equals(showCompletetype = this.showCompletetype(result2 = QueryServiceHelper.query((String)"cad_sysparam", (String)"id, completetype", (QFilter[])new QFilter[]{accountorgQF, costcenterQFNull, appNumQF}))) ? String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0cExcel\u6570\u636e\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u5728\u6210\u672c\u53c2\u6570\u8bbe\u7f6e\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u5bfc\u5165\u65b9\u5f0f\uff0c\u8bf7\u5728\u6210\u672c\u53c2\u6570\u4e2d\u4fee\u6539\u3002", (String)"FactnedOutputBillEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), accountOrgNumber) : String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0cExcel\u6570\u636e\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u6210\u672c\u53c2\u6570\u8bbe\u7f6e\u7684\u5b8c\u5de5\u4ea7\u91cf\u65b0\u589e\u65b9\u5f0f\u4e3a\u201c%2$s\u201d\u3002", (String)"FactnedOutputBillEditPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), accountOrgNumber, showCompletetype)) : ("".equals(showCompletetype = this.showCompletetype(result = QueryServiceHelper.query((String)"cad_sysparam", (String)"id, completetype", (QFilter[])new QFilter[]{accountorgQF, costcenterQF, appNumQF}))) ? String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0cExcel\u6570\u636e\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u548c\u6210\u672c\u4e2d\u5fc3\u201c%2$s\u201d\u5728\u6210\u672c\u53c2\u6570\u8bbe\u7f6e\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u5bfc\u5165\u65b9\u5f0f\uff0c\u8bf7\u5728\u6210\u672c\u53c2\u6570\u4e2d\u4fee\u6539\u3002", (String)"FactnedOutputBillEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]), accountOrgNumber, costCenterNumber) : String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0cExcel\u6570\u636e\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u548c\u6210\u672c\u4e2d\u5fc3\u201c%2$s\u201d\u5728\u6210\u672c\u53c2\u6570\u8bbe\u7f6e\u7684\u5b8c\u5de5\u4ea7\u91cf\u65b0\u589e\u65b9\u5f0f\u4e3a\u201c%3$s\u201d\u3002", (String)"FactnedOutputBillEditPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), accountOrgNumber, costCenterNumber, showCompletetype));
        return msg;
    }

    private String showCompletetype(DynamicObjectCollection result) {
        if (result != null && !result.isEmpty()) {
            String realCompletetype = "";
            for (DynamicObject costparam : result) {
                realCompletetype = costparam.getString("completetype");
                if ("".equals(realCompletetype)) continue;
                SysParamEnum enumByValue = SysParamEnum.getEnumByValue((String)realCompletetype);
                return enumByValue.getName();
            }
        }
        return "";
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("manuorg");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            basedataEdit.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            basedataEdit.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

