/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.yieldcollection;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.costobject.BaseCostObjectListPlugin;
import kd.macc.cad.servicehelper.FactnedOutPutServiceHelper;

public class FactnedOutputBillListPlugin
extends BaseCostObjectListPlugin {
    private static final Log logger = LogFactory.getLog(FactnedOutputBillListPlugin.class);
    private boolean isFirstInitFilterByMainPage = false;
    private boolean isfirstSetFilterByMainPage = false;
    private static final String KEY_REFRESH = "refresh";
    private static final String PAGECACHE_COSTCENTERSET = "costcenterset";
    private static final String closeBack_importResult = "importResult";
    private static List<ComboItem> costCenterComboItemListBy;

    public FactnedOutputBillListPlugin() {
        this.ORG_FIELD = "org";
        this.PROORG_FIELD = "manuorg";
        this.COSTCENTER_FIELD = "costcenter";
        this.BIZDATE_FIELD = "bizdate";
    }

    public void afterCreateNewData(EventObject e) {
        String appNum = this.getView().getFormShowParameter().getAppId();
        if ("aca".equalsIgnoreCase(appNum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"importdata", "importdetails", "exportdata_expt", "exportdata"});
        }
        if ("sca".equalsIgnoreCase(appNum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"importexport_userset"});
        }
        this.isFirstInitFilterByMainPage = true;
        this.isfirstSetFilterByMainPage = true;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String org = this.getPageCache().get(this.ORG_FIELD);
        if (!CadEmptyUtils.isEmpty((String)org)) {
            costCenterComboItemListBy = this.getCostCenterComboItemListBy(org);
        }
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Map paramMap = listShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isFirstInitFilterByMainPage) {
            this.mainPageFilterInit(filterColumns, paramMap);
            this.isFirstInitFilterByMainPage = false;
        }
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn("costcenter.name");
        List comboItems = filterColumn.getComboItems();
        HashSet<String> costCenterSet = new HashSet<String>(10);
        for (ComboItem comboItem : comboItems) {
            costCenterSet.add(comboItem.getValue());
        }
        this.getPageCache().put(PAGECACHE_COSTCENTERSET, SerializationUtils.toJsonString(costCenterSet));
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
    }

    private void mainPageFilterInit(List<FilterColumn> filterColumns, Map<String, Object> paramMap) {
        String pageCacheOrg = null;
        for (int i = filterColumns.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = filterColumns.get(i);
            CommonFilterColumn schemeFilterColumn = (CommonFilterColumn)filterColumn;
            String schemeFilterColumnName = schemeFilterColumn.getFieldName();
            if ("costcenter.name".equals(schemeFilterColumnName) && paramMap.get("costcenter") != null) {
                this.setCenterComboItems(paramMap.get("org").toString(), paramMap.get("costcenter").toString(), schemeFilterColumn);
                continue;
            }
            if ("org.name".equals(schemeFilterColumnName) && paramMap.get("org") != null) {
                schemeFilterColumn.setDefaultValue(paramMap.get("org").toString());
                pageCacheOrg = paramMap.get("org").toString();
                continue;
            }
            if ("bookdate".equals(schemeFilterColumnName) && paramMap.get("bookdate") != null) {
                schemeFilterColumn.setDefaultValue(paramMap.get("bookdate").toString());
                continue;
            }
            schemeFilterColumn.setDefaultValue((String)null);
        }
        if (pageCacheOrg != null) {
            this.getPageCache().put("org", pageCacheOrg);
        }
    }

    private void setCenterComboItems(String orgId, String costCenterId, CommonFilterColumn commonFilterColumn) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> comboItems = Util.getCostCenterByAccoutOrg(orgId, true);
        if (!CadEmptyUtils.isEmpty(comboItems)) {
            commonFilterColumn.setComboItems(comboItems);
        }
        commonFilterColumn.setDefaultValue(costCenterId);
        this.getPageCache().put("costcenter", costCenterId);
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (!"costcenter.id".equals(String.valueOf(names.get(0)))) continue;
            List vals = (List)map.get("Value");
            if (vals == null || vals.isEmpty()) {
                this.getPageCache().put("costcenter", "");
                continue;
            }
            if (!CadEmptyUtils.isEmpty(costCenterComboItemListBy)) {
                Set costCenterIdsSet = costCenterComboItemListBy.stream().map(o -> o.getValue()).collect(Collectors.toSet());
                if (!costCenterIdsSet.contains(vals.get(0))) {
                    vals.clear();
                    vals.add("");
                }
            } else {
                vals.clear();
                vals.add("");
            }
            String val = String.valueOf(vals.get(0));
            this.getPageCache().put(this.COSTCENTER_FIELD, val);
        }
        String org = this.getPageCache().get("org");
        if (CadEmptyUtils.isEmpty((String)org)) {
            return;
        }
        Long costCenterId = this.getPageCache().get("org") == null ? 0L : Long.parseLong(this.getPageCache().get("org"));
        List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)args, (String)"costcenter.id", (Long)costCenterId);
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter;
        QFilter costCenterQFilter;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isfirstSetFilterByMainPage) {
            String filterStr = (String)paramMap.get("filter");
            if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                QFilter filter = QFilter.fromSerializedString((String)filterStr);
                e.getQFilters().clear();
                e.getQFilters().add(filter);
            }
            this.isfirstSetFilterByMainPage = false;
        }
        if ((costCenterQFilter = this.getCostCenterQFilter()) != null) {
            e.getQFilters().add(costCenterQFilter);
        }
        if ((manuOrgQFilter = this.getManuOrgQFilter()) != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.setOrderBy("bookdate desc,billno desc");
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costCenter = this.getPageCache().get("costcenter");
        String manuOrg = this.getPageCache().get("manuorg");
        String bizDate = this.getPageCache().get("bizdate");
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam("costcenter", (Object)costCenter);
        bsp.setCustomParam("manuorg", (Object)manuOrg);
        bsp.setCustomParam("bizdate", (Object)bizDate);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateAccuracy();
        if (!AppIdHelper.isSCA((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "baritemap", "importdata", "importdetails"});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        List<ComboItem> orgComboItemList = this.getORGComboItemList();
        if ("tblnew".equals(key) || "importdata".equals(key) || "innersysimportcover".equals(key) || "innersysimportcoveraca".equals(key)) {
            if (CadEmptyUtils.isEmpty(orgComboItemList)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"FactnedOutputBillListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                return;
            }
            String accountOrg = this.getPageCache().get("org");
            String costCenter = this.getPageCache().get("costcenter");
            if (CadEmptyUtils.isEmpty((String)costCenter) && CadEmptyUtils.isEmpty((Set)((Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(PAGECACHE_COSTCENTERSET), Set.class)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"FactnedOutputBillListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
        switch (key) {
            case "tblnew": {
                break;
            }
            case "importdata": {
                break;
            }
            case "innersysimport": 
            case "innersysimportaca": 
            case "innersysimportcover": 
            case "innersysimportcoveraca": {
                if (!CadEmptyUtils.isEmpty(orgComboItemList)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"FactnedOutputBillListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "innersysimport": 
            case "innersysimportaca": {
                this.inSysImport();
                break;
            }
            case "innersysimportcover": 
            case "innersysimportcoveraca": {
                boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)"cad_factnedoutputbill", (String)"47156aff000000ac");
                if (!hasPerm) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FactnedOutputBillListPlugin_24", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.inSysImport();
                break;
            }
            case "searchup": {
                try {
                    this.searchUpManuBill();
                    break;
                }
                catch (Exception e) {
                    logger.error("\u4e0a\u67e5\u5931\u8d25\uff1a", (Throwable)e);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u6765\u6e90\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"FactnedOutputBillListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            case "colreport": {
                this.viewColReport();
                break;
            }
            case "searchconfig": {
                this.searchConfig();
                break;
            }
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"cad_factnedoutputbill", (IFormView)this.getView());
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_colreport", (boolean)true, (int)1, (boolean)false);
        String acctOrgId = this.getPageCache().get("org");
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)acctOrgId);
        listShowParameter.setCustomParam("colobj", (Object)CollectObjectEnum.FACTNED_OUT.getObj());
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u62a5\u544a", (String)"FactnedOutputBillListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void searchUpManuBill() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0a\u67e5\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"FactnedOutputBillListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] primaryKeys = rows.getPrimaryKeyValues();
        Map<String, List<Object>> probillEntryIdMap = FactnedOutputBillListPlugin.getProbillEntryIds(primaryKeys);
        if (CadEmptyUtils.isEmpty(probillEntryIdMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u624d\u80fd\u4e0a\u67e5\u3002", (String)"FactnedOutputBillListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        for (Map.Entry<String, List<Object>> probill : probillEntryIdMap.entrySet()) {
            String source = probill.getKey();
            SrcBillShowerUtils.showSearchUpBillOrList((IFormView)this.getView(), (String)source, probill.getValue(), null);
        }
    }

    private static Map<String, List<Object>> getProbillEntryIds(Object[] objIds) {
        HashMap<String, List<Object>> probillEntryIdMap = new HashMap<String, List<Object>>(10);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        filter.and(new QFilter("sourcebill", ">", (Object)0L));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)"id,sourcebill,srcbilltype,completetype", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return probillEntryIdMap;
        }
        for (DynamicObject row : rows) {
            probillEntryIdMap.computeIfAbsent(row.getString("srcbilltype"), p -> new ArrayList(10)).add(row.getLong("sourcebill"));
        }
        return probillEntryIdMap;
    }

    private void updateAccuracy() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            return;
        }
        DynamicObject[] cols = BusinessDataServiceHelper.load((String)"cad_factnedoutputbill", (String)"baseunit,entryentity.qty", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)rows.getPrimaryKeyValues())});
        HashMap<Object, BigDecimal> costObjectMap = new HashMap<Object, BigDecimal>(16);
        if (cols == null) {
            return;
        }
        for (DynamicObject item : cols) {
            int precision = item.getInt("baseunit.precision");
            DynamicObjectCollection entryentity = item.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) continue;
            for (DynamicObject entry : entryentity) {
                BigDecimal entryQty = entry.getBigDecimal("qty");
                if (entryQty.compareTo(BigDecimal.ZERO) == 0) continue;
                entryQty = entryQty.setScale(precision, 4);
                costObjectMap.put(entry.get("id"), entryQty);
            }
        }
        int i = 0;
        for (ListSelectedRow row : rows) {
            Long id = (Long)row.getEntryPrimaryKeyValue();
            if (CadEmptyUtils.isEmpty((Long)id)) {
                ++i;
                continue;
            }
            BigDecimal entryQty = (BigDecimal)costObjectMap.get(id);
            if (CadEmptyUtils.isEmpty((BigDecimal)entryQty)) {
                ++i;
                continue;
            }
            billList.setCellFieldValue("qty", i, (Object)entryQty.toString());
            ++i;
        }
    }

    private void inSysImport() {
        try {
            String accountOrg = this.getPageCache().get(this.ORG_FIELD);
            String costCenter = this.getPageCache().get(this.COSTCENTER_FIELD);
            ArrayList<Long> costCenters = new ArrayList<Long>(10);
            if (accountOrg == null) {
                return;
            }
            List costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("multiselectcostcenters"), List.class);
            if (!CadEmptyUtils.isEmpty((List)costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
                costCenters.addAll(costCenterMultiSelect);
            } else if (!CadEmptyUtils.isEmpty((String)costCenter)) {
                costCenters.add(Long.parseLong(costCenter));
            } else {
                String manuOrgId = this.getPageCache().get("manuorg");
                List<ComboItem> comboItems = this.getCostCenterComboItemListByManuOrg(accountOrg, manuOrgId);
                comboItems.forEach(p -> costCenters.add(Long.parseLong(p.getValue())));
                boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(accountOrg));
                if (isEnableMultiFactory && CadEmptyUtils.isEmpty(comboItems)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u4e0e\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u7684\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"FactnedOutputBillListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(Long.parseLong(accountOrg)), (Set)Sets.newHashSet(costCenters), (String)"cad_factnedoutputbill", (String)this.getView().getFormShowParameter().getAppId());
            Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)Long.parseLong(accountOrg), (List)enableCostCenters);
            if (CadEmptyUtils.isEmpty((Map)objRules)) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"FactnedOutputBillListPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"CostObjectListPlugin_6"));
                return;
            }
            if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
                Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)Long.parseLong(accountOrg), costCenters, (Map)objRules);
                List collConfigs = CommonCollConfigService.getCollConfigs((Long)Long.parseLong(accountOrg), null, (Set)calDimensionIds, (String)"cad_factnedoutputbill", (String)this.getView().getFormShowParameter().getAppId());
                if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                    this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u65b9\u6848\u3002", (String)"FactnedOutputBillListPlugin_23", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"PlannedOutputBillListPlugin_18"));
                    return;
                }
            }
            Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(accountOrg));
            ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
            if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountOrg), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(userHasPermManuOrgs);
            } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                manuOrgs.add(Long.parseLong(this.getPageCache().get("manuorg")));
            }
            DeleteServiceHelper.delete((String)"cad_sysparam", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)0L)});
            String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"FactnedOutputBillListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = FactnedOutPutServiceHelper.importCompletion(null, (Long)Long.parseLong(accountOrg), (List)enableCostCenters, (List)manuOrgs, (String)appNum, (String)progressId);
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"FactnedOutputBillListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        this.getView().hideLoading();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                if ("confirm".equals(responseInfo.get("type"))) {
                    billList.refresh();
                    this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (callBackId) {
                case "showReport": {
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                    this.showColReport((String)responseInfo.get("colReportId"));
                    break;
                }
            }
        }
    }

    private void showColReport(String colReportId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_colreport");
        billShowParameter.setCustomParam("id", (Object)colReportId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u62a5\u544a", (String)"FactnedOutputBillListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        ArrayList<String> hideFields = new ArrayList<String>(Arrays.asList("completeqty", "warehouse.name", "location.name", "billstatus"));
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Boolean isShowTotalData = (Boolean)fsp.getCustomParam("isShowTotalData");
        List listColumns = o.getListColumns();
        listColumns = o.getListColumns();
        for (IListColumn columns : listColumns) {
            if (isShowTotalData == null || isShowTotalData.booleanValue() || !hideFields.contains(columns.toString())) continue;
            columns.setVisible(0);
        }
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, new HashSet<String>(Arrays.asList("srcauditdate", "plannedoutput.billno", "costaccount.name", "period.name", "costtype.name", "element.name", "subelement.name", "stdprice", "amount")));
        } else {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, new HashSet<String>(Arrays.asList("plannedoutput.billno", "costobjectproducttype", "costobject.productgroup.number", "costobject.productgroup.name", "costobject.weight")));
        }
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
            break;
        }
    }

    private boolean isMatchCondition(Map<String, Object> paramMap) {
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if ("GardHomePlugin".equals(key)) {
            flag = true;
        }
        return flag;
    }
}

