/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.yieldcollection;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.cad.formplugin.common.Util;

public class PlannedOutputBillEditPlugin
extends AbstractBillPlugIn {
    private static String[] BILL_SOURCES = new String[]{"3", "4"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit center = (BasedataEdit)this.getControl("costcenter");
        center.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            qList.add(new QFilter("accountorg", "!=", (Object)0L));
            qList.add(new QFilter("orgduty", "=", (Object)4L));
            if (accountorg != null) {
                Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                manuOrgList.add(manuorgId);
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                qList.add(costCenterIdFilter);
            }
        });
        BasedataEdit costObject = (BasedataEdit)this.getControl("costobject");
        costObject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
            if (costCenter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u6210\u672c\u4e2d\u5fc3\u540e\u518d\u9009\u62e9\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"PlannedOutputBillEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountOrg != null) {
                qList.add(new QFilter("org", "=", accountOrg.getPkValue()));
            }
            qList.add(new QFilter("costcenter", "=", costCenter.getPkValue()));
            qList.add(new QFilter("billstatus", "=", (Object)"C"));
            qList.add(new QFilter("bizstatus", "=", (Object)"A"));
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("accountorg");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlannedOutputBillEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_new": {
                break;
            }
            case "bar_save": 
            case "bar_submit": 
            case "bar_submitandnew": {
                this.checkBillNo(evt);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "searchup": {
                this.showManuBill();
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
        sourceData.put("source", "1");
        String orgNumber = ((JSONObject)sourceData.get("accountorg")).getString("number");
        String manuOrgNumber = "";
        JSONObject manuorg = (JSONObject)sourceData.get("manuorg");
        if (manuorg != null) {
            manuOrgNumber = manuorg.getString("number");
        }
        Object bizdate = sourceData.get("bizdate");
        Object srcTransmitTime = sourceData.get("srctransmittime");
        if (bizdate != null && srcTransmitTime == null) {
            sourceData.put("srcTransmitTime", bizdate);
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        String msg = null;
        if (org == null) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u6838\u7b97\u7ec4\u7ec7\u672a\u586b\u5199\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"PlannedOutputBillEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
            return;
        }
        if (OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
            if (CadEmptyUtils.isEmpty((String)manuOrgNumber)) {
                msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u5df2\u542f\u7528\u591a\u5de5\u5382\uff0c\u8bf7\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"PlannedOutputBillEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.setCancelMessage(msg);
            } else {
                DynamicObject manuOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)manuOrgNumber)});
                Long orgId = org == null ? 0L : org.getLong("id");
                List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                if (OrgHelper.isOrgEnableMultiFactory((Long)orgId) || manuorgList == null || manuOrg == null || !manuorgList.contains(manuOrg.getLong("id"))) {
                    msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"PlannedOutputBillEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    e.setCancel(true);
                    e.setCancelMessage(msg);
                }
            }
        }
        if (sourceData.get("material") == null) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u4ea7\u54c1\u7f16\u7801\u672a\u586b\u5199\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"PlannedOutputBillEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
            return;
        }
        String matNumber = ((JSONObject)sourceData.get("material")).getString("number");
        DynamicObject mat = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"baseunit", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)matNumber)});
        if (mat == null) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"PlannedOutputBillEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
            return;
        }
        sourceData.put("baseunit", mat.get("baseunit"));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        this.initOrgAndCostCenterValue(os);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        this.initEnable();
        this.initOrgAndCostCenterStatus(os);
        Long org = this.getModel().getDataEntity().getLong("accountorg.id");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("manuorg");
        if (org != null && OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(String.valueOf(org)))) {
            basedataEdit.setMustInput(true);
        } else {
            basedataEdit.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        this.changManuorgStatus();
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }

    private void initOrgAndCostCenterStatus(OperationStatus os) {
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            Object manuorg;
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Object accountorg = fsp.getCustomParam("accountorg");
            if (accountorg != null && !"".equals(accountorg.toString())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountorg"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"accountorg"});
            }
            Object costcenter = fsp.getCustomParam("costcenter");
            if (costcenter != null && !"".equals(costcenter.toString())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"costcenter"});
            }
            if ((manuorg = fsp.getCustomParam("manuorg")) != null && !"".equals(manuorg.toString())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxpty"});
        }
    }

    private void initOrgAndCostCenterValue(OperationStatus os) {
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            Object manuorg;
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Object accountorg = fsp.getCustomParam("accountorg");
            if (accountorg != null && !"".equals(accountorg.toString())) {
                this.getModel().setValue("accountorg", accountorg);
            } else {
                this.getModel().setValue("accountorg", null);
            }
            Object costcenter = fsp.getCustomParam("costcenter");
            if (costcenter != null && !"".equals(costcenter.toString())) {
                this.getModel().setValue("costcenter", costcenter);
            }
            if ((manuorg = fsp.getCustomParam("manuorg")) != null && !"".equals(manuorg.toString())) {
                this.getModel().setValue("manuorg", manuorg);
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"auxpty"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "costcenter": {
                this.updateAccountOrg();
                break;
            }
            case "costobject": {
                this.updateMaterial();
                break;
            }
            case "material": {
                this.updateBaseUnitQty();
                this.setMatVisible();
                break;
            }
            case "accountorg": {
                this.changManuorgStatus();
                break;
            }
            case "bizdate": {
                this.setSrcTransmitTime();
                break;
            }
        }
    }

    private void setSrcTransmitTime() {
        String source = (String)this.getModel().getValue("source");
        if (!Arrays.asList(BILL_SOURCES).contains(source)) {
            this.getView().getModel().setValue("srctransmittime", this.getModel().getValue("bizdate"));
        }
    }

    private void showManuBill() {
        Object sourceBill = this.getModel().getValue("sourcebill");
        String source = (String)this.getModel().getDataEntity().get("srcbilltype.id");
        if (sourceBill == null || (Long)sourceBill == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u6765\u6e90\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"PlannedOutputBillEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> proBillEntryIds = new ArrayList<Long>();
        proBillEntryIds.add((Long)sourceBill);
        Long fromlogid = (Long)this.getModel().getValue("fromlogid");
        switch (source) {
            case "pom_xmftorderlog": 
            case "om_xmftorderlog": 
            case "om_mftorder_splitog": 
            case "pom_mftorder_splitlog": {
                if (CadEmptyUtils.isEmpty((Long)fromlogid)) break;
                ArrayList<String> orgIds = new ArrayList<String>();
                orgIds.add("");
                HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>(2);
                map.put("useorgIdFilter", orgIds);
                SrcBillShowerUtils.showSearchUpBillList((IFormView)this.getView(), (String)source, Collections.singletonList(fromlogid), map);
                break;
            }
            default: {
                SrcBillShowerUtils.showSearchUpBill((IFormView)this.getView(), (String)source, proBillEntryIds);
            }
        }
    }

    private void updateAccountOrg() {
        DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
        this.getView().getModel().setValue("accountorg", costCenter == null ? null : Long.valueOf(costCenter.getLong("accountorg.id")));
    }

    private void updateMaterial() {
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
        this.getModel().setValue("material", costObject == null ? null : Long.valueOf(costObject.getLong("material.id")));
        this.getModel().setValue("auxpty", costObject == null || costObject.getDynamicObject("auxpty") == null ? null : costObject.getDynamicObject("auxpty").get("id"));
    }

    private void updateBaseUnitQty() {
        DynamicObject baseUnit;
        this.getModel().setValue("baseunit", null);
        this.getModel().setValue("qty", (Object)0);
        DynamicObject mat = (DynamicObject)this.getModel().getValue("material");
        if (mat != null && (baseUnit = mat.getDynamicObject("baseunit")) != null) {
            this.getModel().setValue("baseunit", baseUnit.getPkValue());
        }
    }

    private void setMatVisible() {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            return;
        }
        Boolean isenablematerialversion = material.getBoolean("isenablematerialversion");
        this.getView().setVisible(isenablematerialversion, new String[]{"bomversion"});
        Boolean isuseauxpty = material.getBoolean("isuseauxpty");
        this.getView().setVisible(isuseauxpty, new String[]{"auxpty"});
    }

    private void checkBillNo(BeforeItemClickEvent evt) {
        Long id = Long.valueOf(this.getModel().getDataEntity().getPkValue().toString());
        String billNo = (String)this.getModel().getValue("billno");
        if (CadEmptyUtils.isEmpty((String)billNo)) {
            return;
        }
        QFilter qfId = new QFilter("id", "!=", (Object)id);
        QFilter qfBillNo = new QFilter("billno", "=", (Object)billNo);
        if (QueryServiceHelper.exists((String)"cad_plannedoutputbill", (QFilter[])new QFilter[]{qfId, qfBillNo})) {
            evt.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlannedOutputBillEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), billNo));
        }
    }

    private void initEnable() {
        Long id = Long.valueOf(this.getModel().getDataEntity().getPkValue().toString());
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and(new QFilter("source", "in", (Object)new String[]{"3", "4", "5"}));
        Boolean isPlanned = QueryServiceHelper.exists((String)"cad_plannedoutputbill", (QFilter[])new QFilter[]{qFilter});
        if (isPlanned.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno", "bizdate", "planneddate", "costcenter", "costobject", "manuorg", "qty"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"billno", "bizdate", "planneddate", "costcenter", "costobject", "manuorg", "qty"});
        }
    }

    private void setCostcenterByCostdriver(List<QFilter> qList, DynamicObject accountorg, String newType) {
        DynamicObjectCollection costquery;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        HashSet<Long> costcentIds = new HashSet<Long>();
        if (accountorg != null) {
            filters.add(new QFilter("accountorg", "=", (Object)accountorg.getLong("id")));
        }
        if (CadEmptyUtils.isEmpty((List)(costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)("accountorg,costcenter," + newType), (QFilter[])filters.toArray(new QFilter[0]))))) {
            return;
        }
        Boolean hasNullCostcenter = Boolean.FALSE;
        int isManual = 0;
        long sysOrgId = 0L;
        ArrayList<String> manualList = new ArrayList<String>();
        manualList.add("");
        manualList.add("MANUAL");
        for (Object dynamicObject : costquery) {
            long long1 = dynamicObject.getLong("costcenter");
            if (long1 != 0L) continue;
            sysOrgId = dynamicObject.getLong("accountorg");
            hasNullCostcenter = Boolean.TRUE;
            String stNewType = dynamicObject.getString(newType);
            if (manualList.contains(stNewType)) {
                isManual = 1;
                continue;
            }
            isManual = 2;
        }
        if (hasNullCostcenter.booleanValue() && isManual == 2) {
            filters.add(new QFilter("costcenter", "!=", (Object)0L));
            filters.add(new QFilter(newType, "in", manualList));
            costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])filters.toArray(new QFilter[0]));
            costcentIds.clear();
            List<Long> costCenterByOrg = this.getCostCenterByOrg(sysOrgId);
            if (!CadEmptyUtils.isEmpty((List)costquery)) {
                for (DynamicObject dynamicObject : costquery) {
                    long costcenterId = dynamicObject.getLong("costcenter");
                    if (costCenterByOrg == null) continue;
                    costCenterByOrg.remove(costcenterId);
                }
                QFilter costcenterIdFilter = new QFilter("id", "not in", (Object)costCenterByOrg);
                qList.add(costcenterIdFilter);
            } else {
                List<Long> costCenterByOrg1 = this.getCostCenterByOrg(sysOrgId);
                QFilter costcenterIdFilter = new QFilter("id", "not in", costCenterByOrg1);
                qList.add(costcenterIdFilter);
            }
        } else if (Boolean.FALSE.equals(hasNullCostcenter) || Boolean.TRUE.equals(hasNullCostcenter) && isManual == 1) {
            filters.add(new QFilter("costcenter", "!=", (Object)0L));
            filters.add(new QFilter(newType, "not in", manualList));
            costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])filters.toArray(new QFilter[0]));
            costcentIds.clear();
            if (CadEmptyUtils.isEmpty((List)costquery)) {
                return;
            }
            for (Object dynamicObject : costquery) {
                long costcenterId = dynamicObject.getLong("costcenter");
                costcentIds.add(costcenterId);
            }
            QFilter costcenterIdFilter = new QFilter("id", "not in", costcentIds);
            qList.add(costcenterIdFilter);
        }
    }

    private List<Long> getCostCenterByOrg(long org) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)org));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    private List<Long> getCostCenterByUser() {
        List<ComboItem> accountOrgs = Util.getAccountOrg();
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (ComboItem ComboItem2 : accountOrgs) {
            ids.add(Long.valueOf(ComboItem2.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!accountOrgs.isEmpty()) {
            filters.add(new QFilter("accountorg", "in", ids));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    private String getInnerType(String accountOrg, String costCenter, String newTypeKey, String appNum) {
        String result = "";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!CadEmptyUtils.isEmpty((String)accountOrg)) {
            filters.add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrg)));
        }
        if (!CadEmptyUtils.isEmpty((String)costCenter)) {
            filters.add(new QFilter("costcenter", "=", (Object)Long.valueOf(costCenter)));
        }
        QFilter appnumFilter = null;
        if (this.getView().getFormShowParameter().getAppId() != null) {
            appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        }
        DynamicObject queryOne = null;
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 2) {
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if ((queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters.toArray(new QFilter[0]))) == null) {
                ArrayList<QFilter> filters2 = new ArrayList<QFilter>();
                filters2.add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrg)));
                filters2.add(new QFilter("costcenter", "=", (Object)0L));
                if (appnumFilter != null) {
                    filters2.add(appnumFilter);
                }
                queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters2.toArray(new QFilter[0]));
            }
        }
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 1) {
            DynamicObjectCollection query;
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(query = QueryServiceHelper.query((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters.toArray(new QFilter[0]))))) {
                for (DynamicObject dynamicObject : query) {
                    if (!"MANUAL".equals(dynamicObject.getString(newTypeKey))) continue;
                    return "MANUAL";
                }
                queryOne = (DynamicObject)query.get(0);
            }
        }
        if (queryOne != null) {
            result = queryOne.getString(newTypeKey);
        }
        return result;
    }
}

