/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.yieldcollection;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.business.planoutput.PlanOutputService;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.costobject.BaseCostObjectListPlugin;
import kd.macc.cad.servicehelper.PlannedOutputServiceHelper;

public class PlannedOutputBillListPlugin
extends BaseCostObjectListPlugin {
    private static final Log logger = LogFactory.getLog(PlannedOutputBillListPlugin.class);
    private boolean isFirstInitFilterByMainPage = false;
    private boolean isfirstSetFilterByMainPage = false;
    private static final String PAGECACHE_COSTCENTERSET = "costcenterset";
    private static final String closeBack_importResult = "importResult";
    private static final String BIZDATE_DEL_CHERCK = "bizDateDelCherck";
    private static List<ComboItem> costCenterComboItemListBy;
    private static final String closeBack_bizDate = "bizDateModify";

    public PlannedOutputBillListPlugin() {
        this.ORG_FIELD = "accountorg";
        this.PROORG_FIELD = "manuorg";
        this.COSTCENTER_FIELD = "costcenter";
        this.BIZDATE_FIELD = "bizdate";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblshut"});
    }

    @Override
    public String getOrgCacheKey() {
        return this.ORG_FIELD;
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter;
        QFilter costCenterFilter;
        e.setOrderBy("bizdate desc,billno desc");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (this.isMatchCondition(paramMap) && this.isfirstSetFilterByMainPage) {
            String filterStr = (String)paramMap.get("filter");
            if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                QFilter filter = QFilter.fromSerializedString((String)filterStr);
                e.getQFilters().clear();
                e.getQFilters().add(filter);
            }
            this.isfirstSetFilterByMainPage = false;
        }
        if ((costCenterFilter = this.getCostCenterQFilter()) != null) {
            e.getQFilters().add(costCenterFilter);
        }
        if ((manuOrgQFilter = this.getManuOrgQFilter()) != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isFirstInitFilterByMainPage = true;
        this.isfirstSetFilterByMainPage = true;
    }

    private boolean isMatchCondition(Map<String, Object> paramMap) {
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if ("GardHomePlugin".equals(key)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        Map paramMap;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String org = this.getPageCache().get(this.ORG_FIELD);
        if (!CadEmptyUtils.isEmpty((String)org)) {
            costCenterComboItemListBy = this.getCostCenterComboItemListBy(org);
        }
        if (this.isMatchCondition(paramMap = formShowParameter.getCustomParams()) && this.isFirstInitFilterByMainPage) {
            this.mainPageFilterInit(filterColumns, paramMap);
            this.isFirstInitFilterByMainPage = false;
        }
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn("costcenter.name");
        List comboItems = filterColumn.getComboItems();
        HashSet<String> costCenterSet = new HashSet<String>(10);
        for (ComboItem comboItem : comboItems) {
            costCenterSet.add(comboItem.getValue());
        }
        this.getPageCache().put(PAGECACHE_COSTCENTERSET, SerializationUtils.toJsonString(costCenterSet));
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
    }

    private void setCenterComboItems(String orgId, String costCenterId, CommonFilterColumn commonFilterColumn) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> comboItems = Util.getCostCenterByAccoutOrg(orgId, true);
        if (!CadEmptyUtils.isEmpty(comboItems)) {
            commonFilterColumn.setComboItems(comboItems);
        }
        commonFilterColumn.setDefaultValue(costCenterId);
        this.getPageCache().put("costcenter", costCenterId);
    }

    private void mainPageFilterInit(List<FilterColumn> filterColumns, Map<String, Object> paramMap) {
        for (int i = filterColumns.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = filterColumns.get(i);
            CommonFilterColumn schemeFilterColumn = (CommonFilterColumn)filterColumn;
            String schemeFilterColumnName = schemeFilterColumn.getFieldName();
            if ("costcenter.name".equals(schemeFilterColumnName) && paramMap.get("costcenter") != null) {
                this.setCenterComboItems(paramMap.get("org").toString(), paramMap.get("costcenter").toString(), schemeFilterColumn);
                continue;
            }
            if ("accountorg.name".equals(schemeFilterColumnName) && paramMap.get("org") != null) {
                schemeFilterColumn.setDefaultValue(paramMap.get("org").toString());
                this.getPageCache().put("accountorg", paramMap.get("org").toString());
                continue;
            }
            if ("bizdate".equals(schemeFilterColumnName) && paramMap.get("bizdate") != null) {
                schemeFilterColumn.setDefaultValue(paramMap.get("bizdate").toString());
                continue;
            }
            schemeFilterColumn.setDefaultValue((String)null);
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        HashSet<String> hideFields = new HashSet<String>(Arrays.asList("totalinqty", "wipqty"));
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, hideFields);
        }
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
            break;
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (!"costcenter.id".equals(String.valueOf(names.get(0)))) continue;
            List vals = (List)map.get("Value");
            if (vals == null || vals.isEmpty()) {
                this.getPageCache().put("costcenter", "");
                continue;
            }
            if (!CadEmptyUtils.isEmpty(costCenterComboItemListBy)) {
                Set costCenterIdsSet = costCenterComboItemListBy.stream().map(o -> o.getValue()).collect(Collectors.toSet());
                if (!costCenterIdsSet.contains(vals.get(0))) {
                    vals.clear();
                    vals.add("");
                }
            } else {
                vals.clear();
                vals.add("");
            }
            String val = String.valueOf(vals.get(0));
            this.getPageCache().put(this.COSTCENTER_FIELD, val);
        }
        String accountorg = this.getPageCache().get("accountorg");
        if (CadEmptyUtils.isEmpty((String)accountorg)) {
            return;
        }
        Long costCenterId = this.getPageCache().get("accountorg") == null ? 0L : Long.parseLong(this.getPageCache().get("accountorg"));
        List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)args, (String)"costcenter.id", (Long)costCenterId);
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costCenter = this.getPageCache().get("costcenter");
        String manuOrg = this.getPageCache().get("manuorg");
        String bizDate = this.getPageCache().get("bizdate");
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam("costcenter", (Object)costCenter);
        bsp.setCustomParam("manuorg", (Object)manuOrg);
        bsp.setCustomParam("bizdate", (Object)bizDate);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "new": {
                String accountOrg = this.getPageCache().get("accountorg");
                if (!kd.bos.util.StringUtils.isEmpty((String)accountOrg) && !"0".equals(accountOrg)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u65f6\uff0c\u4e0d\u80fd\u65b0\u589e\u3002", (String)"PlannedOutputBillListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                break;
            }
            case "bizdate_modify": {
                BillList billist = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billist.getSelectedRows();
                List planIds = rows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                String acctOrg = this.getPageCache().get(this.ORG_FIELD);
                String message = PlanOutputService.cherckBizDateModify(planIds, (Long)Long.valueOf(acctOrg));
                if (!CadEmptyUtils.isEmpty((String)message)) {
                    this.getView().showMessage(message);
                    args.setCancel(true);
                    return;
                }
                this.showBizDateModifyPage();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        List<ComboItem> orgComboItemList = Util.getAccountOrg();
        if ("tblnew".equals(key) || "manufacturebillcover".equals(key)) {
            if (CadEmptyUtils.isEmpty(orgComboItemList)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PlannedOutputBillListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                return;
            }
            String accountOrg = this.getPageCache().get("accountorg");
            String costCenter = this.getPageCache().get("costcenter");
            if (CadEmptyUtils.isEmpty((String)costCenter) && CadEmptyUtils.isEmpty((Set)((Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(PAGECACHE_COSTCENTERSET), Set.class)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"PlannedOutputBillListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
        switch (key) {
            case "tblnew": {
                break;
            }
            case "manufacturebillbulking": 
            case "manufacturebillcover": {
                if (!CadEmptyUtils.isEmpty(orgComboItemList)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u3002", (String)"PlannedOutputBillListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "tbldel": {
                BillList billist;
                ListSelectedRowCollection rows;
                List planIds;
                DynamicObjectCollection planutputBillnos;
                if ("sca".equalsIgnoreCase(AppIdHelper.getCurAppNum((IFormView)this.getView())) || CadEmptyUtils.isEmpty((DynamicObjectCollection)(planutputBillnos = PlanOutputService.getBizDateModifyInfo(planIds = (rows = (billist = (BillList)this.getControl("billlistap")).getSelectedRows()).stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList()))))) break;
                StringBuilder message = new StringBuilder();
                for (DynamicObject bill : planutputBillnos) {
                    String billno = bill.getString("billno");
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"PlannedOutputBillListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]), billno);
                    message.append(msg);
                    message.append("\r\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5220\u9664\u3002", (String)"PlannedOutputBillListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(message.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(BIZDATE_DEL_CHERCK, (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
        }
    }

    private void showBizDateModifyPage() {
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        Long maxPeriod = PeriodHelper.getMaxPeriodByAcctOrg((Long)Long.valueOf(acctOrg), (String)"aca");
        HashSet<Long> periodIds = new HashSet<Long>(16);
        periodIds.add(maxPeriod);
        Map dates = PeriodHelper.getDateByPeriod(periodIds);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_bizdatemodify");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("beginDate", dates.get("begindate"));
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_bizDate));
        this.getView().showForm(fsp);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "manufacturebillbulking": 
            case "manufacturebillcover": {
                boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)"cad_plannedoutputbill", (String)"47156aff000000ac");
                if (!hasPerm) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PlannedOutputBillListPlugin_25", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.manuBillImport();
                break;
            }
            case "searchup": {
                this.searchUpManuBill();
                break;
            }
            case "colreport": {
                this.viewColReport();
                break;
            }
            case "searchconfig": {
                this.searchConfig();
                break;
            }
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"cad_plannedoutputbill", (IFormView)this.getView());
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_colreport", (boolean)true, (int)1, (boolean)false);
        String acctOrgId = this.getPageCache().get(this.ORG_FIELD);
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)acctOrgId);
        listShowParameter.setCustomParam("colobj", (Object)CollectObjectEnum.PLAN_OUT.getObj());
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u62a5\u544a", (String)"PlannedOutputBillListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblbizdate", "tblnew", "importdata", "importdetails"});
        }
    }

    private void searchUpManuBill() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0a\u67e5\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"PlannedOutputBillListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, List<Object>> probillEntryIdMap = PlannedOutputBillListPlugin.getProbillEntryIds(rows.getPrimaryKeyValues());
        if (CadEmptyUtils.isEmpty(probillEntryIdMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u6765\u6e90\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"PlannedOutputBillListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        block10: for (Map.Entry<String, List<Object>> probill : probillEntryIdMap.entrySet()) {
            String source = probill.getKey();
            ArrayList<String> orgIds = new ArrayList<String>();
            orgIds.add("");
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>(2);
            map.put("useorgIdFilter", orgIds);
            switch (source) {
                case "pom_xmftorderlog": 
                case "om_xmftorderlog": {
                    SrcBillShowerUtils.showSearchUpBillList((IFormView)this.getView(), (String)source, probill.getValue(), map);
                    continue block10;
                }
                case "pom_mftorder_splitlog": 
                case "om_mftorder_splitog": {
                    SrcBillShowerUtils.showSearchUpBillOrList((IFormView)this.getView(), (String)source, probill.getValue(), map);
                    continue block10;
                }
            }
            SrcBillShowerUtils.showSearchUpBillOrList((IFormView)this.getView(), (String)source, probill.getValue(), null);
        }
    }

    private static Map<String, List<Object>> getProbillEntryIds(Object[] objIds) {
        HashMap<String, List<Object>> probillEntryIdMap = new HashMap<String, List<Object>>(10);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        filter.and(new QFilter("source", "not in", (Object)new String[]{"0", "1", "2"}));
        filter.and(new QFilter("sourcebill", ">", (Object)0L));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id,sourcebill,srcbilltype,source,fromlogid", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return probillEntryIdMap;
        }
        for (DynamicObject row : rows) {
            String source = row.getString("srcbilltype");
            if ("pom_xmftorderlog".equals(source) || "pom_mftorder_splitlog".equals(source) || "om_xmftorderlog".equals(source)) {
                probillEntryIdMap.computeIfAbsent(source, p -> new ArrayList(10)).add(row.getLong("fromlogid"));
                continue;
            }
            probillEntryIdMap.computeIfAbsent(source, p -> new ArrayList(10)).add(row.getLong("sourcebill"));
        }
        return probillEntryIdMap;
    }

    private void manuBillImport() {
        try {
            String accountorg = this.getPageCache().get("accountorg");
            String costcenter = this.getPageCache().get("costcenter");
            ArrayList<Long> costCenters = new ArrayList<Long>(10);
            if (accountorg == null) {
                return;
            }
            List costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("multiselectcostcenters"), List.class);
            if (!CadEmptyUtils.isEmpty((List)costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
                costCenters.addAll(costCenterMultiSelect);
            } else if (!CadEmptyUtils.isEmpty((String)costcenter)) {
                costCenters.add(Long.parseLong(costcenter));
            } else {
                String manuOrgId = this.getPageCache().get("manuorg");
                List<ComboItem> comboItems = this.getCostCenterComboItemListByManuOrg(accountorg, manuOrgId);
                comboItems.forEach(p -> costCenters.add(Long.parseLong(p.getValue())));
                boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(accountorg));
                if (isEnableMultiFactory && CadEmptyUtils.isEmpty(comboItems)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"PlannedOutputBillListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(Long.parseLong(accountorg)), (Set)Sets.newHashSet(costCenters), (String)"cad_plannedoutputbill", (String)this.getView().getFormShowParameter().getAppId());
            Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)Long.parseLong(accountorg), (List)enableCostCenters);
            if (CadEmptyUtils.isEmpty((Map)objRules)) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"PlannedOutputBillListPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"PlannedOutputBillListPlugin_17"));
                return;
            }
            if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
                Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)Long.parseLong(accountorg), costCenters, (Map)objRules);
                List collConfigs = CommonCollConfigService.getCollConfigs((Long)Long.parseLong(accountorg), null, (Set)calDimensionIds, (String)"cad_plannedoutputbill", (String)this.getView().getFormShowParameter().getAppId());
                if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                    this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u65b9\u6848\u3002", (String)"PlannedOutputBillListPlugin_24", (String)"macc-cad-formplugin", (Object[])new Object[0]), (String)"PlannedOutputBillListPlugin_18"));
                    return;
                }
            }
            Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(accountorg));
            ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
            if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountorg), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(userHasPermManuOrgs);
            } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                manuOrgs.add(Long.parseLong(this.getPageCache().get("manuorg")));
            }
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"PlannedOutputBillListPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = (Map)PlannedOutputServiceHelper.importPlannedOut((Long)Long.parseLong(accountorg), (List)enableCostCenters, null, (List)manuOrgs, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)progressId);
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"PlannedOutputBillListPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5f15\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    protected String getOrgFileName() {
        return "accountorg";
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        this.getView().hideLoading();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                if ("confirm".equals(responseInfo.get("type"))) {
                    billList.refresh();
                    this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
                break;
            }
            case "bizDateModify": {
                Date newBizDate = (Date)closedCallBackEvent.getReturnData();
                if (newBizDate == null) {
                    return;
                }
                this.dealBizDateModify(newBizDate);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (callBackId) {
                case "showReport": {
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                    this.showColReport((String)responseInfo.get("colReportId"));
                    break;
                }
                case "bizDateDelCherck": {
                    OperateOption operationOption = OperateOption.create();
                    operationOption.setVariableValue(BIZDATE_DEL_CHERCK, "true");
                    this.getView().invokeOperation("delete", operationOption);
                    break;
                }
            }
        }
    }

    private void showColReport(String colReportId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_colreport");
        billShowParameter.setCustomParam("id", (Object)colReportId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u62a5\u544a", (String)"PlannedOutputBillListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void dealBizDateModify(Date newBizDate) {
        BillList billist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billist.getSelectedRows();
        List planIds = rows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        PlanOutputService.dealBizDateModify(planIds, (Date)newBizDate);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u6210\u529f\u3002", (String)"PlannedOutputBillListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }
}

