/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class ActualRateAnalyRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private Boolean isChangeSubEle = false;

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String appId = this.getView().getFormShowParameter().getAppId();
        filterInfo.addFilterItem("appnum", (Object)appId, "=");
        queryParam.setFilter(filterInfo);
    }

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulProdorg = (MulBasedataEdit)this.getControl("mulprodorg");
        mulProdorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulcostcenter = (MulBasedataEdit)this.getControl("mulcostcenter");
        mulcostcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulelement = (MulBasedataEdit)this.getControl("mulelement");
        mulelement.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulsubelement = (MulBasedataEdit)this.getControl("mulsubelement");
        mulsubelement.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit queryperiod = (BasedataEdit)this.getControl("queryperiod");
        queryperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d", (String)"ActualRateAnalyRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getEnableQfilterByOrg((Long)Long.valueOf(org.getPkValue().toString()), null, (String)"sca"));
                break;
            }
            case "mulprodorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d", (String)"ActualRateAnalyRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
                break;
            }
            case "startperiod": 
            case "endperiod": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d", (String)"ActualRateAnalyRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d", (String)"ActualRateAnalyRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter usePeriodFilter = StartCostHelper.getUsePeriodFilter((Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue())));
                listShowParameter.getListFilterParameter().getQFilters().add(usePeriodFilter);
                break;
            }
            case "mulcostcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d", (String)"ActualRateAnalyRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ArrayList manuOrgList = new ArrayList(16);
                DynamicObjectCollection mulManuorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulprodorg");
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulManuorg)) {
                    mulManuorg.forEach(p -> manuOrgList.add(p.getLong("fbasedataid.id")));
                }
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)org.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
                QFilter qfOrgDuty = new QFilter("orgduty.number", "in", (Object)new String[]{"4"});
                listShowParameter.getListFilterParameter().getQFilters().add(costCenterIdFilter);
                listShowParameter.getListFilterParameter().getQFilters().add(qfOrgDuty);
                break;
            }
            case "mulelement": {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("type", "in", (Object)new String[]{"003", "004"}));
                break;
            }
            case "mulsubelement": {
                DynamicObjectCollection mulelements = this.getModel().getDataEntity().getDynamicObjectCollection("mulelement");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulelements)) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("type", "in", (Object)new String[]{"003", "004"}));
                    return;
                }
                HashSet elements = new HashSet(16);
                mulelements.forEach(p -> elements.add(p.getLong("fbasedataid.id")));
                DynamicObjectCollection subElments = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id subelement", (QFilter[])new QFilter[]{new QFilter("element", "in", elements)});
                elements.clear();
                subElments.forEach(p -> elements.add(p.getLong("subelement")));
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", elements));
                break;
            }
            case "queryperiod": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d", (String)"ActualRateAnalyRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d", (String)"ActualRateAnalyRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(CostUpdateHelper.getRptPeriodQFilter((Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "org": {
                this.setCostAccount(newValue);
                this.getModel().setValue("mulcostcenter", null);
                break;
            }
            case "costaccount": {
                this.displayProdOrg(newValue);
                this.setCurrency(newValue);
                this.setPeriod(newValue);
                this.dealQueryPeriod();
                break;
            }
            case "startperiod": {
                this.adjustEndPeriodByStartPeriod(newValue);
                break;
            }
            case "endperiod": {
                this.adjustEndPeriodByEndPeriod(newValue);
                break;
            }
            case "mulelement": {
                if (this.isChangeSubEle.booleanValue()) break;
                this.getModel().setValue("mulsubelement", null);
                break;
            }
            case "mulsubelement": {
                this.isChangeSubEle = Boolean.TRUE;
                this.setElement(newValue);
                break;
            }
            case "showperiodsum": {
                this.dealQueryPeriod();
                break;
            }
            case "stdperiodsum": {
                this.dealQueryPeriod();
            }
        }
    }

    private void adjustEndPeriodByStartPeriod(Object startPeriod) {
        if (startPeriod == null) {
            return;
        }
        DynamicObject endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod");
        if (endPeriod == null) {
            return;
        }
        long endPeriodId = endPeriod.getLong("id");
        long startPeriodId = ((DynamicObject)startPeriod).getLong("id");
        if (startPeriodId > endPeriodId) {
            this.getModel().setValue("endperiod", (Object)startPeriodId);
            this.getView().updateView("endperiod");
        }
    }

    private void adjustEndPeriodByEndPeriod(Object endPeriod) {
        if (endPeriod == null) {
            return;
        }
        DynamicObject startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod");
        if (startPeriod == null) {
            return;
        }
        long startPeriodId = startPeriod.getLong("id");
        long endPeriodId = ((DynamicObject)endPeriod).getLong("id");
        if (endPeriodId < startPeriodId) {
            this.getModel().setValue("endperiod", (Object)startPeriodId);
            this.getView().updateView("endperiod");
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d", (String)"ActualRateAnalyRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d", (String)"ActualRateAnalyRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject startperiod = filter.getDynamicObject("startperiod");
        if (startperiod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f00\u59cb\u671f\u95f4\u201d", (String)"ActualRateAnalyRpt_2", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject endperiod = filter.getDynamicObject("endperiod");
        if (endperiod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ed3\u675f\u671f\u95f4\u201d", (String)"ActualRateAnalyRpt_3", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject currency = filter.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ef4\u62a4\u5e01\u79cd", (String)"ActualRateAnalyRpt_4", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        Boolean showPeriodSum = (Boolean)this.getModel().getValue("showperiodsum");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)org.getLong("id"), (Long)costaccount.getLong("id"));
        if (showPeriodSum.booleanValue()) {
            if (CadEmptyUtils.isEmpty((String)filter.getString("actperiodsum"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6309\u671f\u95f4\u6c47\u603b\u5b9e\u9645\u8d39\u7387\u201d", (String)"ActualRateAnalyRpt_5", (String)"macc-cad-report", (Object[])new Object[0]));
            }
            if (CadEmptyUtils.isEmpty((String)filter.getString("stdperiodsum"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6309\u671f\u95f4\u6c47\u603b\u6807\u51c6\u8d39\u7387\u201d", (String)"ActualRateAnalyRpt_6", (String)"macc-cad-report", (Object[])new Object[0]));
            }
            if ("date".equals(filter.getString("stdperiodsum"))) {
                if (Boolean.FALSE.equals(isUpdateByPeriod) && filter.getDate("querydate") == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u67e5\u8be2\u65f6\u95f4\uff08\u6807\u51c6\u8d39\u7387\uff09\u201d", (String)"ActualRateAnalyRpt_7", (String)"macc-cad-report", (Object[])new Object[0]));
                }
                if (Boolean.TRUE.equals(isUpdateByPeriod) && filter.getDynamicObject("queryperiod") == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u67e5\u8be2\u671f\u95f4\uff08\u6807\u51c6\u8d39\u7387\uff09\u201d", (String)"ActualRateAnalyRpt_8", (String)"macc-cad-report", (Object[])new Object[0]));
                }
            }
        }
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("entityId", (Object)this.getBillEntityId());
        return super.verifyQuery(queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.parseLong(costaccount.getPkValue().toString()));
        boolean showPeriodSum = (Boolean)this.getModel().getValue("showperiodsum");
        List columns = event.getColumns();
        for (AbstractReportColumn col : columns) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)col;
            String key = reportColumn.getFieldKey();
            if ("entryprodorg".equals(key) || "entryprodorgname".equals(key)) {
                reportColumn.setHide(!enableMulFactory);
            }
            if (!"period".equals(key)) continue;
            reportColumn.setHide(showPeriodSum);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ActualRateAnalyRpt_9", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"ActualRateAnalyRpt_10", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    private String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void setElement(Object subelement) {
        DynamicObjectCollection mulelement = (DynamicObjectCollection)this.getModel().getValue("mulelement");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulelement)) {
            return;
        }
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)((DynamicObjectCollection)subelement))) {
            return;
        }
        DynamicObjectCollection subelements = (DynamicObjectCollection)subelement;
        HashSet subeleids = new HashSet(16);
        subelements.forEach(p -> subeleids.add(p.getLong("fbasedataid.id")));
        DynamicObjectCollection elments = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element.id element", (QFilter[])new QFilter[]{new QFilter("subelement", "in", subeleids)});
        subeleids.clear();
        elments.forEach(p -> subeleids.add(p.getLong("element")));
        this.getModel().setValue("mulelement", (Object)subeleids.toArray());
        this.getView().updateView("mulelement");
    }

    private void displayProdOrg(Object costaccount) {
        if (costaccount == null) {
            this.getModel().setValue("mulprodorg", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"mulprodorg"});
            return;
        }
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.parseLong(((DynamicObject)costaccount).getPkValue().toString()));
        if (!enableMulFactory) {
            this.getModel().setValue("mulprodorg", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"mulprodorg"});
            return;
        }
        this.getModel().setValue("mulprodorg", null);
        this.getView().setVisible(Boolean.TRUE, new String[]{"mulprodorg"});
        this.getView().updateView("mulprodorg");
    }

    private void setCurrency(Object costaccount) {
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = ((DynamicObject)costaccount).getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod(Object costAccount) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        if (costAccount == null) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = ((DynamicObject)costAccount).getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("startperiod", (Object)currentperiod);
            this.getModel().setValue("endperiod", (Object)currentperiod);
            this.getView().updateView("startperiod");
            this.getView().updateView("endperiod");
        }
    }

    private void init() {
        DynamicObject costaccount;
        if (this.getModel().getValue("org") == null) {
            DynamicObject org;
            long currentOrgId = RequestContext.getOrCreate().getOrgId();
            boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
            if (!this.getHasPermAccountOrg(currentOrgId)) {
                return;
            }
            if (isaccount) {
                this.getModel().setValue("org", (Object)currentOrgId);
                this.getView().updateView("org");
            }
            if ((org = this.getModel().getDataEntity().getDynamicObject("org")) == null) {
                return;
            }
            this.setCostAccount(org);
            DynamicObject costaccount2 = this.getModel().getDataEntity().getDynamicObject("costaccount");
            this.displayProdOrg(costaccount2);
            this.getModel().setValue("querydate", (Object)TimeServiceHelper.now());
            this.getView().updateView("querydate");
        }
        if ((costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount")) == null) {
            return;
        }
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.parseLong(costaccount.getPkValue().toString()));
        if (!enableMulFactory) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mulprodorg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mulprodorg"});
        }
        this.dealQueryPeriod();
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("mulprodorg", null);
            this.getModel().setValue("currency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("mulcostcenter", null);
            return;
        }
        Long mainBookId = this.getCostAccountByAccoutOrg(((DynamicObject)org).getLong("id"));
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
            this.getView().updateView("costaccount");
            Object costaccount = this.getModel().getValue("costaccount");
            this.setCurrency(costaccount);
            this.setPeriod(costaccount);
            return;
        }
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("startperiod", null);
        this.getModel().setValue("endperiod", null);
    }

    public Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter[] filters;
        DynamicObjectCollection result;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        if ((result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])(filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF = new QFilter("appnum", "=", (Object)appId)}), null)) == null || result.size() == 0) {
            return 0L;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return 0L;
    }

    private boolean getHasPermAccountOrg(Long orgId) {
        String entityid = this.getView().getEntityId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getView().getFormShowParameter().getAppId(), (String)entityid, (String)"47150e89000000ac");
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        return rs.getHasPermOrgs().contains(orgId);
    }

    private void dealQueryPeriod() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (org == null || costAccount == null) {
            this.setQueryVisible(Boolean.FALSE, null, null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)orgId, (Long)costAccountId);
        this.setQueryVisible(isUpdateByPeriod, orgId, costAccountId);
    }

    private void setQueryVisible(Boolean isShow, Long orgId, Long costAccountId) {
        Boolean showPeriodSum = (Boolean)this.getModel().getValue("showperiodsum");
        String stdPeriodSum = (String)this.getModel().getValue("stdperiodsum");
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        DateTimeEdit queryDate = (DateTimeEdit)this.getControl("querydate");
        ComboEdit actperiodSum = (ComboEdit)this.getControl("actperiodsum");
        ComboEdit stdperiodSum = (ComboEdit)this.getControl("stdperiodsum");
        if (showPeriodSum.booleanValue()) {
            if ("date".equals(stdPeriodSum)) {
                this.getView().setVisible(isShow, new String[]{"queryperiod"});
                queryPeriod.setMustInput(isShow.booleanValue());
                if (Boolean.TRUE.equals(isShow)) {
                    List periodIds = CostUpdateHelper.getPeriodIds((Long)orgId, (Long)costAccountId);
                    this.getModel().setValue("queryperiod", periodIds.isEmpty() ? null : periodIds.get(0));
                } else {
                    this.getModel().setValue("queryperiod", null);
                }
                this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{"querydate"});
                queryDate.setMustInput(isShow == false);
                this.getModel().setValue("querydate", (Object)(Boolean.TRUE.equals(isShow == false) ? TimeServiceHelper.now() : null));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"queryperiod", "querydate"});
                queryPeriod.setMustInput(Boolean.FALSE.booleanValue());
                queryDate.setMustInput(Boolean.FALSE.booleanValue());
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"actperiodsum", "stdperiodsum"});
            actperiodSum.setMustInput(Boolean.TRUE.booleanValue());
            stdperiodSum.setMustInput(Boolean.TRUE.booleanValue());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"actperiodsum", "stdperiodsum", "queryperiod", "querydate"});
            queryPeriod.setMustInput(Boolean.FALSE.booleanValue());
            queryDate.setMustInput(Boolean.FALSE.booleanValue());
            actperiodSum.setMustInput(Boolean.FALSE.booleanValue());
            stdperiodSum.setMustInput(Boolean.FALSE.booleanValue());
        }
    }
}

