/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class BaseLogarithmPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(qfId);
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BaseLogarithmPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulbizorg = filter.getDynamicObjectCollection("mulbizorg");
        if (mulbizorg == null || mulbizorg.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"BaseLogarithmPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate == null || enddate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"BaseLogarithmPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        this.setDateRange();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        String appnum = showParameter.getAppId();
        FilterInfo filterInfo = queryParam.getFilter();
        if (CadEmptyUtils.isEmpty((String)filterInfo.getString("appnum"))) {
            filterInfo.addFilterItem("appnum", (Object)appnum, "=");
        }
        Map customParams = showParameter.getCustomParams();
        if (this.getView().getControl("ishyperlink") != null && ((Boolean)this.getModel().getValue("ishyperlink")).booleanValue() && customParams.get("transactiontypeid") != null) {
            filterInfo.addFilterItem("transactiontypeid", customParams.get("transactiontypeid"), "=");
            filterInfo.addFilterItem("sourcebill", customParams.get("sourcebill"), "=");
        }
        queryParam.setFilter(filterInfo);
    }

    public void afterBindData(EventObject e) {
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        if (customParams.get("org") == null) {
            return;
        }
        this.getModel().setValue("org", customParams.get("org"));
        List mulbizorg = (List)customParams.get("mulbizorg");
        this.getModel().setValue("mulbizorg", (Object)mulbizorg.toArray());
        this.getModel().setValue("startdate", customParams.get("startdate"));
        this.getModel().setValue("enddate", customParams.get("enddate"));
        this.getModel().setValue("ishyperlink", customParams.get("ishyperlink"));
    }

    private void setDateRange() {
        if (this.getModel().getValue("startdate") == null && this.getModel().getValue("enddate") == null) {
            Calendar calendar1 = Calendar.getInstance();
            calendar1.add(2, 0);
            calendar1.set(5, 1);
            Calendar calendar2 = Calendar.getInstance();
            calendar1.add(2, 0);
            calendar2.set(5, calendar2.getActualMaximum(5));
            this.getModel().setValue("startdate", (Object)calendar1.getTime());
            this.getModel().setValue("enddate", (Object)calendar2.getTime());
            this.getView().updateView("daterange");
        }
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            this.getModel().setValue("org", (Object)orgId);
            this.getView().updateView("org");
        }
    }
}

