/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import net.sf.json.JSONArray;

public class CollectNumCheckRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(CollectNumCheckRptPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String KEY_SHOWBIZORG = "isShowBizOrg";
    private static final String BIZ_TYPE_RO = "RO";

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgInput = (BasedataEdit)this.getControl("forg");
        orgInput.addBeforeF7SelectListener(evt -> {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(qfId);
        });
        BasedataEdit mulbizorgInput = (BasedataEdit)this.getControl("mulbizorg");
        mulbizorgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("forg");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CollectNumCheckRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List productOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            filterParameter.getQFilters().add(new QFilter("id", "in", (Object)productOrgs));
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "forg": {
                this.setBizOrgIsShow(true);
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("forg");
                if (org == null) break;
                if (!"true".equals(this.getPageCache().get("customSet"))) {
                    List importScopeDate = SysParamHelper.getImportScopeDate((Long)org.getLong("id"), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                    if (!CadEmptyUtils.isEmpty((List)importScopeDate)) {
                        Date startDate = (Date)((Map)importScopeDate.get(0)).get("start");
                        Date endDate = (Date)((Map)importScopeDate.get(0)).get("end");
                        if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)"colCheckDateEnable", (String)"1"))) {
                            this.getPageCache().put("startdate", DateUtils.formatDate((Date)startDate, (String)"yyyy-MM-dd"));
                            this.getPageCache().put("enddate", DateUtils.formatDate((Date)endDate, (String)"yyyy-MM-dd"));
                        }
                        this.getModel().setValue("startdate", (Object)startDate);
                        this.getModel().setValue("enddate", (Object)endDate);
                    } else {
                        this.getPageCache().put("startdate", null);
                        this.getPageCache().put("enddate", null);
                    }
                }
                this.getModel().setValue("entryids", (Object)"");
                break;
            }
            case "startdate": {
                this.dateVaildate(e, "startdate");
                break;
            }
            case "enddate": {
                this.dateVaildate(e, "enddate");
            }
        }
    }

    private void dateVaildate(PropertyChangedArgs e, String property) {
        String startdate = this.getPageCache().get("startdate");
        String enddate = this.getPageCache().get("enddate");
        if (StringUtils.isEmpty((String)startdate) || StringUtils.isEmpty((String)enddate)) {
            return;
        }
        Date startD = DateUtils.parseDate((String)(startdate + " 00:00:00"));
        Date endD = DateUtils.parseDate((String)(enddate + " 00:00:00"));
        boolean isSet = false;
        Date newDate = (Date)e.getChangeSet()[0].getNewValue();
        if (newDate == null) {
            isSet = true;
        } else if ((newDate = DateUtils.getDayStartTime((Date)newDate)).compareTo(startD) < 0 || newDate.compareTo(endD) > 0) {
            isSet = true;
        }
        if (isSet) {
            this.getModel().beginInit();
            if ("startdate".equals(property)) {
                this.getModel().setValue(property, (Object)startD);
            } else {
                this.getModel().setValue(property, (Object)endD);
            }
            this.getModel().endInit();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u53ef\u9009\u8303\u56f4\u9650\u5236\u5728%1$s~%2$s\u4e4b\u95f4\u3002", (String)"CollectNumCheckRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]), startdate, enddate));
        }
    }

    private void setBizOrgIsShow(boolean isClear) {
        DynamicObject org;
        boolean show = false;
        if (isClear) {
            this.getModel().setValue("mulbizorg", null);
        }
        if ("sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())) && (org = this.getModel().getDataEntity().getDynamicObject("forg")) != null && OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
            show = true;
        }
        this.getPageCache().put(KEY_SHOWBIZORG, String.valueOf(show));
        this.getView().setVisible(Boolean.valueOf(show), new String[]{"mulbizorg"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        if (customParams.get("org") == null) {
            this.setOrg();
            this.setDateRange();
        }
    }

    public void afterBindData(EventObject e) {
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        if (customParams.get("org") == null) {
            this.setBizOrgIsShow(false);
            return;
        }
        this.getPageCache().put("customSet", "true");
        this.getModel().setValue("forg", customParams.get("org"));
        if (customParams.get("mulbizorg") != null) {
            JSONArray jsonArray = JSONArray.fromObject(customParams.get("mulbizorg"));
            Object[] mulbizorgs = (Object[])JSONArray.toArray((JSONArray)jsonArray);
            this.getModel().setValue("mulbizorg", (Object)mulbizorgs);
        }
        this.getModel().setValue("multargetbill", customParams.get("multargetbill"));
        this.getModel().setValue("startdate", customParams.get("startdate"));
        this.getModel().setValue("enddate", customParams.get("enddate"));
        if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)"colCheckDateEnable", (String)"1"))) {
            this.getPageCache().put("startdate", DateUtils.formatDate((Date)this.getModel().getDataEntity().getDate("startdate"), (String)"yyyy-MM-dd"));
            this.getPageCache().put("enddate", DateUtils.formatDate((Date)this.getModel().getDataEntity().getDate("enddate"), (String)"yyyy-MM-dd"));
        }
        if (customParams.containsKey("entryIds")) {
            try {
                JSONArray entryIdArr = JSONArray.fromObject(customParams.get("entryIds"));
                Object[] ids = (Object[])JSONArray.toArray((JSONArray)entryIdArr);
                StringBuilder sb = new StringBuilder();
                for (Object obj : ids) {
                    if (obj == null) continue;
                    sb.append(obj).append(",");
                }
                this.getModel().setValue("entryids", (Object)sb.toString());
            }
            catch (Exception ex) {
                logger.error("json\u8f6c\u6362\u62a5\u9519", (Throwable)ex);
                this.getModel().setValue("entryids", customParams.get("entryIds"));
            }
        }
        this.setBizOrgIsShow(false);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo;
        super.beforeQuery(queryParam);
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        String appnum = showParameter.getAppId();
        if (StringUtils.isEmpty((String)appnum)) {
            appnum = "sca";
        }
        if (CadEmptyUtils.isEmpty((String)(filterInfo = queryParam.getFilter()).getString("appnum"))) {
            filterInfo.addFilterItem("appnum", (Object)appnum, "=");
        }
        if (this.getView().getFormShowParameter().getShowParameter().getCustomParam("org") == null && CollectNumCheckRptPlugin.isCostObjectRuleAllRoType(filterInfo.getDynamicObject("forg").getLong("id"))) {
            filterInfo.addFilterItem("entryIdSearchType", (Object)"1", "=");
        } else {
            Map customParams = showParameter.getCustomParams();
            if (customParams.containsKey("entryIdSearchType")) {
                filterInfo.addFilterItem("entryIdSearchType", customParams.get("entryIdSearchType"), "=");
            }
        }
        queryParam.setFilter(filterInfo);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CollectNumCheckRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u5f52\u96c6\u5bf9\u6570\u6c47\u603b\u8868", (String)"CollectNumCheckRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        int month;
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("forg");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CollectNumCheckRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        String multargetbill = filter.getString("multargetbill");
        if (CadEmptyUtils.isEmpty((String)multargetbill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u76ee\u6807\u5355\u636e\u3002", (String)"CollectNumCheckRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate == null || enddate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"CollectNumCheckRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        String entryIds = this.getModel().getDataEntity().getString("entryids");
        if (StringUtils.isEmpty((String)entryIds) && this.getView().getFormShowParameter().getShowParameter().getCustomParam("org") == null && CollectNumCheckRptPlugin.isCostObjectRuleAllRoType(org.getLong("id")) && (month = CadBgParamUtils.getCadParamForInt((String)"colnumCheckMonth", (int)3)) > 0) {
            if (month > 10) {
                month = 10;
            }
            Date sDate = this.getStartDateOnEnd(enddate, month);
            String entryids = this.getEntryIds(org.getLong("id"), sDate, enddate);
            this.getModel().setValue("entryids", (Object)entryids);
            List items = filter.getFilterItems();
            for (FilterItemInfo info : items) {
                if (!"entryids".equals(info.getPropName())) continue;
                info.setValue((Object)entryids);
                break;
            }
        }
        return super.verifyQuery(queryParam);
    }

    private String getEntryIds(long orgId, Date startDate, Date endDate) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("bookdate", ">=", (Object)startDate);
        filter.and("bookdate", "<=", (Object)endDate);
        DataSet costObjects = QueryServiceHelper.queryDataSet((String)"cadcostobject", (String)"cad_costobject", (String)"probill", (QFilter[])filter.toArray(), null);
        StringBuilder sb = new StringBuilder();
        for (Row costObject : costObjects) {
            Long proBill = costObject.getLong("probill");
            if (CadEmptyUtils.isEmpty((Long)proBill)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(proBill);
        }
        return sb.toString();
    }

    private Date getStartDateOnEnd(Date enddate, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(enddate);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.add(10, 24);
        calendar.add(2, -month);
        return calendar.getTime();
    }

    private static boolean isCostObjectRuleAllRoType(long orgId) {
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter billStatusQf = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection costObjRule = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"biztype", (QFilter[])new QFilter[]{orgQf, billStatusQf});
        for (DynamicObject rule : costObjRule) {
            String bizType = rule.getString("biztype");
            if (BIZ_TYPE_RO.equals(bizType)) continue;
            return false;
        }
        return true;
    }

    private void setDateRange() {
        if (this.getModel().getValue("startdate") != null || this.getModel().getValue("enddate") != null) {
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("forg");
        if (org == null) {
            Calendar calendar1 = Calendar.getInstance();
            calendar1.add(2, 0);
            calendar1.set(5, 1);
            Calendar calendar2 = Calendar.getInstance();
            calendar1.add(2, 0);
            calendar2.set(5, calendar2.getActualMaximum(5));
            this.getModel().setValue("startdate", (Object)calendar1.getTime());
            this.getModel().setValue("enddate", (Object)calendar2.getTime());
            this.getView().updateView("daterange");
        } else {
            List importScopeDate = SysParamHelper.getImportScopeDate((Long)org.getLong("id"), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            if (!CadEmptyUtils.isEmpty((List)importScopeDate)) {
                Date startDate = (Date)((Map)importScopeDate.get(0)).get("start");
                Date endDate = (Date)((Map)importScopeDate.get(0)).get("end");
                this.getModel().setValue("startdate", (Object)startDate);
                this.getModel().setValue("enddate", (Object)endDate);
                if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)"colCheckDateEnable", (String)"1"))) {
                    this.getPageCache().put("startdate", DateUtils.formatDate((Date)startDate, (String)"yyyy-MM-dd"));
                    this.getPageCache().put("enddate", DateUtils.formatDate((Date)endDate, (String)"yyyy-MM-dd"));
                }
            }
        }
    }

    private void setOrg() {
        if (this.getModel().getValue("forg") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            this.getModel().setValue("forg", (Object)orgId);
            this.getView().updateView("forg");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        ReportList rptList = (ReportList)e.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
        DynamicObject orgDyn = row.getDynamicObject("org");
        Long org = 0L;
        org = orgDyn != null ? Long.valueOf(row.getDynamicObject("org").getLong("id")) : Long.valueOf(this.getModel().getDataEntity().getDynamicObject("forg").getLong("id"));
        Long entrybizorg = null;
        if (row.getDynamicObject("manuorg") != null) {
            entrybizorg = row.getDynamicObject("manuorg").getLong("id");
        }
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        DynamicObject billtype = row.getDynamicObject("billtype");
        String targetbill = this.getModel().getDataEntity().getString("multargetbill");
        ReportShowParameter showParameter = new ReportShowParameter();
        ReportQueryParam queryParam = new ReportQueryParam();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("org", org);
        if (!CadEmptyUtils.isEmpty((Long)entrybizorg) && "sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())) && OrgHelper.isOrgEnableMultiFactory((Long)org)) {
            map.put("mulbizorg", entrybizorg);
        }
        map.put("multargetbill", targetbill);
        if (billtype != null) {
            String billtypeNum = billtype.getString("id");
            if ("om_xmftorderlog".equals(billtypeNum) || "om_mftorder_splitog".equals(billtypeNum)) {
                map.put("sourcebill", "om_mftorder");
            } else if ("pom_mftorder_splitlog".equals(billtypeNum) || "pom_xmftorderlog".equals(billtypeNum)) {
                map.put("sourcebill", "pom_mftorder");
            } else {
                map.put("sourcebill", billtype.getString("id"));
            }
        }
        map.put("startdate", startdate);
        map.put("enddate", enddate);
        map.put("showdiffonly", true);
        String entryids = this.getModel().getDataEntity().getString("entryids");
        if (!StringUtils.isEmpty((String)entryids)) {
            map.put("entryIds", entryids);
            if (this.getView().getFormShowParameter().getShowParameter().getCustomParam("org") == null && CollectNumCheckRptPlugin.isCostObjectRuleAllRoType(org)) {
                map.put("entryIdSearchType", "1");
            } else {
                Map customParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
                if (customParams.containsKey("entryIdSearchType")) {
                    map.put("entryIdSearchType", customParams.get("entryIdSearchType"));
                }
            }
        }
        map.put("ishyperlink", Boolean.TRUE);
        showParameter.setFormId("cad_collectconcheck");
        showParameter.setCustomParams(map);
        showParameter.setQueryParam(queryParam);
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        rptList.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        boolean showBizOrg = "true".equals(this.getPageCache().get(KEY_SHOWBIZORG));
        for (AbstractReportColumn col : columns) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)col;
            String key = reportColumn.getFieldKey();
            if (showBizOrg) continue;
            if ("manuorg".equals(key)) {
                reportColumn.setHide(true);
            }
            if (!"manuorgname".equals(key)) continue;
            reportColumn.setHide(true);
        }
    }
}

