/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.service.ServiceFactory;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.report.formplugin.BaseLogarithmPlugin;
import net.sf.json.JSONArray;

public class CollectionCheckRptPlugin
extends BaseLogarithmPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    @Override
    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        final Date startdate = (Date)this.getModel().getValue("startdate");
        final Date enddate = (Date)this.getModel().getValue("enddate");
        BasedataEdit mulbizorgInput = (BasedataEdit)this.getControl("mulbizorg");
        mulbizorgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CollectionCheckRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qfId = new QFilter("enable", "=", (Object)Boolean.TRUE);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(qfId);
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        final IReportView view = this.getView();
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                ReportList rptList = (ReportList)e.getSource();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                String fieldName = e.getFieldName();
                String entrybizorgname = row.getString("entrybizorgname");
                if (ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CollectionCheckRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]), (String)"macc-cad-report").equals(entrybizorgname) || ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u603b\u8ba1", (String)"CollectionCheckRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]), (String)"macc-cad-report").equals(entrybizorgname)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5408\u8ba1\u884c\u7684\u6570\u91cf\u5f02\u5e38\u4e3a\u603b\u6570\uff0c\u4e0d\u80fd\u901a\u8fc7\u94fe\u63a5\u67e5\u770b\u6570\u91cf\u5dee\u5f02\u8868\u3002", (String)"CollectionCheckRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
                    return;
                }
                Long entryorg = row.getDynamicObject("entryorg").getLong("id");
                Long entrybizorg = row.getDynamicObject("entrybizorg").getLong("id");
                Long transactiontypeid = CadEmptyUtils.isEmpty((String)row.getString("transactiontypeid")) ? 0L : Long.parseLong(row.getString("transactiontypeid"));
                String targetbill = row.getString("targetbill");
                String sourcebill = row.getString("sourcebilltype");
                String formId = "";
                if ("A".equals(targetbill)) {
                    formId = "cad_costobjectlogarithm";
                } else if ("B".equals(targetbill)) {
                    formId = "cad_plannedoutputlogarith";
                } else if ("C".equals(targetbill)) {
                    formId = "cad_factoutputlogarithm";
                } else if ("D".equals(targetbill)) {
                    formId = "cad_resourceuselogarithm";
                } else if ("E".equals(targetbill)) {
                    formId = "cad_matcollectlogarithm";
                } else {
                    return;
                }
                ReportShowParameter showParameter = new ReportShowParameter();
                ReportQueryParam queryParam = new ReportQueryParam();
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("org", entryorg);
                map.put("mulbizorg", Collections.singletonList(entrybizorg));
                map.put("multargetbill", targetbill);
                map.put("transactiontypeid", transactiontypeid);
                map.put("sourcebill", sourcebill);
                map.put("startdate", startdate);
                map.put("enddate", enddate);
                map.put("ishyperlink", Boolean.TRUE);
                if ("numabnormal".equals(fieldName)) {
                    formId = "cad_collectquantityvarrpt";
                    showParameter.setFormId(formId);
                    showParameter.setCustomParams(map);
                    showParameter.setQueryParam(queryParam);
                    showParameter.setHasRight(true);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    rptList.getView().showForm((FormShowParameter)showParameter);
                    return;
                }
                if ("contentabnormal".equals(fieldName)) {
                    showParameter.setFormId(formId);
                    showParameter.setCustomParams(map);
                    showParameter.setQueryParam(queryParam);
                    showParameter.setHasRight(true);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    rptList.getView().showForm((FormShowParameter)showParameter);
                }
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.getModel().setValue("mulbizorg", null);
            }
        }
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        if (evt.getRowData() != null && evt.getRowData().containsProperty("entrybizorgname")) {
            String entryBizOrgName = evt.getRowData().getString("entrybizorgname");
            if (ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CollectionCheckRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]), (String)"macc-cad-report").equals(entryBizOrgName) || ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u603b\u8ba1", (String)"CollectionCheckRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]), (String)"macc-cad-report").equals(entryBizOrgName)) {
                evt.getNoLinkKey().add(((ReportColumn)evt.getSource()).getFieldKey());
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        if (customParams.get("org") == null) {
            return;
        }
        this.getModel().setValue("org", customParams.get("org"));
        JSONArray jsonArray = JSONArray.fromObject(customParams.get("mulbizorg"));
        Object[] mulbizorgs = (Object[])JSONArray.toArray((JSONArray)jsonArray);
        this.getModel().setValue("mulbizorg", (Object)mulbizorgs);
        this.getModel().setValue("multargetbill", customParams.get("multargetbill"));
        this.getModel().setValue("startdate", customParams.get("startdate"));
        this.getModel().setValue("enddate", customParams.get("enddate"));
        this.getModel().setValue("ishyperlink", customParams.get("ishyperlink"));
    }

    public void afterQuery(ReportQueryParam queryParam) {
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CollectionCheckRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u5f52\u96c6\u5bf9\u6570\u6c47\u603b\u8868", (String)"CollectionCheckRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_collectioncheck", (String)this.getView().getFormShowParameter().getAppId());
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CollectionCheckRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulbizorg = filter.getDynamicObjectCollection("mulbizorg");
        if (mulbizorg == null || mulbizorg.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"CollectionCheckRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        String multargetbill = filter.getString("multargetbill");
        if (CadEmptyUtils.isEmpty((String)multargetbill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u76ee\u6807\u5355\u636e\u3002", (String)"CollectionCheckRptPlugin_8", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate == null || enddate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"CollectionCheckRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }
}

