/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.report.formplugin.CollectionCheckRptPlugin;

public class CollectionQuantityVarianceRptPlugin
extends CollectionCheckRptPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    @Override
    public void registerListener(EventObject e) {
        List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(qfId);
        });
        BasedataEdit mulbizorgInput = (BasedataEdit)this.getControl("mulbizorg");
        mulbizorgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CollectionQuantityVarianceRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(filter);
        });
        final String appNum = this.getView().getFormShowParameter().getAppId();
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                ReportList rptList = (ReportList)e.getSource();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                String fieldName = e.getFieldName();
                String formId = "";
                String billno = row.getString(fieldName);
                String targetBillType = row.getString("targetbill");
                if ("bizbillno".equals(fieldName)) {
                    formId = row.getString("srcbilltype");
                } else if ("costbillno".equals(fieldName) && "A".equals(targetBillType)) {
                    formId = "cad_costobject";
                } else if ("costbillno".equals(fieldName) && "B".equals(targetBillType)) {
                    formId = "cad_plannedoutputbill";
                } else if ("costbillno".equals(fieldName) && "C".equals(targetBillType)) {
                    formId = "cad_factnedoutputbill";
                } else if ("costbillno".equals(fieldName) && "D".equals(targetBillType)) {
                    formId = "sca_resourceuse";
                } else if ("costbillno".equals(fieldName) && "E".equals(targetBillType)) {
                    formId = "sca".equals(appNum) ? "sca_matusecollect" : "aca_matusecollect";
                } else {
                    return;
                }
                QFilter allocbillnoQF = new QFilter("billno", "=", (Object)billno);
                if ("pom_xmftorderlog".equals(formId) || "om_xmftorderlog".equals(formId)) {
                    allocbillnoQF = new QFilter("xbillno", "=", (Object)billno);
                }
                if ("pom_mftorder_splitlog".equals(formId) || "om_mftorder_splitog".equals(formId)) {
                    BaseShowParameter bsp = new BaseShowParameter();
                    bsp.setFormId(formId);
                    bsp.getOpenStyle().setShowType(ShowType.Modal);
                    bsp.setPkId((Object)Long.parseLong(billno));
                    bsp.setBillStatusValue(Integer.valueOf(BillOperationStatus.VIEW.getValue()));
                    rptList.getView().showForm((FormShowParameter)bsp);
                    return;
                }
                DynamicObjectCollection allocbill = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])new QFilter[]{allocbillnoQF});
                if (allocbill.isEmpty()) {
                    return;
                }
                Long billId = ((DynamicObject)allocbill.get(0)).getLong("id");
                BaseShowParameter bsp = new BaseShowParameter();
                bsp.setFormId(formId);
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setPkId((Object)billId);
                bsp.setStatus(OperationStatus.VIEW);
                bsp.setBillStatusValue(Integer.valueOf(BillOperationStatus.VIEW.getValue()));
                rptList.getView().showForm((FormShowParameter)bsp);
            }
        });
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("org".equals(propertyName)) {
            this.getModel().setValue("mulbizorg", null);
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "mulbizorg", "multargetbill", "startdate", "enddate"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u5185\u5bb9\u3002", (String)"CollectionQuantityVarianceRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void afterQuery(ReportQueryParam queryParam) {
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CollectionQuantityVarianceRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u6570\u91cf\u5dee\u5f02\u8868", (String)"CollectionQuantityVarianceRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_collectquantityvarrpt", (String)this.getView().getFormShowParameter().getAppId());
        this.getModel().setValue("ishyperlink", (Object)Boolean.FALSE);
    }
}

