/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.WriteLogUtils;

public class CostUpdateRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private Log logger = LogFactory.getLog(CostUpdateRptPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit billno = (BasedataEdit)this.getControl("billno");
        billno.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObject targCostType = this.getModel().getDataEntity().getDynamicObject("targetcosttype");
            DynamicObject srcCostType = this.getModel().getDataEntity().getDynamicObject("srccosttype");
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            if (srcCostType != null && srcCostType.getLong("id") != 0L) {
                filters.add(new QFilter("srccosttype", "=", srcCostType.getPkValue()));
            }
            if (targCostType != null && targCostType.getLong("id") != 0L) {
                filters.add(new QFilter("targetcosttype", "=", targCostType.getPkValue()));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit targetCostType = (BasedataEdit)this.getControl("targetcosttype");
        targetCostType.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            filterParameter.getQFilters().add(CostTypeHelper.getScaCostType());
        });
        BasedataEdit srcCostType = (BasedataEdit)this.getControl("srccosttype");
        srcCostType.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            filterParameter.getQFilters().add(CostTypeHelper.getScaCostType());
        });
        BasedataEdit mat = (BasedataEdit)this.getControl("querymaterial");
        mat.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
        });
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("billno");
        if (costType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u66f4\u65b0\u7533\u8bf7\u5355\u5355\u53f7", (String)"CostUpdateRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        try {
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2", (String)"CostUpdateRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u67e5\u8be2", (String)"CostUpdateRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]), (String)"cad_costupdatequeryrpt", (IDataModel)this.getModel());
        }
        catch (Exception e) {
            this.logger.error("+++++\u6210\u672c\u66f4\u65b0\u67e5\u8be2\u62a5\u8868\u5199\u64cd\u4f5c\u65e5\u5fd7\u9519\u8bef" + e.getMessage());
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "targetcosttype": {
                this.updateCurrency();
                break;
            }
            case "billno": {
                this.initQueryBanel();
            }
        }
    }

    private void updateCurrency() {
        DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("targetcosttype");
        DynamicObject currency = Optional.ofNullable(costType).map(s -> s.getDynamicObject("currency")).orElse(null);
        this.getModel().setValue("currency", (Object)currency);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateCurrency();
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }

    private void initQueryBanel() {
        DynamicObject billno = this.getModel().getDataEntity().getDynamicObject("billno");
        if (billno == null) {
            this.getModel().setValue("targetcosttype", null);
            this.getModel().setValue("srccosttype", null);
            this.getModel().setValue("updatetime", (Object)new Date());
        } else {
            DynamicObject updatebillinfo = BusinessDataServiceHelper.loadSingle((Object)billno.getPkValue(), (String)"cad_costupdatenew");
            this.getModel().setValue("targetcosttype", (Object)updatebillinfo.getDynamicObject("targetcosttype"));
            this.getModel().setValue("srccosttype", (Object)updatebillinfo.getDynamicObject("srccosttype"));
            this.getModel().setValue("updatetime", (Object)updatebillinfo.getDate("updatetime"));
        }
    }
}

