/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class FinalStdAnalysisRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mullot", "calcrecord_a", "calcrecord_b"});
        BasedataEdit costType_A = (BasedataEdit)this.getControl("costtype_a");
        costType_A.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView());
            filter.and("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
            }
            filterParameter.setFilter(filter);
        });
        BasedataEdit costType_B = (BasedataEdit)this.getControl("costtype_b");
        costType_B.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView());
            filter.and("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
            }
            filterParameter.setFilter(filter);
        });
        BasedataEdit mat = (BasedataEdit)this.getControl("querymat");
        mat.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            DynamicObject ct = this.getModel().getDataEntity().getDynamicObject("costtype_a");
            DynamicObject matVer = this.getModel().getDataEntity().getDynamicObject("querymatvers");
            List filters = ElementRelationHelper.getMatFiltersBy((DynamicObject)ct, (DynamicObject)matVer);
            filterParameter.setQFilters(filters);
        });
        BasedataEdit matVer = (BasedataEdit)this.getControl("querymatvers");
        matVer.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject material = this.getModel().getDataEntity().getDynamicObject("querymat");
            if (material != null) {
                filters.add(new QFilter("material", "=", material.getPkValue()));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            DynamicObject dyCostType = (DynamicObject)this.getModel().getValue("costtype_a");
            if (dyCostType == null) {
                evt.setCancel(true);
                return;
            }
            filterParameter.getQFilters().add(new QFilter("isadjustperiod", "=", (Object)false));
            filterParameter.getQFilters().add(CostUpdateHelper.getRptPeriodQFilter((Long)dyCostType.getLong("id")));
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype_a");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"FinalStdAnalysisRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"FinalStdAnalysisRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype_a");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"FinalStdAnalysisRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit products = (BasedataEdit)this.getControl("mulgroupmaterial");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype_a");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"FinalStdAnalysisRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(costtype.getLong("createorg.id"));
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (!CollectionUtils.isEmpty((Collection)mulmaterialGroup) || materialgrpstd != null && materialGroupStandard.getLong("id") != 730148448254487552L) {
                QFilter classifiedMaterialIdFilter = InFilterHelper.getQFilterByBachSize((String)"id", new ArrayList(MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulmaterialGroup, (boolean)false, (DynamicObject)materialGroupStandard)), (String)"in", (int)20000);
                qFilters.add(classifiedMaterialIdFilter);
            }
        });
        BasedataEdit configuredCodeEdit = (BasedataEdit)this.getControl("mulconfiguredcode");
        configuredCodeEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject matObj = (DynamicObject)this.getModel().getValue("querymat");
            if (matObj != null) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                List configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(matObj.getLong("id")));
                if (!CadEmptyUtils.isEmpty((List)configCodeIds)) {
                    qFilters.add(new QFilter("id", "in", (Object)configCodeIds));
                }
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String key = textEdit.getKey();
            if ("mullot".equalsIgnoreCase(key)) {
                this.showStoragebillnos(key);
            } else if ("calcrecord_a".equalsIgnoreCase(key) || "calcrecord_b".equalsIgnoreCase(key)) {
                this.showSelectPage(key);
            }
        }
    }

    private void showSelectPage(String actionId) {
        DynamicObject costtype;
        Long costTypeId = 0L;
        if ("calcrecord_a".equalsIgnoreCase(actionId)) {
            costtype = this.getModel().getDataEntity().getDynamicObject("costtype_a");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"FinalStdAnalysisRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                return;
            }
            costTypeId = costtype.getLong("id");
        }
        if ("calcrecord_b".equalsIgnoreCase(actionId)) {
            costtype = this.getModel().getDataEntity().getDynamicObject("costtype_a");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6bd4\u8f83\u6210\u672c\u7c7b\u578b\u3002", (String)"FinalStdAnalysisRptPlugin_12", (String)"macc-cad-report", (Object[])new Object[0]));
                return;
            }
            costTypeId = costtype.getLong("id");
        }
        ArrayList mulmaterial = Lists.newArrayList();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_stdcalcrecord_text");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costTypeId", (Object)costTypeId);
        fsp.setCustomParam("materialIds", (Object)mulmaterial);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        fsp.setCaption(ResManager.loadKDString((String)"\u5377\u7b97\u6863\u6848", (String)"FinalStdAnalysisRptPlugin_13", (String)"macc-cad-report", (Object[])new Object[0]));
        this.getView().showForm(fsp);
    }

    private void showStoragebillnos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sca_billnos");
        parameter.setCaption(ResManager.loadKDString((String)"\u6279\u53f7", (String)"FinalStdAnalysisRptPlugin_14", (String)"macc-cad-report", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        } else if (returnDataObj instanceof String) {
            String value = (String)returnDataObj;
            this.getModel().setValue(actionId, (Object)value);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject materialgrpstd;
        String fromType = (String)this.getView().getFormShowParameter().getCustomParam("fromType");
        DynamicObject costType_a = this.getModel().getDataEntity().getDynamicObject("costtype_a");
        if (costType_a == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u201c\u6210\u672c\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinalStdAnalysisRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costType_b = this.getModel().getDataEntity().getDynamicObject("costtype_b");
        if (costType_b == null) {
            if (!"calc".equals(fromType) || "0".equals(this.getPageCache().get("isAutoOpen"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u201c\u6bd4\u8f83\u6210\u672c\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinalStdAnalysisRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
            } else {
                this.getPageCache().put("isAutoOpen", "0");
            }
            return false;
        }
        if (fromType == null && (materialgrpstd = this.getModel().getDataEntity().getDynamicObject("materialgrpstd")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"FinalStdAnalysisRptPlugin_11", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        if (costType_b.getLong("currency.id") != costType_a.getLong("currency.id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u67e5\u8be2\u3002", (String)"FinalStdAnalysisRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        if (CostTypePtyEnum.CALCULATING.getValue().equals(costType_a.getString("type")) || CostTypePtyEnum.CALCULATING.getValue().equals(costType_b.getString("type"))) {
            Long costTypeAId = costType_a.getLong("id");
            Long costTypeBId = costType_b.getLong("id");
            Boolean isUpdateByPeriodA = CostUpdateHelper.isUpdateByPeriod((Long)costTypeAId);
            Boolean isUpdateByPeriodB = CostUpdateHelper.isUpdateByPeriod((Long)costTypeBId);
            Boolean isUpdateByPeriod = isUpdateByPeriodA != false && isUpdateByPeriodB != false;
            if (Boolean.TRUE.equals(isUpdateByPeriod) && this.getModel().getValue("queryperiod") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u67e5\u8be2\u671f\u95f4\u201d\u3002", (String)"FinalStdAnalysisRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
            if (Boolean.FALSE.equals(isUpdateByPeriod) && this.getModel().getValue("querydate") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u67e5\u8be2\u65e5\u671f\u201d\u3002", (String)"FinalStdAnalysisRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.dealQueryPeriod();
        Object materialgrpstd = this.getModel().getValue("materialgrpstd");
        if (materialgrpstd == null) {
            materialgrpstd = BusinessDataServiceHelper.loadSingleFromCache((Object)730148448254487552L, (String)"bd_materialgroupstandard");
            this.getModel().setValue("materialgrpstd", materialgrpstd);
            this.getView().updateView("materialgrpstd");
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (this.isUnique()) {
            Set trackNumberIds;
            Set configuredCodeIds;
            Set materialIds;
            if (fsp.getCustomParam("matIds") != null && !CadEmptyUtils.isEmpty((Set)(materialIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("matIds")), Set.class)))) {
                this.getModel().setValue("querymat", materialIds.iterator().next());
            }
            if (fsp.getCustomParam("configuredCodeIds") != null && !CadEmptyUtils.isEmpty((Set)(configuredCodeIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("configuredCodeIds")), Set.class)))) {
                this.getModel().setValue("mulconfiguredcode", (Object)configuredCodeIds.toArray());
            }
            if (fsp.getCustomParam("trackNumberIds") != null && !CadEmptyUtils.isEmpty((Set)(trackNumberIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("trackNumberIds")), Set.class)))) {
                this.getModel().setValue("multracknumber", (Object)trackNumberIds.toArray());
            }
        }
        if (fsp.getCustomParam("calcrecord") != null) {
            String calcRecord = (String)fsp.getCustomParam("calcrecord");
            this.getModel().setValue("calcrecord_a", (Object)calcRecord);
        }
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulconfiguredcode", "multracknumber"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "querymatvers": {
                DynamicObject version = (DynamicObject)newValue;
                DynamicObject mat = Optional.ofNullable(version).map(s -> s.getDynamicObject("material")).orElse(null);
                this.getModel().setValue("querymat", (Object)mat);
                break;
            }
            case "costtype_a": {
                this.dealQueryPeriod();
                this.getModel().setValue("calcrecord_a", null);
                break;
            }
            case "costtype_b": {
                this.dealQueryPeriod();
                this.getModel().setValue("calcrecord_b", null);
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
            case "showgroup": {
                Boolean showgroup = (Boolean)this.getModel().getValue("showgroup");
                if (!showgroup.booleanValue()) break;
                this.getModel().setValue("issubmaterial", (Object)true);
                break;
            }
            case "issubmaterial": {
                Boolean isdetail = (Boolean)this.getModel().getValue("issubmaterial");
                if (isdetail.booleanValue()) break;
                this.getModel().setValue("showgroup", (Object)false);
                break;
            }
            case "mulgroupmaterial": {
                DynamicObjectCollection mulmaterials = this.getModel().getDataEntity().getDynamicObjectCollection("mulgroupmaterial");
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterials)) break;
                this.getModel().setValue("mulconfiguredcode", null);
                this.getModel().setValue("multracknumber", null);
                break;
            }
            case "querymat": {
                Object querymat = this.getModel().getDataEntity().get("querymat");
                if (querymat != null) break;
                this.getModel().setValue("mulconfiguredcode", null);
                this.getModel().setValue("multracknumber", null);
                break;
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        List<String> hdieDetailFields = Arrays.asList("matresnumber", "matresname", "submatvers", "subauxprop", "subconfiguredcode", "subtracknumber", "subproject", "sublot", "subdatatype", "material_a", "matname_a", "matvers_a", "auxprop_a", "datatype_a", "resource_a", "resourcename_a", "qty_a", "price_a", "matresnumber_a", "matresname_a", "material_b", "matname_b", "matvers_b", "auxprop_b", "datatype_b", "resource_b", "resourcename_b", "qty_b", "price_b", "matresnumber_b", "matresname_b", "diffqty", "materialgroup", "materialgroupname");
        List<String> grouphdieDetailFields = Arrays.asList("matresnumber", "matresname", "submatvers", "subauxprop", "subconfiguredcode", "subtracknumber", "subproject", "sublot", "subdatatype", "material_a", "matname_a", "matvers_a", "auxprop_a", "datatype_a", "resource_a", "resourcename_a", "qty_a", "price_a", "matresnumber_a", "matresname_a", "material_b", "matname_b", "matvers_b", "auxprop_b", "datatype_b", "resource_b", "resourcename_b", "qty_b", "price_b", "matresnumber_b", "matresname_b", "diffqty", "qty_a", "qty_b", "diffqty", "price_a", "price_b");
        boolean isDetail = this.getModel().getDataEntity().getBoolean("issubmaterial");
        boolean showgroup = this.getModel().getDataEntity().getBoolean("showgroup");
        while (it.hasNext()) {
            ReportColumn reportColumn = null;
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                reportColumn = (ReportColumn)obj;
                String key = reportColumn.getFieldKey();
                if (!isDetail && hdieDetailFields.contains(key)) {
                    it.remove();
                    continue;
                }
                if (!showgroup || !grouphdieDetailFields.contains(key)) continue;
                it.remove();
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            if (!isDetail && ResManager.loadKDString((String)"\u5dee\u5f02", (String)"FinalStdAnalysisRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]).equals(reportColumnGroup.getCaption().toString())) {
                reportColumnGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u5dee\u5f02", (String)"FinalStdAnalysisRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0])));
            }
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn cloun = (ReportColumn)column;
                if (!isDetail && hdieDetailFields.contains(cloun.getFieldKey())) {
                    cloun.setHide(true);
                    continue;
                }
                if (!showgroup || !grouphdieDetailFields.contains(cloun.getFieldKey())) continue;
                cloun.setHide(true);
            }
        }
        super.afterCreateColumn(e);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"FinalStdAnalysisRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"FinalStdAnalysisRptPlugin_15", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_finalstdanalysisrpt", (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }

    private void dealQueryPeriod() {
        DynamicObject costTypeA = (DynamicObject)this.getModel().getValue("costtype_a");
        DynamicObject costTypeB = (DynamicObject)this.getModel().getValue("costtype_b");
        boolean isSimulatedA = costTypeA == null || CostTypePtyEnum.SIMULATED.getValue().equals(costTypeA.getString("type"));
        boolean isSimulatedB = costTypeB == null || CostTypePtyEnum.SIMULATED.getValue().equals(costTypeB.getString("type"));
        this.getView().setVisible(Boolean.valueOf(isSimulatedA), new String[]{"calcrecord_a"});
        this.getView().setVisible(Boolean.valueOf(isSimulatedB), new String[]{"calcrecord_b"});
        if (costTypeA == null || costTypeB == null) {
            this.setQueryVisible(Boolean.FALSE, Boolean.FALSE, null);
            return;
        }
        if (isSimulatedA && isSimulatedB) {
            this.setQueryVisible(Boolean.FALSE, Boolean.FALSE, null);
            return;
        }
        Long costTypeAId = costTypeA.getLong("id");
        Long costTypeBId = costTypeB.getLong("id");
        Boolean isUpdateByPeriodA = CostUpdateHelper.isUpdateByPeriod((Long)costTypeAId);
        Boolean isUpdateByPeriodB = CostUpdateHelper.isUpdateByPeriod((Long)costTypeBId);
        Boolean isUpdateByPeriod = isUpdateByPeriodA != false && isUpdateByPeriodB != false;
        this.setQueryVisible(isUpdateByPeriod == false, isUpdateByPeriod, costTypeAId);
    }

    private void setQueryVisible(Boolean isDateShow, Boolean isPeriodShow, Long costTypeId) {
        this.getView().setVisible(isPeriodShow, new String[]{"queryperiod"});
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.setMustInput(isPeriodShow.booleanValue());
        if (Boolean.TRUE.equals(isPeriodShow)) {
            List periodIds = CostUpdateHelper.getPeriodIds((Long)costTypeId);
            this.getModel().setValue("queryperiod", periodIds.isEmpty() ? null : periodIds.get(0));
        } else {
            this.getModel().setValue("queryperiod", null);
        }
        this.getView().setVisible(isDateShow, new String[]{"querydate"});
        DateTimeEdit queryDate = (DateTimeEdit)this.getControl("querydate");
        queryDate.setMustInput(isDateShow.booleanValue());
        this.getModel().setValue("querydate", (Object)(Boolean.TRUE.equals(isDateShow) ? TimeServiceHelper.now() : null));
    }

    private boolean isUnique() {
        Set trackNumberIds;
        Set configuredCodeIds;
        Set materialIds;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (fsp.getCustomParam("matIds") != null && !CadEmptyUtils.isEmpty((Set)(materialIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("matIds")), Set.class))) && materialIds.size() > 1) {
            return false;
        }
        if (fsp.getCustomParam("configuredCodeIds") != null && !CadEmptyUtils.isEmpty((Set)(configuredCodeIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("configuredCodeIds")), Set.class))) && configuredCodeIds.size() > 1) {
            return false;
        }
        return fsp.getCustomParam("trackNumberIds") == null || CadEmptyUtils.isEmpty((Set)(trackNumberIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("trackNumberIds")), Set.class))) || trackNumberIds.size() <= 1;
    }
}

