/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class InnerDistributionRptPlugin
extends AbstractReportFormPlugin {
    private static final String[] divideDetailStr = new String[]{"costobject", "costobjectname", "material", "materialname", "auxpty"};
    private static final String[] clearStrArr = new String[]{"period", "manuorgnum", "manuorgname", "benefcostcenter", "costcentername", "element", "subelement", "subelementname", "expenseitem", "billno"};

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String appId = this.getView().getFormShowParameter().getAppId();
        filterInfo.addFilterItem("appnum", (Object)appId, "=");
        queryParam.setFilter(filterInfo);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountOrgBase = (BasedataEdit)this.getControl("accountorg");
        accountOrgBase.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
            filters.add(orgIdsFilter);
        });
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"InnerDistributionRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEnableQfilterByOrg((Long)Long.valueOf(accountorg.getPkValue().toString()), null, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"InnerDistributionRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
        });
        BasedataEdit beginperiod = (BasedataEdit)this.getControl("beginperiod");
        this.getaVoid(beginperiod);
        BasedataEdit endperiod = (BasedataEdit)this.getControl("endperiod");
        this.getaVoid(endperiod);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"InnerDistributionRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("manuorg");
            List manuOrgList = dynamicObjects.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
            QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
            qFilters.add(costCenterIdFilter);
            qFilters.add(new QFilter("orgduty", "=", (Object)4L));
        });
        BasedataEdit subelement = (BasedataEdit)this.getControl("fsubelement");
        subelement.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection element = (DynamicObjectCollection)this.getModel().getValue("felement");
            if (element != null && element.size() > 0) {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                Set collect = element.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toSet());
                QFilter elementQf = new QFilter("element", "in", collect);
                DynamicObjectCollection subelements = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{elementQf});
                Set collect1 = subelements.stream().map(o -> o.getLong("subelement")).collect(Collectors.toSet());
                qFilters.add(new QFilter("id", "in", collect1));
            }
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                ReportList rptList = (ReportList)e.getSource();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                String fieldName = e.getFieldName();
                String formId = "";
                String billNo = row.getString(fieldName);
                if (!"billno".equals(fieldName)) {
                    return;
                }
                formId = "cad_mfgfeeallocco";
                if (CadEmptyUtils.isEmpty((String)billNo)) {
                    return;
                }
                DynamicObject org = (DynamicObject)InnerDistributionRptPlugin.this.getModel().getDataEntity().get("accountorg");
                DynamicObject costAccount = (DynamicObject)InnerDistributionRptPlugin.this.getModel().getDataEntity().get("costaccount");
                String appId = InnerDistributionRptPlugin.this.getView().getFormShowParameter().getAppId();
                QFilter orgQF = new QFilter("org", "=", (Object)org.getLong("id"));
                orgQF.and("costaccount", "=", (Object)costAccount.getLong("id"));
                orgQF.and("appnum", "=", (Object)appId);
                QFilter allocBillNoQFilter = new QFilter("billno", "=", (Object)billNo);
                DynamicObject allocBill = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])new QFilter[]{allocBillNoQFilter, orgQF});
                if (allocBill == null) {
                    return;
                }
                Long billId = allocBill.getLong("id");
                BaseShowParameter bsp = new BaseShowParameter();
                bsp.setFormId(formId);
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setPkId((Object)billId);
                bsp.setBillStatusValue(Integer.valueOf(BillOperationStatus.VIEW.getValue()));
                bsp.setStatus(OperationStatus.VIEW);
                bsp.setCustomParam("viewOnly", (Object)"view");
                rptList.getView().showForm((FormShowParameter)bsp);
            }
        });
    }

    private void getaVoid(BasedataEdit beginperiod) {
        beginperiod.addBeforeF7SelectListener(evt -> {
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("accountorg");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InnerDistributionRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"InnerDistributionRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter usePeriodFilter = this.getUsePeriodFilter(Long.valueOf(String.valueOf(accountOrg.getPkValue())), Long.valueOf(String.valueOf(costAccount.getPkValue())));
            filterParameter.getQFilters().add(usePeriodFilter);
            filterParameter.getQFilters().add(new QFilter("isadjustperiod", "=", (Object)false));
        });
    }

    public void afterBindData(EventObject e) {
        Long accountorg;
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("accountorg");
        Long l = accountorg = org == null ? null : (Long)org.getPkValue();
        if (accountorg == null) {
            accountorg = RequestContext.get().getOrgId();
            if (!this.getHasPermAccountOrg(accountorg)) {
                return;
            }
            if (OrgUnitServiceHelper.checkOrgFunction((Long)accountorg, (String)"10")) {
                this.getModel().setValue("accountorg", (Object)accountorg);
                this.getView().updateView("accountorg");
            }
            this.changeAccountOrg(accountorg);
        } else {
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
            boolean isMulFactory = CostAccountHelper.isEnableMulFactory(costaccount == null ? null : (Long)costaccount.getPkValue());
            this.getView().setVisible(Boolean.valueOf(isMulFactory), new String[]{"manuorg"});
        }
    }

    private void changeAccountOrg(Long accountorg) {
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("beginperiod", null);
        this.getModel().setValue("endperiod", null);
        if (accountorg != null) {
            Long costaccountId = this.getCostAccountByAccoutOrg(accountorg);
            this.getModel().setValue("costaccount", (Object)(costaccountId == null ? null : costaccountId));
            this.changeCostaccout(costaccountId);
            this.getView().updateView("costaccount");
        }
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter[] filters;
        DynamicObjectCollection result;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        if ((result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])(filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF = new QFilter("appnum", "=", (Object)appId)}), null)) == null || result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return null;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        String tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"InnerDistributionRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("accountorg", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"InnerDistributionRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("costaccount", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u671f\u95f4\u3002", (String)"InnerDistributionRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("beginperiod", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ed3\u675f\u671f\u95f4\u3002", (String)"InnerDistributionRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("endperiod", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6210\u672c\u8d26\u7c3f\u662f\u5426\u5173\u8054\u5e01\u79cd\u3002", (String)"InnerDistributionRptPlugin_8", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("currency", tips)) {
            return false;
        }
        DynamicObject beginperiod = (DynamicObject)this.getModel().getValue("beginperiod");
        DynamicObject endperiod = (DynamicObject)this.getModel().getValue("endperiod");
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("entityId", (Object)this.getBillEntityId());
        return this.changePeriod(beginperiod, endperiod);
    }

    private boolean checkFileNameisNull(String fileName, String tips) {
        if (this.getModel().getValue(fileName) == null) {
            this.getView().showTipNotification(tips);
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "costaccount": {
                this.getModel().setValue("manuorg", null);
                this.changeCostaccout((DynamicObject)newValue);
                break;
            }
            case "accountorg": {
                Long accountorgId = newValue == null ? null : (Long)((DynamicObject)newValue).getPkValue();
                this.getModel().setValue("manuorg", null);
                this.changeAccountOrg(accountorgId);
                break;
            }
            case "beginperiod": {
                DynamicObject endperiod = (DynamicObject)this.getModel().getValue("endperiod");
                DynamicObject beginperiod = (DynamicObject)newValue;
                this.changePeriod(beginperiod, endperiod);
                break;
            }
            case "endperiod": {
                DynamicObject beginperiodlate = (DynamicObject)this.getModel().getValue("beginperiod");
                DynamicObject endperiodlate = (DynamicObject)newValue;
                this.changePeriod(beginperiodlate, endperiodlate);
                break;
            }
            case "fsubelement": {
                DynamicObjectCollection felement;
                if (newValue == null || CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)newValue)) || !CollectionUtils.isEmpty((Collection)(felement = (DynamicObjectCollection)this.getModel().getValue("felement")))) break;
                DynamicObjectCollection subelement = (DynamicObjectCollection)newValue;
                List collect = subelement.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList());
                QFilter subElementIdFilter = new QFilter("subelement", "in", collect);
                DynamicObjectCollection elementAndSubelements = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{subElementIdFilter});
                List collect1 = elementAndSubelements.stream().map(o -> o.getLong("element")).collect(Collectors.toList());
                this.getModel().beginInit();
                this.getModel().setValue("felement", (Object)collect1.toArray());
                this.getModel().endInit();
                this.getView().updateView("felement");
                break;
            }
            case "felement": {
                this.getModel().beginInit();
                this.getModel().setValue("fsubelement", null);
                this.getModel().endInit();
                this.getView().updateView("fsubelement");
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        List<String> divideDetailHideFiles = Arrays.asList(divideDetailStr);
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("accountorg");
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            hiddenColumns.add("productgroup");
        }
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory(costaccount == null ? null : (Long)costaccount.getPkValue());
        Boolean isMergeBill = SysParamHelper.isMergeBill((Long)(accountOrg == null ? null : Long.valueOf(accountOrg.getLong("id"))), (Long)(costaccount == null ? null : Long.valueOf(costaccount.getLong("id"))), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        Boolean isDivideDetail = this.getModel().getDataEntity().getBoolean("dividedetail");
        Boolean sumByPeriod = this.getModel().getDataEntity().getBoolean("sumbyperiod");
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                String key = reportColumn.getFieldKey();
                if (!isDivideDetail.booleanValue() && divideDetailHideFiles.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (sumByPeriod.booleanValue() && ("period".equals(key) || "expenseitem".equals(key) || "expenseitemname".equals(key) || "billno".equals(key))) {
                    reportColumn.setHide(true);
                }
                if (!isMulFactory && ("manuorgnum".equals(key) || "manuorgname".equals(key))) {
                    reportColumn.setHide(true);
                }
                if (hiddenColumns.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!isMergeBill.booleanValue() || !key.startsWith("expenseitem")) continue;
                reportColumn.setHide(true);
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (!isDivideDetail.booleanValue() && divideDetailHideFiles.contains(key)) {
                    col.setHide(true);
                }
                if (sumByPeriod.booleanValue() && "period".equals(key)) {
                    col.setHide(true);
                }
                if (!isMulFactory && ("manuorgnum".equals(key) || "manuorgname".equals(key))) {
                    col.setHide(true);
                }
                if (!hiddenColumns.contains(key)) continue;
                col.setHide(true);
            }
        }
        this.getView().updateView("reportlistap");
    }

    private Boolean changePeriod(DynamicObject beginperiod, DynamicObject endperiod) {
        if (beginperiod != null && endperiod != null && !beginperiod.getPkValue().equals(endperiod.getPkValue())) {
            Date begindate = beginperiod.getDate("begindate");
            Date enddate = beginperiod.getDate("enddate");
            Date begindatelate = endperiod.getDate("begindate");
            Date enddatelate = endperiod.getDate("enddate");
            if (begindate == null || begindatelate == null || enddate == null || enddatelate == null || begindate.compareTo(begindatelate) > 0 || enddate.compareTo(enddatelate) > 0) {
                this.getModel().beginInit();
                this.getModel().setValue("endperiod", beginperiod.getPkValue());
                this.getView().updateView("endperiod");
                this.getModel().endInit();
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private void changeCostaccout(Long costaccountId) {
        this.getModel().setValue("currency", null);
        this.getModel().setValue("beginperiod", null);
        this.getModel().setValue("endperiod", null);
        if (costaccountId == null || costaccountId == 0L) {
            costaccountId = null;
        }
        this.setCurrency();
        this.setPeriod();
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory((Long)costaccountId);
        this.getView().setVisible(Boolean.valueOf(isMulFactory), new String[]{"manuorg"});
    }

    private void changeCostaccout(DynamicObject costaccount) {
        Long costaccountId = costaccount == null ? Long.valueOf(0L) : (Long)costaccount.getPkValue();
        this.changeCostaccout(costaccountId);
    }

    protected void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("accountorg");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("beginperiod", (Object)currentperiod);
            this.getModel().setValue("endperiod", (Object)currentperiod);
            this.getView().updateView("beginperiod");
            this.getView().updateView("endperiod");
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Object currency = this.getModel().getValue("currency");
        Boolean onlyundivide = (Boolean)this.getModel().getValue("onlyundivide");
        Boolean sumbyperiod = (Boolean)this.getModel().getValue("sumbyperiod");
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory(costaccount == null ? null : (Long)costaccount.getPkValue());
        Boolean flagClear = Boolean.TRUE;
        Boolean mergesame = (Boolean)this.getModel().getValue("mergesame");
        for (DynamicObject rowDatum : rowData) {
            String sunhand;
            flagClear = Boolean.TRUE;
            BigDecimal fileValue = rowDatum.getBigDecimal("sumamount");
            BigDecimal allocamt = rowDatum.getBigDecimal("allocamt");
            BigDecimal unocamt = rowDatum.getBigDecimal("unocamt");
            if (fileValue != null && fileValue.compareTo(BigDecimal.ZERO) != 0) {
                flagClear = Boolean.FALSE;
            }
            if (mergesame.booleanValue() && flagClear.booleanValue()) {
                for (String clearFile : clearStrArr) {
                    rowDatum.set(clearFile, null);
                }
            }
            rowDatum.set("currencyfield", currency);
            if (!this.isNullOrZero(fileValue).booleanValue() && this.isNullOrZero(allocamt).booleanValue() && this.isNullOrZero(unocamt).booleanValue()) {
                rowDatum.set("unocamt", (Object)fileValue);
            }
            if ((sunhand = rowDatum.getString("sunhand")) != null) {
                switch (sunhand) {
                    case "A": {
                        if (onlyundivide.booleanValue()) break;
                        if (!sumbyperiod.booleanValue()) {
                            rowDatum.set("benefcostcenter", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"InnerDistributionRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                            rowDatum.set("costcentername", null);
                            break;
                        }
                        rowDatum.set("subelement", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"InnerDistributionRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                        break;
                    }
                    case "B": {
                        if (sumbyperiod.booleanValue()) {
                            if (isMulFactory) {
                                rowDatum.set("manuorgnum", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"InnerDistributionRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                                break;
                            }
                            rowDatum.set("benefcostcenter", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"InnerDistributionRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                            break;
                        }
                        rowDatum.set("period", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"InnerDistributionRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                        break;
                    }
                    case "C": {
                        if (sumbyperiod.booleanValue()) {
                            if (isMulFactory) {
                                rowDatum.set("manuorgnum", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InnerDistributionRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]));
                                break;
                            }
                            rowDatum.set("benefcostcenter", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InnerDistributionRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]));
                            break;
                        }
                        rowDatum.set("period", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InnerDistributionRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    private Boolean isNullOrZero(BigDecimal value) {
        if (value == null || BigDecimal.ZERO.compareTo(value) == 0 || "0E-10".equals(value.toString())) {
            return true;
        }
        return false;
    }

    private boolean getHasPermAccountOrg(Long orgId) {
        String entityid = this.getView().getEntityId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getView().getFormShowParameter().getAppId(), (String)entityid, (String)"47150e89000000ac");
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        return rs.getHasPermOrgs().contains(orgId);
    }

    private QFilter getUsePeriodFilter(Long orgId, Long costAccountId) {
        QFilter result = new QFilter("periodtype", ">", (Object)0L);
        QFilter periodfilter = new QFilter("org", "=", (Object)orgId);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costAccountId));
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            DynamicObject periodDO = (DynamicObject)cal_sysctrlentity.get(0);
            result = new QFilter("periodtype", "=", (Object)periodDO.getLong("periodtype"));
            if (periodDO.get("startperiod") != null) {
                result.and(new QFilter("id", ">=", (Object)periodDO.getLong("startperiod")));
            }
        }
        return result;
    }
}

