/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;

public class InputOutputRptPlugin
extends AbstractReportFormPlugin {
    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List orgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit accountorgInput = (BasedataEdit)this.getControl("accountorg");
        accountorgInput.addBeforeF7SelectListener(evt -> {
            List<QFilter> qFilters = this.getInputQFilters(evt);
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            qFilters.add(qfId);
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InputOutputRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)"cad_inputoutputrpt", (String)param.getAppId())));
        });
        BasedataEdit costcenterInput = (BasedataEdit)this.getControl("costcenter");
        costcenterInput.addBeforeF7SelectListener(evt -> {
            QFilter qf;
            List<QFilter> qFilters = this.getInputQFilters(evt);
            DynamicObject accountorg = this.getModel().getDataEntity().getDynamicObject("accountorg");
            if (accountorg == null) {
                qf = new QFilter("accountorg", "in", (Object)orgIds);
            } else {
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("manuorg");
                List manuOrgList = dynamicObjects.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
                qf = CostCenterHelper.getCostCenterByMultFactoryForList((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
            }
            qFilters.add(qf);
            qFilters.add(new QFilter("orgduty.number", "=", (Object)"4"));
        });
        BasedataEdit costobjectInput = (BasedataEdit)this.getControl("costobject");
        costobjectInput.addBeforeF7SelectListener(evt -> {
            List<QFilter> qFilters = this.getInputQFilters(evt);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject costcenter = dataEntity.getDynamicObject("costcenter");
            QFilter ccIdQF = null;
            if (costcenter == null) {
                DynamicObject accountorg = dataEntity.getDynamicObject("accountorg");
                List<Object> ccIdsList = new ArrayList();
                ccIdsList = accountorg == null ? this.getCostCenterIds(orgIds) : this.getCostCenterIds(accountorg.getLong("id"));
                ccIdQF = new QFilter("costcenter", "in", ccIdsList);
            } else {
                ccIdQF = new QFilter("costcenter", "=", (Object)costcenter.getLong("id"));
            }
            qFilters.add(ccIdQF);
        });
        BasedataEdit materialInput = (BasedataEdit)this.getControl("material");
        materialInput.addBeforeF7SelectListener(evt -> {
            List<QFilter> qFilters = this.getInputQFilters(evt);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            this.getModel().getDataEntity();
            List<Long> ccIdsList = null;
            QFilter ccIdQF = null;
            DynamicObject costobject = dataEntity.getDynamicObject("costobject");
            if (costobject == null) {
                DynamicObject costcenter = dataEntity.getDynamicObject("costcenter");
                if (costcenter == null) {
                    DynamicObject accountorg = dataEntity.getDynamicObject("accountorg");
                    ccIdsList = accountorg == null ? this.getCostCenterIds(orgIds) : this.getCostCenterIds(accountorg.getLong("id"));
                    ccIdQF = new QFilter("costcenter", "in", ccIdsList);
                } else {
                    ccIdQF = new QFilter("costcenter", "=", (Object)costcenter.getLong("id"));
                }
            } else {
                ccIdQF = new QFilter("id", "=", (Object)costobject.getLong("id"));
            }
            DynamicObjectCollection coDOC = QueryServiceHelper.query((String)"cad_costobject", (String)"material", (QFilter[])new QFilter[]{ccIdQF});
            ArrayList<Long> matIds = new ArrayList<Long>();
            for (DynamicObject coDO : coDOC) {
                matIds.add(coDO.getLong("material"));
            }
            QFilter coQF = new QFilter("id", "in", matIds);
            qFilters.add(coQF);
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                DynamicObject costobject;
                ReportList rptList = (ReportList)e.getSource();
                FilterInfo filterInfo = rptList.getReportModel().getReportQueryParam().getFilter();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                DynamicObject accountorg = filterInfo.getDynamicObject("accountorg");
                QFilter filter = new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNum((IFormView)InputOutputRptPlugin.this.getView()));
                filter.and(new QFilter("org", "=", (Object)accountorg.getLong("id")));
                String plannum = row.getString("plannum");
                if (!"".equals(plannum)) {
                    QFilter plannumQF = new QFilter("entryentity.plannedoutput.billno", "=", (Object)plannum);
                    filter.and(plannumQF);
                }
                if ((costobject = row.getDynamicObject("costobjectnum")) != null) {
                    QFilter costobjectQF = new QFilter("entryentity.costobject.id", "=", costobject.getPkValue());
                    filter.and(costobjectQF);
                }
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_factnedoutputbill", (QFilter[])new QFilter[]{filter}, (String)"", (int)-1);
                LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    linkQueryPkIdCollection.addLinkQueryPkId(iterator.next());
                }
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("cad_factnedoutputbill");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
                showParameter.setCustomParam("org", (Object)accountorg.getLong("id"));
                showParameter.setHasRight(false);
                showParameter.setCustomParam("source", (Object)"HyperLink");
                rptList.getView().showForm((FormShowParameter)showParameter);
            }
        });
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListShowParameter fParameter = (ListShowParameter)evt.getFormShowParameter();
        fParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
        ListFilterParameter filterParameter = fParameter.getListFilterParameter();
        return filterParameter.getQFilters();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        Long orgId = RequestContext.get().getOrgId();
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
        if (isAccounting) {
            model.setValue("accountorg", (Object)orgId);
            view.updateView("accountorg");
        }
        this.configManuOrg();
        boolean isshowdetail = (Boolean)model.getValue("isshowdetail");
        view.setVisible(Boolean.valueOf(isshowdetail), new String[]{"planneddate"});
    }

    private void configManuOrg() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("accountorg");
        if (org == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        } else {
            boolean enableMul = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
            if (!enableMul) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
                this.getModel().setValue("manuorg", null);
            }
        }
    }

    private List<Long> getCostCenterIds(Long orgId) {
        ArrayList<Long> sampleOrgId = new ArrayList<Long>();
        sampleOrgId.add(orgId);
        return this.getCostCenterIds(sampleOrgId);
    }

    private List<Long> getCostCenterIds(List<Long> orgIds) {
        QFilter qf = new QFilter("accountorg", "in", orgIds);
        DynamicObjectCollection ccDOC = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> ccIdsList = new ArrayList<Long>();
        for (DynamicObject ccDO : ccDOC) {
            ccIdsList.add(ccDO.getLong("id"));
        }
        return ccIdsList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        switch (e.getProperty().getName()) {
            case "isshowdetail": {
                boolean isON = (Boolean)newValue;
                view.setVisible(Boolean.valueOf(isON), new String[]{"planneddate"});
                if (isON) {
                    model.setValue("planneddate_startdate", (Object)new Date());
                    model.setValue("planneddate_enddate", (Object)new Date());
                    break;
                }
                model.setValue("planneddate_startdate", null);
                model.setValue("planneddate_enddate", null);
                break;
            }
            case "accountorg": {
                model.setValue("costcenter", null);
                this.configManuOrg();
                model.setValue("costobject", null);
                model.setValue("material", null);
                break;
            }
            case "costcenter": {
                model.setValue("costobject", null);
                model.setValue("material", null);
                break;
            }
            case "costobject": {
                model.setValue("material", null);
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        List<String> hideDetailFields = Arrays.asList("plannum", "closeingstatuses", "planneddates", "factneddates");
        List<String> freezeFields = Arrays.asList("seq", "accountorgnum", "accountorgname");
        ArrayList<String> hyperlinkFields = new ArrayList<String>();
        hyperlinkFields.add("totalinqty");
        boolean isShowDetail = this.getModel().getDataEntity().getBoolean("isshowdetail");
        while (it.hasNext()) {
            ReportColumn reportColumn = (ReportColumn)it.next();
            String key = reportColumn.getFieldKey();
            if (isShowDetail || !hideDetailFields.contains(key)) continue;
            it.remove();
        }
        for (AbstractReportColumn a : cols) {
            ReportColumn reportColumn = (ReportColumn)a;
            String key = reportColumn.getFieldKey();
            if (freezeFields.contains(key)) {
                reportColumn.setFreeze(true);
            }
            if (!isShowDetail || !hyperlinkFields.contains(key)) continue;
            reportColumn.setHyperlink(true);
        }
        this.getView().updateView("reportlistap");
        super.afterCreateColumn(e);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("appnum", (Object)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject accountorg = dataEntity.getDynamicObject("accountorg");
        if (accountorg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InputOutputRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.writeLog(ResManager.loadKDString((String)"\u67e5\u8be2", (String)"InputOutputRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6570\u636e", (String)"InputOutputRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
    }

    public void writeLog(String opName, String opDescriotion) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = InputOutputRptPlugin.buildLogInfo(opName, opDescriotion, AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    public static AppLogInfo buildLogInfo(String opName, String opDescription, String bizAppId, String bizEntityNumber) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(bizAppId);
        logInfo.setBizObjID(bizEntityNumber);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setClientName(RequestContext.get().getClient());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(opDescription);
        return logInfo;
    }

    public String getBizAppId() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_inputoutputrpt");
        return type.getAppId();
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }
}

