/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostBomHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.utils.WriteLogUtils;

public class MatCostBomRpt
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String PROP_COSTTYPE = "costtype";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costtype = (BasedataEdit)this.getControl(PROP_COSTTYPE);
        costtype.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView());
            filter.and("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
            }
            filterParameter.setFilter(filter);
        });
        this.addClickListeners(new String[]{"mullot"});
        BasedataEdit materials = (BasedataEdit)this.getControl("materials");
        materials.addBeforeF7SelectListener(evt -> {
            DynamicObject costType = this.getModel().getDataEntity().getDynamicObject(PROP_COSTTYPE);
            if (costType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"MatCostBomRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                Long costTypeId = costType.getLong("id");
                List qFilters = filterParameter.getQFilters();
                qFilters.add(CostBomHelper.getMaterialFilterByCostType((Long)costTypeId));
            }
        });
        BasedataEdit matVer = (BasedataEdit)this.getControl("version");
        matVer.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject material = this.getModel().getDataEntity().getDynamicObject("material");
            if (material != null) {
                filters.add(new QFilter("material", "=", material.getPkValue()));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            DynamicObject dyCostType = (DynamicObject)this.getModel().getValue(PROP_COSTTYPE);
            if (dyCostType == null) {
                evt.setCancel(true);
                return;
            }
            filterParameter.getQFilters().add(CostUpdateHelper.getRptPeriodQFilter((Long)dyCostType.getLong("id")));
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String key = textEdit.getKey();
            this.showStoragebillnos(key);
        }
    }

    private void showStoragebillnos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sca_billnos");
        parameter.setCaption(ResManager.loadKDString((String)"\u6279\u53f7", (String)"MatCostBomRpt_8", (String)"macc-cad-report", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterItemInfo auxPropFilterItem = queryParam.getFilter().getFilterItem("auxprop");
        if (this.getModel().getDataEntity().getDynamicObject("auxprop") != null) {
            DynamicObject auxProp = this.getModel().getDataEntity().getDynamicObject("auxprop");
            auxPropFilterItem.setValue(auxProp.getPkValue());
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"MatCostBomRpt_1", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u7269\u6599\u5168\u67e5\u6807\u51c6\u6210\u672c", (String)"MatCostBomRpt_2", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_matcostbom", (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject(PROP_COSTTYPE);
        DynamicObject material = this.getModel().getDataEntity().getDynamicObject("material");
        if (costtype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"MatCostBomRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("materials");
        if (materials == null || materials.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"MatCostBomRpt_3", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        if (material != null) {
            boolean isUseAuxpty = material.getBoolean("isuseauxpty");
            DynamicObject auxprop = this.getModel().getDataEntity().getDynamicObject("auxprop");
            if (isUseAuxpty && auxprop == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f85\u52a9\u5c5e\u6027\u3002", (String)"MatCostBomRpt_4", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
            boolean costIsUseVersion = !costtype.getBoolean("isuseversion");
            boolean matIsUseVersion = material.getBoolean("isenablematerialversion");
            DynamicObject version = this.getModel().getDataEntity().getDynamicObject("version");
            if (costIsUseVersion && matIsUseVersion && version == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7248\u672c\u3002", (String)"MatCostBomRpt_5", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
        }
        if (CostTypePtyEnum.CALCULATING.getValue().equals(costtype.getString("type"))) {
            Long costTypeId = costtype.getLong("id");
            Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)costTypeId);
            if (Boolean.TRUE.equals(isUpdateByPeriod) && this.getModel().getValue("queryperiod") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u67e5\u8be2\u671f\u95f4\u201d\u3002", (String)"MatCostBomRpt_6", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
            if (Boolean.FALSE.equals(isUpdateByPeriod) && this.getModel().getValue("date") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u67e5\u8be2\u65e5\u671f\u201d\u3002", (String)"MatCostBomRpt_7", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (e.getProperty().getName()) {
            case "costtype": {
                DynamicObject costType = dataEntity.getDynamicObject(PROP_COSTTYPE);
                BasedataEdit versionInput = (BasedataEdit)this.getView().getControl("version");
                if (costType != null) {
                    boolean isUseVersion = !costType.getBoolean("isuseversion");
                    this.getView().setEnable(Boolean.valueOf(isUseVersion), new String[]{"version"});
                    versionInput.setMustInput(isUseVersion);
                }
                if (costType == null || !costType.getBoolean("isuseversion")) {
                    versionInput.setMustInput(Boolean.FALSE.booleanValue());
                }
                this.getModel().setValue("version", null);
                this.dealQueryPeriod();
                break;
            }
            case "materials": {
                DynamicObjectCollection materials = dataEntity.getDynamicObjectCollection("materials");
                this.removeUseVerOrAuxptyMat(materials);
                break;
            }
            case "material": {
                DynamicObject material = dataEntity.getDynamicObject("material");
                if (material != null) {
                    this.getView().setEnable(Boolean.valueOf(material.getBoolean("isuseauxpty")), new String[]{"auxprop"});
                }
                if (material == null || !material.getBoolean("isuseauxpty")) {
                    this.getModel().setValue("auxprop", null);
                }
                DynamicObject costType1 = dataEntity.getDynamicObject(PROP_COSTTYPE);
                boolean isUseVersion = false;
                if (costType1 != null) {
                    boolean bl = isUseVersion = !costType1.getBoolean("isuseversion");
                }
                if (material != null) {
                    this.getView().setEnable(Boolean.valueOf(isUseVersion && material.getBoolean("isenablematerialversion")), new String[]{"version"});
                }
                if (material != null && isUseVersion && material.getBoolean("isenablematerialversion")) break;
                this.getModel().setValue("version", null);
            }
        }
    }

    private void removeUseVerOrAuxptyMat(DynamicObjectCollection materials) {
        Set<Long> materialIds = materials.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("masterid")).collect(Collectors.toSet());
        if (materials.size() == 1) {
            this.getModel().setValue("material", materialIds.iterator().next());
            return;
        }
        this.getModel().setValue("material", null);
        Set<Long> useVerOrAuxptyMatIds = this.getUseVerOrAuxptyMatIds(materialIds);
        HashSet<Long> useVerOrAuxptyMatIdSet = new HashSet<Long>();
        for (DynamicObject material : materials) {
            Long matId = material.getDynamicObject("fbasedataid").getLong("masterid");
            if (!useVerOrAuxptyMatIds.contains(matId)) continue;
            useVerOrAuxptyMatIdSet.add(matId);
        }
        materialIds.removeAll(useVerOrAuxptyMatIdSet);
        this.getModel().setValue("materials", (Object)materialIds.toArray());
        if (materialIds.size() == 1) {
            this.getModel().setValue("material", (Object)materialIds.iterator().next());
        }
    }

    private Set<Long> getUseVerOrAuxptyMatIds(Set<Long> materialIds) {
        DynamicObjectCollection mats = QueryServiceHelper.query((String)"bd_material", (String)"id, isenablematerialversion, isuseauxpty", (QFilter[])new QFilter("id", "in", materialIds).toArray());
        HashSet<Long> useVerOrAuxptyMatIds = new HashSet<Long>(16);
        for (DynamicObject mat : mats) {
            boolean isUseMatVer = mat.getBoolean("isenablematerialversion");
            boolean isUseAuxpty = mat.getBoolean("isuseauxpty");
            if (!isUseMatVer && !isUseAuxpty) continue;
            useVerOrAuxptyMatIds.add(mat.getLong("id"));
        }
        return useVerOrAuxptyMatIds;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"version"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"auxprop"});
        this.dealQueryPeriod();
    }

    private void dealQueryPeriod() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue(PROP_COSTTYPE);
        if (costType == null || CostTypePtyEnum.SIMULATED.getValue().equals(costType.getString("type"))) {
            this.setQueryVisible(Boolean.FALSE, Boolean.FALSE, null);
            return;
        }
        Long costTypeId = costType.getLong("id");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)costTypeId);
        this.setQueryVisible(isUpdateByPeriod == false, isUpdateByPeriod, costTypeId);
    }

    private void setQueryVisible(Boolean isDateShow, Boolean isPeriodShow, Long costTypeId) {
        this.getView().setVisible(isPeriodShow, new String[]{"queryperiod"});
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.setMustInput(isPeriodShow.booleanValue());
        if (Boolean.TRUE.equals(isPeriodShow)) {
            List periodIds = CostUpdateHelper.getPeriodIds((Long)costTypeId);
            this.getModel().setValue("queryperiod", periodIds.isEmpty() ? null : periodIds.get(0));
        } else {
            this.getModel().setValue("queryperiod", null);
        }
        this.getView().setVisible(isDateShow, new String[]{"date"});
        DateTimeEdit queryDate = (DateTimeEdit)this.getControl("date");
        queryDate.setMustInput(isDateShow.booleanValue());
        this.getModel().setValue("date", (Object)(Boolean.TRUE.equals(isDateShow) ? TimeServiceHelper.now() : null));
    }
}

