/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostBomHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.utils.WriteLogUtils;

public class MatStdCostUpRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String PROP_COSTTYPE = "costtype";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costtype = (BasedataEdit)this.getControl(PROP_COSTTYPE);
        costtype.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView());
            filter.and("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
            }
            filterParameter.setFilter(filter);
        });
        this.addClickListeners(new String[]{"mullot"});
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(evt -> {
            DynamicObject costType = this.getModel().getDataEntity().getDynamicObject(PROP_COSTTYPE);
            if (costType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"MatStdCostUpRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                Long costTypeId = costType.getLong("id");
                List qFilters = filterParameter.getQFilters();
                qFilters.add(CostBomHelper.getMaterialFilterByCostType((Long)costTypeId));
            }
        });
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            DynamicObject dyCostType = (DynamicObject)this.getModel().getValue(PROP_COSTTYPE);
            if (dyCostType == null) {
                evt.setCancel(true);
                return;
            }
            filterParameter.getQFilters().add(CostUpdateHelper.getRptPeriodQFilter((Long)dyCostType.getLong("id")));
        });
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject(PROP_COSTTYPE);
        if (costtype == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"MatStdCostUpRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("material");
        if (materials == null || materials.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599", (String)"MatStdCostUpRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        if (CostTypePtyEnum.CALCULATING.getValue().equals(costtype.getString("type"))) {
            Long costTypeId = costtype.getLong("id");
            Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)costTypeId);
            if (Boolean.TRUE.equals(isUpdateByPeriod) && this.getModel().getValue("queryperiod") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u67e5\u8be2\u671f\u95f4\u201d\u3002", (String)"MatStdCostUpRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
            if (Boolean.FALSE.equals(isUpdateByPeriod) && this.getModel().getValue("searchdate") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u67e5\u8be2\u65e5\u671f\u201d\u3002", (String)"MatStdCostUpRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String key = textEdit.getKey();
            this.showStoragebillnos(key);
        }
    }

    private void showStoragebillnos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sca_billnos");
        parameter.setCaption(ResManager.loadKDString((String)"\u6279\u53f7", (String)"MatStdCostUpRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCurrencyAndPeriod();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "costtype": {
                this.setCurrencyAndPeriod();
            }
        }
    }

    private void setCurrencyAndPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costType = dataEntity.getDynamicObject(PROP_COSTTYPE);
        this.getModel().setValue("currency", costType == null ? null : Long.valueOf(costType.getLong("currency.id")));
        this.getView().updateView("currency");
        if (costType == null || CostTypePtyEnum.SIMULATED.getValue().equals(costType.getString("type"))) {
            this.setQueryVisible(Boolean.FALSE, Boolean.FALSE, null);
            return;
        }
        Long costTypeId = costType.getLong("id");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)costTypeId);
        this.setQueryVisible(isUpdateByPeriod == false, isUpdateByPeriod, costTypeId);
    }

    private void setQueryVisible(Boolean isDateShow, Boolean isPeriodShow, Long costTypeId) {
        this.getView().setVisible(isPeriodShow, new String[]{"queryperiod"});
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.setMustInput(isPeriodShow.booleanValue());
        if (Boolean.TRUE.equals(isPeriodShow)) {
            List periodIds = CostUpdateHelper.getPeriodIds((Long)costTypeId);
            this.getModel().setValue("queryperiod", periodIds.isEmpty() ? null : periodIds.get(0));
        } else {
            this.getModel().setValue("queryperiod", null);
        }
        this.getView().setVisible(isDateShow, new String[]{"searchdate"});
        DateTimeEdit queryDate = (DateTimeEdit)this.getControl("searchdate");
        queryDate.setMustInput(isDateShow.booleanValue());
        this.getModel().setValue("searchdate", (Object)(Boolean.TRUE.equals(isDateShow) ? TimeServiceHelper.now() : null));
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"MatStdCostUpRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u7269\u6599\u4e0a\u67e5\u6807\u51c6\u6210\u672c", (String)"MatStdCostUpRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_matstdcostup", (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        this.getModel().setValue("mulauxpty", (Object)"");
    }
}

