/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;

public class MfgAuxAllocRptPlugin
extends AbstractReportFormPlugin {
    private static final String[] clearFileName = new String[]{"period", "manuorg", "costcenter"};

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String appId = this.getView().getFormShowParameter().getAppId();
        filterInfo.addFilterItem("appnum", (Object)appId, "=");
        queryParam.setFilter(filterInfo);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map customParamMap = queryParam.getCustomParam();
        if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            customParamMap.put("entitytype", "cad_planauxprodalloc");
        } else {
            customParamMap.put("entitytype", "cad_auxprodalloc");
        }
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountOrgBase = (BasedataEdit)this.getControl("accountorg");
        accountOrgBase.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
            filters.add(orgIdsFilter);
        });
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"MfgAuxAllocRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEnableQfilterByOrg((Long)Long.valueOf(accountorg.getPkValue().toString()), null, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorgf");
        manuorg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"MfgAuxAllocRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
        });
        BasedataEdit beginperiod = (BasedataEdit)this.getControl("beginperiod");
        this.getaVoid(beginperiod);
        BasedataEdit endperiod = (BasedataEdit)this.getControl("endperiod");
        this.getaVoid(endperiod);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenterf");
        costcenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"MfgAuxAllocRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("manuorgf");
            List manuOrgList = dynamicObjects.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
            QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
            qFilters.add(costCenterIdFilter);
            qFilters.add(new QFilter("orgduty", "=", (Object)5L));
        });
        MulBasedataEdit subCostcenter = (MulBasedataEdit)this.getControl("subcostcenterf");
        subCostcenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"MfgAuxAllocRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)accountorg.getLong("id"));
            qFilters.add(calorgsFilter);
            DynamicObjectCollection benefcsOrgDuty = (DynamicObjectCollection)this.getModel().getValue("benefcsorgduty");
            if (benefcsOrgDuty != null && benefcsOrgDuty.size() > 0) {
                List orgdutys = benefcsOrgDuty.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
                QFilter showOrgDutyFilter = new QFilter("orgduty", "in", orgdutys);
                qFilters.add(showOrgDutyFilter);
            }
        });
        BasedataEdit planscheme = (BasedataEdit)this.getControl("planscheme");
        planscheme.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject costAccountDyn = (DynamicObject)this.getModel().getValue("costaccount");
            if (costAccountDyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgAuxAllocRptPlugin_8", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("costaccount", "=", (Object)costAccountDyn.getLong("id")));
        });
    }

    public void afterBindData(EventObject e) {
        Map customParams;
        Long accountorg;
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("accountorg");
        Long l = accountorg = org == null ? null : (Long)org.getPkValue();
        if (accountorg == null) {
            accountorg = RequestContext.get().getOrgId();
            if (!this.getHasPermAccountOrg(accountorg)) {
                return;
            }
            if (OrgUnitServiceHelper.checkOrgFunction((Long)accountorg, (String)"10")) {
                this.getModel().setValue("accountorg", (Object)accountorg);
                this.getView().updateView("accountorg");
            }
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()) != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"planscheme"});
            BasedataEdit planscheme = (BasedataEdit)this.getView().getControl("planscheme");
            planscheme.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"planscheme"});
        }
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount == null) {
            this.changeAccountOrg(accountorg);
        } else {
            boolean isMulFactory = CostAccountHelper.isEnableMulFactory((Long)((Long)costaccount.getPkValue()));
            this.getView().setVisible(Boolean.valueOf(isMulFactory), new String[]{"manuorgf"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "costaccount": {
                this.changeCostaccout((DynamicObject)newValue);
                break;
            }
            case "accountorg": {
                Long accountorgId = newValue == null ? null : (Long)((DynamicObject)newValue).getPkValue();
                this.changeAccountOrg(accountorgId);
                break;
            }
            case "beginperiod": {
                DynamicObject endperiod = (DynamicObject)this.getModel().getValue("endperiod");
                DynamicObject beginperiod = (DynamicObject)newValue;
                this.changePeriod(beginperiod, endperiod);
                break;
            }
            case "endperiod": {
                DynamicObject beginperiodlate = (DynamicObject)this.getModel().getValue("beginperiod");
                DynamicObject endperiodlate = (DynamicObject)newValue;
                this.changePeriod(beginperiodlate, endperiodlate);
                break;
            }
            case "benefcsorgduty": {
                this.getModel().setValue("subcostcenterf", null);
                break;
            }
            case "planscheme": {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (customParams == null || customParams.get("isplandata") == null || !"true".equals(customParams.get("isplandata").toString())) break;
                this.setPeriod();
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        String tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"MfgAuxAllocRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("accountorg", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgAuxAllocRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("costaccount", tips)) {
            return false;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString()) && this.checkFileNameisNull("planscheme", tips = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u6848\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgAuxAllocRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]))) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u671f\u95f4\u3002", (String)"MfgAuxAllocRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("beginperiod", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ed3\u675f\u671f\u95f4\u3002", (String)"MfgAuxAllocRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("endperiod", tips)) {
            return false;
        }
        if (this.getModel().getValue("currency") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u8d26\u7c3f\u662f\u5426\u5173\u8054\u5e01\u79cd\u3002", (String)"MfgAuxAllocRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject beginperiod = (DynamicObject)this.getModel().getValue("beginperiod");
        DynamicObject endperiod = (DynamicObject)this.getModel().getValue("endperiod");
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("entityId", (Object)this.getBillEntityId());
        return this.changePeriod(beginperiod, endperiod);
    }

    private boolean checkFileNameisNull(String fileName, String tips) {
        if (this.getModel().getValue(fileName) == null) {
            this.getView().showTipNotification(tips);
            return true;
        }
        return false;
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        Boolean sumByPeriod = this.getModel().getDataEntity().getBoolean("periodmerge");
        DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory(costaccount == null ? null : (Long)costaccount.getPkValue());
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)obj;
            String key = reportColumn.getFieldKey();
            if (sumByPeriod.booleanValue() && "period".equals(key)) {
                reportColumn.setHide(true);
                continue;
            }
            if (!isMulFactory && "manuorg".equals(key)) {
                reportColumn.setHide(true);
                continue;
            }
            if (isMulFactory || !"manorgnum".equals(key)) continue;
            reportColumn.setHide(true);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Boolean mergesame = (Boolean)this.getModel().getValue("mergesame");
        if (mergesame.booleanValue()) {
            ReportUtils.clearFileNameValue((String[])clearFileName, (DynamicObjectCollection)rowData, (String[])clearFileName);
        }
    }

    private void getaVoid(BasedataEdit beginperiod) {
        beginperiod.addBeforeF7SelectListener(evt -> {
            QFilter usePeriodFilter;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("accountorg");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgAuxAllocRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgAuxAllocRptPlugin_8", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
                DynamicObject planScheme = this.getModel().getDataEntity().getDynamicObject("planscheme");
                if (planScheme == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"MfgAuxAllocRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Long schemeId = planScheme.getLong("id");
                List ids = PlanFeeAllocHelper.getPlanStartAllPeriods((Long)schemeId);
                usePeriodFilter = new QFilter("id", "in", (Object)ids);
            } else {
                usePeriodFilter = StartCostHelper.getUsePeriodFilter((Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue())));
            }
            qFilters.add(usePeriodFilter);
        });
    }

    private void changeAccountOrg(Long accountorg) {
        if (accountorg != null) {
            Long costaccountId = this.getCostAccountByAccoutOrg(accountorg);
            this.getModel().setValue("costaccount", (Object)(costaccountId == null ? null : costaccountId));
            this.changeCostaccout(costaccountId);
            this.getModel().setValue("costcenterf", null);
            this.getModel().setValue("subcostcenterf", null);
            this.getModel().setValue("manuorgf", null);
            this.getView().updateView("costaccount");
        } else {
            this.getModel().setValue("costcenterf", null);
            this.getModel().setValue("subcostcenterf", null);
            this.getModel().setValue("manuorgf", null);
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("currency", null);
        }
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter[] filters;
        DynamicObjectCollection result;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        if ((result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])(filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF = new QFilter("appnum", "=", (Object)appId)}), null)) == null || result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return null;
    }

    private Boolean changePeriod(DynamicObject beginperiod, DynamicObject endperiod) {
        if (beginperiod != null && endperiod != null && !beginperiod.getPkValue().equals(endperiod.getPkValue())) {
            Date begindate = beginperiod.getDate("begindate");
            Date enddate = beginperiod.getDate("enddate");
            Date begindatelate = endperiod.getDate("begindate");
            Date enddatelate = endperiod.getDate("enddate");
            if (begindate == null || begindatelate == null || enddate == null || enddatelate == null || begindate.compareTo(begindatelate) > 0 || enddate.compareTo(enddatelate) > 0) {
                this.getModel().setValue("endperiod", beginperiod.getPkValue());
                this.getView().updateView("endperiod");
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private void changeCostaccout(Long costaccountId) {
        if (costaccountId == null || costaccountId == 0L) {
            costaccountId = null;
        }
        this.setPlanScheme();
        this.setCurrency();
        this.setPeriod();
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory((Long)costaccountId);
        this.getView().setVisible(Boolean.valueOf(isMulFactory), new String[]{"manuorgf"});
    }

    private void setPlanScheme() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
            if (costaccount == null) {
                this.getModel().setValue("planscheme", null);
                return;
            }
            List planSchemeIds = PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costaccount.getLong("id"));
            if (!CadEmptyUtils.isEmpty((List)planSchemeIds)) {
                this.getModel().setValue("planscheme", planSchemeIds.get(0));
                this.getView().updateView("planscheme");
            }
        }
    }

    private void changeCostaccout(DynamicObject costaccount) {
        Long costaccountId = costaccount == null ? Long.valueOf(0L) : (Long)costaccount.getPkValue();
        this.changeCostaccout(costaccountId);
    }

    protected void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("accountorg");
        if (org == null) {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            List periodIds;
            DynamicObject planScheme = dataEntity.getDynamicObject("planscheme");
            if (planScheme == null) {
                this.getModel().setValue("beginperiod", null);
                this.getModel().setValue("endperiod", null);
                return;
            }
            Long schemeId = 0L;
            if (planScheme != null) {
                schemeId = planScheme.getLong("id");
            }
            if (!CadEmptyUtils.isEmpty((List)(periodIds = PlanFeeAllocHelper.getPlanLastEnablePeriods((Long)schemeId)))) {
                this.getModel().setValue("beginperiod", periodIds.get(0));
                this.getModel().setValue("endperiod", periodIds.get(periodIds.size() - 1));
                this.getView().updateView("beginperiod");
                this.getView().updateView("endperiod");
            }
        } else {
            QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
            QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
            DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
            if (res != null) {
                Long currentperiod = res.getLong("currentperiod");
                this.getModel().setValue("beginperiod", (Object)currentperiod);
                this.getModel().setValue("endperiod", (Object)currentperiod);
                this.getView().updateView("beginperiod");
                this.getView().updateView("endperiod");
            }
        }
    }

    public void setExcelName(List<String> list) {
        super.setExcelName(list);
        String newName = ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u8868\uff08\u8ba1\u5212\uff09", (String)"MfgAuxAllocRptPlugin_11", (String)"macc-cad-report", (Object[])new Object[0]);
        list.add(newName);
    }

    private boolean getHasPermAccountOrg(Long orgId) {
        String entityid = this.getView().getEntityId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getView().getFormShowParameter().getAppId(), (String)entityid, (String)"47150e89000000ac");
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        return rs.getHasPermOrgs().contains(orgId);
    }
}

